%------------------------------------------------------------------------------
% File     : SWV573_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 27
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_27 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  183 (  75 unt;  38 typ;   0 def)
%            Number of atoms       :  261 (  85 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  141 (  25   ~;   7   |;   8   &)
%                                         (  32 <=>;  69  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   28 (  17   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-3 aty)
%            Number of functors    :   19 (  19 usr;   4 con; 0-4 aty)
%            Number of variables   :  224 ( 198   !;   2   ?; 224   :)
%                                         (  24  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:13:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Complex_Ocomplex,type,
    complex1: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__algebra__1,type,
    real_algebra_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__vector,type,
    real_normed_vector: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__algebra__1,type,
    real_n2089651433ebra_1: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_OIm,type,
    im: complex1 > real ).

tff(sy_c_Complex_ORe,type,
    re: complex1 > real ).

tff(sy_c_Complex_Ocomplex_OComplex,type,
    complex: ( real * real ) > complex1 ).

tff(sy_c_Complex_Ocomplex_Ocomplex__case,type,
    complex_case: 
      !>[T1: $tType] : ( ( fun(real,fun(real,T1)) * complex1 ) > T1 ) ).

tff(sy_c_Complex_Ocomplex_Ocomplex__rec,type,
    complex_rec: 
      !>[T1: $tType] : ( ( fun(real,fun(real,T1)) * complex1 ) > T1 ) ).

tff(sy_c_Complex_Ocomplex_Ocomplex__size,type,
    complex_size: complex1 > nat ).

tff(sy_c_Complex_Oii,type,
    ii: complex1 ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_RealVector_Onorm__class_Onorm,type,
    norm_norm: 
      !>[A: $tType] : ( A > real ) ).

tff(sy_c_RealVector_Oof__real,type,
    of_real: 
      !>[A: $tType] : ( real > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (99)
tff(fact_0_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_1_complex_Oinject,axiom,
    ! [Real23: real,Real13: real,Real22: real,Real12: real] :
      ( ( complex(Real12,Real22) = complex(Real13,Real23) )
    <=> ( ( Real12 = Real13 )
        & ( Real22 = Real23 ) ) ) ).

tff(fact_2_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,M1: nat] :
          ( ( semiring_1_of_nat(A,M1) = semiring_1_of_nat(A,Na) )
        <=> ( M1 = Na ) ) ) ).

tff(fact_3_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_4_complex__Re__of__nat,axiom,
    ! [N: nat] : ( re(semiring_1_of_nat(complex1,N)) = semiring_1_of_nat(real,N) ) ).

tff(fact_5_complex_Orecs,axiom,
    ! [A: $tType,Real22: real,Real12: real,F1: fun(real,fun(real,A))] : ( complex_rec(A,F1,complex(Real12,Real22)) = aa(real,A,aa(real,fun(real,A),F1,Real12),Real22) ) ).

tff(fact_6_complex_Osimps_I2_J,axiom,
    ! [A: $tType,Real22: real,Real12: real,F1: fun(real,fun(real,A))] : ( complex_case(A,F1,complex(Real12,Real22)) = aa(real,A,aa(real,fun(real,A),F1,Real12),Real22) ) ).

tff(fact_7_complex__Im__of__nat,axiom,
    ! [N: nat] : ( im(semiring_1_of_nat(complex1,N)) = zero_zero(real) ) ).

tff(fact_8_of__real__of__nat__eq,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [N: nat] : ( of_real(A,semiring_1_of_nat(real,N)) = semiring_1_of_nat(A,N) ) ) ).

tff(fact_9_norm__of__nat,axiom,
    ! [A: $tType] :
      ( real_n2089651433ebra_1(A)
     => ! [N: nat] : ( norm_norm(A,semiring_1_of_nat(A,N)) = semiring_1_of_nat(real,N) ) ) ).

tff(fact_10_complex_Oexhaust,axiom,
    ! [Y: complex1] :
      ~ ! [Real11: real,Real21: real] : ( Y != complex(Real11,Real21) ) ).

tff(fact_11_of__real__eq__iff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y1: real,X1: real] :
          ( ( of_real(A,X1) = of_real(A,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_12_complex__Re__zero,axiom,
    re(zero_zero(complex1)) = zero_zero(real) ).

tff(fact_13_complex__Im__zero,axiom,
    im(zero_zero(complex1)) = zero_zero(real) ).

tff(fact_14_Im__complex__of__real,axiom,
    ! [Z: real] : ( im(of_real(complex1,Z)) = zero_zero(real) ) ).

tff(fact_15_complex__eq__cancel__iff2,axiom,
    ! [Xa: real,Y1: real,X1: real] :
      ( ( complex(X1,Y1) = of_real(complex1,Xa) )
    <=> ( ( X1 = Xa )
        & ( Y1 = zero_zero(real) ) ) ) ).

tff(fact_16_Complex__eq__0,axiom,
    ! [B2: real,A2: real] :
      ( ( complex(A2,B2) = zero_zero(complex1) )
    <=> ( ( A2 = zero_zero(real) )
        & ( B2 = zero_zero(real) ) ) ) ).

tff(fact_17_Im,axiom,
    ! [Y: real,X: real] : ( im(complex(X,Y)) = Y ) ).

tff(fact_18_norm__eq__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X1: A] :
          ( ( norm_norm(A,X1) = zero_zero(real) )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_19_norm__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ( norm_norm(A,zero_zero(A)) = zero_zero(real) ) ) ).

tff(fact_20_of__real__eq__0__iff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [X1: real] :
          ( ( of_real(A,X1) = zero_zero(A) )
        <=> ( X1 = zero_zero(real) ) ) ) ).

tff(fact_21_of__real__0,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ( of_real(A,zero_zero(real)) = zero_zero(A) ) ) ).

tff(fact_22_Re__complex__of__real,axiom,
    ! [Z: real] : ( re(of_real(complex1,Z)) = Z ) ).

tff(fact_23_complex__eq__iff,axiom,
    ! [Y1: complex1,X1: complex1] :
      ( ( X1 = Y1 )
    <=> ( ( re(X1) = re(Y1) )
        & ( im(X1) = im(Y1) ) ) ) ).

tff(fact_24_complex__surj,axiom,
    ! [Z: complex1] : ( complex(re(Z),im(Z)) = Z ) ).

tff(fact_25_complex__eqI,axiom,
    ! [Y: complex1,X: complex1] :
      ( ( re(X) = re(Y) )
     => ( ( im(X) = im(Y) )
       => ( X = Y ) ) ) ).

tff(fact_26_Re,axiom,
    ! [Y: real,X: real] : ( re(complex(X,Y)) = X ) ).

tff(fact_27_complex__of__real__def,axiom,
    ! [R: real] : ( of_real(complex1,R) = complex(R,zero_zero(real)) ) ).

tff(fact_28_complex__zero__def,axiom,
    zero_zero(complex1) = complex(zero_zero(real),zero_zero(real)) ).

tff(fact_29_complex_Osize_I1_J,axiom,
    ! [Real2: real,Real1: real] : ( complex_size(complex(Real1,Real2)) = zero_zero(nat) ) ).

tff(fact_30_complex_Osize_I2_J,axiom,
    ! [Real2: real,Real1: real] : ( size_size(complex1,complex(Real1,Real2)) = zero_zero(nat) ) ).

tff(fact_31_complex__Re__i,axiom,
    re(ii) = zero_zero(real) ).

tff(fact_32_norm__le__zero__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X1: A] :
          ( ord_less_eq(real,norm_norm(A,X1),zero_zero(real))
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_33_zero__less__norm__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X1: A] :
          ( ord_less(real,zero_zero(real),norm_norm(A,X1))
        <=> ( X1 != zero_zero(A) ) ) ) ).

tff(fact_34_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_35_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_36_int__eq__0__conv,axiom,
    ! [Na: nat] :
      ( ( semiring_1_of_nat(int,Na) = zero_zero(int) )
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_37_of__nat__aux_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [I1: A,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,zero_zero(nat),I1) = I1 ) ) ).

tff(fact_38_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M1: nat] :
          ( ord_less_eq(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,Na))
        <=> ord_less_eq(nat,M1,Na) ) ) ).

tff(fact_39_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,M1,Na) ) ) ).

tff(fact_40_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_41_complex__i__not__zero,axiom,
    ii != zero_zero(complex1) ).

tff(fact_42_int__int__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ( semiring_1_of_nat(int,M1) = semiring_1_of_nat(int,Na) )
    <=> ( M1 = Na ) ) ).

tff(fact_43_Nat__Transfer_Otransfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_44_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_45_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(nat,M,N)
         => ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N)) ) ) ).

tff(fact_46_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N))
         => ord_less(nat,M,N) ) ) ).

tff(fact_47_complex__Re__le__cmod,axiom,
    ! [X: complex1] : ord_less_eq(real,re(X),norm_norm(complex1,X)) ).

tff(fact_48_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

tff(fact_49_zero__le__imp__of__nat,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,M)) ) ).

tff(fact_50_of__nat__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,N)) ) ).

tff(fact_51_norm__not__less__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] : ~ ord_less(real,norm_norm(A,X),zero_zero(real)) ) ).

tff(fact_52_norm__ge__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] : ord_less_eq(real,zero_zero(real),norm_norm(A,X)) ) ).

tff(fact_53_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_54_less__eq__real__def,axiom,
    ! [Y1: real,X1: real] :
      ( ord_less_eq(real,X1,Y1)
    <=> ( ord_less(real,X1,Y1)
        | ( X1 = Y1 ) ) ) ).

tff(fact_55_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_56_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_57_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( A1 != B1 )
           => ord_less(A,A1,B1) ) ) ) ).

tff(fact_58_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_59_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_60_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_61_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_62_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_63_le__0__eq,axiom,
    ! [Na: nat] :
      ( ord_less_eq(nat,Na,zero_zero(nat))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_64_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_65_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_66_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( ord_less(nat,M1,Na)
        | ord_less(nat,Na,M1) ) ) ).

tff(fact_67_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

tff(fact_68_nat__less__le,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(nat,M1,Na)
    <=> ( ord_less_eq(nat,M1,Na)
        & ( M1 != Na ) ) ) ).

tff(fact_69_le__eq__less__or__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less_eq(nat,M1,Na)
    <=> ( ord_less(nat,M1,Na)
        | ( M1 = Na ) ) ) ).

tff(fact_70_zless__int,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,M1),semiring_1_of_nat(int,Na))
    <=> ord_less(nat,M1,Na) ) ).

tff(fact_71_Nat__Transfer_Otransfer__int__nat__relations_I2_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less(nat,X1,Y1) ) ).

tff(fact_72_zle__int,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,M1),semiring_1_of_nat(int,Na))
    <=> ord_less_eq(nat,M1,Na) ) ).

tff(fact_73_Nat__Transfer_Otransfer__int__nat__relations_I3_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less_eq(nat,X1,Y1) ) ).

tff(fact_74_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_75_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_76_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_77_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_78_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_79_less__imp__le__nat,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less_eq(nat,M,N) ) ).

tff(fact_80_le__neq__implies__less,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ( M != N )
       => ord_less(nat,M,N) ) ) ).

tff(fact_81_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_82_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_83_less__or__eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
        | ( M = N ) )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_84_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( ord_less(nat,M1,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( ord_less(nat,Na,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_85_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_86_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_87_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_88_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_89_zero__less__int__conv,axiom,
    ! [Na: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,Na))
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_90_int__less__0__conv,axiom,
    ! [K: nat] : ~ ord_less(int,semiring_1_of_nat(int,K),zero_zero(int)) ).

tff(fact_91_transfer__int__nat__quantifiers_I1_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ! [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
         => pp(aa(int,bool,P1,X2)) )
    <=> ! [X2: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X2))) ) ).

tff(fact_92_transfer__int__nat__quantifiers_I2_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ? [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
          & pp(aa(int,bool,P1,X2)) )
    <=> ? [X2: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X2))) ) ).

tff(fact_93_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,
    ! [Z: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,Z)) ).

tff(fact_94_zero__zle__int,axiom,
    ! [N: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,N)) ).

tff(fact_95_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X2: A] : ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_96_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_97_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
        <=> ( ord_less_eq(A,X1,Y1)
            & ord_less_eq(A,Y1,X1) ) ) ) ).

tff(fact_98_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

%----Arities (40)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__algebra__1,axiom,
    real_algebra_1(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__semidom,axiom,
    linordered_semidom(real) ).

tff(arity_RealDef_Oreal___Nat_Osemiring__char__0,axiom,
    semiring_char_0(real) ).

tff(arity_RealDef_Oreal___Orderings_Opreorder,axiom,
    preorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Olinorder,axiom,
    linorder(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__1,axiom,
    semiring_1(real) ).

tff(arity_RealDef_Oreal___Orderings_Oorder,axiom,
    order(real) ).

tff(arity_RealDef_Oreal___Orderings_Oord,axiom,
    ord(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(complex1) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(complex1) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__algebra__1,axiom,
    real_algebra_1(complex1) ).

tff(arity_Complex_Ocomplex___Nat_Osemiring__char__0,axiom,
    semiring_char_0(complex1) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex1) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex1) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    semiring_1_of_nat(complex1,n) = complex(semiring_1_of_nat(real,n),zero_zero(real)) ).

%------------------------------------------------------------------------------
