%------------------------------------------------------------------------------
% File     : SWV234+2 : TPTP v9.2.0. Released v3.2.0.
% Domain   : Software Verification (Security)
% Problem  : 4758 typecast attack
% Version  : Especial.
% English  : Mike Bond's version of a model for the 4758 typecast attack.

% Refs     : [BA01]  Bond & Anderson (2001), API-Level Attacks on Embedded
%          : [Ste06] Steel (2006), Email to G. Sutcliffe
% Source   : [Ste06]
% Names    :

% Status   : Theorem
% Rating   : 0.55 v9.0.0, 0.61 v8.2.0, 0.58 v8.1.0, 0.64 v7.5.0, 0.69 v7.4.0, 0.57 v7.3.0, 0.62 v7.1.0, 0.61 v7.0.0, 0.57 v6.4.0, 0.62 v6.2.0, 0.68 v6.1.0, 0.70 v6.0.0, 0.74 v5.5.0, 0.78 v5.4.0, 0.79 v5.3.0, 0.81 v5.2.0, 0.70 v5.1.0, 0.71 v4.1.0, 0.74 v4.0.0, 0.75 v3.5.0, 0.74 v3.3.0, 0.71 v3.2.0
% Syntax   : Number of formulae    :   22 (  15 unt;   0 def)
%            Number of atoms       :   37 (   5 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   15 (   0   ~;   0   |;   8   &)
%                                         (   0 <=>;   7  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    7 (   3 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :   13 (  13 usr;   9 con; 0-2 aty)
%            Number of variables   :   30 (  30   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : File generated by dfg2tptp Version 0.47
%          : Bond's formalism is slightly different to Steel's in the modelling
%            of XOR and partially completed keys. Bond's model also contains
%            only the commands needed to find the attack. Nevertheless, it
%            presents a challenging problem for theorem provers because of the
%            use of XOR.
%------------------------------------------------------------------------------
fof(ability_to_xor,axiom,
    ! [U,V] :
      ( ( public(U)
        & public(V) )
     => public(xor(U,V)) ) ).

fof(kp_set,axiom,
    ! [U] :
      ( public(U)
     => public(kp(U)) ) ).

fof(ability_to_encrypt,axiom,
    ! [U,V] :
      ( ( public(U)
        & public(V) )
     => public(enc(U,V)) ) ).

fof(ability_to_decrypt,axiom,
    ! [U,V] :
      ( ( public(U)
        & public(V) )
     => public(enc(inv(U),V)) ) ).

fof(encrypt_data_cmd,axiom,
    ! [U,V] :
      ( ( public(U)
        & public(V) )
     => public(enc(enc(inv(xor(data,km)),U),V)) ) ).

fof(key_import_cmd,axiom,
    ! [U,V,W] :
      ( ( public(V)
        & public(enc(xor(U,V),W))
        & public(enc(xor(km,imp),U)) )
     => public(enc(xor(km,V),W)) ) ).

fof(key_part_import_cmd,axiom,
    ! [U,V,W] :
      ( ( public(kp(V))
        & public(W)
        & public(enc(xor(km,kp(V)),U)) )
     => public(enc(xor(km,V),xor(U,W))) ) ).

fof(encrypt_decrypt_cancel,axiom,
    ! [U,V,W] : enc(U,enc(inv(U),V)) = V ).

fof(xor_commutes,axiom,
    ! [U,V,W] : xor(U,V) = xor(V,U) ).

fof(xor_assosciative,axiom,
    ! [U,V,W] : xor(U,xor(V,W)) = xor(xor(U,V),W) ).

fof(xor_self_cancel,axiom,
    ! [U,V,W] : xor(U,U) = z ).

fof(xor_zero,axiom,
    ! [U,V,W] : xor(U,z) = U ).

fof(initial_knowledge1,axiom,
    public(imp) ).

fof(initial_knowledge2,axiom,
    public(data) ).

fof(initial_knowledge3,axiom,
    public(z) ).

fof(initial_knowledge4,axiom,
    public(pin) ).

fof(initial_knowledge5,axiom,
    public(enc(xor(kek,pin),pp)) ).

fof(initial_knowledge6,axiom,
    public(k3) ).

fof(initial_knowledge7,axiom,
    public(enc(xor(km,kp(imp)),xor(kek,k3))) ).

fof(initial_knowledge8,axiom,
    public(a) ).

fof(initial_knowledge9,axiom,
    public(enc(xor(km,imp),xor(kek,xor(pin,data)))) ).

%----Can you make a PIN? (enc(pp,a))
fof(co1,conjecture,
    public(enc(pp,a)) ).

%------------------------------------------------------------------------------
