%------------------------------------------------------------------------------
% File     : SWV221+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Simplified proof obligation quaternion_ds1_symm_0401
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the quaternion_ds1 program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_symm_0401 [Fis04]

% Status   : Theorem
% Rating   : 0.15 v9.1.0, 0.12 v9.0.0, 0.14 v8.1.0, 0.19 v7.5.0, 0.25 v7.4.0, 0.13 v7.3.0, 0.10 v7.1.0, 0.13 v7.0.0, 0.17 v6.4.0, 0.19 v6.3.0, 0.17 v6.2.0, 0.28 v6.1.0, 0.33 v6.0.0, 0.22 v5.4.0, 0.29 v5.3.0, 0.33 v5.2.0, 0.20 v5.1.0, 0.24 v5.0.0, 0.25 v4.1.0, 0.26 v4.0.0, 0.29 v3.7.0, 0.25 v3.5.0, 0.32 v3.4.0, 0.37 v3.3.0
% Syntax   : Number of formulae    :   92 (  56 unt;   0 def)
%            Number of atoms       :  303 (  91 equ)
%            Maximal formula atoms :   47 (   3 avg)
%            Number of connectives :  218 (   7   ~;  17   |; 125   &)
%                                         (   5 <=>;  64  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   36 (  36 usr;  18 con; 0-4 aty)
%            Number of variables   :  182 ( 182   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_symm_0401,conjecture,
    ( ( leq(n0,pv5)
      & leq(n0,pv57)
      & leq(pv5,n998)
      & leq(pv57,n5)
      & leq(pv58,n5)
      & gt(pv58,pv57)
      & ! [A,B] :
          ( ( leq(n0,A)
            & leq(n0,B)
            & leq(A,n5)
            & leq(B,n5) )
         => a_select3(q_ds1_filter,A,B) = a_select3(q_ds1_filter,B,A) )
      & ! [C,D] :
          ( ( leq(n0,C)
            & leq(n0,D)
            & leq(C,n2)
            & leq(D,n2) )
         => a_select3(r_ds1_filter,C,D) = a_select3(r_ds1_filter,D,C) )
      & ! [E,F] :
          ( ( leq(n0,E)
            & leq(n0,F)
            & leq(E,n5)
            & leq(F,n5) )
         => a_select3(pminus_ds1_filter,E,F) = a_select3(pminus_ds1_filter,F,E) )
      & ! [G,H] :
          ( ( leq(n0,G)
            & leq(n0,H)
            & leq(G,n5)
            & leq(H,n5) )
         => ( ( G = pv57
              & gt(pv58,H) )
           => a_select3(id_ds1_filter,G,H) = a_select3(id_ds1_filter,H,G) ) )
      & ! [I,J] :
          ( ( leq(n0,I)
            & leq(n0,J)
            & leq(I,n5)
            & leq(J,n5) )
         => ( gt(pv57,I)
           => a_select3(id_ds1_filter,I,J) = a_select3(id_ds1_filter,J,I) ) )
      & ! [K] :
          ( ( leq(n0,K)
            & leq(K,pred(pv57)) )
         => ! [L] :
              ( ( leq(n0,L)
                & leq(L,n5) )
             => a_select3(id_ds1_filter,K,L) = a_select3(id_ds1_filter,L,K) ) ) )
   => ! [M] :
        ( ( leq(n0,M)
          & leq(M,pred(pv57)) )
       => ! [N] :
            ( ( leq(n0,N)
              & leq(N,n5) )
           => ( ( ~ ( pv57 = N
                    & N = M )
                & pv57 != M )
             => a_select3(id_ds1_filter,M,N) = a_select3(id_ds1_filter,N,M) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_998_4,axiom,
    gt(n998,n4) ).

fof(gt_998_5,axiom,
    gt(n998,n5) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_998_tptp_minus_1,axiom,
    gt(n998,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_998_0,axiom,
    gt(n998,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_998_1,axiom,
    gt(n998,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_998_2,axiom,
    gt(n998,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_998_3,axiom,
    gt(n998,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
