%------------------------------------------------------------------------------
% File     : SWV211+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Simplified proof obligation quaternion_ds1_symm_0001
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the quaternion_ds1 program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_symm_0001 [Fis04]

% Status   : Theorem
% Rating   : 0.03 v7.1.0, 0.04 v7.0.0, 0.03 v6.4.0, 0.04 v6.3.0, 0.08 v6.2.0, 0.16 v6.1.0, 0.10 v6.0.0, 0.09 v5.5.0, 0.04 v5.3.0, 0.11 v5.2.0, 0.05 v5.0.0, 0.04 v4.0.0, 0.08 v3.7.0, 0.10 v3.5.0, 0.16 v3.4.0, 0.26 v3.3.0
% Syntax   : Number of formulae    :   92 (  56 unt;   0 def)
%            Number of atoms       :  334 ( 154 equ)
%            Maximal formula atoms :   78 (   3 avg)
%            Number of connectives :  282 (  40   ~;  17   |; 167   &)
%                                         (   5 <=>;  53  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   42 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   32 (  32 usr;  12 con; 0-4 aty)
%            Number of variables   :  170 ( 170   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_symm_0001,conjecture,
    ! [A,B] :
      ( ( leq(n0,A)
        & leq(n0,B)
        & leq(A,n5)
        & leq(B,n5) )
     => ( ( ~ ( n0 = A
              & n1 = B )
          & ~ ( n0 = A
              & n2 = B )
          & ~ ( n0 = A
              & n3 = B )
          & ~ ( n0 = A
              & n4 = B )
          & ~ ( n0 = A
              & n5 = B )
          & ~ ( n0 = B
              & n1 = A )
          & ~ ( n0 = B
              & n2 = A )
          & ~ ( n0 = B
              & n3 = A )
          & ~ ( n0 = B
              & n4 = A )
          & ~ ( n0 = B
              & n5 = A )
          & ~ ( n1 = A
              & n1 = B )
          & ~ ( n1 = A
              & n2 = B )
          & ~ ( n1 = A
              & n3 = B )
          & ~ ( n1 = A
              & n4 = B )
          & ~ ( n1 = A
              & n5 = B )
          & ~ ( n1 = B
              & n2 = A )
          & ~ ( n1 = B
              & n3 = A )
          & ~ ( n1 = B
              & n4 = A )
          & ~ ( n1 = B
              & n5 = A )
          & ~ ( n2 = A
              & n2 = B )
          & ~ ( n2 = A
              & n3 = B )
          & ~ ( n2 = A
              & n4 = B )
          & ~ ( n2 = A
              & n5 = B )
          & ~ ( n2 = B
              & n3 = A )
          & ~ ( n2 = B
              & n4 = A )
          & ~ ( n2 = B
              & n5 = A )
          & ~ ( n3 = A
              & n3 = B )
          & ~ ( n3 = A
              & n4 = B )
          & ~ ( n3 = A
              & n5 = B )
          & ~ ( n3 = B
              & n4 = A )
          & ~ ( n3 = B
              & n5 = A )
          & ~ ( n4 = A
              & n4 = B )
          & ~ ( n4 = A
              & n5 = B )
          & ~ ( n4 = B
              & n5 = A )
          & ~ ( n5 = A
              & n5 = B )
          & n0 = A
          & n0 = B
          & n1 = A )
       => n0 = times(divide(n1,n400),a_select2(sigma,n0)) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_400_4,axiom,
    gt(n400,n4) ).

fof(gt_400_5,axiom,
    gt(n400,n5) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_400_tptp_minus_1,axiom,
    gt(n400,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_400_0,axiom,
    gt(n400,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_400_1,axiom,
    gt(n400,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_400_2,axiom,
    gt(n400,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_400_3,axiom,
    gt(n400,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
