%------------------------------------------------------------------------------
% File     : SWV130+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_symm_0001
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the thruster program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_symm_0001 [Fis04]

% Status   : Theorem
% Rating   : 1.00 v3.3.0
% Syntax   : Number of formulae    :  185 ( 148 unt;   0 def)
%            Number of atoms       : 1419 ( 279 equ)
%            Maximal formula atoms : 1062 (   7 avg)
%            Number of connectives : 1254 (  20   ~;  23   |; 878   &)
%                                         (   5 <=>; 328  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   37 (   3 avg)
%            Maximal term depth    :   38 (   3 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   64 (  64 usr;  41 con; 0-4 aty)
%            Number of variables   :  537 ( 537   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(thruster_symm_0001,conjecture,
    ( ( geq(minus(n4,n1),n0)
      & geq(minus(n1000,n1),n0) )
   => ! [A] :
        ( ( geq(n7,n0)
          & geq(minus(n1000,n1),n0) )
       => ! [D14] :
            ( ( true
             => ! [B,C] :
                  ( ( leq(n0,B)
                    & leq(n0,C)
                    & leq(B,minus(n6,n1))
                    & leq(C,minus(n6,n1)) )
                 => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(q_thruster_filter,n0,n0,n0),n0,n1,n0),n0,n2,n0),n0,n3,n0),n0,n4,n0),n0,n5,n0),n1,n0,n0),n1,n1,n0),n1,n2,n0),n1,n3,n0),n1,n4,n0),n1,n5,n0),n2,n0,n0),n2,n1,n0),n2,n2,n0),n2,n3,n0),n2,n4,n0),n2,n5,n0),n3,n0,n0),n3,n1,n0),n3,n2,n0),n3,n3,tptp_float_0_001),n3,n4,n0),n3,n5,n0),n4,n0,n0),n4,n1,n0),n4,n2,n0),n4,n3,n0),n4,n4,tptp_float_0_0001),n4,n5,n0),n5,n0,n0),n5,n1,n0),n5,n2,n0),n5,n3,n0),n5,n4,n0),n5,n5,tptp_float_0_0001),B,C) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(q_thruster_filter,n0,n0,n0),n0,n1,n0),n0,n2,n0),n0,n3,n0),n0,n4,n0),n0,n5,n0),n1,n0,n0),n1,n1,n0),n1,n2,n0),n1,n3,n0),n1,n4,n0),n1,n5,n0),n2,n0,n0),n2,n1,n0),n2,n2,n0),n2,n3,n0),n2,n4,n0),n2,n5,n0),n3,n0,n0),n3,n1,n0),n3,n2,n0),n3,n3,tptp_float_0_001),n3,n4,n0),n3,n5,n0),n4,n0,n0),n4,n1,n0),n4,n2,n0),n4,n3,n0),n4,n4,tptp_float_0_0001),n4,n5,n0),n5,n0,n0),n5,n1,n0),n5,n2,n0),n5,n3,n0),n5,n4,n0),n5,n5,tptp_float_0_0001),C,B) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv29)
                & leq(pv5,n588)
                & leq(pv29,minus(n6,n1))
                & ! [D,E] :
                    ( ( leq(n0,D)
                      & leq(n0,E)
                      & leq(D,minus(n6,n1))
                      & leq(E,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,D,E) = a_select3(q_thruster_filter,E,D) )
                & ! [F,G] :
                    ( ( leq(n0,F)
                      & leq(n0,G)
                      & leq(F,minus(n4,n1))
                      & leq(G,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,F,G) = a_select3(r_thruster_filter,G,F) )
                & ! [H,I] :
                    ( ( leq(n0,H)
                      & leq(n0,I)
                      & leq(H,minus(n6,n1))
                      & leq(I,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,H,I) = a_select3(pminus_thruster_filter,I,H) )
                & ! [J,K] :
                    ( ( leq(n0,J)
                      & leq(n0,K)
                      & leq(J,minus(n6,n1))
                      & leq(K,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,J,K) = a_select3(pminus_thruster_filter,K,J) )
                & ! [L] :
                    ( ( leq(n0,L)
                      & leq(L,minus(n6,n1)) )
                   => ! [M] :
                        ( ( leq(n0,M)
                          & leq(M,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,L,M) = a_select3(id_thruster_filter,M,L) ) ) )
             => ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [N,O] :
                    ( ( leq(n0,N)
                      & leq(n0,O)
                      & leq(N,minus(n6,n1))
                      & leq(O,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,N,O) = a_select3(q_thruster_filter,O,N) )
                & ! [P,Q] :
                    ( ( leq(n0,P)
                      & leq(n0,Q)
                      & leq(P,minus(n4,n1))
                      & leq(Q,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,P,Q) = a_select3(r_thruster_filter,Q,P) )
                & ! [R,S] :
                    ( ( leq(n0,R)
                      & leq(n0,S)
                      & leq(R,minus(n6,n1))
                      & leq(S,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,R,S) = a_select3(pminus_thruster_filter,S,R) )
                & ! [T,U] :
                    ( ( leq(n0,T)
                      & leq(n0,U)
                      & leq(T,minus(n6,n1))
                      & leq(U,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,T,U) = a_select3(pminus_thruster_filter,U,T) )
                & ! [V] :
                    ( ( leq(n0,V)
                      & leq(V,minus(n6,n1)) )
                   => ! [W] :
                        ( ( leq(n0,W)
                          & leq(W,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,V,W) = a_select3(id_thruster_filter,W,V) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(plus(n1,pv39),pv40)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & leq(pv40,minus(n6,n1))
                & ! [X,Y] :
                    ( ( leq(n0,X)
                      & leq(n0,Y)
                      & leq(X,minus(n6,n1))
                      & leq(Y,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,X,Y) = a_select3(q_thruster_filter,Y,X) )
                & ! [Z,A1] :
                    ( ( leq(n0,Z)
                      & leq(n0,A1)
                      & leq(Z,minus(n4,n1))
                      & leq(A1,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,Z,A1) = a_select3(r_thruster_filter,A1,Z) )
                & ! [B1,C1] :
                    ( ( leq(n0,B1)
                      & leq(n0,C1)
                      & leq(B1,minus(n6,n1))
                      & leq(C1,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,B1,C1) = a_select3(pminus_thruster_filter,C1,B1) )
                & ! [D1,E1] :
                    ( ( leq(n0,D1)
                      & leq(n0,E1)
                      & leq(D1,minus(n6,n1))
                      & leq(E1,minus(n6,n1)) )
                   => ( ( ( lt(E1,pv40)
                          & D1 = pv39 )
                       => a_select3(id_thruster_filter,D1,E1) = a_select3(id_thruster_filter,E1,D1) )
                      & ( lt(D1,pv39)
                       => a_select3(id_thruster_filter,D1,E1) = a_select3(id_thruster_filter,E1,D1) ) ) )
                & ! [F1] :
                    ( ( leq(n0,F1)
                      & leq(F1,minus(pv39,n1)) )
                   => ! [G1] :
                        ( ( leq(n0,G1)
                          & leq(G1,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,F1,G1) = a_select3(id_thruster_filter,G1,F1) ) ) )
             => ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & ! [H1,I1] :
                    ( ( leq(n0,H1)
                      & leq(n0,I1)
                      & leq(H1,minus(n6,n1))
                      & leq(I1,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,H1,I1) = a_select3(q_thruster_filter,I1,H1) )
                & ! [J1,K1] :
                    ( ( leq(n0,J1)
                      & leq(n0,K1)
                      & leq(J1,minus(n4,n1))
                      & leq(K1,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,J1,K1) = a_select3(r_thruster_filter,K1,J1) )
                & ! [L1,M1] :
                    ( ( leq(n0,L1)
                      & leq(n0,M1)
                      & leq(L1,minus(n6,n1))
                      & leq(M1,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,L1,M1) = a_select3(pminus_thruster_filter,M1,L1) )
                & ! [N1,O1] :
                    ( ( leq(n0,N1)
                      & leq(n0,O1)
                      & leq(N1,minus(n6,n1))
                      & leq(O1,minus(n6,n1)) )
                   => ( ( ( lt(O1,plus(n1,pv40))
                          & N1 = pv39 )
                       => a_select3(tptp_update3(tptp_update3(id_thruster_filter,pv39,pv40,n0),pv40,pv39,n0),N1,O1) = a_select3(tptp_update3(tptp_update3(id_thruster_filter,pv39,pv40,n0),pv40,pv39,n0),O1,N1) )
                      & ( lt(N1,pv39)
                       => a_select3(tptp_update3(tptp_update3(id_thruster_filter,pv39,pv40,n0),pv40,pv39,n0),N1,O1) = a_select3(tptp_update3(tptp_update3(id_thruster_filter,pv39,pv40,n0),pv40,pv39,n0),O1,N1) ) ) )
                & ! [P1] :
                    ( ( leq(n0,P1)
                      & leq(P1,minus(pv39,n1)) )
                   => ! [Q1] :
                        ( ( leq(n0,Q1)
                          & leq(Q1,minus(n6,n1)) )
                       => a_select3(tptp_update3(tptp_update3(id_thruster_filter,pv39,Q1,n0),Q1,pv39,n0),P1,Q1) = a_select3(tptp_update3(tptp_update3(id_thruster_filter,pv39,Q1,n0),Q1,pv39,n0),Q1,P1) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & ! [R1,S1] :
                    ( ( leq(n0,R1)
                      & leq(n0,S1)
                      & leq(R1,minus(n6,n1))
                      & leq(S1,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,R1,S1) = a_select3(q_thruster_filter,S1,R1) )
                & ! [T1,U1] :
                    ( ( leq(n0,T1)
                      & leq(n0,U1)
                      & leq(T1,minus(n4,n1))
                      & leq(U1,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,T1,U1) = a_select3(r_thruster_filter,U1,T1) )
                & ! [V1,W1] :
                    ( ( leq(n0,V1)
                      & leq(n0,W1)
                      & leq(V1,minus(n6,n1))
                      & leq(W1,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,V1,W1) = a_select3(pminus_thruster_filter,W1,V1) )
                & ! [X1,Y1] :
                    ( ( leq(n0,X1)
                      & leq(n0,Y1)
                      & leq(X1,minus(n6,n1))
                      & leq(Y1,minus(n6,n1)) )
                   => ( ( ( lt(Y1,plus(n1,minus(n6,n1)))
                          & X1 = pv39 )
                       => a_select3(id_thruster_filter,X1,Y1) = a_select3(id_thruster_filter,Y1,X1) )
                      & ( lt(X1,pv39)
                       => a_select3(id_thruster_filter,X1,Y1) = a_select3(id_thruster_filter,Y1,X1) ) ) )
                & ! [Z1] :
                    ( ( leq(n0,Z1)
                      & leq(Z1,minus(pv39,n1)) )
                   => ! [A2] :
                        ( ( leq(n0,A2)
                          & leq(A2,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,Z1,A2) = a_select3(id_thruster_filter,A2,Z1) ) ) )
             => ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & ! [B2,C2] :
                    ( ( leq(n0,B2)
                      & leq(n0,C2)
                      & leq(B2,minus(n6,n1))
                      & leq(C2,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,B2,C2) = a_select3(q_thruster_filter,C2,B2) )
                & ! [D2,E2] :
                    ( ( leq(n0,D2)
                      & leq(n0,E2)
                      & leq(D2,minus(n4,n1))
                      & leq(E2,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,D2,E2) = a_select3(r_thruster_filter,E2,D2) )
                & ! [F2,G2] :
                    ( ( leq(n0,F2)
                      & leq(n0,G2)
                      & leq(F2,minus(n6,n1))
                      & leq(G2,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,F2,G2) = a_select3(pminus_thruster_filter,G2,F2) )
                & ! [H2,I2] :
                    ( ( leq(n0,H2)
                      & leq(n0,I2)
                      & leq(H2,pv39)
                      & leq(I2,minus(n6,n1)) )
                   => a_select3(id_thruster_filter,H2,I2) = a_select3(id_thruster_filter,I2,H2) )
                & ! [J2] :
                    ( ( leq(n0,J2)
                      & leq(J2,minus(pv39,n1)) )
                   => ! [K2] :
                        ( ( leq(n0,K2)
                          & leq(K2,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,J2,K2) = a_select3(id_thruster_filter,K2,J2) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & ! [L2,M2] :
                    ( ( leq(n0,L2)
                      & leq(n0,M2)
                      & leq(L2,minus(n6,n1))
                      & leq(M2,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,L2,M2) = a_select3(q_thruster_filter,M2,L2) )
                & ! [N2,O2] :
                    ( ( leq(n0,N2)
                      & leq(n0,O2)
                      & leq(N2,minus(n4,n1))
                      & leq(O2,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,N2,O2) = a_select3(r_thruster_filter,O2,N2) )
                & ! [P2,Q2] :
                    ( ( leq(n0,P2)
                      & leq(n0,Q2)
                      & leq(P2,minus(n6,n1))
                      & leq(Q2,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,P2,Q2) = a_select3(pminus_thruster_filter,Q2,P2) )
                & ! [R2,S2] :
                    ( ( leq(n0,R2)
                      & leq(n0,S2)
                      & leq(R2,pv39)
                      & leq(S2,minus(n6,n1)) )
                   => a_select3(id_thruster_filter,R2,S2) = a_select3(id_thruster_filter,S2,R2) )
                & ! [T2] :
                    ( ( leq(n0,T2)
                      & leq(T2,minus(pv39,n1)) )
                   => ! [U2] :
                        ( ( leq(n0,U2)
                          & leq(U2,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,T2,U2) = a_select3(id_thruster_filter,U2,T2) ) ) )
             => ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [V2,W2] :
                    ( ( leq(n0,V2)
                      & leq(n0,W2)
                      & leq(V2,minus(n6,n1))
                      & leq(W2,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,V2,W2) = a_select3(q_thruster_filter,W2,V2) )
                & ! [X2,Y2] :
                    ( ( leq(n0,X2)
                      & leq(n0,Y2)
                      & leq(X2,minus(n4,n1))
                      & leq(Y2,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,X2,Y2) = a_select3(r_thruster_filter,Y2,X2) )
                & ! [Z2,A3] :
                    ( ( leq(n0,Z2)
                      & leq(n0,A3)
                      & leq(Z2,minus(n6,n1))
                      & leq(A3,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,Z2,A3) = a_select3(pminus_thruster_filter,A3,Z2) )
                & ! [B3] :
                    ( ( leq(n0,B3)
                      & leq(B3,minus(plus(n1,pv39),n1)) )
                   => ! [C3] :
                        ( ( leq(n0,C3)
                          & leq(C3,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,B3,C3) = a_select3(id_thruster_filter,C3,B3) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & ! [D3,E3] :
                    ( ( leq(n0,D3)
                      & leq(n0,E3)
                      & leq(D3,minus(n6,n1))
                      & leq(E3,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,D3,E3) = a_select3(q_thruster_filter,E3,D3) )
                & ! [F3,G3] :
                    ( ( leq(n0,F3)
                      & leq(n0,G3)
                      & leq(F3,minus(n4,n1))
                      & leq(G3,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,F3,G3) = a_select3(r_thruster_filter,G3,F3) )
                & ! [H3,I3] :
                    ( ( leq(n0,H3)
                      & leq(n0,I3)
                      & leq(H3,minus(n6,n1))
                      & leq(I3,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,H3,I3) = a_select3(pminus_thruster_filter,I3,H3) )
                & ! [J3] :
                    ( ( leq(n0,J3)
                      & leq(J3,minus(pv39,n1)) )
                   => ! [K3] :
                        ( ( leq(n0,K3)
                          & leq(K3,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,J3,K3) = a_select3(id_thruster_filter,K3,J3) ) ) )
             => ( leq(n0,pv5)
                & leq(n0,pv39)
                & leq(pv5,n588)
                & leq(pv39,minus(n6,n1))
                & ! [L3,M3] :
                    ( ( leq(n0,L3)
                      & leq(n0,M3)
                      & leq(L3,minus(n6,n1))
                      & leq(M3,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,L3,M3) = a_select3(q_thruster_filter,M3,L3) )
                & ! [N3,O3] :
                    ( ( leq(n0,N3)
                      & leq(n0,O3)
                      & leq(N3,minus(n4,n1))
                      & leq(O3,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,N3,O3) = a_select3(r_thruster_filter,O3,N3) )
                & ! [P3,Q3] :
                    ( ( leq(n0,P3)
                      & leq(n0,Q3)
                      & leq(P3,minus(n6,n1))
                      & leq(Q3,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,P3,Q3) = a_select3(pminus_thruster_filter,Q3,P3) )
                & ! [R3,S3] :
                    ( ( leq(n0,R3)
                      & leq(n0,S3)
                      & leq(R3,minus(n6,n1))
                      & leq(S3,minus(n6,n1)) )
                   => ( ( ( lt(S3,plus(n1,pv39))
                          & R3 = pv39 )
                       => a_select3(tptp_update3(id_thruster_filter,pv39,pv39,n1),R3,S3) = a_select3(tptp_update3(id_thruster_filter,pv39,pv39,n1),S3,R3) )
                      & ( lt(R3,pv39)
                       => a_select3(tptp_update3(id_thruster_filter,pv39,pv39,n1),R3,S3) = a_select3(tptp_update3(id_thruster_filter,pv39,pv39,n1),S3,R3) ) ) )
                & ! [T3] :
                    ( ( leq(n0,T3)
                      & leq(T3,minus(pv39,n1)) )
                   => ! [U3] :
                        ( ( leq(n0,U3)
                          & leq(U3,minus(n6,n1)) )
                       => a_select3(tptp_update3(id_thruster_filter,pv39,pv39,n1),T3,U3) = a_select3(tptp_update3(id_thruster_filter,pv39,pv39,n1),U3,T3) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [V3,W3] :
                    ( ( leq(n0,V3)
                      & leq(n0,W3)
                      & leq(V3,minus(n6,n1))
                      & leq(W3,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,V3,W3) = a_select3(q_thruster_filter,W3,V3) )
                & ! [X3,Y3] :
                    ( ( leq(n0,X3)
                      & leq(n0,Y3)
                      & leq(X3,minus(n4,n1))
                      & leq(Y3,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,X3,Y3) = a_select3(r_thruster_filter,Y3,X3) )
                & ! [Z3,A4] :
                    ( ( leq(n0,Z3)
                      & leq(n0,A4)
                      & leq(Z3,minus(n6,n1))
                      & leq(A4,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,Z3,A4) = a_select3(pminus_thruster_filter,A4,Z3) ) )
             => ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [B4,C4] :
                    ( ( leq(n0,B4)
                      & leq(n0,C4)
                      & leq(B4,minus(n6,n1))
                      & leq(C4,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,B4,C4) = a_select3(q_thruster_filter,C4,B4) )
                & ! [D4,E4] :
                    ( ( leq(n0,D4)
                      & leq(n0,E4)
                      & leq(D4,minus(n4,n1))
                      & leq(E4,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,D4,E4) = a_select3(r_thruster_filter,E4,D4) )
                & ! [F4,G4] :
                    ( ( leq(n0,F4)
                      & leq(n0,G4)
                      & leq(F4,minus(n6,n1))
                      & leq(G4,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,F4,G4) = a_select3(pminus_thruster_filter,G4,F4) )
                & ! [H4] :
                    ( ( leq(n0,H4)
                      & leq(H4,minus(n0,n1)) )
                   => ! [I4] :
                        ( ( leq(n0,I4)
                          & leq(I4,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,H4,I4) = a_select3(id_thruster_filter,I4,H4) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [J4,K4] :
                    ( ( leq(n0,J4)
                      & leq(n0,K4)
                      & leq(J4,minus(n6,n1))
                      & leq(K4,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,J4,K4) = a_select3(q_thruster_filter,K4,J4) )
                & ! [L4,M4] :
                    ( ( leq(n0,L4)
                      & leq(n0,M4)
                      & leq(L4,minus(n4,n1))
                      & leq(M4,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,L4,M4) = a_select3(r_thruster_filter,M4,L4) )
                & ! [N4,O4] :
                    ( ( leq(n0,N4)
                      & leq(n0,O4)
                      & leq(N4,minus(n6,n1))
                      & leq(O4,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,N4,O4) = a_select3(pminus_thruster_filter,O4,N4) )
                & ! [P4,Q4] :
                    ( ( leq(n0,P4)
                      & leq(n0,Q4)
                      & leq(P4,minus(n6,n1))
                      & leq(Q4,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,P4,Q4) = a_select3(pminus_thruster_filter,Q4,P4) )
                & ! [R4] :
                    ( ( leq(n0,R4)
                      & leq(R4,minus(n6,n1)) )
                   => ! [S4] :
                        ( ( leq(n0,S4)
                          & leq(S4,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,R4,S4) = a_select3(id_thruster_filter,S4,R4) ) ) )
             => ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [T4,U4] :
                    ( ( leq(n0,T4)
                      & leq(n0,U4)
                      & leq(T4,minus(n6,n1))
                      & leq(U4,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,T4,U4) = a_select3(q_thruster_filter,U4,T4) )
                & ! [V4,W4] :
                    ( ( leq(n0,V4)
                      & leq(n0,W4)
                      & leq(V4,minus(n4,n1))
                      & leq(W4,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,V4,W4) = a_select3(r_thruster_filter,W4,V4) )
                & ! [X4,Y4] :
                    ( ( leq(n0,X4)
                      & leq(n0,Y4)
                      & leq(X4,minus(n6,n1))
                      & leq(Y4,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,X4,Y4) = a_select3(pminus_thruster_filter,Y4,X4) )
                & ! [Z4,A5] :
                    ( ( leq(n0,Z4)
                      & leq(n0,A5)
                      & leq(Z4,minus(n6,n1))
                      & leq(A5,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,Z4,A5) = a_select3(pminus_thruster_filter,A5,Z4) )
                & ! [B5] :
                    ( ( leq(n0,B5)
                      & leq(B5,minus(n6,n1)) )
                   => ! [C5] :
                        ( ( leq(n0,C5)
                          & leq(C5,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,B5,C5) = a_select3(id_thruster_filter,C5,B5) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [D5,E5] :
                    ( ( leq(n0,D5)
                      & leq(n0,E5)
                      & leq(D5,minus(n6,n1))
                      & leq(E5,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,D5,E5) = a_select3(q_thruster_filter,E5,D5) )
                & ! [F5,G5] :
                    ( ( leq(n0,F5)
                      & leq(n0,G5)
                      & leq(F5,minus(n4,n1))
                      & leq(G5,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,F5,G5) = a_select3(r_thruster_filter,G5,F5) )
                & ! [H5,I5] :
                    ( ( leq(n0,H5)
                      & leq(n0,I5)
                      & leq(H5,minus(n6,n1))
                      & leq(I5,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,H5,I5) = a_select3(pminus_thruster_filter,I5,H5) )
                & ! [J5,K5] :
                    ( ( leq(n0,J5)
                      & leq(n0,K5)
                      & leq(J5,minus(n6,n1))
                      & leq(K5,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,J5,K5) = a_select3(pminus_thruster_filter,K5,J5) )
                & ! [L5] :
                    ( ( leq(n0,L5)
                      & leq(L5,minus(n6,n1)) )
                   => ! [M5] :
                        ( ( leq(n0,M5)
                          & leq(M5,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,L5,M5) = a_select3(id_thruster_filter,M5,L5) ) ) )
             => ( ! [N5,O5] :
                    ( ( leq(n0,N5)
                      & leq(n0,O5)
                      & leq(N5,minus(n6,n1))
                      & leq(O5,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,N5,O5) = a_select3(q_thruster_filter,O5,N5) )
                & ! [P5,Q5] :
                    ( ( leq(n0,P5)
                      & leq(n0,Q5)
                      & leq(P5,minus(n4,n1))
                      & leq(Q5,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,P5,Q5) = a_select3(r_thruster_filter,Q5,P5) )
                & ! [R5,S5] :
                    ( ( leq(n0,R5)
                      & leq(n0,S5)
                      & leq(R5,minus(n6,n1))
                      & leq(S5,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,R5,S5) = a_select3(pminus_thruster_filter,S5,R5) ) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [T5,U5] :
                    ( ( leq(n0,T5)
                      & leq(n0,U5)
                      & leq(T5,minus(n6,n1))
                      & leq(U5,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,T5,U5) = a_select3(q_thruster_filter,U5,T5) )
                & ! [V5,W5] :
                    ( ( leq(n0,V5)
                      & leq(n0,W5)
                      & leq(V5,minus(n4,n1))
                      & leq(W5,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,V5,W5) = a_select3(r_thruster_filter,W5,V5) )
                & ! [X5,Y5] :
                    ( ( leq(n0,X5)
                      & leq(n0,Y5)
                      & leq(X5,minus(n6,n1))
                      & leq(Y5,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,X5,Y5) = a_select3(pminus_thruster_filter,Y5,X5) )
                & ! [Z5] :
                    ( ( leq(n0,Z5)
                      & leq(Z5,minus(plus(n1,minus(n6,n1)),n1)) )
                   => ! [A6] :
                        ( ( leq(n0,A6)
                          & leq(A6,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,Z5,A6) = a_select3(id_thruster_filter,A6,Z5) ) ) )
             => ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [B6,C6] :
                    ( ( leq(n0,B6)
                      & leq(n0,C6)
                      & leq(B6,minus(n6,n1))
                      & leq(C6,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,B6,C6) = a_select3(q_thruster_filter,C6,B6) )
                & ! [D6,E6] :
                    ( ( leq(n0,D6)
                      & leq(n0,E6)
                      & leq(D6,minus(n4,n1))
                      & leq(E6,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,D6,E6) = a_select3(r_thruster_filter,E6,D6) )
                & ! [F6,G6] :
                    ( ( leq(n0,F6)
                      & leq(n0,G6)
                      & leq(F6,minus(n6,n1))
                      & leq(G6,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,F6,G6) = a_select3(pminus_thruster_filter,G6,F6) )
                & ! [H6] :
                    ( ( leq(n0,H6)
                      & leq(H6,minus(n6,n1)) )
                   => ! [I6] :
                        ( ( leq(n0,I6)
                          & leq(I6,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,H6,I6) = a_select3(id_thruster_filter,I6,H6) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588)
                & ! [J6,K6] :
                    ( ( leq(n0,J6)
                      & leq(n0,K6)
                      & leq(J6,minus(n6,n1))
                      & leq(K6,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,J6,K6) = a_select3(q_thruster_filter,K6,J6) )
                & ! [L6,M6] :
                    ( ( leq(n0,L6)
                      & leq(n0,M6)
                      & leq(L6,minus(n4,n1))
                      & leq(M6,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,L6,M6) = a_select3(r_thruster_filter,M6,L6) )
                & ! [N6,O6] :
                    ( ( leq(n0,N6)
                      & leq(n0,O6)
                      & leq(N6,minus(n6,n1))
                      & leq(O6,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,N6,O6) = a_select3(pminus_thruster_filter,O6,N6) )
                & ! [P6] :
                    ( ( leq(n0,P6)
                      & leq(P6,minus(n6,n1)) )
                   => ! [Q6] :
                        ( ( leq(n0,Q6)
                          & leq(Q6,minus(n6,n1)) )
                       => a_select3(id_thruster_filter,P6,Q6) = a_select3(id_thruster_filter,Q6,P6) ) ) )
             => ( ( ~ gt(pv5,n0)
                 => ( ( ~ gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [R6,S6] :
                                    ( ( leq(n0,R6)
                                      & leq(n0,S6)
                                      & leq(R6,minus(n6,n1))
                                      & leq(S6,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,R6,S6) = a_select3(q_thruster_filter,S6,R6) )
                                & ! [T6,U6] :
                                    ( ( leq(n0,T6)
                                      & leq(n0,U6)
                                      & leq(T6,minus(n4,n1))
                                      & leq(U6,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,T6,U6) = a_select3(r_thruster_filter,U6,T6) )
                                & ! [V6,W6] :
                                    ( ( leq(n0,V6)
                                      & leq(n0,W6)
                                      & leq(V6,minus(n6,n1))
                                      & leq(W6,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),V6,W6) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),W6,V6) )
                                & ! [X6,Y6] :
                                    ( ( leq(n0,X6)
                                      & leq(n0,Y6)
                                      & leq(X6,minus(n6,n1))
                                      & leq(Y6,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),X6,Y6) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),Y6,X6) )
                                & ! [Z6] :
                                    ( ( leq(n0,Z6)
                                      & leq(Z6,minus(n6,n1)) )
                                   => ! [A7] :
                                        ( ( leq(n0,A7)
                                          & leq(A7,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,Z6,A7) = a_select3(id_thruster_filter,A7,Z6) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [B7,C7] :
                                    ( ( leq(n0,B7)
                                      & leq(n0,C7)
                                      & leq(B7,minus(n6,n1))
                                      & leq(C7,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,B7,C7) = a_select3(q_thruster_filter,C7,B7) )
                                & ! [D7,E7] :
                                    ( ( leq(n0,D7)
                                      & leq(n0,E7)
                                      & leq(D7,minus(n4,n1))
                                      & leq(E7,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,D7,E7) = a_select3(r_thruster_filter,E7,D7) )
                                & ! [F7,G7] :
                                    ( ( leq(n0,F7)
                                      & leq(n0,G7)
                                      & leq(F7,minus(n6,n1))
                                      & leq(G7,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),F7,G7) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),G7,F7) )
                                & ! [H7,I7] :
                                    ( ( leq(n0,H7)
                                      & leq(n0,I7)
                                      & leq(H7,minus(n6,n1))
                                      & leq(I7,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),H7,I7) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),I7,H7) )
                                & ! [J7] :
                                    ( ( leq(n0,J7)
                                      & leq(J7,minus(n6,n1)) )
                                   => ! [K7] :
                                        ( ( leq(n0,K7)
                                          & leq(K7,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,J7,K7) = a_select3(id_thruster_filter,K7,J7) ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [L7,M7] :
                                    ( ( leq(n0,L7)
                                      & leq(n0,M7)
                                      & leq(L7,minus(n6,n1))
                                      & leq(M7,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,L7,M7) = a_select3(q_thruster_filter,M7,L7) )
                                & ! [N7,O7] :
                                    ( ( leq(n0,N7)
                                      & leq(n0,O7)
                                      & leq(N7,minus(n4,n1))
                                      & leq(O7,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),N7,O7) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),O7,N7) )
                                & ! [P7,Q7] :
                                    ( ( leq(n0,P7)
                                      & leq(n0,Q7)
                                      & leq(P7,minus(n6,n1))
                                      & leq(Q7,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),P7,Q7) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),Q7,P7) )
                                & ! [R7,S7] :
                                    ( ( leq(n0,R7)
                                      & leq(n0,S7)
                                      & leq(R7,minus(n6,n1))
                                      & leq(S7,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),R7,S7) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),S7,R7) )
                                & ! [T7] :
                                    ( ( leq(n0,T7)
                                      & leq(T7,minus(n6,n1)) )
                                   => ! [U7] :
                                        ( ( leq(n0,U7)
                                          & leq(U7,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,T7,U7) = a_select3(id_thruster_filter,U7,T7) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [V7,W7] :
                                    ( ( leq(n0,V7)
                                      & leq(n0,W7)
                                      & leq(V7,minus(n6,n1))
                                      & leq(W7,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,V7,W7) = a_select3(q_thruster_filter,W7,V7) )
                                & ! [X7,Y7] :
                                    ( ( leq(n0,X7)
                                      & leq(n0,Y7)
                                      & leq(X7,minus(n4,n1))
                                      & leq(Y7,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),X7,Y7) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),Y7,X7) )
                                & ! [Z7,A8] :
                                    ( ( leq(n0,Z7)
                                      & leq(n0,A8)
                                      & leq(Z7,minus(n6,n1))
                                      & leq(A8,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),Z7,A8) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),A8,Z7) )
                                & ! [B8,C8] :
                                    ( ( leq(n0,B8)
                                      & leq(n0,C8)
                                      & leq(B8,minus(n6,n1))
                                      & leq(C8,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),B8,C8) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),C8,B8) )
                                & ! [D8] :
                                    ( ( leq(n0,D8)
                                      & leq(D8,minus(n6,n1)) )
                                   => ! [E8] :
                                        ( ( leq(n0,E8)
                                          & leq(E8,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,D8,E8) = a_select3(id_thruster_filter,E8,D8) ) ) ) ) ) ) ) )
                    & ( gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [F8,G8] :
                                    ( ( leq(n0,F8)
                                      & leq(n0,G8)
                                      & leq(F8,minus(n6,n1))
                                      & leq(G8,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,F8,G8) = a_select3(q_thruster_filter,G8,F8) )
                                & ! [H8,I8] :
                                    ( ( leq(n0,H8)
                                      & leq(n0,I8)
                                      & leq(H8,minus(n4,n1))
                                      & leq(I8,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,H8,I8) = a_select3(r_thruster_filter,I8,H8) )
                                & ! [J8,K8] :
                                    ( ( leq(n0,J8)
                                      & leq(n0,K8)
                                      & leq(J8,minus(n6,n1))
                                      & leq(K8,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),J8,K8) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),K8,J8) )
                                & ! [L8,M8] :
                                    ( ( leq(n0,L8)
                                      & leq(n0,M8)
                                      & leq(L8,minus(n6,n1))
                                      & leq(M8,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),L8,M8) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),M8,L8) )
                                & ! [N8] :
                                    ( ( leq(n0,N8)
                                      & leq(N8,minus(n6,n1)) )
                                   => ! [O8] :
                                        ( ( leq(n0,O8)
                                          & leq(O8,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,N8,O8) = a_select3(id_thruster_filter,O8,N8) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [P8,Q8] :
                                    ( ( leq(n0,P8)
                                      & leq(n0,Q8)
                                      & leq(P8,minus(n6,n1))
                                      & leq(Q8,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,P8,Q8) = a_select3(q_thruster_filter,Q8,P8) )
                                & ! [R8,S8] :
                                    ( ( leq(n0,R8)
                                      & leq(n0,S8)
                                      & leq(R8,minus(n4,n1))
                                      & leq(S8,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,R8,S8) = a_select3(r_thruster_filter,S8,R8) )
                                & ! [T8,U8] :
                                    ( ( leq(n0,T8)
                                      & leq(n0,U8)
                                      & leq(T8,minus(n6,n1))
                                      & leq(U8,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),T8,U8) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),U8,T8) )
                                & ! [V8,W8] :
                                    ( ( leq(n0,V8)
                                      & leq(n0,W8)
                                      & leq(V8,minus(n6,n1))
                                      & leq(W8,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),V8,W8) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),W8,V8) )
                                & ! [X8] :
                                    ( ( leq(n0,X8)
                                      & leq(X8,minus(n6,n1)) )
                                   => ! [Y8] :
                                        ( ( leq(n0,Y8)
                                          & leq(Y8,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,X8,Y8) = a_select3(id_thruster_filter,Y8,X8) ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [Z8,A9] :
                                    ( ( leq(n0,Z8)
                                      & leq(n0,A9)
                                      & leq(Z8,minus(n6,n1))
                                      & leq(A9,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,Z8,A9) = a_select3(q_thruster_filter,A9,Z8) )
                                & ! [B9,C9] :
                                    ( ( leq(n0,B9)
                                      & leq(n0,C9)
                                      & leq(B9,minus(n4,n1))
                                      & leq(C9,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),B9,C9) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),C9,B9) )
                                & ! [D9,E9] :
                                    ( ( leq(n0,D9)
                                      & leq(n0,E9)
                                      & leq(D9,minus(n6,n1))
                                      & leq(E9,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),D9,E9) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),E9,D9) )
                                & ! [F9,G9] :
                                    ( ( leq(n0,F9)
                                      & leq(n0,G9)
                                      & leq(F9,minus(n6,n1))
                                      & leq(G9,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),F9,G9) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(phi_thruster_filter)))),G9,F9) )
                                & ! [H9] :
                                    ( ( leq(n0,H9)
                                      & leq(H9,minus(n6,n1)) )
                                   => ! [I9] :
                                        ( ( leq(n0,I9)
                                          & leq(I9,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,H9,I9) = a_select3(id_thruster_filter,I9,H9) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [J9,K9] :
                                    ( ( leq(n0,J9)
                                      & leq(n0,K9)
                                      & leq(J9,minus(n6,n1))
                                      & leq(K9,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,J9,K9) = a_select3(q_thruster_filter,K9,J9) )
                                & ! [L9,M9] :
                                    ( ( leq(n0,L9)
                                      & leq(n0,M9)
                                      & leq(L9,minus(n4,n1))
                                      & leq(M9,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),L9,M9) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),M9,L9) )
                                & ! [N9,O9] :
                                    ( ( leq(n0,N9)
                                      & leq(n0,O9)
                                      & leq(N9,minus(n6,n1))
                                      & leq(O9,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),N9,O9) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),O9,N9) )
                                & ! [P9,Q9] :
                                    ( ( leq(n0,P9)
                                      & leq(n0,Q9)
                                      & leq(P9,minus(n6,n1))
                                      & leq(Q9,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),P9,Q9) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(phi_thruster_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(phi_thruster_filter)))),Q9,P9) )
                                & ! [R9] :
                                    ( ( leq(n0,R9)
                                      & leq(R9,minus(n6,n1)) )
                                   => ! [S9] :
                                        ( ( leq(n0,S9)
                                          & leq(S9,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,R9,S9) = a_select3(id_thruster_filter,S9,R9) ) ) ) ) ) ) ) ) ) )
                & ( gt(pv5,n0)
                 => ( ( ~ gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [T9,U9] :
                                    ( ( leq(n0,T9)
                                      & leq(n0,U9)
                                      & leq(T9,minus(n6,n1))
                                      & leq(U9,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,T9,U9) = a_select3(q_thruster_filter,U9,T9) )
                                & ! [V9,W9] :
                                    ( ( leq(n0,V9)
                                      & leq(n0,W9)
                                      & leq(V9,minus(n4,n1))
                                      & leq(W9,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,V9,W9) = a_select3(r_thruster_filter,W9,V9) )
                                & ! [X9,Y9] :
                                    ( ( leq(n0,X9)
                                      & leq(n0,Y9)
                                      & leq(X9,minus(n6,n1))
                                      & leq(Y9,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),X9,Y9) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),Y9,X9) )
                                & ! [Z9,A10] :
                                    ( ( leq(n0,Z9)
                                      & leq(n0,A10)
                                      & leq(Z9,minus(n6,n1))
                                      & leq(A10,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),Z9,A10) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),A10,Z9) )
                                & ! [B10] :
                                    ( ( leq(n0,B10)
                                      & leq(B10,minus(n6,n1)) )
                                   => ! [C10] :
                                        ( ( leq(n0,C10)
                                          & leq(C10,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,B10,C10) = a_select3(id_thruster_filter,C10,B10) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [D10,E10] :
                                    ( ( leq(n0,D10)
                                      & leq(n0,E10)
                                      & leq(D10,minus(n6,n1))
                                      & leq(E10,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,D10,E10) = a_select3(q_thruster_filter,E10,D10) )
                                & ! [F10,G10] :
                                    ( ( leq(n0,F10)
                                      & leq(n0,G10)
                                      & leq(F10,minus(n4,n1))
                                      & leq(G10,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,F10,G10) = a_select3(r_thruster_filter,G10,F10) )
                                & ! [H10,I10] :
                                    ( ( leq(n0,H10)
                                      & leq(n0,I10)
                                      & leq(H10,minus(n6,n1))
                                      & leq(I10,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),H10,I10) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),I10,H10) )
                                & ! [J10,K10] :
                                    ( ( leq(n0,J10)
                                      & leq(n0,K10)
                                      & leq(J10,minus(n6,n1))
                                      & leq(K10,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),J10,K10) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),K10,J10) )
                                & ! [L10] :
                                    ( ( leq(n0,L10)
                                      & leq(L10,minus(n6,n1)) )
                                   => ! [M10] :
                                        ( ( leq(n0,M10)
                                          & leq(M10,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,L10,M10) = a_select3(id_thruster_filter,M10,L10) ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [N10,O10] :
                                    ( ( leq(n0,N10)
                                      & leq(n0,O10)
                                      & leq(N10,minus(n6,n1))
                                      & leq(O10,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,N10,O10) = a_select3(q_thruster_filter,O10,N10) )
                                & ! [P10,Q10] :
                                    ( ( leq(n0,P10)
                                      & leq(n0,Q10)
                                      & leq(P10,minus(n4,n1))
                                      & leq(Q10,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),P10,Q10) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),Q10,P10) )
                                & ! [R10,S10] :
                                    ( ( leq(n0,R10)
                                      & leq(n0,S10)
                                      & leq(R10,minus(n6,n1))
                                      & leq(S10,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),R10,S10) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),S10,R10) )
                                & ! [T10,U10] :
                                    ( ( leq(n0,T10)
                                      & leq(n0,U10)
                                      & leq(T10,minus(n6,n1))
                                      & leq(U10,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),T10,U10) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),U10,T10) )
                                & ! [V10] :
                                    ( ( leq(n0,V10)
                                      & leq(V10,minus(n6,n1)) )
                                   => ! [W10] :
                                        ( ( leq(n0,W10)
                                          & leq(W10,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,V10,W10) = a_select3(id_thruster_filter,W10,V10) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [X10,Y10] :
                                    ( ( leq(n0,X10)
                                      & leq(n0,Y10)
                                      & leq(X10,minus(n6,n1))
                                      & leq(Y10,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,X10,Y10) = a_select3(q_thruster_filter,Y10,X10) )
                                & ! [Z10,A11] :
                                    ( ( leq(n0,Z10)
                                      & leq(n0,A11)
                                      & leq(Z10,minus(n4,n1))
                                      & leq(A11,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),Z10,A11) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),A11,Z10) )
                                & ! [B11,C11] :
                                    ( ( leq(n0,B11)
                                      & leq(n0,C11)
                                      & leq(B11,minus(n6,n1))
                                      & leq(C11,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),B11,C11) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),C11,B11) )
                                & ! [D11,E11] :
                                    ( ( leq(n0,D11)
                                      & leq(n0,E11)
                                      & leq(D11,minus(n6,n1))
                                      & leq(E11,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),D11,E11) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),E11,D11) )
                                & ! [F11] :
                                    ( ( leq(n0,F11)
                                      & leq(F11,minus(n6,n1)) )
                                   => ! [G11] :
                                        ( ( leq(n0,G11)
                                          & leq(G11,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,F11,G11) = a_select3(id_thruster_filter,G11,F11) ) ) ) ) ) ) ) )
                    & ( gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [H11,I11] :
                                    ( ( leq(n0,H11)
                                      & leq(n0,I11)
                                      & leq(H11,minus(n6,n1))
                                      & leq(I11,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,H11,I11) = a_select3(q_thruster_filter,I11,H11) )
                                & ! [J11,K11] :
                                    ( ( leq(n0,J11)
                                      & leq(n0,K11)
                                      & leq(J11,minus(n4,n1))
                                      & leq(K11,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,J11,K11) = a_select3(r_thruster_filter,K11,J11) )
                                & ! [L11,M11] :
                                    ( ( leq(n0,L11)
                                      & leq(n0,M11)
                                      & leq(L11,minus(n6,n1))
                                      & leq(M11,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),L11,M11) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),M11,L11) )
                                & ! [N11,O11] :
                                    ( ( leq(n0,N11)
                                      & leq(n0,O11)
                                      & leq(N11,minus(n6,n1))
                                      & leq(O11,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),N11,O11) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(r_thruster_filter,tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),O11,N11) )
                                & ! [P11] :
                                    ( ( leq(n0,P11)
                                      & leq(P11,minus(n6,n1)) )
                                   => ! [Q11] :
                                        ( ( leq(n0,Q11)
                                          & leq(Q11,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,P11,Q11) = a_select3(id_thruster_filter,Q11,P11) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [R11,S11] :
                                    ( ( leq(n0,R11)
                                      & leq(n0,S11)
                                      & leq(R11,minus(n6,n1))
                                      & leq(S11,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,R11,S11) = a_select3(q_thruster_filter,S11,R11) )
                                & ! [T11,U11] :
                                    ( ( leq(n0,T11)
                                      & leq(n0,U11)
                                      & leq(T11,minus(n4,n1))
                                      & leq(U11,minus(n4,n1)) )
                                   => a_select3(r_thruster_filter,T11,U11) = a_select3(r_thruster_filter,U11,T11) )
                                & ! [V11,W11] :
                                    ( ( leq(n0,V11)
                                      & leq(n0,W11)
                                      & leq(V11,minus(n6,n1))
                                      & leq(W11,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),V11,W11) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),W11,V11) )
                                & ! [X11,Y11] :
                                    ( ( leq(n0,X11)
                                      & leq(n0,Y11)
                                      & leq(X11,minus(n6,n1))
                                      & leq(Y11,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),X11,Y11) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(r_thruster_filter,trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(r_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),Y11,X11) )
                                & ! [Z11] :
                                    ( ( leq(n0,Z11)
                                      & leq(Z11,minus(n6,n1)) )
                                   => ! [A12] :
                                        ( ( leq(n0,A12)
                                          & leq(A12,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,Z11,A12) = a_select3(id_thruster_filter,A12,Z11) ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [B12,C12] :
                                    ( ( leq(n0,B12)
                                      & leq(n0,C12)
                                      & leq(B12,minus(n6,n1))
                                      & leq(C12,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,B12,C12) = a_select3(q_thruster_filter,C12,B12) )
                                & ! [D12,E12] :
                                    ( ( leq(n0,D12)
                                      & leq(n0,E12)
                                      & leq(D12,minus(n4,n1))
                                      & leq(E12,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),D12,E12) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),E12,D12) )
                                & ! [F12,G12] :
                                    ( ( leq(n0,F12)
                                      & leq(n0,G12)
                                      & leq(F12,minus(n6,n1))
                                      & leq(G12,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),F12,G12) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),G12,F12) )
                                & ! [H12,I12] :
                                    ( ( leq(n0,H12)
                                      & leq(n0,I12)
                                      & leq(H12,minus(n6,n1))
                                      & leq(I12,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),H12,I12) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter)))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(h_thruster_filter),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(h_thruster_filter,tptp_mmul(pminus_thruster_filter,trans(h_thruster_filter))))))),h_thruster_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),I12,H12) )
                                & ! [J12] :
                                    ( ( leq(n0,J12)
                                      & leq(J12,minus(n6,n1)) )
                                   => ! [K12] :
                                        ( ( leq(n0,K12)
                                          & leq(K12,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,J12,K12) = a_select3(id_thruster_filter,K12,J12) ) ) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [L12,M12] :
                                    ( ( leq(n0,L12)
                                      & leq(n0,M12)
                                      & leq(L12,minus(n6,n1))
                                      & leq(M12,minus(n6,n1)) )
                                   => a_select3(q_thruster_filter,L12,M12) = a_select3(q_thruster_filter,M12,L12) )
                                & ! [N12,O12] :
                                    ( ( leq(n0,N12)
                                      & leq(n0,O12)
                                      & leq(N12,minus(n4,n1))
                                      & leq(O12,minus(n4,n1)) )
                                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),N12,O12) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),O12,N12) )
                                & ! [P12,Q12] :
                                    ( ( leq(n0,P12)
                                      & leq(n0,Q12)
                                      & leq(P12,minus(n6,n1))
                                      & leq(Q12,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),P12,Q12) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),Q12,P12) )
                                & ! [R12,S12] :
                                    ( ( leq(n0,R12)
                                      & leq(n0,S12)
                                      & leq(R12,minus(n6,n1))
                                      & leq(S12,minus(n6,n1)) )
                                   => a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),R12,S12) = a_select3(tptp_madd(q_thruster_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),trans(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))))))),tptp_mmul(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))),tptp_mmul(pminus_thruster_filter,trans(tptp_msub(id_thruster_filter,tptp_mmul(tptp_mmul(pminus_thruster_filter,tptp_mmul(trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))),inv(tptp_madd(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n3,n3,a_select3(rho,n3,pv5)),n2,n2,a_select3(rho,n2,pv5)),n1,n1,a_select3(rho,n1,pv5)),n0,n0,a_select3(rho,n0,pv5)),tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))),tptp_mmul(pminus_thruster_filter,trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0)))))))))))),tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter,n3,n0,tptp_uminus(plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0)))))),n2,n0,minus(times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n1,n0,plus(times(tptp_float_0_217,sin(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,cos(a_select3(xhatmin_thruster_filter,n0,n0))))),n0,n0,minus(times(tptp_float_0_217,cos(a_select3(xhatmin_thruster_filter,n0,n0))),times(tptp_float_0_423,sin(a_select3(xhatmin_thruster_filter,n0,n0))))))))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter,n5,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))))),tptp_float_70_707)),n4,n0,divide(times(tptp_float_0_034,times(tptp_float_1_2,minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))))),tptp_float_70_707)),n2,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)),n1,n0,divide(times(tptp_float_1_2,times(minus(minus(minus(minus(plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n1,pv5)),plus(times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n2,pv5)),plus(times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n0,pv5)),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n7,pv5))))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n5,pv5))),times(cos(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n6,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n3,pv5))),times(sin(a_select3(xhatmin_thruster_filter,n0,n0)),a_select3(tr,n4,pv5))),divide(times(tptp_float_0_034,tptp_float_0_034),n2))),tptp_float_70_707)))))),S12,R12) )
                                & ! [T12] :
                                    ( ( leq(n0,T12)
                                      & leq(T12,minus(n6,n1)) )
                                   => ! [U12] :
                                        ( ( leq(n0,U12)
                                          & leq(U12,minus(n6,n1)) )
                                       => a_select3(id_thruster_filter,T12,U12) = a_select3(id_thruster_filter,U12,T12) ) ) ) ) ) ) ) ) ) ) ) )
            & ( ( leq(n0,pv31)
                & leq(pv31,minus(n6,n1)) )
             => ( leq(n0,a_select2(sigma,pv31))
               => true ) )
            & ( ( ! [V12,W12] :
                    ( ( leq(n0,V12)
                      & leq(n0,W12)
                      & leq(V12,minus(n6,n1))
                      & leq(W12,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,V12,W12) = a_select3(q_thruster_filter,W12,V12) )
                & ! [X12,Y12] :
                    ( ( leq(n0,X12)
                      & leq(n0,Y12)
                      & leq(X12,minus(n4,n1))
                      & leq(Y12,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,X12,Y12) = a_select3(r_thruster_filter,Y12,X12) ) )
             => ( ! [Z12,A13] :
                    ( ( leq(n0,Z12)
                      & leq(n0,A13)
                      & leq(Z12,minus(n6,n1))
                      & leq(A13,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,Z12,A13) = a_select3(q_thruster_filter,A13,Z12) )
                & ! [B13,C13] :
                    ( ( leq(n0,B13)
                      & leq(n0,C13)
                      & leq(B13,minus(n4,n1))
                      & leq(C13,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,B13,C13) = a_select3(r_thruster_filter,C13,B13) )
                & ! [D13,E13] :
                    ( ( leq(n0,D13)
                      & leq(n0,E13)
                      & leq(D13,minus(n6,n1))
                      & leq(E13,minus(n6,n1)) )
                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(pminus_thruster_filter,n0,n0,n10000),n0,n1,n0),n0,n2,n0),n0,n3,n0),n0,n4,n0),n0,n5,n0),n1,n0,n0),n1,n1,n10000),n1,n2,n0),n1,n3,n0),n1,n4,n0),n1,n5,n0),n2,n0,n0),n2,n1,n0),n2,n2,n10000),n2,n3,n0),n2,n4,n0),n2,n5,n0),n3,n0,n0),n3,n1,n0),n3,n2,n0),n3,n3,n10000),n3,n4,n0),n3,n5,n0),n4,n0,n0),n4,n1,n0),n4,n2,n0),n4,n3,n0),n4,n4,n10000),n4,n5,n0),n5,n0,n0),n5,n1,n0),n5,n2,n0),n5,n3,n0),n5,n4,n0),n5,n5,n10000),D13,E13) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(pminus_thruster_filter,n0,n0,n10000),n0,n1,n0),n0,n2,n0),n0,n3,n0),n0,n4,n0),n0,n5,n0),n1,n0,n0),n1,n1,n10000),n1,n2,n0),n1,n3,n0),n1,n4,n0),n1,n5,n0),n2,n0,n0),n2,n1,n0),n2,n2,n10000),n2,n3,n0),n2,n4,n0),n2,n5,n0),n3,n0,n0),n3,n1,n0),n3,n2,n0),n3,n3,n10000),n3,n4,n0),n3,n5,n0),n4,n0,n0),n4,n1,n0),n4,n2,n0),n4,n3,n0),n4,n4,n10000),n4,n5,n0),n5,n0,n0),n5,n1,n0),n5,n2,n0),n5,n3,n0),n5,n4,n0),n5,n5,n10000),E13,D13) ) ) )
            & ( ( ! [F13,G13] :
                    ( ( leq(n0,F13)
                      & leq(n0,G13)
                      & leq(F13,minus(n6,n1))
                      & leq(G13,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,F13,G13) = a_select3(q_thruster_filter,G13,F13) )
                & ! [H13,I13] :
                    ( ( leq(n0,H13)
                      & leq(n0,I13)
                      & leq(H13,minus(n4,n1))
                      & leq(I13,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,H13,I13) = a_select3(r_thruster_filter,I13,H13) )
                & ! [J13,K13] :
                    ( ( leq(n0,J13)
                      & leq(n0,K13)
                      & leq(J13,minus(n6,n1))
                      & leq(K13,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,J13,K13) = a_select3(pminus_thruster_filter,K13,J13) ) )
             => true )
            & ( ( ! [L13,M13] :
                    ( ( leq(n0,L13)
                      & leq(n0,M13)
                      & leq(L13,minus(n6,n1))
                      & leq(M13,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,L13,M13) = a_select3(q_thruster_filter,M13,L13) )
                & ! [N13,O13] :
                    ( ( leq(n0,N13)
                      & leq(n0,O13)
                      & leq(N13,minus(n4,n1))
                      & leq(O13,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,N13,O13) = a_select3(r_thruster_filter,O13,N13) )
                & ! [P13,Q13] :
                    ( ( leq(n0,P13)
                      & leq(n0,Q13)
                      & leq(P13,minus(n6,n1))
                      & leq(Q13,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,P13,Q13) = a_select3(pminus_thruster_filter,Q13,P13) ) )
             => ( ! [R13,S13] :
                    ( ( leq(n0,R13)
                      & leq(n0,S13)
                      & leq(R13,minus(n6,n1))
                      & leq(S13,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,R13,S13) = a_select3(q_thruster_filter,S13,R13) )
                & ! [T13,U13] :
                    ( ( leq(n0,T13)
                      & leq(n0,U13)
                      & leq(T13,minus(n4,n1))
                      & leq(U13,minus(n4,n1)) )
                   => a_select3(r_thruster_filter,T13,U13) = a_select3(r_thruster_filter,U13,T13) )
                & ! [V13,W13] :
                    ( ( leq(n0,V13)
                      & leq(n0,W13)
                      & leq(V13,minus(n6,n1))
                      & leq(W13,minus(n6,n1)) )
                   => a_select3(pminus_thruster_filter,V13,W13) = a_select3(pminus_thruster_filter,W13,V13) ) ) )
            & ( geq(minus(n6,n1),n0)
             => ( geq(minus(n6,n1),n0)
               => ( ( geq(minus(n4,n1),n0)
                    & geq(minus(n1000,n1),n0) )
                 => true ) ) )
            & ( ! [X13,Y13] :
                  ( ( leq(n0,X13)
                    & leq(n0,Y13)
                    & leq(X13,minus(n6,n1))
                    & leq(Y13,minus(n6,n1)) )
                 => a_select3(q_thruster_filter,X13,Y13) = a_select3(q_thruster_filter,Y13,X13) )
             => ( ! [Z13,A14] :
                    ( ( leq(n0,Z13)
                      & leq(n0,A14)
                      & leq(Z13,minus(n6,n1))
                      & leq(A14,minus(n6,n1)) )
                   => a_select3(q_thruster_filter,Z13,A14) = a_select3(q_thruster_filter,A14,Z13) )
                & ! [B14,C14] :
                    ( ( leq(n0,B14)
                      & leq(n0,C14)
                      & leq(B14,minus(n4,n1))
                      & leq(C14,minus(n4,n1)) )
                   => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n0,n0,a_select3(rho,n0,n0)),n0,n1,n0),n0,n2,n0),n0,n3,n0),n1,n0,n0),n1,n1,a_select3(rho,n1,n0)),n1,n2,n0),n1,n3,n0),n2,n0,n0),n2,n1,n0),n2,n2,a_select3(rho,n2,n0)),n2,n3,n0),n3,n0,n0),n3,n1,n0),n3,n2,n0),n3,n3,a_select3(rho,n3,n0)),B14,C14) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter,n0,n0,a_select3(rho,n0,n0)),n0,n1,n0),n0,n2,n0),n0,n3,n0),n1,n0,n0),n1,n1,a_select3(rho,n1,n0)),n1,n2,n0),n1,n3,n0),n2,n0,n0),n2,n1,n0),n2,n2,a_select3(rho,n2,n0)),n2,n3,n0),n3,n0,n0),n3,n1,n0),n3,n2,n0),n3,n3,a_select3(rho,n3,n0)),C14,B14) ) ) ) ) ) ) ).

fof(gt_10000_588,axiom,
    gt(n10000,n588) ).

fof(gt_1000_588,axiom,
    gt(n1000,n588) ).

fof(gt_588_4,axiom,
    gt(n588,n4) ).

fof(gt_707_4,axiom,
    gt(n707,n4) ).

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_7_4,axiom,
    gt(n7,n4) ).

fof(gt_217_4,axiom,
    gt(n217,n4) ).

fof(gt_10000_4,axiom,
    gt(n10000,n4) ).

fof(gt_423_4,axiom,
    gt(n423,n4) ).

fof(gt_1000_4,axiom,
    gt(n1000,n4) ).

fof(gt_34_4,axiom,
    gt(n34,n4) ).

fof(gt_10000_707,axiom,
    gt(n10000,n707) ).

fof(gt_1000_707,axiom,
    gt(n1000,n707) ).

fof(gt_588_5,axiom,
    gt(n588,n5) ).

fof(gt_707_5,axiom,
    gt(n707,n5) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_7_5,axiom,
    gt(n7,n5) ).

fof(gt_217_5,axiom,
    gt(n217,n5) ).

fof(gt_10000_5,axiom,
    gt(n10000,n5) ).

fof(gt_423_5,axiom,
    gt(n423,n5) ).

fof(gt_1000_5,axiom,
    gt(n1000,n5) ).

fof(gt_34_5,axiom,
    gt(n34,n5) ).

fof(gt_588_6,axiom,
    gt(n588,n6) ).

fof(gt_707_6,axiom,
    gt(n707,n6) ).

fof(gt_7_6,axiom,
    gt(n7,n6) ).

fof(gt_217_6,axiom,
    gt(n217,n6) ).

fof(gt_10000_6,axiom,
    gt(n10000,n6) ).

fof(gt_423_6,axiom,
    gt(n423,n6) ).

fof(gt_1000_6,axiom,
    gt(n1000,n6) ).

fof(gt_34_6,axiom,
    gt(n34,n6) ).

fof(gt_588_7,axiom,
    gt(n588,n7) ).

fof(gt_707_7,axiom,
    gt(n707,n7) ).

fof(gt_217_7,axiom,
    gt(n217,n7) ).

fof(gt_10000_7,axiom,
    gt(n10000,n7) ).

fof(gt_423_7,axiom,
    gt(n423,n7) ).

fof(gt_1000_7,axiom,
    gt(n1000,n7) ).

fof(gt_34_7,axiom,
    gt(n34,n7) ).

fof(gt_588_217,axiom,
    gt(n588,n217) ).

fof(gt_707_217,axiom,
    gt(n707,n217) ).

fof(gt_10000_217,axiom,
    gt(n10000,n217) ).

fof(gt_423_217,axiom,
    gt(n423,n217) ).

fof(gt_1000_217,axiom,
    gt(n1000,n217) ).

fof(gt_588_tptp_minus_1,axiom,
    gt(n588,tptp_minus_1) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_707_tptp_minus_1,axiom,
    gt(n707,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_7_tptp_minus_1,axiom,
    gt(n7,tptp_minus_1) ).

fof(gt_217_tptp_minus_1,axiom,
    gt(n217,tptp_minus_1) ).

fof(gt_10000_tptp_minus_1,axiom,
    gt(n10000,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_423_tptp_minus_1,axiom,
    gt(n423,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_1000_tptp_minus_1,axiom,
    gt(n1000,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_34_tptp_minus_1,axiom,
    gt(n34,tptp_minus_1) ).

fof(gt_588_0,axiom,
    gt(n588,n0) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_707_0,axiom,
    gt(n707,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_7_0,axiom,
    gt(n7,n0) ).

fof(gt_217_0,axiom,
    gt(n217,n0) ).

fof(gt_10000_0,axiom,
    gt(n10000,n0) ).

fof(gt_423_0,axiom,
    gt(n423,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_1000_0,axiom,
    gt(n1000,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_34_0,axiom,
    gt(n34,n0) ).

fof(gt_588_423,axiom,
    gt(n588,n423) ).

fof(gt_707_423,axiom,
    gt(n707,n423) ).

fof(gt_10000_423,axiom,
    gt(n10000,n423) ).

fof(gt_1000_423,axiom,
    gt(n1000,n423) ).

fof(gt_588_1,axiom,
    gt(n588,n1) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_707_1,axiom,
    gt(n707,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_7_1,axiom,
    gt(n7,n1) ).

fof(gt_217_1,axiom,
    gt(n217,n1) ).

fof(gt_10000_1,axiom,
    gt(n10000,n1) ).

fof(gt_423_1,axiom,
    gt(n423,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_1000_1,axiom,
    gt(n1000,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_34_1,axiom,
    gt(n34,n1) ).

fof(gt_588_2,axiom,
    gt(n588,n2) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_707_2,axiom,
    gt(n707,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_7_2,axiom,
    gt(n7,n2) ).

fof(gt_217_2,axiom,
    gt(n217,n2) ).

fof(gt_10000_2,axiom,
    gt(n10000,n2) ).

fof(gt_423_2,axiom,
    gt(n423,n2) ).

fof(gt_1000_2,axiom,
    gt(n1000,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_34_2,axiom,
    gt(n34,n2) ).

fof(gt_10000_1000,axiom,
    gt(n10000,n1000) ).

fof(gt_588_3,axiom,
    gt(n588,n3) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_707_3,axiom,
    gt(n707,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(gt_7_3,axiom,
    gt(n7,n3) ).

fof(gt_217_3,axiom,
    gt(n217,n3) ).

fof(gt_10000_3,axiom,
    gt(n10000,n3) ).

fof(gt_423_3,axiom,
    gt(n423,n3) ).

fof(gt_1000_3,axiom,
    gt(n1000,n3) ).

fof(gt_34_3,axiom,
    gt(n34,n3) ).

fof(gt_588_34,axiom,
    gt(n588,n34) ).

fof(gt_707_34,axiom,
    gt(n707,n34) ).

fof(gt_217_34,axiom,
    gt(n217,n34) ).

fof(gt_10000_34,axiom,
    gt(n10000,n34) ).

fof(gt_423_34,axiom,
    gt(n423,n34) ).

fof(gt_1000_34,axiom,
    gt(n1000,n34) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
