%------------------------------------------------------------------------------
% File     : SWV129+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_inuse_0002
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the inuse-safety verification for
%            the thruster program. inuse-safety ensures that each sensor
%            reading passed as an input to the Kalman filter algorithm is
%            actually used during the computation of the output estimate.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_inuse_0002 [Fis04]

% Status   : CounterSatisfiable
% Rating   : 1.00 v3.3.0
% Syntax   : Number of formulae    :  121 (  84 unt;   0 def)
%            Number of atoms       : 1572 (1009 equ)
%            Maximal formula atoms : 1279 (  12 avg)
%            Number of connectives : 1472 (  21   ~;  23   |;1257   &)
%                                         (   5 <=>; 166  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   52 (   4 avg)
%            Maximal term depth    :   17 (   2 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   41 (  41 usr;  23 con; 0-4 aty)
%            Number of variables   :  289 ( 289   !;   0   ?)
% SPC      : FOF_CSA_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(thruster_inuse_0002,conjecture,
    ( ( geq(minus(n4,n1),n0)
      & geq(minus(n1000,n1),n0) )
   => ! [A] :
        ( ( geq(n7,n0)
          & geq(minus(n1000,n1),n0) )
       => ! [P4] :
            ( ( true
             => a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_defuse,n0,use),n0,use),n0,use),n0,use),n0) = use )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & ! [B,C] :
                    ( ( leq(n0,B)
                      & leq(n0,C)
                      & leq(B,n3)
                      & leq(C,minus(n0,n1)) )
                   => ( a_select3(z_defuse,B,C) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),B,C) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),B,C) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(n0,pv23)
                & leq(pv5,n588)
                & leq(pv23,minus(n6,n1))
                & ! [D,E] :
                    ( ( leq(n0,D)
                      & leq(n0,E)
                      & leq(D,n3)
                      & leq(E,pv5) )
                   => ( a_select3(z_defuse,D,E) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),D,E) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),D,E) = use ) )
                & ! [F,G] :
                    ( ( leq(n0,F)
                      & leq(n0,G)
                      & leq(F,n3)
                      & leq(G,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,F,G) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),F,G) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),F,G) = use ) ) )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [H,I] :
                    ( ( leq(n0,H)
                      & leq(n0,I)
                      & leq(H,n3)
                      & leq(I,pv5) )
                   => ( a_select3(z_defuse,H,I) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),H,I) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),H,I) = use ) )
                & ! [J,K] :
                    ( ( leq(n0,J)
                      & leq(n0,K)
                      & leq(J,n3)
                      & leq(K,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,J,K) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),J,K) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),J,K) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(n0,pv33)
                & leq(n0,pv34)
                & leq(pv5,n588)
                & leq(pv33,minus(n6,n1))
                & leq(pv34,minus(n6,n1))
                & ! [L,M] :
                    ( ( leq(n0,L)
                      & leq(n0,M)
                      & leq(L,n3)
                      & leq(M,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,L,M) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),L,M) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),L,M) = use ) ) )
             => ( ( pv33 != pv34
                 => ( a_select2(xinit_defuse,n0) = use
                    & a_select2(xinit_mean_defuse,n0) = use
                    & a_select2(xinit_mean_defuse,n1) = use
                    & a_select2(xinit_mean_defuse,n2) = use
                    & a_select2(xinit_mean_defuse,n3) = use
                    & a_select2(xinit_mean_defuse,n4) = use
                    & a_select2(xinit_mean_defuse,n5) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                    & leq(n0,pv5)
                    & leq(n0,pv33)
                    & leq(pv5,n588)
                    & leq(pv33,minus(n6,n1))
                    & ! [N,O] :
                        ( ( leq(n0,N)
                          & leq(n0,O)
                          & leq(N,n3)
                          & leq(O,minus(pv5,n1)) )
                       => ( a_select3(z_defuse,N,O) = use
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),N,O) = use
                          & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),N,O) = use ) ) ) )
                & ( pv33 = pv34
                 => ( a_select2(xinit_defuse,n0) = use
                    & a_select2(xinit_mean_defuse,n0) = use
                    & a_select2(xinit_mean_defuse,n1) = use
                    & a_select2(xinit_mean_defuse,n2) = use
                    & a_select2(xinit_mean_defuse,n3) = use
                    & a_select2(xinit_mean_defuse,n4) = use
                    & a_select2(xinit_mean_defuse,n5) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                    & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                    & leq(n0,pv5)
                    & leq(n0,pv33)
                    & leq(pv5,n588)
                    & leq(pv33,minus(n6,n1))
                    & ! [P,Q] :
                        ( ( leq(n0,P)
                          & leq(n0,Q)
                          & leq(P,n3)
                          & leq(Q,minus(pv5,n1)) )
                       => ( a_select3(z_defuse,P,Q) = use
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),P,Q) = use
                          & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),P,Q) = use ) ) ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(n0,pv33)
                & leq(pv5,n588)
                & leq(pv33,minus(n6,n1))
                & ! [R,S] :
                    ( ( leq(n0,R)
                      & leq(n0,S)
                      & leq(R,n3)
                      & leq(S,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,R,S) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),R,S) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),R,S) = use ) ) )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(n0,pv33)
                & leq(pv5,n588)
                & leq(pv33,minus(n6,n1))
                & ! [T,U] :
                    ( ( leq(n0,T)
                      & leq(n0,U)
                      & leq(T,n3)
                      & leq(U,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,T,U) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),T,U) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),T,U) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(n0,pv33)
                & leq(pv5,n588)
                & leq(pv33,minus(n6,n1))
                & ! [V,W] :
                    ( ( leq(n0,V)
                      & leq(n0,W)
                      & leq(V,n3)
                      & leq(W,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,V,W) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),V,W) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),V,W) = use ) ) )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [X,Y] :
                    ( ( leq(n0,X)
                      & leq(n0,Y)
                      & leq(X,n3)
                      & leq(Y,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,X,Y) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),X,Y) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),X,Y) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [Z,A1] :
                    ( ( leq(n0,Z)
                      & leq(n0,A1)
                      & leq(Z,n3)
                      & leq(A1,pv5) )
                   => ( a_select3(z_defuse,Z,A1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),Z,A1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),Z,A1) = use ) )
                & ! [B1,C1] :
                    ( ( leq(n0,B1)
                      & leq(n0,C1)
                      & leq(B1,n3)
                      & leq(C1,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,B1,C1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),B1,C1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),B1,C1) = use ) ) )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [D1,E1] :
                    ( ( leq(n0,D1)
                      & leq(n0,E1)
                      & leq(D1,n3)
                      & leq(E1,pv5) )
                   => ( a_select3(z_defuse,D1,E1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),D1,E1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),D1,E1) = use ) )
                & ! [F1,G1] :
                    ( ( leq(n0,F1)
                      & leq(n0,G1)
                      & leq(F1,n3)
                      & leq(G1,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,F1,G1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),F1,G1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),F1,G1) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [H1,I1] :
                    ( ( leq(n0,H1)
                      & leq(n0,I1)
                      & leq(H1,n3)
                      & leq(I1,pv5) )
                   => ( a_select3(z_defuse,H1,I1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),H1,I1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),H1,I1) = use ) )
                & ! [J1,K1] :
                    ( ( leq(n0,J1)
                      & leq(n0,K1)
                      & leq(J1,n3)
                      & leq(K1,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,J1,K1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),J1,K1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),J1,K1) = use ) ) )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & ! [L1,M1] :
                    ( ( leq(n0,L1)
                      & leq(n0,M1)
                      & leq(L1,n3)
                      & leq(M1,minus(plus(n1,pv5),n1)) )
                   => ( a_select3(z_defuse,L1,M1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),L1,M1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),L1,M1) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [N1,O1] :
                    ( ( leq(n0,N1)
                      & leq(n0,O1)
                      & leq(N1,n3)
                      & leq(O1,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,N1,O1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),N1,O1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),N1,O1) = use ) ) )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [P1,Q1] :
                    ( ( leq(n0,P1)
                      & leq(n0,Q1)
                      & leq(P1,n3)
                      & leq(Q1,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,P1,Q1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),P1,Q1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),P1,Q1) = use ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & leq(n0,pv5)
                & leq(pv5,n588)
                & ! [R1,S1] :
                    ( ( leq(n0,R1)
                      & leq(n0,S1)
                      & leq(R1,n3)
                      & leq(S1,minus(pv5,n1)) )
                   => ( a_select3(z_defuse,R1,S1) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),R1,S1) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),R1,S1) = use ) ) )
             => ( ( ~ gt(pv5,n0)
                 => ( ( ~ gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [T1,U1] :
                                    ( ( leq(n0,T1)
                                      & leq(n0,U1)
                                      & leq(T1,n3)
                                      & leq(U1,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),T1,U1) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),T1,U1) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),T1,U1) = use ) )
                                & ! [V1,W1] :
                                    ( ( leq(n0,V1)
                                      & leq(n0,W1)
                                      & leq(V1,n3)
                                      & leq(W1,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),V1,W1) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),V1,W1) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),V1,W1) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [X1,Y1] :
                                    ( ( leq(n0,X1)
                                      & leq(n0,Y1)
                                      & leq(X1,n3)
                                      & leq(Y1,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),X1,Y1) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),X1,Y1) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),X1,Y1) = use ) )
                                & ! [Z1,A2] :
                                    ( ( leq(n0,Z1)
                                      & leq(n0,A2)
                                      & leq(Z1,n3)
                                      & leq(A2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),Z1,A2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),Z1,A2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),Z1,A2) = use ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [B2,C2] :
                                    ( ( leq(n0,B2)
                                      & leq(n0,C2)
                                      & leq(B2,n3)
                                      & leq(C2,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),B2,C2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),B2,C2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),B2,C2) = use ) )
                                & ! [D2,E2] :
                                    ( ( leq(n0,D2)
                                      & leq(n0,E2)
                                      & leq(D2,n3)
                                      & leq(E2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),D2,E2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),D2,E2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),D2,E2) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [F2,G2] :
                                    ( ( leq(n0,F2)
                                      & leq(n0,G2)
                                      & leq(F2,n3)
                                      & leq(G2,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),F2,G2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),F2,G2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),F2,G2) = use ) )
                                & ! [H2,I2] :
                                    ( ( leq(n0,H2)
                                      & leq(n0,I2)
                                      & leq(H2,n3)
                                      & leq(I2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),H2,I2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),H2,I2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),H2,I2) = use ) ) ) ) ) ) ) )
                    & ( gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [J2,K2] :
                                    ( ( leq(n0,J2)
                                      & leq(n0,K2)
                                      & leq(J2,n3)
                                      & leq(K2,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),J2,K2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),J2,K2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),J2,K2) = use ) )
                                & ! [L2,M2] :
                                    ( ( leq(n0,L2)
                                      & leq(n0,M2)
                                      & leq(L2,n3)
                                      & leq(M2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),L2,M2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),L2,M2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),L2,M2) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [N2,O2] :
                                    ( ( leq(n0,N2)
                                      & leq(n0,O2)
                                      & leq(N2,n3)
                                      & leq(O2,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),N2,O2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),N2,O2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),N2,O2) = use ) )
                                & ! [P2,Q2] :
                                    ( ( leq(n0,P2)
                                      & leq(n0,Q2)
                                      & leq(P2,n3)
                                      & leq(Q2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),P2,Q2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),P2,Q2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),P2,Q2) = use ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [R2,S2] :
                                    ( ( leq(n0,R2)
                                      & leq(n0,S2)
                                      & leq(R2,n3)
                                      & leq(S2,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),R2,S2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),R2,S2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),R2,S2) = use ) )
                                & ! [T2,U2] :
                                    ( ( leq(n0,T2)
                                      & leq(n0,U2)
                                      & leq(T2,n3)
                                      & leq(U2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),T2,U2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),T2,U2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),T2,U2) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [V2,W2] :
                                    ( ( leq(n0,V2)
                                      & leq(n0,W2)
                                      & leq(V2,n3)
                                      & leq(W2,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),V2,W2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),V2,W2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),V2,W2) = use ) )
                                & ! [X2,Y2] :
                                    ( ( leq(n0,X2)
                                      & leq(n0,Y2)
                                      & leq(X2,n3)
                                      & leq(Y2,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),X2,Y2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),X2,Y2) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),X2,Y2) = use ) ) ) ) ) ) ) ) ) )
                & ( gt(pv5,n0)
                 => ( ( ~ gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [Z2,A3] :
                                    ( ( leq(n0,Z2)
                                      & leq(n0,A3)
                                      & leq(Z2,n3)
                                      & leq(A3,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),Z2,A3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),Z2,A3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),Z2,A3) = use ) )
                                & ! [B3,C3] :
                                    ( ( leq(n0,B3)
                                      & leq(n0,C3)
                                      & leq(B3,n3)
                                      & leq(C3,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),B3,C3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),B3,C3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),B3,C3) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [D3,E3] :
                                    ( ( leq(n0,D3)
                                      & leq(n0,E3)
                                      & leq(D3,n3)
                                      & leq(E3,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),D3,E3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),D3,E3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),D3,E3) = use ) )
                                & ! [F3,G3] :
                                    ( ( leq(n0,F3)
                                      & leq(n0,G3)
                                      & leq(F3,n3)
                                      & leq(G3,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),F3,G3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),F3,G3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),F3,G3) = use ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [H3,I3] :
                                    ( ( leq(n0,H3)
                                      & leq(n0,I3)
                                      & leq(H3,n3)
                                      & leq(I3,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),H3,I3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),H3,I3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),H3,I3) = use ) )
                                & ! [J3,K3] :
                                    ( ( leq(n0,J3)
                                      & leq(n0,K3)
                                      & leq(J3,n3)
                                      & leq(K3,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),J3,K3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),J3,K3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),J3,K3) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [L3,M3] :
                                    ( ( leq(n0,L3)
                                      & leq(n0,M3)
                                      & leq(L3,n3)
                                      & leq(M3,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),L3,M3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),L3,M3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),L3,M3) = use ) )
                                & ! [N3,O3] :
                                    ( ( leq(n0,N3)
                                      & leq(n0,O3)
                                      & leq(N3,n3)
                                      & leq(O3,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),N3,O3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),N3,O3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),N3,O3) = use ) ) ) ) ) ) ) )
                    & ( gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [P3,Q3] :
                                    ( ( leq(n0,P3)
                                      & leq(n0,Q3)
                                      & leq(P3,n3)
                                      & leq(Q3,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),P3,Q3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),P3,Q3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),P3,Q3) = use ) )
                                & ! [R3,S3] :
                                    ( ( leq(n0,R3)
                                      & leq(n0,S3)
                                      & leq(R3,n3)
                                      & leq(S3,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),R3,S3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),R3,S3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),R3,S3) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [T3,U3] :
                                    ( ( leq(n0,T3)
                                      & leq(n0,U3)
                                      & leq(T3,n3)
                                      & leq(U3,pv5) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),T3,U3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),T3,U3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),T3,U3) = use ) )
                                & ! [V3,W3] :
                                    ( ( leq(n0,V3)
                                      & leq(n0,W3)
                                      & leq(V3,n3)
                                      & leq(W3,minus(pv5,n1)) )
                                   => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),V3,W3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),V3,W3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),V3,W3) = use ) ) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [X3,Y3] :
                                    ( ( leq(n0,X3)
                                      & leq(n0,Y3)
                                      & leq(X3,n3)
                                      & leq(Y3,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),X3,Y3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),X3,Y3) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),X3,Y3) = use ) )
                                & ! [Z3,A4] :
                                    ( ( leq(n0,Z3)
                                      & leq(n0,A4)
                                      & leq(Z3,n3)
                                      & leq(A4,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),Z3,A4) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),Z3,A4) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),Z3,A4) = use ) ) ) )
                            & ( gt(pv5,n0)
                             => ( a_select2(xinit_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n0) = use
                                & a_select2(xinit_mean_defuse,n1) = use
                                & a_select2(xinit_mean_defuse,n2) = use
                                & a_select2(xinit_mean_defuse,n3) = use
                                & a_select2(xinit_mean_defuse,n4) = use
                                & a_select2(xinit_mean_defuse,n5) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n0,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n1,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n3,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n4,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n5,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n6,n0) = use
                                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n7,n0) = use
                                & leq(n0,pv5)
                                & leq(pv5,n588)
                                & ! [B4,C4] :
                                    ( ( leq(n0,B4)
                                      & leq(n0,C4)
                                      & leq(B4,n3)
                                      & leq(C4,pv5) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),B4,C4) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),B4,C4) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),B4,C4) = use ) )
                                & ! [D4,E4] :
                                    ( ( leq(n0,D4)
                                      & leq(n0,E4)
                                      & leq(D4,n3)
                                      & leq(E4,minus(pv5,n1)) )
                                   => ( a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),n3,pv5,use),D4,E4) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n2,pv5,use),n1,pv5,use),n0,pv5,use),D4,E4) = use
                                      & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,pv5,use),n1,pv5,use),n3,pv5,use),n1,pv5,use),n2,pv5,use),n2,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),n2,pv5,use),n3,pv5,use),n5,pv5,use),D4,E4) = use ) ) ) ) ) ) ) ) ) ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n0) = use
                & a_select2(xinit_mean_defuse,n1) = use
                & a_select2(xinit_mean_defuse,n2) = use
                & a_select2(xinit_mean_defuse,n3) = use
                & a_select2(xinit_mean_defuse,n4) = use
                & a_select2(xinit_mean_defuse,n5) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & ! [F4,G4] :
                    ( ( leq(n0,F4)
                      & leq(n0,G4)
                      & leq(F4,n3)
                      & leq(G4,minus(plus(n1,n588),n1)) )
                   => ( a_select3(z_defuse,F4,G4) = use
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),F4,G4) = use
                      & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),F4,G4) = use ) ) )
             => ( def = use
                & ! [H4,I4] :
                    ( ( leq(n0,H4)
                      & leq(n0,I4)
                      & leq(H4,minus(n4,n1))
                      & leq(I4,minus(n1000,n1)) )
                   => a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),H4,I4) = use )
                & ! [J4,K4] :
                    ( ( leq(n0,J4)
                      & leq(n0,K4)
                      & leq(J4,n7)
                      & leq(K4,minus(n1000,n1)) )
                   => a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),J4,K4) = use )
                & ! [L4] :
                    ( ( leq(n0,L4)
                      & leq(L4,minus(n6,n1)) )
                   => a_select2(xinit_defuse,L4) = use )
                & ! [M4] :
                    ( ( leq(n0,M4)
                      & leq(M4,minus(n6,n1)) )
                   => a_select2(xinit_mean_defuse,M4) = use )
                & ! [N4,O4] :
                    ( ( leq(n0,N4)
                      & leq(n0,O4)
                      & leq(N4,minus(n4,n1))
                      & leq(O4,minus(n1000,n1)) )
                   => a_select3(z_defuse,N4,O4) = use ) ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0,use),n1,n0,use),n2,n0,use),n3,n0,use),n0,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0,use),n1,n0,use),n2,n0,use),n3,n0,use),n1,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0,use),n1,n0,use),n2,n0,use),n3,n0,use),n2,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0,use),n1,n0,use),n2,n0,use),n3,n0,use),n3,n0) = use ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n0,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n1,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n2,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n3,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n4,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n5,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n6,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0,use),n2,n0,use),n7,n0) = use ) )
            & ( ( a_select2(xinit_defuse,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use )
             => ( a_select2(xinit_defuse,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n4,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n5,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n6,n0) = use
                & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n7,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n0,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n1,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n2,n0) = use
                & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),def),n3,n0) = use
                & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_mean_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n0) = use
                & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_mean_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n1) = use
                & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_mean_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n2) = use
                & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_mean_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n3) = use
                & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_mean_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n4) = use
                & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_mean_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n5) = use ) )
            & ( ( leq(n0,pv25)
                & leq(pv25,minus(n6,n1)) )
             => ( leq(n0,a_select2(sigma,pv25))
               => true ) )
            & ( a_select2(xinit_defuse,n0) = use
             => ( a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_defuse,n0,use),n0,use),n0,use),n0,use),n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n0,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n1,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n2,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n3,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n4,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n5,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n6,n0) = use
                & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),def),n1,n0,use),n3,n0,use),n1,n0,use),n3,n0,use),n7,n0) = use ) )
            & ( geq(minus(n6,n1),n0)
             => ( geq(minus(n6,n1),n0)
               => ( ( geq(minus(n4,n1),n0)
                    & geq(minus(n1000,n1),n0) )
                 => true ) ) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_1000_588,axiom,
    gt(n1000,n588) ).

fof(gt_588_4,axiom,
    gt(n588,n4) ).

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_7_4,axiom,
    gt(n7,n4) ).

fof(gt_1000_4,axiom,
    gt(n1000,n4) ).

fof(gt_588_5,axiom,
    gt(n588,n5) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_7_5,axiom,
    gt(n7,n5) ).

fof(gt_1000_5,axiom,
    gt(n1000,n5) ).

fof(gt_588_6,axiom,
    gt(n588,n6) ).

fof(gt_7_6,axiom,
    gt(n7,n6) ).

fof(gt_1000_6,axiom,
    gt(n1000,n6) ).

fof(gt_588_7,axiom,
    gt(n588,n7) ).

fof(gt_1000_7,axiom,
    gt(n1000,n7) ).

fof(gt_588_tptp_minus_1,axiom,
    gt(n588,tptp_minus_1) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_7_tptp_minus_1,axiom,
    gt(n7,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_1000_tptp_minus_1,axiom,
    gt(n1000,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_588_0,axiom,
    gt(n588,n0) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_7_0,axiom,
    gt(n7,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_1000_0,axiom,
    gt(n1000,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_588_1,axiom,
    gt(n588,n1) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_7_1,axiom,
    gt(n7,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_1000_1,axiom,
    gt(n1000,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_588_2,axiom,
    gt(n588,n2) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_7_2,axiom,
    gt(n7,n2) ).

fof(gt_1000_2,axiom,
    gt(n1000,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_588_3,axiom,
    gt(n588,n3) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(gt_7_3,axiom,
    gt(n7,n3) ).

fof(gt_1000_3,axiom,
    gt(n1000,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
