%------------------------------------------------------------------------------
% File     : SWV127+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_init_0002
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the init-safety verification for
%            the thruster program. init-safety ensures that each variable or
%            individual array element has been assigned a defined value before
%            it is used.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_init_0002 [Fis04]

% Status   : Theorem
% Rating   : 1.00 v4.0.1, 0.96 v3.7.0, 1.00 v3.3.0
% Syntax   : Number of formulae    :  121 (  84 unt;   0 def)
%            Number of atoms       : 3997 (1112 equ)
%            Maximal formula atoms : 3704 (  33 avg)
%            Number of connectives : 3897 (  21   ~;  23   |;3062   &)
%                                         (   5 <=>; 786  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  105 (   4 avg)
%            Maximal term depth    :   38 (   2 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   49 (  49 usr;  31 con; 0-4 aty)
%            Number of variables   : 1441 (1441   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(thruster_init_0002,conjecture,
    ( ( geq(minus(n4,n1),n0)
      & geq(minus(n1000,n1),n0) )
   => ! [A] :
        ( init = init
        & ( ( geq(n7,n0)
            & geq(minus(n1000,n1),n0) )
         => ! [X48] :
              ( init = init
              & ( true
               => ( init = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n0) = init
                  & ! [B,C] :
                      ( ( leq(n0,B)
                        & leq(n0,C)
                        & leq(B,n3)
                        & leq(C,n5) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n0,n0,init),n0,n1,init),n0,n2,init),n0,n3,init),n0,n4,init),n0,n5,init),n1,n0,init),n1,n1,init),n1,n2,init),n1,n3,init),n1,n4,init),n1,n5,init),n2,n0,init),n2,n1,init),n2,n2,init),n2,n3,init),n2,n4,init),n2,n5,init),n3,n0,init),n3,n1,init),n3,n2,init),n3,n3,init),n3,n4,init),n3,n5,init),B,C) = init ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv21)
                  & leq(pv5,n588)
                  & leq(pv21,minus(n6,n1))
                  & ! [D,E] :
                      ( ( leq(n0,D)
                        & leq(n0,E)
                        & leq(D,n3)
                        & leq(E,n5) )
                     => a_select3(h_thruster_filter_init,D,E) = init )
                  & ! [F,G] :
                      ( ( leq(n0,F)
                        & leq(n0,G)
                        & leq(F,n5)
                        & leq(G,n5) )
                     => a_select3(phi_thruster_filter_init,F,G) = init )
                  & ! [H,I] :
                      ( ( leq(n0,H)
                        & leq(n0,I)
                        & leq(H,minus(n6,n1))
                        & leq(I,n0) )
                     => a_select3(dv_thruster_filter_init,H,I) = init )
                  & ! [J,K] :
                      ( ( leq(n0,J)
                        & leq(n0,K)
                        & leq(J,n5)
                        & leq(K,n5) )
                     => a_select3(q_thruster_filter_init,J,K) = init )
                  & ! [L,M] :
                      ( ( leq(n0,L)
                        & leq(n0,M)
                        & leq(L,n3)
                        & leq(M,n3) )
                     => a_select3(r_thruster_filter_init,L,M) = init )
                  & ! [N,O] :
                      ( ( leq(n0,N)
                        & leq(n0,O)
                        & leq(N,n5)
                        & leq(O,n0) )
                     => a_select3(xhatmin_thruster_filter_init,N,O) = init )
                  & ! [P,Q] :
                      ( ( leq(n0,P)
                        & leq(n0,Q)
                        & leq(P,n5)
                        & leq(Q,n5) )
                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),P,Q) = init )
                  & ! [R] :
                      ( ( leq(n0,R)
                        & leq(R,minus(n6,n1)) )
                     => ! [S] :
                          ( ( leq(n0,S)
                            & leq(S,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,R,S) = init ) ) )
               => ( init = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),pv21,n0) = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [T,U] :
                      ( ( leq(n0,T)
                        & leq(n0,U)
                        & leq(T,n3)
                        & leq(U,n5) )
                     => a_select3(h_thruster_filter_init,T,U) = init )
                  & ! [V,W] :
                      ( ( leq(n0,V)
                        & leq(n0,W)
                        & leq(V,n5)
                        & leq(W,n5) )
                     => a_select3(phi_thruster_filter_init,V,W) = init )
                  & ! [X,Y] :
                      ( ( leq(n0,X)
                        & leq(n0,Y)
                        & leq(X,minus(n6,n1))
                        & leq(Y,n0) )
                     => a_select3(dv_thruster_filter_init,X,Y) = init )
                  & ! [Z,A1] :
                      ( ( leq(n0,Z)
                        & leq(n0,A1)
                        & leq(Z,n5)
                        & leq(A1,n5) )
                     => a_select3(q_thruster_filter_init,Z,A1) = init )
                  & ! [B1,C1] :
                      ( ( leq(n0,B1)
                        & leq(n0,C1)
                        & leq(B1,n3)
                        & leq(C1,n3) )
                     => a_select3(r_thruster_filter_init,B1,C1) = init )
                  & ! [D1,E1] :
                      ( ( leq(n0,D1)
                        & leq(n0,E1)
                        & leq(D1,n5)
                        & leq(E1,n0) )
                     => a_select3(xhatmin_thruster_filter_init,D1,E1) = init )
                  & ! [F1,G1] :
                      ( ( leq(n0,F1)
                        & leq(n0,G1)
                        & leq(F1,n5)
                        & leq(G1,n5) )
                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),F1,G1) = init )
                  & ! [H1] :
                      ( ( leq(n0,H1)
                        & leq(H1,minus(n6,n1)) )
                     => ! [I1] :
                          ( ( leq(n0,I1)
                            & leq(I1,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,H1,I1) = init ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv45)
                  & leq(n0,pv46)
                  & leq(pv5,n588)
                  & leq(pv45,minus(n6,n1))
                  & leq(pv46,minus(n6,n1))
                  & ! [J1,K1] :
                      ( ( leq(n0,J1)
                        & leq(n0,K1)
                        & leq(J1,n3)
                        & leq(K1,n5) )
                     => a_select3(h_thruster_filter_init,J1,K1) = init )
                  & ! [L1,M1] :
                      ( ( leq(n0,L1)
                        & leq(n0,M1)
                        & leq(L1,n5)
                        & leq(M1,n5) )
                     => a_select3(phi_thruster_filter_init,L1,M1) = init )
                  & ! [N1,O1] :
                      ( ( leq(n0,N1)
                        & leq(n0,O1)
                        & leq(N1,minus(n6,n1))
                        & leq(O1,n0) )
                     => a_select3(dv_thruster_filter_init,N1,O1) = init )
                  & ! [P1,Q1] :
                      ( ( leq(n0,P1)
                        & leq(n0,Q1)
                        & leq(P1,n5)
                        & leq(Q1,n5) )
                     => a_select3(q_thruster_filter_init,P1,Q1) = init )
                  & ! [R1,S1] :
                      ( ( leq(n0,R1)
                        & leq(n0,S1)
                        & leq(R1,n3)
                        & leq(S1,n3) )
                     => a_select3(r_thruster_filter_init,R1,S1) = init )
                  & ! [T1,U1] :
                      ( ( leq(n0,T1)
                        & leq(n0,U1)
                        & leq(T1,n5)
                        & leq(U1,n0) )
                     => a_select3(xhatmin_thruster_filter_init,T1,U1) = init )
                  & ! [V1,W1] :
                      ( ( leq(n0,V1)
                        & leq(n0,W1)
                        & leq(V1,n5)
                        & leq(W1,n5) )
                     => a_select3(pminus_thruster_filter_init,V1,W1) = init )
                  & ! [X1,Y1] :
                      ( ( leq(n0,X1)
                        & leq(n0,Y1)
                        & leq(X1,minus(n6,n1))
                        & leq(Y1,minus(n6,n1)) )
                     => ( ( ( lt(Y1,pv46)
                            & X1 = pv45 )
                         => a_select3(id_thruster_filter_init,X1,Y1) = init )
                        & ( lt(X1,pv45)
                         => a_select3(id_thruster_filter_init,X1,Y1) = init ) ) )
                  & ! [Z1] :
                      ( ( leq(n0,Z1)
                        & leq(Z1,minus(pv45,n1)) )
                     => ! [A2] :
                          ( ( leq(n0,A2)
                            & leq(A2,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,Z1,A2) = init ) ) )
               => ( init = init
                  & ( pv45 != pv46
                   => ( init = init
                      & leq(n0,pv5)
                      & leq(n0,pv45)
                      & leq(pv5,n588)
                      & leq(pv45,minus(n6,n1))
                      & ! [B2,C2] :
                          ( ( leq(n0,B2)
                            & leq(n0,C2)
                            & leq(B2,n3)
                            & leq(C2,n5) )
                         => a_select3(h_thruster_filter_init,B2,C2) = init )
                      & ! [D2,E2] :
                          ( ( leq(n0,D2)
                            & leq(n0,E2)
                            & leq(D2,n5)
                            & leq(E2,n5) )
                         => a_select3(phi_thruster_filter_init,D2,E2) = init )
                      & ! [F2,G2] :
                          ( ( leq(n0,F2)
                            & leq(n0,G2)
                            & leq(F2,minus(n6,n1))
                            & leq(G2,n0) )
                         => a_select3(dv_thruster_filter_init,F2,G2) = init )
                      & ! [H2,I2] :
                          ( ( leq(n0,H2)
                            & leq(n0,I2)
                            & leq(H2,n5)
                            & leq(I2,n5) )
                         => a_select3(q_thruster_filter_init,H2,I2) = init )
                      & ! [J2,K2] :
                          ( ( leq(n0,J2)
                            & leq(n0,K2)
                            & leq(J2,n3)
                            & leq(K2,n3) )
                         => a_select3(r_thruster_filter_init,J2,K2) = init )
                      & ! [L2,M2] :
                          ( ( leq(n0,L2)
                            & leq(n0,M2)
                            & leq(L2,n5)
                            & leq(M2,n0) )
                         => a_select3(xhatmin_thruster_filter_init,L2,M2) = init )
                      & ! [N2,O2] :
                          ( ( leq(n0,N2)
                            & leq(n0,O2)
                            & leq(N2,n5)
                            & leq(O2,n5) )
                         => a_select3(pminus_thruster_filter_init,N2,O2) = init )
                      & ! [P2,Q2] :
                          ( ( leq(n0,P2)
                            & leq(n0,Q2)
                            & leq(P2,minus(n6,n1))
                            & leq(Q2,minus(n6,n1)) )
                         => ( ( ( lt(Q2,plus(n1,pv46))
                                & P2 = pv45 )
                             => a_select3(tptp_update3(id_thruster_filter_init,pv45,pv46,init),P2,Q2) = init )
                            & ( lt(P2,pv45)
                             => a_select3(tptp_update3(id_thruster_filter_init,pv45,pv46,init),P2,Q2) = init ) ) )
                      & ! [R2] :
                          ( ( leq(n0,R2)
                            & leq(R2,minus(pv45,n1)) )
                         => ! [S2] :
                              ( ( leq(n0,S2)
                                & leq(S2,minus(n6,n1)) )
                             => a_select3(tptp_update3(id_thruster_filter_init,pv45,S2,init),R2,S2) = init ) ) ) )
                  & ( pv45 = pv46
                   => ( init = init
                      & leq(n0,pv5)
                      & leq(n0,pv45)
                      & leq(pv5,n588)
                      & leq(pv45,minus(n6,n1))
                      & ! [T2,U2] :
                          ( ( leq(n0,T2)
                            & leq(n0,U2)
                            & leq(T2,n3)
                            & leq(U2,n5) )
                         => a_select3(h_thruster_filter_init,T2,U2) = init )
                      & ! [V2,W2] :
                          ( ( leq(n0,V2)
                            & leq(n0,W2)
                            & leq(V2,n5)
                            & leq(W2,n5) )
                         => a_select3(phi_thruster_filter_init,V2,W2) = init )
                      & ! [X2,Y2] :
                          ( ( leq(n0,X2)
                            & leq(n0,Y2)
                            & leq(X2,minus(n6,n1))
                            & leq(Y2,n0) )
                         => a_select3(dv_thruster_filter_init,X2,Y2) = init )
                      & ! [Z2,A3] :
                          ( ( leq(n0,Z2)
                            & leq(n0,A3)
                            & leq(Z2,n5)
                            & leq(A3,n5) )
                         => a_select3(q_thruster_filter_init,Z2,A3) = init )
                      & ! [B3,C3] :
                          ( ( leq(n0,B3)
                            & leq(n0,C3)
                            & leq(B3,n3)
                            & leq(C3,n3) )
                         => a_select3(r_thruster_filter_init,B3,C3) = init )
                      & ! [D3,E3] :
                          ( ( leq(n0,D3)
                            & leq(n0,E3)
                            & leq(D3,n5)
                            & leq(E3,n0) )
                         => a_select3(xhatmin_thruster_filter_init,D3,E3) = init )
                      & ! [F3,G3] :
                          ( ( leq(n0,F3)
                            & leq(n0,G3)
                            & leq(F3,n5)
                            & leq(G3,n5) )
                         => a_select3(pminus_thruster_filter_init,F3,G3) = init )
                      & ! [H3,I3] :
                          ( ( leq(n0,H3)
                            & leq(n0,I3)
                            & leq(H3,minus(n6,n1))
                            & leq(I3,minus(n6,n1)) )
                         => ( ( ( lt(I3,plus(n1,pv46))
                                & H3 = pv45 )
                             => a_select3(tptp_update3(id_thruster_filter_init,pv45,pv46,init),H3,I3) = init )
                            & ( lt(H3,pv45)
                             => a_select3(tptp_update3(id_thruster_filter_init,pv45,pv46,init),H3,I3) = init ) ) )
                      & ! [J3] :
                          ( ( leq(n0,J3)
                            & leq(J3,minus(pv45,n1)) )
                         => ! [K3] :
                              ( ( leq(n0,K3)
                                & leq(K3,minus(n6,n1)) )
                             => a_select3(tptp_update3(id_thruster_filter_init,pv45,K3,init),J3,K3) = init ) ) ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv45)
                  & leq(pv5,n588)
                  & leq(pv45,minus(n6,n1))
                  & ! [L3,M3] :
                      ( ( leq(n0,L3)
                        & leq(n0,M3)
                        & leq(L3,n3)
                        & leq(M3,n5) )
                     => a_select3(h_thruster_filter_init,L3,M3) = init )
                  & ! [N3,O3] :
                      ( ( leq(n0,N3)
                        & leq(n0,O3)
                        & leq(N3,n5)
                        & leq(O3,n5) )
                     => a_select3(phi_thruster_filter_init,N3,O3) = init )
                  & ! [P3,Q3] :
                      ( ( leq(n0,P3)
                        & leq(n0,Q3)
                        & leq(P3,minus(n6,n1))
                        & leq(Q3,n0) )
                     => a_select3(dv_thruster_filter_init,P3,Q3) = init )
                  & ! [R3,S3] :
                      ( ( leq(n0,R3)
                        & leq(n0,S3)
                        & leq(R3,n5)
                        & leq(S3,n5) )
                     => a_select3(q_thruster_filter_init,R3,S3) = init )
                  & ! [T3,U3] :
                      ( ( leq(n0,T3)
                        & leq(n0,U3)
                        & leq(T3,n3)
                        & leq(U3,n3) )
                     => a_select3(r_thruster_filter_init,T3,U3) = init )
                  & ! [V3,W3] :
                      ( ( leq(n0,V3)
                        & leq(n0,W3)
                        & leq(V3,n5)
                        & leq(W3,n0) )
                     => a_select3(xhatmin_thruster_filter_init,V3,W3) = init )
                  & ! [X3,Y3] :
                      ( ( leq(n0,X3)
                        & leq(n0,Y3)
                        & leq(X3,n5)
                        & leq(Y3,n5) )
                     => a_select3(pminus_thruster_filter_init,X3,Y3) = init )
                  & ! [Z3,A4] :
                      ( ( leq(n0,Z3)
                        & leq(n0,A4)
                        & leq(Z3,minus(n6,n1))
                        & leq(A4,minus(n6,n1)) )
                     => ( ( ( lt(A4,plus(n1,minus(n6,n1)))
                            & Z3 = pv45 )
                         => a_select3(id_thruster_filter_init,Z3,A4) = init )
                        & ( lt(Z3,pv45)
                         => a_select3(id_thruster_filter_init,Z3,A4) = init ) ) )
                  & ! [B4] :
                      ( ( leq(n0,B4)
                        & leq(B4,minus(pv45,n1)) )
                     => ! [C4] :
                          ( ( leq(n0,C4)
                            & leq(C4,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,B4,C4) = init ) ) )
               => ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv45)
                  & leq(pv5,n588)
                  & leq(pv45,minus(n6,n1))
                  & ! [D4,E4] :
                      ( ( leq(n0,D4)
                        & leq(n0,E4)
                        & leq(D4,n3)
                        & leq(E4,n5) )
                     => a_select3(h_thruster_filter_init,D4,E4) = init )
                  & ! [F4,G4] :
                      ( ( leq(n0,F4)
                        & leq(n0,G4)
                        & leq(F4,n5)
                        & leq(G4,n5) )
                     => a_select3(phi_thruster_filter_init,F4,G4) = init )
                  & ! [H4,I4] :
                      ( ( leq(n0,H4)
                        & leq(n0,I4)
                        & leq(H4,minus(n6,n1))
                        & leq(I4,n0) )
                     => a_select3(dv_thruster_filter_init,H4,I4) = init )
                  & ! [J4,K4] :
                      ( ( leq(n0,J4)
                        & leq(n0,K4)
                        & leq(J4,n5)
                        & leq(K4,n5) )
                     => a_select3(q_thruster_filter_init,J4,K4) = init )
                  & ! [L4,M4] :
                      ( ( leq(n0,L4)
                        & leq(n0,M4)
                        & leq(L4,n3)
                        & leq(M4,n3) )
                     => a_select3(r_thruster_filter_init,L4,M4) = init )
                  & ! [N4,O4] :
                      ( ( leq(n0,N4)
                        & leq(n0,O4)
                        & leq(N4,n5)
                        & leq(O4,n0) )
                     => a_select3(xhatmin_thruster_filter_init,N4,O4) = init )
                  & ! [P4,Q4] :
                      ( ( leq(n0,P4)
                        & leq(n0,Q4)
                        & leq(P4,n5)
                        & leq(Q4,n5) )
                     => a_select3(pminus_thruster_filter_init,P4,Q4) = init )
                  & ! [R4,S4] :
                      ( ( leq(n0,R4)
                        & leq(n0,S4)
                        & leq(R4,pv45)
                        & leq(S4,minus(n6,n1)) )
                     => a_select3(id_thruster_filter_init,R4,S4) = init )
                  & ! [T4] :
                      ( ( leq(n0,T4)
                        & leq(T4,minus(pv45,n1)) )
                     => ! [U4] :
                          ( ( leq(n0,U4)
                            & leq(U4,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,T4,U4) = init ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv45)
                  & leq(pv5,n588)
                  & leq(pv45,minus(n6,n1))
                  & ! [V4,W4] :
                      ( ( leq(n0,V4)
                        & leq(n0,W4)
                        & leq(V4,n3)
                        & leq(W4,n5) )
                     => a_select3(h_thruster_filter_init,V4,W4) = init )
                  & ! [X4,Y4] :
                      ( ( leq(n0,X4)
                        & leq(n0,Y4)
                        & leq(X4,n5)
                        & leq(Y4,n5) )
                     => a_select3(phi_thruster_filter_init,X4,Y4) = init )
                  & ! [Z4,A5] :
                      ( ( leq(n0,Z4)
                        & leq(n0,A5)
                        & leq(Z4,minus(n6,n1))
                        & leq(A5,n0) )
                     => a_select3(dv_thruster_filter_init,Z4,A5) = init )
                  & ! [B5,C5] :
                      ( ( leq(n0,B5)
                        & leq(n0,C5)
                        & leq(B5,n5)
                        & leq(C5,n5) )
                     => a_select3(q_thruster_filter_init,B5,C5) = init )
                  & ! [D5,E5] :
                      ( ( leq(n0,D5)
                        & leq(n0,E5)
                        & leq(D5,n3)
                        & leq(E5,n3) )
                     => a_select3(r_thruster_filter_init,D5,E5) = init )
                  & ! [F5,G5] :
                      ( ( leq(n0,F5)
                        & leq(n0,G5)
                        & leq(F5,n5)
                        & leq(G5,n0) )
                     => a_select3(xhatmin_thruster_filter_init,F5,G5) = init )
                  & ! [H5,I5] :
                      ( ( leq(n0,H5)
                        & leq(n0,I5)
                        & leq(H5,n5)
                        & leq(I5,n5) )
                     => a_select3(pminus_thruster_filter_init,H5,I5) = init )
                  & ! [J5,K5] :
                      ( ( leq(n0,J5)
                        & leq(n0,K5)
                        & leq(J5,pv45)
                        & leq(K5,minus(n6,n1)) )
                     => a_select3(id_thruster_filter_init,J5,K5) = init )
                  & ! [L5] :
                      ( ( leq(n0,L5)
                        & leq(L5,minus(pv45,n1)) )
                     => ! [M5] :
                          ( ( leq(n0,M5)
                            & leq(M5,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,L5,M5) = init ) ) )
               => ( init = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [N5,O5] :
                      ( ( leq(n0,N5)
                        & leq(n0,O5)
                        & leq(N5,n3)
                        & leq(O5,n5) )
                     => a_select3(h_thruster_filter_init,N5,O5) = init )
                  & ! [P5,Q5] :
                      ( ( leq(n0,P5)
                        & leq(n0,Q5)
                        & leq(P5,n5)
                        & leq(Q5,n5) )
                     => a_select3(phi_thruster_filter_init,P5,Q5) = init )
                  & ! [R5,S5] :
                      ( ( leq(n0,R5)
                        & leq(n0,S5)
                        & leq(R5,minus(n6,n1))
                        & leq(S5,n0) )
                     => a_select3(dv_thruster_filter_init,R5,S5) = init )
                  & ! [T5,U5] :
                      ( ( leq(n0,T5)
                        & leq(n0,U5)
                        & leq(T5,n5)
                        & leq(U5,n5) )
                     => a_select3(q_thruster_filter_init,T5,U5) = init )
                  & ! [V5,W5] :
                      ( ( leq(n0,V5)
                        & leq(n0,W5)
                        & leq(V5,n3)
                        & leq(W5,n3) )
                     => a_select3(r_thruster_filter_init,V5,W5) = init )
                  & ! [X5,Y5] :
                      ( ( leq(n0,X5)
                        & leq(n0,Y5)
                        & leq(X5,n5)
                        & leq(Y5,n0) )
                     => a_select3(xhatmin_thruster_filter_init,X5,Y5) = init )
                  & ! [Z5,A6] :
                      ( ( leq(n0,Z5)
                        & leq(n0,A6)
                        & leq(Z5,n5)
                        & leq(A6,n5) )
                     => a_select3(pminus_thruster_filter_init,Z5,A6) = init )
                  & ! [B6] :
                      ( ( leq(n0,B6)
                        & leq(B6,minus(plus(n1,pv45),n1)) )
                     => ! [C6] :
                          ( ( leq(n0,C6)
                            & leq(C6,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,B6,C6) = init ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv45)
                  & leq(pv5,n588)
                  & leq(pv45,minus(n6,n1))
                  & ! [D6,E6] :
                      ( ( leq(n0,D6)
                        & leq(n0,E6)
                        & leq(D6,n3)
                        & leq(E6,n5) )
                     => a_select3(h_thruster_filter_init,D6,E6) = init )
                  & ! [F6,G6] :
                      ( ( leq(n0,F6)
                        & leq(n0,G6)
                        & leq(F6,n5)
                        & leq(G6,n5) )
                     => a_select3(phi_thruster_filter_init,F6,G6) = init )
                  & ! [H6,I6] :
                      ( ( leq(n0,H6)
                        & leq(n0,I6)
                        & leq(H6,minus(n6,n1))
                        & leq(I6,n0) )
                     => a_select3(dv_thruster_filter_init,H6,I6) = init )
                  & ! [J6,K6] :
                      ( ( leq(n0,J6)
                        & leq(n0,K6)
                        & leq(J6,n5)
                        & leq(K6,n5) )
                     => a_select3(q_thruster_filter_init,J6,K6) = init )
                  & ! [L6,M6] :
                      ( ( leq(n0,L6)
                        & leq(n0,M6)
                        & leq(L6,n3)
                        & leq(M6,n3) )
                     => a_select3(r_thruster_filter_init,L6,M6) = init )
                  & ! [N6,O6] :
                      ( ( leq(n0,N6)
                        & leq(n0,O6)
                        & leq(N6,n5)
                        & leq(O6,n0) )
                     => a_select3(xhatmin_thruster_filter_init,N6,O6) = init )
                  & ! [P6,Q6] :
                      ( ( leq(n0,P6)
                        & leq(n0,Q6)
                        & leq(P6,n5)
                        & leq(Q6,n5) )
                     => a_select3(pminus_thruster_filter_init,P6,Q6) = init )
                  & ! [R6] :
                      ( ( leq(n0,R6)
                        & leq(R6,minus(pv45,n1)) )
                     => ! [S6] :
                          ( ( leq(n0,S6)
                            & leq(S6,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,R6,S6) = init ) ) )
               => ( init = init
                  & leq(n0,pv5)
                  & leq(n0,pv45)
                  & leq(pv5,n588)
                  & leq(pv45,minus(n6,n1))
                  & ! [T6,U6] :
                      ( ( leq(n0,T6)
                        & leq(n0,U6)
                        & leq(T6,n3)
                        & leq(U6,n5) )
                     => a_select3(h_thruster_filter_init,T6,U6) = init )
                  & ! [V6,W6] :
                      ( ( leq(n0,V6)
                        & leq(n0,W6)
                        & leq(V6,n5)
                        & leq(W6,n5) )
                     => a_select3(phi_thruster_filter_init,V6,W6) = init )
                  & ! [X6,Y6] :
                      ( ( leq(n0,X6)
                        & leq(n0,Y6)
                        & leq(X6,minus(n6,n1))
                        & leq(Y6,n0) )
                     => a_select3(dv_thruster_filter_init,X6,Y6) = init )
                  & ! [Z6,A7] :
                      ( ( leq(n0,Z6)
                        & leq(n0,A7)
                        & leq(Z6,n5)
                        & leq(A7,n5) )
                     => a_select3(q_thruster_filter_init,Z6,A7) = init )
                  & ! [B7,C7] :
                      ( ( leq(n0,B7)
                        & leq(n0,C7)
                        & leq(B7,n3)
                        & leq(C7,n3) )
                     => a_select3(r_thruster_filter_init,B7,C7) = init )
                  & ! [D7,E7] :
                      ( ( leq(n0,D7)
                        & leq(n0,E7)
                        & leq(D7,n5)
                        & leq(E7,n0) )
                     => a_select3(xhatmin_thruster_filter_init,D7,E7) = init )
                  & ! [F7,G7] :
                      ( ( leq(n0,F7)
                        & leq(n0,G7)
                        & leq(F7,n5)
                        & leq(G7,n5) )
                     => a_select3(pminus_thruster_filter_init,F7,G7) = init )
                  & ! [H7,I7] :
                      ( ( leq(n0,H7)
                        & leq(n0,I7)
                        & leq(H7,minus(n6,n1))
                        & leq(I7,minus(n6,n1)) )
                     => ( ( ( lt(I7,n0)
                            & H7 = pv45 )
                         => a_select3(id_thruster_filter_init,H7,I7) = init )
                        & ( lt(H7,pv45)
                         => a_select3(id_thruster_filter_init,H7,I7) = init ) ) )
                  & ! [J7] :
                      ( ( leq(n0,J7)
                        & leq(J7,minus(pv45,n1)) )
                     => ! [K7] :
                          ( ( leq(n0,K7)
                            & leq(K7,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,J7,K7) = init ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [L7,M7] :
                      ( ( leq(n0,L7)
                        & leq(n0,M7)
                        & leq(L7,n3)
                        & leq(M7,n5) )
                     => a_select3(h_thruster_filter_init,L7,M7) = init )
                  & ! [N7,O7] :
                      ( ( leq(n0,N7)
                        & leq(n0,O7)
                        & leq(N7,n5)
                        & leq(O7,n5) )
                     => a_select3(phi_thruster_filter_init,N7,O7) = init )
                  & ! [P7,Q7] :
                      ( ( leq(n0,P7)
                        & leq(n0,Q7)
                        & leq(P7,minus(n6,n1))
                        & leq(Q7,n0) )
                     => a_select3(dv_thruster_filter_init,P7,Q7) = init )
                  & ! [R7,S7] :
                      ( ( leq(n0,R7)
                        & leq(n0,S7)
                        & leq(R7,n5)
                        & leq(S7,n5) )
                     => a_select3(q_thruster_filter_init,R7,S7) = init )
                  & ! [T7,U7] :
                      ( ( leq(n0,T7)
                        & leq(n0,U7)
                        & leq(T7,n3)
                        & leq(U7,n3) )
                     => a_select3(r_thruster_filter_init,T7,U7) = init )
                  & ! [V7,W7] :
                      ( ( leq(n0,V7)
                        & leq(n0,W7)
                        & leq(V7,n5)
                        & leq(W7,n0) )
                     => a_select3(xhatmin_thruster_filter_init,V7,W7) = init )
                  & ! [X7,Y7] :
                      ( ( leq(n0,X7)
                        & leq(n0,Y7)
                        & leq(X7,n5)
                        & leq(Y7,n5) )
                     => a_select3(pminus_thruster_filter_init,X7,Y7) = init )
                  & ! [Z7] :
                      ( ( leq(n0,Z7)
                        & leq(Z7,minus(plus(n1,minus(n6,n1)),n1)) )
                     => ! [A8] :
                          ( ( leq(n0,A8)
                            & leq(A8,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,Z7,A8) = init ) ) )
               => ( init = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [B8,C8] :
                      ( ( leq(n0,B8)
                        & leq(n0,C8)
                        & leq(B8,n3)
                        & leq(C8,n5) )
                     => a_select3(h_thruster_filter_init,B8,C8) = init )
                  & ! [D8,E8] :
                      ( ( leq(n0,D8)
                        & leq(n0,E8)
                        & leq(D8,n5)
                        & leq(E8,n5) )
                     => a_select3(phi_thruster_filter_init,D8,E8) = init )
                  & ! [F8,G8] :
                      ( ( leq(n0,F8)
                        & leq(n0,G8)
                        & leq(F8,minus(n6,n1))
                        & leq(G8,n0) )
                     => a_select3(dv_thruster_filter_init,F8,G8) = init )
                  & ! [H8,I8] :
                      ( ( leq(n0,H8)
                        & leq(n0,I8)
                        & leq(H8,n5)
                        & leq(I8,n5) )
                     => a_select3(q_thruster_filter_init,H8,I8) = init )
                  & ! [J8,K8] :
                      ( ( leq(n0,J8)
                        & leq(n0,K8)
                        & leq(J8,n3)
                        & leq(K8,n3) )
                     => a_select3(r_thruster_filter_init,J8,K8) = init )
                  & ! [L8,M8] :
                      ( ( leq(n0,L8)
                        & leq(n0,M8)
                        & leq(L8,n5)
                        & leq(M8,n0) )
                     => a_select3(xhatmin_thruster_filter_init,L8,M8) = init )
                  & ! [N8,O8] :
                      ( ( leq(n0,N8)
                        & leq(n0,O8)
                        & leq(N8,n5)
                        & leq(O8,n5) )
                     => a_select3(pminus_thruster_filter_init,N8,O8) = init )
                  & ! [P8] :
                      ( ( leq(n0,P8)
                        & leq(P8,minus(n6,n1)) )
                     => ! [Q8] :
                          ( ( leq(n0,Q8)
                            & leq(Q8,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,P8,Q8) = init ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [R8,S8] :
                      ( ( leq(n0,R8)
                        & leq(n0,S8)
                        & leq(R8,n3)
                        & leq(S8,n5) )
                     => a_select3(h_thruster_filter_init,R8,S8) = init )
                  & ! [T8,U8] :
                      ( ( leq(n0,T8)
                        & leq(n0,U8)
                        & leq(T8,n5)
                        & leq(U8,n5) )
                     => a_select3(phi_thruster_filter_init,T8,U8) = init )
                  & ! [V8,W8] :
                      ( ( leq(n0,V8)
                        & leq(n0,W8)
                        & leq(V8,minus(n6,n1))
                        & leq(W8,n0) )
                     => a_select3(dv_thruster_filter_init,V8,W8) = init )
                  & ! [X8,Y8] :
                      ( ( leq(n0,X8)
                        & leq(n0,Y8)
                        & leq(X8,n5)
                        & leq(Y8,n5) )
                     => a_select3(q_thruster_filter_init,X8,Y8) = init )
                  & ! [Z8,A9] :
                      ( ( leq(n0,Z8)
                        & leq(n0,A9)
                        & leq(Z8,n3)
                        & leq(A9,n3) )
                     => a_select3(r_thruster_filter_init,Z8,A9) = init )
                  & ! [B9,C9] :
                      ( ( leq(n0,B9)
                        & leq(n0,C9)
                        & leq(B9,n5)
                        & leq(C9,n0) )
                     => a_select3(xhatmin_thruster_filter_init,B9,C9) = init )
                  & ! [D9,E9] :
                      ( ( leq(n0,D9)
                        & leq(n0,E9)
                        & leq(D9,n5)
                        & leq(E9,n5) )
                     => a_select3(pminus_thruster_filter_init,D9,E9) = init )
                  & ! [F9] :
                      ( ( leq(n0,F9)
                        & leq(F9,minus(n6,n1)) )
                     => ! [G9] :
                          ( ( leq(n0,G9)
                            & leq(G9,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,F9,G9) = init ) ) )
               => ( init = init
                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                  & a_select3(xhatmin_thruster_filter_init,n1,n0) = init
                  & a_select3(xhatmin_thruster_filter_init,n2,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                  & ( ~ gt(pv5,n0)
                   => ( init = init
                      & ( ~ gt(pv5,n0)
                       => ( init = init
                          & ( ~ gt(pv5,n0)
                           => ( init = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H9,I9] :
                                      ( ( leq(n0,H9)
                                        & leq(n0,I9)
                                        & leq(H9,n3)
                                        & leq(I9,n5) )
                                     => a_select3(h_thruster_filter_init,H9,I9) = init )
                                  & ! [J9,K9] :
                                      ( ( leq(n0,J9)
                                        & leq(n0,K9)
                                        & leq(J9,n5)
                                        & leq(K9,n5) )
                                     => a_select3(phi_thruster_filter_init,J9,K9) = init )
                                  & ! [L9,M9] :
                                      ( ( leq(n0,L9)
                                        & leq(n0,M9)
                                        & leq(L9,minus(n6,n1))
                                        & leq(M9,n0) )
                                     => a_select3(dv_thruster_filter_init,L9,M9) = init )
                                  & ! [N9,O9] :
                                      ( ( leq(n0,N9)
                                        & leq(n0,O9)
                                        & leq(N9,n5)
                                        & leq(O9,n5) )
                                     => a_select3(q_thruster_filter_init,N9,O9) = init )
                                  & ! [P9,Q9] :
                                      ( ( leq(n0,P9)
                                        & leq(n0,Q9)
                                        & leq(P9,n3)
                                        & leq(Q9,n3) )
                                     => a_select3(r_thruster_filter_init,P9,Q9) = init )
                                  & ! [R9,S9] :
                                      ( ( leq(n0,R9)
                                        & leq(n0,S9)
                                        & leq(R9,n5)
                                        & leq(S9,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R9,S9) = init )
                                  & ! [T9,U9] :
                                      ( ( leq(n0,T9)
                                        & leq(n0,U9)
                                        & leq(T9,n5)
                                        & leq(U9,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T9,U9) = init )
                                  & ! [V9] :
                                      ( ( leq(n0,V9)
                                        & leq(V9,minus(n6,n1)) )
                                     => ! [W9] :
                                          ( ( leq(n0,W9)
                                            & leq(W9,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V9,W9) = init ) )
                                  & ! [X9,Y9] :
                                      ( ( leq(n0,X9)
                                        & leq(n0,Y9)
                                        & leq(X9,minus(n6,n1))
                                        & leq(Y9,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X9,Y9) = init )
                                  & ! [Z9,A10] :
                                      ( ( leq(n0,Z9)
                                        & leq(n0,A10)
                                        & leq(Z9,minus(n6,n1))
                                        & leq(A10,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z9,A10) = init )
                                  & ! [B10,C10] :
                                      ( ( leq(n0,B10)
                                        & leq(n0,C10)
                                        & leq(B10,minus(n6,n1))
                                        & leq(C10,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B10,C10) = init )
                                  & ! [D10,E10] :
                                      ( ( leq(n0,D10)
                                        & leq(n0,E10)
                                        & leq(D10,minus(n6,n1))
                                        & leq(E10,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D10,E10) = init )
                                  & ! [F10,G10] :
                                      ( ( leq(n0,F10)
                                        & leq(n0,G10)
                                        & leq(F10,minus(n6,n1))
                                        & leq(G10,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F10,G10) = init )
                                  & ! [H10,I10] :
                                      ( ( leq(n0,H10)
                                        & leq(n0,I10)
                                        & leq(H10,minus(n6,n1))
                                        & leq(I10,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H10,I10) = init )
                                  & ! [J10,K10] :
                                      ( ( leq(n0,J10)
                                        & leq(n0,K10)
                                        & leq(J10,minus(n4,n1))
                                        & leq(K10,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J10,K10) = init )
                                  & ! [L10,M10] :
                                      ( ( leq(n0,L10)
                                        & leq(n0,M10)
                                        & leq(L10,minus(n6,n1))
                                        & leq(M10,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L10,M10) = init )
                                  & ! [N10,O10] :
                                      ( ( leq(n0,N10)
                                        & leq(n0,O10)
                                        & leq(N10,minus(n6,n1))
                                        & leq(O10,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N10,O10) = init )
                                  & ! [P10,Q10] :
                                      ( ( leq(n0,P10)
                                        & leq(n0,Q10)
                                        & leq(P10,minus(n6,n1))
                                        & leq(Q10,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P10,Q10) = init )
                                  & ! [R10,S10] :
                                      ( ( leq(n0,R10)
                                        & leq(n0,S10)
                                        & leq(R10,minus(n4,n1))
                                        & leq(S10,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R10,S10) = init )
                                  & ! [T10,U10] :
                                      ( ( leq(n0,T10)
                                        & leq(n0,U10)
                                        & leq(T10,minus(n4,n1))
                                        & leq(U10,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T10,U10) = init )
                                  & ! [V10,W10] :
                                      ( ( leq(n0,V10)
                                        & leq(n0,W10)
                                        & leq(V10,minus(n6,n1))
                                        & leq(W10,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V10,W10) = init )
                                  & ! [X10,Y10] :
                                      ( ( leq(n0,X10)
                                        & leq(n0,Y10)
                                        & leq(X10,minus(n4,n1))
                                        & leq(Y10,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X10,Y10) = init )
                                  & ! [Z10,A11] :
                                      ( ( leq(n0,Z10)
                                        & leq(n0,A11)
                                        & leq(Z10,minus(n4,n1))
                                        & leq(A11,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z10,A11) = init )
                                  & ! [B11,C11] :
                                      ( ( leq(n0,B11)
                                        & leq(n0,C11)
                                        & leq(B11,minus(n4,n1))
                                        & leq(C11,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B11,C11) = init )
                                  & ! [D11,E11] :
                                      ( ( leq(n0,D11)
                                        & leq(n0,E11)
                                        & leq(D11,minus(n6,n1))
                                        & leq(E11,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D11,E11) = init )
                                  & ! [F11,G11] :
                                      ( ( leq(n0,F11)
                                        & leq(n0,G11)
                                        & leq(F11,minus(n4,n1))
                                        & leq(G11,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F11,G11) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H11,I11] :
                                      ( ( leq(n0,H11)
                                        & leq(n0,I11)
                                        & leq(H11,n3)
                                        & leq(I11,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H11,I11) = init )
                                  & ! [J11,K11] :
                                      ( ( leq(n0,J11)
                                        & leq(n0,K11)
                                        & leq(J11,n5)
                                        & leq(K11,n5) )
                                     => a_select3(phi_thruster_filter_init,J11,K11) = init )
                                  & ! [L11,M11] :
                                      ( ( leq(n0,L11)
                                        & leq(n0,M11)
                                        & leq(L11,minus(n6,n1))
                                        & leq(M11,n0) )
                                     => a_select3(dv_thruster_filter_init,L11,M11) = init )
                                  & ! [N11,O11] :
                                      ( ( leq(n0,N11)
                                        & leq(n0,O11)
                                        & leq(N11,n5)
                                        & leq(O11,n5) )
                                     => a_select3(q_thruster_filter_init,N11,O11) = init )
                                  & ! [P11,Q11] :
                                      ( ( leq(n0,P11)
                                        & leq(n0,Q11)
                                        & leq(P11,n3)
                                        & leq(Q11,n3) )
                                     => a_select3(r_thruster_filter_init,P11,Q11) = init )
                                  & ! [R11,S11] :
                                      ( ( leq(n0,R11)
                                        & leq(n0,S11)
                                        & leq(R11,n5)
                                        & leq(S11,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R11,S11) = init )
                                  & ! [T11,U11] :
                                      ( ( leq(n0,T11)
                                        & leq(n0,U11)
                                        & leq(T11,n5)
                                        & leq(U11,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T11,U11) = init )
                                  & ! [V11] :
                                      ( ( leq(n0,V11)
                                        & leq(V11,minus(n6,n1)) )
                                     => ! [W11] :
                                          ( ( leq(n0,W11)
                                            & leq(W11,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V11,W11) = init ) )
                                  & ! [X11,Y11] :
                                      ( ( leq(n0,X11)
                                        & leq(n0,Y11)
                                        & leq(X11,minus(n6,n1))
                                        & leq(Y11,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X11,Y11) = init )
                                  & ! [Z11,A12] :
                                      ( ( leq(n0,Z11)
                                        & leq(n0,A12)
                                        & leq(Z11,minus(n6,n1))
                                        & leq(A12,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z11,A12) = init )
                                  & ! [B12,C12] :
                                      ( ( leq(n0,B12)
                                        & leq(n0,C12)
                                        & leq(B12,minus(n6,n1))
                                        & leq(C12,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B12,C12) = init )
                                  & ! [D12,E12] :
                                      ( ( leq(n0,D12)
                                        & leq(n0,E12)
                                        & leq(D12,minus(n6,n1))
                                        & leq(E12,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D12,E12) = init )
                                  & ! [F12,G12] :
                                      ( ( leq(n0,F12)
                                        & leq(n0,G12)
                                        & leq(F12,minus(n6,n1))
                                        & leq(G12,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F12,G12) = init )
                                  & ! [H12,I12] :
                                      ( ( leq(n0,H12)
                                        & leq(n0,I12)
                                        & leq(H12,minus(n6,n1))
                                        & leq(I12,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H12,I12) = init )
                                  & ! [J12,K12] :
                                      ( ( leq(n0,J12)
                                        & leq(n0,K12)
                                        & leq(J12,minus(n4,n1))
                                        & leq(K12,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J12,K12) = init )
                                  & ! [L12,M12] :
                                      ( ( leq(n0,L12)
                                        & leq(n0,M12)
                                        & leq(L12,minus(n6,n1))
                                        & leq(M12,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L12,M12) = init )
                                  & ! [N12,O12] :
                                      ( ( leq(n0,N12)
                                        & leq(n0,O12)
                                        & leq(N12,minus(n6,n1))
                                        & leq(O12,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N12,O12) = init )
                                  & ! [P12,Q12] :
                                      ( ( leq(n0,P12)
                                        & leq(n0,Q12)
                                        & leq(P12,minus(n6,n1))
                                        & leq(Q12,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P12,Q12) = init )
                                  & ! [R12,S12] :
                                      ( ( leq(n0,R12)
                                        & leq(n0,S12)
                                        & leq(R12,minus(n4,n1))
                                        & leq(S12,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R12,S12) = init )
                                  & ! [T12,U12] :
                                      ( ( leq(n0,T12)
                                        & leq(n0,U12)
                                        & leq(T12,minus(n4,n1))
                                        & leq(U12,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T12,U12) = init )
                                  & ! [V12,W12] :
                                      ( ( leq(n0,V12)
                                        & leq(n0,W12)
                                        & leq(V12,minus(n6,n1))
                                        & leq(W12,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V12,W12) = init )
                                  & ! [X12,Y12] :
                                      ( ( leq(n0,X12)
                                        & leq(n0,Y12)
                                        & leq(X12,minus(n4,n1))
                                        & leq(Y12,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X12,Y12) = init )
                                  & ! [Z12,A13] :
                                      ( ( leq(n0,Z12)
                                        & leq(n0,A13)
                                        & leq(Z12,minus(n4,n1))
                                        & leq(A13,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z12,A13) = init )
                                  & ! [B13,C13] :
                                      ( ( leq(n0,B13)
                                        & leq(n0,C13)
                                        & leq(B13,minus(n4,n1))
                                        & leq(C13,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B13,C13) = init )
                                  & ! [D13,E13] :
                                      ( ( leq(n0,D13)
                                        & leq(n0,E13)
                                        & leq(D13,minus(n6,n1))
                                        & leq(E13,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D13,E13) = init )
                                  & ! [F13,G13] :
                                      ( ( leq(n0,F13)
                                        & leq(n0,G13)
                                        & leq(F13,minus(n4,n1))
                                        & leq(G13,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F13,G13) = init ) ) ) ) )
                          & ( gt(pv5,n0)
                           => ( init = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H13,I13] :
                                      ( ( leq(n0,H13)
                                        & leq(n0,I13)
                                        & leq(H13,n3)
                                        & leq(I13,n5) )
                                     => a_select3(h_thruster_filter_init,H13,I13) = init )
                                  & ! [J13,K13] :
                                      ( ( leq(n0,J13)
                                        & leq(n0,K13)
                                        & leq(J13,n5)
                                        & leq(K13,n5) )
                                     => a_select3(phi_thruster_filter_init,J13,K13) = init )
                                  & ! [L13,M13] :
                                      ( ( leq(n0,L13)
                                        & leq(n0,M13)
                                        & leq(L13,minus(n6,n1))
                                        & leq(M13,n0) )
                                     => a_select3(dv_thruster_filter_init,L13,M13) = init )
                                  & ! [N13,O13] :
                                      ( ( leq(n0,N13)
                                        & leq(n0,O13)
                                        & leq(N13,n5)
                                        & leq(O13,n5) )
                                     => a_select3(q_thruster_filter_init,N13,O13) = init )
                                  & ! [P13,Q13] :
                                      ( ( leq(n0,P13)
                                        & leq(n0,Q13)
                                        & leq(P13,n3)
                                        & leq(Q13,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P13,Q13) = init )
                                  & ! [R13,S13] :
                                      ( ( leq(n0,R13)
                                        & leq(n0,S13)
                                        & leq(R13,n5)
                                        & leq(S13,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R13,S13) = init )
                                  & ! [T13,U13] :
                                      ( ( leq(n0,T13)
                                        & leq(n0,U13)
                                        & leq(T13,n5)
                                        & leq(U13,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T13,U13) = init )
                                  & ! [V13] :
                                      ( ( leq(n0,V13)
                                        & leq(V13,minus(n6,n1)) )
                                     => ! [W13] :
                                          ( ( leq(n0,W13)
                                            & leq(W13,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V13,W13) = init ) )
                                  & ! [X13,Y13] :
                                      ( ( leq(n0,X13)
                                        & leq(n0,Y13)
                                        & leq(X13,minus(n6,n1))
                                        & leq(Y13,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X13,Y13) = init )
                                  & ! [Z13,A14] :
                                      ( ( leq(n0,Z13)
                                        & leq(n0,A14)
                                        & leq(Z13,minus(n6,n1))
                                        & leq(A14,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z13,A14) = init )
                                  & ! [B14,C14] :
                                      ( ( leq(n0,B14)
                                        & leq(n0,C14)
                                        & leq(B14,minus(n6,n1))
                                        & leq(C14,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B14,C14) = init )
                                  & ! [D14,E14] :
                                      ( ( leq(n0,D14)
                                        & leq(n0,E14)
                                        & leq(D14,minus(n6,n1))
                                        & leq(E14,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D14,E14) = init )
                                  & ! [F14,G14] :
                                      ( ( leq(n0,F14)
                                        & leq(n0,G14)
                                        & leq(F14,minus(n6,n1))
                                        & leq(G14,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F14,G14) = init )
                                  & ! [H14,I14] :
                                      ( ( leq(n0,H14)
                                        & leq(n0,I14)
                                        & leq(H14,minus(n6,n1))
                                        & leq(I14,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H14,I14) = init )
                                  & ! [J14,K14] :
                                      ( ( leq(n0,J14)
                                        & leq(n0,K14)
                                        & leq(J14,minus(n4,n1))
                                        & leq(K14,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J14,K14) = init )
                                  & ! [L14,M14] :
                                      ( ( leq(n0,L14)
                                        & leq(n0,M14)
                                        & leq(L14,minus(n6,n1))
                                        & leq(M14,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L14,M14) = init )
                                  & ! [N14,O14] :
                                      ( ( leq(n0,N14)
                                        & leq(n0,O14)
                                        & leq(N14,minus(n6,n1))
                                        & leq(O14,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N14,O14) = init )
                                  & ! [P14,Q14] :
                                      ( ( leq(n0,P14)
                                        & leq(n0,Q14)
                                        & leq(P14,minus(n6,n1))
                                        & leq(Q14,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P14,Q14) = init )
                                  & ! [R14,S14] :
                                      ( ( leq(n0,R14)
                                        & leq(n0,S14)
                                        & leq(R14,minus(n4,n1))
                                        & leq(S14,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R14,S14) = init )
                                  & ! [T14,U14] :
                                      ( ( leq(n0,T14)
                                        & leq(n0,U14)
                                        & leq(T14,minus(n4,n1))
                                        & leq(U14,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T14,U14) = init )
                                  & ! [V14,W14] :
                                      ( ( leq(n0,V14)
                                        & leq(n0,W14)
                                        & leq(V14,minus(n6,n1))
                                        & leq(W14,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V14,W14) = init )
                                  & ! [X14,Y14] :
                                      ( ( leq(n0,X14)
                                        & leq(n0,Y14)
                                        & leq(X14,minus(n4,n1))
                                        & leq(Y14,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X14,Y14) = init )
                                  & ! [Z14,A15] :
                                      ( ( leq(n0,Z14)
                                        & leq(n0,A15)
                                        & leq(Z14,minus(n4,n1))
                                        & leq(A15,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z14,A15) = init )
                                  & ! [B15,C15] :
                                      ( ( leq(n0,B15)
                                        & leq(n0,C15)
                                        & leq(B15,minus(n4,n1))
                                        & leq(C15,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B15,C15) = init )
                                  & ! [D15,E15] :
                                      ( ( leq(n0,D15)
                                        & leq(n0,E15)
                                        & leq(D15,minus(n6,n1))
                                        & leq(E15,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D15,E15) = init )
                                  & ! [F15,G15] :
                                      ( ( leq(n0,F15)
                                        & leq(n0,G15)
                                        & leq(F15,minus(n4,n1))
                                        & leq(G15,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F15,G15) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H15,I15] :
                                      ( ( leq(n0,H15)
                                        & leq(n0,I15)
                                        & leq(H15,n3)
                                        & leq(I15,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H15,I15) = init )
                                  & ! [J15,K15] :
                                      ( ( leq(n0,J15)
                                        & leq(n0,K15)
                                        & leq(J15,n5)
                                        & leq(K15,n5) )
                                     => a_select3(phi_thruster_filter_init,J15,K15) = init )
                                  & ! [L15,M15] :
                                      ( ( leq(n0,L15)
                                        & leq(n0,M15)
                                        & leq(L15,minus(n6,n1))
                                        & leq(M15,n0) )
                                     => a_select3(dv_thruster_filter_init,L15,M15) = init )
                                  & ! [N15,O15] :
                                      ( ( leq(n0,N15)
                                        & leq(n0,O15)
                                        & leq(N15,n5)
                                        & leq(O15,n5) )
                                     => a_select3(q_thruster_filter_init,N15,O15) = init )
                                  & ! [P15,Q15] :
                                      ( ( leq(n0,P15)
                                        & leq(n0,Q15)
                                        & leq(P15,n3)
                                        & leq(Q15,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P15,Q15) = init )
                                  & ! [R15,S15] :
                                      ( ( leq(n0,R15)
                                        & leq(n0,S15)
                                        & leq(R15,n5)
                                        & leq(S15,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R15,S15) = init )
                                  & ! [T15,U15] :
                                      ( ( leq(n0,T15)
                                        & leq(n0,U15)
                                        & leq(T15,n5)
                                        & leq(U15,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T15,U15) = init )
                                  & ! [V15] :
                                      ( ( leq(n0,V15)
                                        & leq(V15,minus(n6,n1)) )
                                     => ! [W15] :
                                          ( ( leq(n0,W15)
                                            & leq(W15,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V15,W15) = init ) )
                                  & ! [X15,Y15] :
                                      ( ( leq(n0,X15)
                                        & leq(n0,Y15)
                                        & leq(X15,minus(n6,n1))
                                        & leq(Y15,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X15,Y15) = init )
                                  & ! [Z15,A16] :
                                      ( ( leq(n0,Z15)
                                        & leq(n0,A16)
                                        & leq(Z15,minus(n6,n1))
                                        & leq(A16,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z15,A16) = init )
                                  & ! [B16,C16] :
                                      ( ( leq(n0,B16)
                                        & leq(n0,C16)
                                        & leq(B16,minus(n6,n1))
                                        & leq(C16,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B16,C16) = init )
                                  & ! [D16,E16] :
                                      ( ( leq(n0,D16)
                                        & leq(n0,E16)
                                        & leq(D16,minus(n6,n1))
                                        & leq(E16,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D16,E16) = init )
                                  & ! [F16,G16] :
                                      ( ( leq(n0,F16)
                                        & leq(n0,G16)
                                        & leq(F16,minus(n6,n1))
                                        & leq(G16,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F16,G16) = init )
                                  & ! [H16,I16] :
                                      ( ( leq(n0,H16)
                                        & leq(n0,I16)
                                        & leq(H16,minus(n6,n1))
                                        & leq(I16,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H16,I16) = init )
                                  & ! [J16,K16] :
                                      ( ( leq(n0,J16)
                                        & leq(n0,K16)
                                        & leq(J16,minus(n4,n1))
                                        & leq(K16,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J16,K16) = init )
                                  & ! [L16,M16] :
                                      ( ( leq(n0,L16)
                                        & leq(n0,M16)
                                        & leq(L16,minus(n6,n1))
                                        & leq(M16,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L16,M16) = init )
                                  & ! [N16,O16] :
                                      ( ( leq(n0,N16)
                                        & leq(n0,O16)
                                        & leq(N16,minus(n6,n1))
                                        & leq(O16,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N16,O16) = init )
                                  & ! [P16,Q16] :
                                      ( ( leq(n0,P16)
                                        & leq(n0,Q16)
                                        & leq(P16,minus(n6,n1))
                                        & leq(Q16,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P16,Q16) = init )
                                  & ! [R16,S16] :
                                      ( ( leq(n0,R16)
                                        & leq(n0,S16)
                                        & leq(R16,minus(n4,n1))
                                        & leq(S16,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R16,S16) = init )
                                  & ! [T16,U16] :
                                      ( ( leq(n0,T16)
                                        & leq(n0,U16)
                                        & leq(T16,minus(n4,n1))
                                        & leq(U16,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T16,U16) = init )
                                  & ! [V16,W16] :
                                      ( ( leq(n0,V16)
                                        & leq(n0,W16)
                                        & leq(V16,minus(n6,n1))
                                        & leq(W16,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V16,W16) = init )
                                  & ! [X16,Y16] :
                                      ( ( leq(n0,X16)
                                        & leq(n0,Y16)
                                        & leq(X16,minus(n4,n1))
                                        & leq(Y16,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X16,Y16) = init )
                                  & ! [Z16,A17] :
                                      ( ( leq(n0,Z16)
                                        & leq(n0,A17)
                                        & leq(Z16,minus(n4,n1))
                                        & leq(A17,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z16,A17) = init )
                                  & ! [B17,C17] :
                                      ( ( leq(n0,B17)
                                        & leq(n0,C17)
                                        & leq(B17,minus(n4,n1))
                                        & leq(C17,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B17,C17) = init )
                                  & ! [D17,E17] :
                                      ( ( leq(n0,D17)
                                        & leq(n0,E17)
                                        & leq(D17,minus(n6,n1))
                                        & leq(E17,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D17,E17) = init )
                                  & ! [F17,G17] :
                                      ( ( leq(n0,F17)
                                        & leq(n0,G17)
                                        & leq(F17,minus(n4,n1))
                                        & leq(G17,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F17,G17) = init ) ) ) ) ) ) )
                      & ( gt(pv5,n0)
                       => ( init = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                          & ( ~ gt(pv5,n0)
                           => ( init = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H17,I17] :
                                      ( ( leq(n0,H17)
                                        & leq(n0,I17)
                                        & leq(H17,n3)
                                        & leq(I17,n5) )
                                     => a_select3(h_thruster_filter_init,H17,I17) = init )
                                  & ! [J17,K17] :
                                      ( ( leq(n0,J17)
                                        & leq(n0,K17)
                                        & leq(J17,n5)
                                        & leq(K17,n5) )
                                     => a_select3(phi_thruster_filter_init,J17,K17) = init )
                                  & ! [L17,M17] :
                                      ( ( leq(n0,L17)
                                        & leq(n0,M17)
                                        & leq(L17,minus(n6,n1))
                                        & leq(M17,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L17,M17) = init )
                                  & ! [N17,O17] :
                                      ( ( leq(n0,N17)
                                        & leq(n0,O17)
                                        & leq(N17,n5)
                                        & leq(O17,n5) )
                                     => a_select3(q_thruster_filter_init,N17,O17) = init )
                                  & ! [P17,Q17] :
                                      ( ( leq(n0,P17)
                                        & leq(n0,Q17)
                                        & leq(P17,n3)
                                        & leq(Q17,n3) )
                                     => a_select3(r_thruster_filter_init,P17,Q17) = init )
                                  & ! [R17,S17] :
                                      ( ( leq(n0,R17)
                                        & leq(n0,S17)
                                        & leq(R17,n5)
                                        & leq(S17,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R17,S17) = init )
                                  & ! [T17,U17] :
                                      ( ( leq(n0,T17)
                                        & leq(n0,U17)
                                        & leq(T17,n5)
                                        & leq(U17,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T17,U17) = init )
                                  & ! [V17] :
                                      ( ( leq(n0,V17)
                                        & leq(V17,minus(n6,n1)) )
                                     => ! [W17] :
                                          ( ( leq(n0,W17)
                                            & leq(W17,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V17,W17) = init ) )
                                  & ! [X17,Y17] :
                                      ( ( leq(n0,X17)
                                        & leq(n0,Y17)
                                        & leq(X17,minus(n6,n1))
                                        & leq(Y17,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X17,Y17) = init )
                                  & ! [Z17,A18] :
                                      ( ( leq(n0,Z17)
                                        & leq(n0,A18)
                                        & leq(Z17,minus(n6,n1))
                                        & leq(A18,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z17,A18) = init )
                                  & ! [B18,C18] :
                                      ( ( leq(n0,B18)
                                        & leq(n0,C18)
                                        & leq(B18,minus(n6,n1))
                                        & leq(C18,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B18,C18) = init )
                                  & ! [D18,E18] :
                                      ( ( leq(n0,D18)
                                        & leq(n0,E18)
                                        & leq(D18,minus(n6,n1))
                                        & leq(E18,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D18,E18) = init )
                                  & ! [F18,G18] :
                                      ( ( leq(n0,F18)
                                        & leq(n0,G18)
                                        & leq(F18,minus(n6,n1))
                                        & leq(G18,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F18,G18) = init )
                                  & ! [H18,I18] :
                                      ( ( leq(n0,H18)
                                        & leq(n0,I18)
                                        & leq(H18,minus(n6,n1))
                                        & leq(I18,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H18,I18) = init )
                                  & ! [J18,K18] :
                                      ( ( leq(n0,J18)
                                        & leq(n0,K18)
                                        & leq(J18,minus(n4,n1))
                                        & leq(K18,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J18,K18) = init )
                                  & ! [L18,M18] :
                                      ( ( leq(n0,L18)
                                        & leq(n0,M18)
                                        & leq(L18,minus(n6,n1))
                                        & leq(M18,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L18,M18) = init )
                                  & ! [N18,O18] :
                                      ( ( leq(n0,N18)
                                        & leq(n0,O18)
                                        & leq(N18,minus(n6,n1))
                                        & leq(O18,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N18,O18) = init )
                                  & ! [P18,Q18] :
                                      ( ( leq(n0,P18)
                                        & leq(n0,Q18)
                                        & leq(P18,minus(n6,n1))
                                        & leq(Q18,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P18,Q18) = init )
                                  & ! [R18,S18] :
                                      ( ( leq(n0,R18)
                                        & leq(n0,S18)
                                        & leq(R18,minus(n4,n1))
                                        & leq(S18,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R18,S18) = init )
                                  & ! [T18,U18] :
                                      ( ( leq(n0,T18)
                                        & leq(n0,U18)
                                        & leq(T18,minus(n4,n1))
                                        & leq(U18,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T18,U18) = init )
                                  & ! [V18,W18] :
                                      ( ( leq(n0,V18)
                                        & leq(n0,W18)
                                        & leq(V18,minus(n6,n1))
                                        & leq(W18,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V18,W18) = init )
                                  & ! [X18,Y18] :
                                      ( ( leq(n0,X18)
                                        & leq(n0,Y18)
                                        & leq(X18,minus(n4,n1))
                                        & leq(Y18,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X18,Y18) = init )
                                  & ! [Z18,A19] :
                                      ( ( leq(n0,Z18)
                                        & leq(n0,A19)
                                        & leq(Z18,minus(n4,n1))
                                        & leq(A19,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z18,A19) = init )
                                  & ! [B19,C19] :
                                      ( ( leq(n0,B19)
                                        & leq(n0,C19)
                                        & leq(B19,minus(n4,n1))
                                        & leq(C19,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B19,C19) = init )
                                  & ! [D19,E19] :
                                      ( ( leq(n0,D19)
                                        & leq(n0,E19)
                                        & leq(D19,minus(n6,n1))
                                        & leq(E19,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D19,E19) = init )
                                  & ! [F19,G19] :
                                      ( ( leq(n0,F19)
                                        & leq(n0,G19)
                                        & leq(F19,minus(n4,n1))
                                        & leq(G19,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F19,G19) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H19,I19] :
                                      ( ( leq(n0,H19)
                                        & leq(n0,I19)
                                        & leq(H19,n3)
                                        & leq(I19,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H19,I19) = init )
                                  & ! [J19,K19] :
                                      ( ( leq(n0,J19)
                                        & leq(n0,K19)
                                        & leq(J19,n5)
                                        & leq(K19,n5) )
                                     => a_select3(phi_thruster_filter_init,J19,K19) = init )
                                  & ! [L19,M19] :
                                      ( ( leq(n0,L19)
                                        & leq(n0,M19)
                                        & leq(L19,minus(n6,n1))
                                        & leq(M19,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L19,M19) = init )
                                  & ! [N19,O19] :
                                      ( ( leq(n0,N19)
                                        & leq(n0,O19)
                                        & leq(N19,n5)
                                        & leq(O19,n5) )
                                     => a_select3(q_thruster_filter_init,N19,O19) = init )
                                  & ! [P19,Q19] :
                                      ( ( leq(n0,P19)
                                        & leq(n0,Q19)
                                        & leq(P19,n3)
                                        & leq(Q19,n3) )
                                     => a_select3(r_thruster_filter_init,P19,Q19) = init )
                                  & ! [R19,S19] :
                                      ( ( leq(n0,R19)
                                        & leq(n0,S19)
                                        & leq(R19,n5)
                                        & leq(S19,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R19,S19) = init )
                                  & ! [T19,U19] :
                                      ( ( leq(n0,T19)
                                        & leq(n0,U19)
                                        & leq(T19,n5)
                                        & leq(U19,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T19,U19) = init )
                                  & ! [V19] :
                                      ( ( leq(n0,V19)
                                        & leq(V19,minus(n6,n1)) )
                                     => ! [W19] :
                                          ( ( leq(n0,W19)
                                            & leq(W19,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V19,W19) = init ) )
                                  & ! [X19,Y19] :
                                      ( ( leq(n0,X19)
                                        & leq(n0,Y19)
                                        & leq(X19,minus(n6,n1))
                                        & leq(Y19,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X19,Y19) = init )
                                  & ! [Z19,A20] :
                                      ( ( leq(n0,Z19)
                                        & leq(n0,A20)
                                        & leq(Z19,minus(n6,n1))
                                        & leq(A20,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z19,A20) = init )
                                  & ! [B20,C20] :
                                      ( ( leq(n0,B20)
                                        & leq(n0,C20)
                                        & leq(B20,minus(n6,n1))
                                        & leq(C20,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B20,C20) = init )
                                  & ! [D20,E20] :
                                      ( ( leq(n0,D20)
                                        & leq(n0,E20)
                                        & leq(D20,minus(n6,n1))
                                        & leq(E20,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D20,E20) = init )
                                  & ! [F20,G20] :
                                      ( ( leq(n0,F20)
                                        & leq(n0,G20)
                                        & leq(F20,minus(n6,n1))
                                        & leq(G20,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F20,G20) = init )
                                  & ! [H20,I20] :
                                      ( ( leq(n0,H20)
                                        & leq(n0,I20)
                                        & leq(H20,minus(n6,n1))
                                        & leq(I20,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H20,I20) = init )
                                  & ! [J20,K20] :
                                      ( ( leq(n0,J20)
                                        & leq(n0,K20)
                                        & leq(J20,minus(n4,n1))
                                        & leq(K20,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J20,K20) = init )
                                  & ! [L20,M20] :
                                      ( ( leq(n0,L20)
                                        & leq(n0,M20)
                                        & leq(L20,minus(n6,n1))
                                        & leq(M20,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L20,M20) = init )
                                  & ! [N20,O20] :
                                      ( ( leq(n0,N20)
                                        & leq(n0,O20)
                                        & leq(N20,minus(n6,n1))
                                        & leq(O20,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N20,O20) = init )
                                  & ! [P20,Q20] :
                                      ( ( leq(n0,P20)
                                        & leq(n0,Q20)
                                        & leq(P20,minus(n6,n1))
                                        & leq(Q20,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P20,Q20) = init )
                                  & ! [R20,S20] :
                                      ( ( leq(n0,R20)
                                        & leq(n0,S20)
                                        & leq(R20,minus(n4,n1))
                                        & leq(S20,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R20,S20) = init )
                                  & ! [T20,U20] :
                                      ( ( leq(n0,T20)
                                        & leq(n0,U20)
                                        & leq(T20,minus(n4,n1))
                                        & leq(U20,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T20,U20) = init )
                                  & ! [V20,W20] :
                                      ( ( leq(n0,V20)
                                        & leq(n0,W20)
                                        & leq(V20,minus(n6,n1))
                                        & leq(W20,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V20,W20) = init )
                                  & ! [X20,Y20] :
                                      ( ( leq(n0,X20)
                                        & leq(n0,Y20)
                                        & leq(X20,minus(n4,n1))
                                        & leq(Y20,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X20,Y20) = init )
                                  & ! [Z20,A21] :
                                      ( ( leq(n0,Z20)
                                        & leq(n0,A21)
                                        & leq(Z20,minus(n4,n1))
                                        & leq(A21,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z20,A21) = init )
                                  & ! [B21,C21] :
                                      ( ( leq(n0,B21)
                                        & leq(n0,C21)
                                        & leq(B21,minus(n4,n1))
                                        & leq(C21,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B21,C21) = init )
                                  & ! [D21,E21] :
                                      ( ( leq(n0,D21)
                                        & leq(n0,E21)
                                        & leq(D21,minus(n6,n1))
                                        & leq(E21,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D21,E21) = init )
                                  & ! [F21,G21] :
                                      ( ( leq(n0,F21)
                                        & leq(n0,G21)
                                        & leq(F21,minus(n4,n1))
                                        & leq(G21,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F21,G21) = init ) ) ) ) )
                          & ( gt(pv5,n0)
                           => ( init = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H21,I21] :
                                      ( ( leq(n0,H21)
                                        & leq(n0,I21)
                                        & leq(H21,n3)
                                        & leq(I21,n5) )
                                     => a_select3(h_thruster_filter_init,H21,I21) = init )
                                  & ! [J21,K21] :
                                      ( ( leq(n0,J21)
                                        & leq(n0,K21)
                                        & leq(J21,n5)
                                        & leq(K21,n5) )
                                     => a_select3(phi_thruster_filter_init,J21,K21) = init )
                                  & ! [L21,M21] :
                                      ( ( leq(n0,L21)
                                        & leq(n0,M21)
                                        & leq(L21,minus(n6,n1))
                                        & leq(M21,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L21,M21) = init )
                                  & ! [N21,O21] :
                                      ( ( leq(n0,N21)
                                        & leq(n0,O21)
                                        & leq(N21,n5)
                                        & leq(O21,n5) )
                                     => a_select3(q_thruster_filter_init,N21,O21) = init )
                                  & ! [P21,Q21] :
                                      ( ( leq(n0,P21)
                                        & leq(n0,Q21)
                                        & leq(P21,n3)
                                        & leq(Q21,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P21,Q21) = init )
                                  & ! [R21,S21] :
                                      ( ( leq(n0,R21)
                                        & leq(n0,S21)
                                        & leq(R21,n5)
                                        & leq(S21,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R21,S21) = init )
                                  & ! [T21,U21] :
                                      ( ( leq(n0,T21)
                                        & leq(n0,U21)
                                        & leq(T21,n5)
                                        & leq(U21,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T21,U21) = init )
                                  & ! [V21] :
                                      ( ( leq(n0,V21)
                                        & leq(V21,minus(n6,n1)) )
                                     => ! [W21] :
                                          ( ( leq(n0,W21)
                                            & leq(W21,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V21,W21) = init ) )
                                  & ! [X21,Y21] :
                                      ( ( leq(n0,X21)
                                        & leq(n0,Y21)
                                        & leq(X21,minus(n6,n1))
                                        & leq(Y21,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X21,Y21) = init )
                                  & ! [Z21,A22] :
                                      ( ( leq(n0,Z21)
                                        & leq(n0,A22)
                                        & leq(Z21,minus(n6,n1))
                                        & leq(A22,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z21,A22) = init )
                                  & ! [B22,C22] :
                                      ( ( leq(n0,B22)
                                        & leq(n0,C22)
                                        & leq(B22,minus(n6,n1))
                                        & leq(C22,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B22,C22) = init )
                                  & ! [D22,E22] :
                                      ( ( leq(n0,D22)
                                        & leq(n0,E22)
                                        & leq(D22,minus(n6,n1))
                                        & leq(E22,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D22,E22) = init )
                                  & ! [F22,G22] :
                                      ( ( leq(n0,F22)
                                        & leq(n0,G22)
                                        & leq(F22,minus(n6,n1))
                                        & leq(G22,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F22,G22) = init )
                                  & ! [H22,I22] :
                                      ( ( leq(n0,H22)
                                        & leq(n0,I22)
                                        & leq(H22,minus(n6,n1))
                                        & leq(I22,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H22,I22) = init )
                                  & ! [J22,K22] :
                                      ( ( leq(n0,J22)
                                        & leq(n0,K22)
                                        & leq(J22,minus(n4,n1))
                                        & leq(K22,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J22,K22) = init )
                                  & ! [L22,M22] :
                                      ( ( leq(n0,L22)
                                        & leq(n0,M22)
                                        & leq(L22,minus(n6,n1))
                                        & leq(M22,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L22,M22) = init )
                                  & ! [N22,O22] :
                                      ( ( leq(n0,N22)
                                        & leq(n0,O22)
                                        & leq(N22,minus(n6,n1))
                                        & leq(O22,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N22,O22) = init )
                                  & ! [P22,Q22] :
                                      ( ( leq(n0,P22)
                                        & leq(n0,Q22)
                                        & leq(P22,minus(n6,n1))
                                        & leq(Q22,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P22,Q22) = init )
                                  & ! [R22,S22] :
                                      ( ( leq(n0,R22)
                                        & leq(n0,S22)
                                        & leq(R22,minus(n4,n1))
                                        & leq(S22,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R22,S22) = init )
                                  & ! [T22,U22] :
                                      ( ( leq(n0,T22)
                                        & leq(n0,U22)
                                        & leq(T22,minus(n4,n1))
                                        & leq(U22,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T22,U22) = init )
                                  & ! [V22,W22] :
                                      ( ( leq(n0,V22)
                                        & leq(n0,W22)
                                        & leq(V22,minus(n6,n1))
                                        & leq(W22,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V22,W22) = init )
                                  & ! [X22,Y22] :
                                      ( ( leq(n0,X22)
                                        & leq(n0,Y22)
                                        & leq(X22,minus(n4,n1))
                                        & leq(Y22,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X22,Y22) = init )
                                  & ! [Z22,A23] :
                                      ( ( leq(n0,Z22)
                                        & leq(n0,A23)
                                        & leq(Z22,minus(n4,n1))
                                        & leq(A23,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z22,A23) = init )
                                  & ! [B23,C23] :
                                      ( ( leq(n0,B23)
                                        & leq(n0,C23)
                                        & leq(B23,minus(n4,n1))
                                        & leq(C23,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B23,C23) = init )
                                  & ! [D23,E23] :
                                      ( ( leq(n0,D23)
                                        & leq(n0,E23)
                                        & leq(D23,minus(n6,n1))
                                        & leq(E23,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D23,E23) = init )
                                  & ! [F23,G23] :
                                      ( ( leq(n0,F23)
                                        & leq(n0,G23)
                                        & leq(F23,minus(n4,n1))
                                        & leq(G23,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F23,G23) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H23,I23] :
                                      ( ( leq(n0,H23)
                                        & leq(n0,I23)
                                        & leq(H23,n3)
                                        & leq(I23,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H23,I23) = init )
                                  & ! [J23,K23] :
                                      ( ( leq(n0,J23)
                                        & leq(n0,K23)
                                        & leq(J23,n5)
                                        & leq(K23,n5) )
                                     => a_select3(phi_thruster_filter_init,J23,K23) = init )
                                  & ! [L23,M23] :
                                      ( ( leq(n0,L23)
                                        & leq(n0,M23)
                                        & leq(L23,minus(n6,n1))
                                        & leq(M23,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L23,M23) = init )
                                  & ! [N23,O23] :
                                      ( ( leq(n0,N23)
                                        & leq(n0,O23)
                                        & leq(N23,n5)
                                        & leq(O23,n5) )
                                     => a_select3(q_thruster_filter_init,N23,O23) = init )
                                  & ! [P23,Q23] :
                                      ( ( leq(n0,P23)
                                        & leq(n0,Q23)
                                        & leq(P23,n3)
                                        & leq(Q23,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P23,Q23) = init )
                                  & ! [R23,S23] :
                                      ( ( leq(n0,R23)
                                        & leq(n0,S23)
                                        & leq(R23,n5)
                                        & leq(S23,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R23,S23) = init )
                                  & ! [T23,U23] :
                                      ( ( leq(n0,T23)
                                        & leq(n0,U23)
                                        & leq(T23,n5)
                                        & leq(U23,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T23,U23) = init )
                                  & ! [V23] :
                                      ( ( leq(n0,V23)
                                        & leq(V23,minus(n6,n1)) )
                                     => ! [W23] :
                                          ( ( leq(n0,W23)
                                            & leq(W23,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V23,W23) = init ) )
                                  & ! [X23,Y23] :
                                      ( ( leq(n0,X23)
                                        & leq(n0,Y23)
                                        & leq(X23,minus(n6,n1))
                                        & leq(Y23,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X23,Y23) = init )
                                  & ! [Z23,A24] :
                                      ( ( leq(n0,Z23)
                                        & leq(n0,A24)
                                        & leq(Z23,minus(n6,n1))
                                        & leq(A24,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,Z23,A24) = init )
                                  & ! [B24,C24] :
                                      ( ( leq(n0,B24)
                                        & leq(n0,C24)
                                        & leq(B24,minus(n6,n1))
                                        & leq(C24,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B24,C24) = init )
                                  & ! [D24,E24] :
                                      ( ( leq(n0,D24)
                                        & leq(n0,E24)
                                        & leq(D24,minus(n6,n1))
                                        & leq(E24,minus(n6,n1)) )
                                     => a_select3(phi_thruster_filter_init,D24,E24) = init )
                                  & ! [F24,G24] :
                                      ( ( leq(n0,F24)
                                        & leq(n0,G24)
                                        & leq(F24,minus(n6,n1))
                                        & leq(G24,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F24,G24) = init )
                                  & ! [H24,I24] :
                                      ( ( leq(n0,H24)
                                        & leq(n0,I24)
                                        & leq(H24,minus(n6,n1))
                                        & leq(I24,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H24,I24) = init )
                                  & ! [J24,K24] :
                                      ( ( leq(n0,J24)
                                        & leq(n0,K24)
                                        & leq(J24,minus(n4,n1))
                                        & leq(K24,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J24,K24) = init )
                                  & ! [L24,M24] :
                                      ( ( leq(n0,L24)
                                        & leq(n0,M24)
                                        & leq(L24,minus(n6,n1))
                                        & leq(M24,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L24,M24) = init )
                                  & ! [N24,O24] :
                                      ( ( leq(n0,N24)
                                        & leq(n0,O24)
                                        & leq(N24,minus(n6,n1))
                                        & leq(O24,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N24,O24) = init )
                                  & ! [P24,Q24] :
                                      ( ( leq(n0,P24)
                                        & leq(n0,Q24)
                                        & leq(P24,minus(n6,n1))
                                        & leq(Q24,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P24,Q24) = init )
                                  & ! [R24,S24] :
                                      ( ( leq(n0,R24)
                                        & leq(n0,S24)
                                        & leq(R24,minus(n4,n1))
                                        & leq(S24,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R24,S24) = init )
                                  & ! [T24,U24] :
                                      ( ( leq(n0,T24)
                                        & leq(n0,U24)
                                        & leq(T24,minus(n4,n1))
                                        & leq(U24,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T24,U24) = init )
                                  & ! [V24,W24] :
                                      ( ( leq(n0,V24)
                                        & leq(n0,W24)
                                        & leq(V24,minus(n6,n1))
                                        & leq(W24,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V24,W24) = init )
                                  & ! [X24,Y24] :
                                      ( ( leq(n0,X24)
                                        & leq(n0,Y24)
                                        & leq(X24,minus(n4,n1))
                                        & leq(Y24,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X24,Y24) = init )
                                  & ! [Z24,A25] :
                                      ( ( leq(n0,Z24)
                                        & leq(n0,A25)
                                        & leq(Z24,minus(n4,n1))
                                        & leq(A25,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z24,A25) = init )
                                  & ! [B25,C25] :
                                      ( ( leq(n0,B25)
                                        & leq(n0,C25)
                                        & leq(B25,minus(n4,n1))
                                        & leq(C25,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B25,C25) = init )
                                  & ! [D25,E25] :
                                      ( ( leq(n0,D25)
                                        & leq(n0,E25)
                                        & leq(D25,minus(n6,n1))
                                        & leq(E25,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D25,E25) = init )
                                  & ! [F25,G25] :
                                      ( ( leq(n0,F25)
                                        & leq(n0,G25)
                                        & leq(F25,minus(n4,n1))
                                        & leq(G25,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F25,G25) = init ) ) ) ) ) ) ) ) )
                  & ( gt(pv5,n0)
                   => ( init = init
                      & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                      & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                      & ( ~ gt(pv5,n0)
                       => ( init = init
                          & ( ~ gt(pv5,n0)
                           => ( init = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H25,I25] :
                                      ( ( leq(n0,H25)
                                        & leq(n0,I25)
                                        & leq(H25,n3)
                                        & leq(I25,n5) )
                                     => a_select3(h_thruster_filter_init,H25,I25) = init )
                                  & ! [J25,K25] :
                                      ( ( leq(n0,J25)
                                        & leq(n0,K25)
                                        & leq(J25,n5)
                                        & leq(K25,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J25,K25) = init )
                                  & ! [L25,M25] :
                                      ( ( leq(n0,L25)
                                        & leq(n0,M25)
                                        & leq(L25,minus(n6,n1))
                                        & leq(M25,n0) )
                                     => a_select3(dv_thruster_filter_init,L25,M25) = init )
                                  & ! [N25,O25] :
                                      ( ( leq(n0,N25)
                                        & leq(n0,O25)
                                        & leq(N25,n5)
                                        & leq(O25,n5) )
                                     => a_select3(q_thruster_filter_init,N25,O25) = init )
                                  & ! [P25,Q25] :
                                      ( ( leq(n0,P25)
                                        & leq(n0,Q25)
                                        & leq(P25,n3)
                                        & leq(Q25,n3) )
                                     => a_select3(r_thruster_filter_init,P25,Q25) = init )
                                  & ! [R25,S25] :
                                      ( ( leq(n0,R25)
                                        & leq(n0,S25)
                                        & leq(R25,n5)
                                        & leq(S25,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R25,S25) = init )
                                  & ! [T25,U25] :
                                      ( ( leq(n0,T25)
                                        & leq(n0,U25)
                                        & leq(T25,n5)
                                        & leq(U25,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T25,U25) = init )
                                  & ! [V25] :
                                      ( ( leq(n0,V25)
                                        & leq(V25,minus(n6,n1)) )
                                     => ! [W25] :
                                          ( ( leq(n0,W25)
                                            & leq(W25,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V25,W25) = init ) )
                                  & ! [X25,Y25] :
                                      ( ( leq(n0,X25)
                                        & leq(n0,Y25)
                                        & leq(X25,minus(n6,n1))
                                        & leq(Y25,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X25,Y25) = init )
                                  & ! [Z25,A26] :
                                      ( ( leq(n0,Z25)
                                        & leq(n0,A26)
                                        & leq(Z25,minus(n6,n1))
                                        & leq(A26,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z25,A26) = init )
                                  & ! [B26,C26] :
                                      ( ( leq(n0,B26)
                                        & leq(n0,C26)
                                        & leq(B26,minus(n6,n1))
                                        & leq(C26,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B26,C26) = init )
                                  & ! [D26,E26] :
                                      ( ( leq(n0,D26)
                                        & leq(n0,E26)
                                        & leq(D26,minus(n6,n1))
                                        & leq(E26,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D26,E26) = init )
                                  & ! [F26,G26] :
                                      ( ( leq(n0,F26)
                                        & leq(n0,G26)
                                        & leq(F26,minus(n6,n1))
                                        & leq(G26,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F26,G26) = init )
                                  & ! [H26,I26] :
                                      ( ( leq(n0,H26)
                                        & leq(n0,I26)
                                        & leq(H26,minus(n6,n1))
                                        & leq(I26,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H26,I26) = init )
                                  & ! [J26,K26] :
                                      ( ( leq(n0,J26)
                                        & leq(n0,K26)
                                        & leq(J26,minus(n4,n1))
                                        & leq(K26,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J26,K26) = init )
                                  & ! [L26,M26] :
                                      ( ( leq(n0,L26)
                                        & leq(n0,M26)
                                        & leq(L26,minus(n6,n1))
                                        & leq(M26,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L26,M26) = init )
                                  & ! [N26,O26] :
                                      ( ( leq(n0,N26)
                                        & leq(n0,O26)
                                        & leq(N26,minus(n6,n1))
                                        & leq(O26,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N26,O26) = init )
                                  & ! [P26,Q26] :
                                      ( ( leq(n0,P26)
                                        & leq(n0,Q26)
                                        & leq(P26,minus(n6,n1))
                                        & leq(Q26,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P26,Q26) = init )
                                  & ! [R26,S26] :
                                      ( ( leq(n0,R26)
                                        & leq(n0,S26)
                                        & leq(R26,minus(n4,n1))
                                        & leq(S26,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R26,S26) = init )
                                  & ! [T26,U26] :
                                      ( ( leq(n0,T26)
                                        & leq(n0,U26)
                                        & leq(T26,minus(n4,n1))
                                        & leq(U26,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T26,U26) = init )
                                  & ! [V26,W26] :
                                      ( ( leq(n0,V26)
                                        & leq(n0,W26)
                                        & leq(V26,minus(n6,n1))
                                        & leq(W26,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V26,W26) = init )
                                  & ! [X26,Y26] :
                                      ( ( leq(n0,X26)
                                        & leq(n0,Y26)
                                        & leq(X26,minus(n4,n1))
                                        & leq(Y26,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X26,Y26) = init )
                                  & ! [Z26,A27] :
                                      ( ( leq(n0,Z26)
                                        & leq(n0,A27)
                                        & leq(Z26,minus(n4,n1))
                                        & leq(A27,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z26,A27) = init )
                                  & ! [B27,C27] :
                                      ( ( leq(n0,B27)
                                        & leq(n0,C27)
                                        & leq(B27,minus(n4,n1))
                                        & leq(C27,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B27,C27) = init )
                                  & ! [D27,E27] :
                                      ( ( leq(n0,D27)
                                        & leq(n0,E27)
                                        & leq(D27,minus(n6,n1))
                                        & leq(E27,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D27,E27) = init )
                                  & ! [F27,G27] :
                                      ( ( leq(n0,F27)
                                        & leq(n0,G27)
                                        & leq(F27,minus(n4,n1))
                                        & leq(G27,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F27,G27) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H27,I27] :
                                      ( ( leq(n0,H27)
                                        & leq(n0,I27)
                                        & leq(H27,n3)
                                        & leq(I27,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H27,I27) = init )
                                  & ! [J27,K27] :
                                      ( ( leq(n0,J27)
                                        & leq(n0,K27)
                                        & leq(J27,n5)
                                        & leq(K27,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J27,K27) = init )
                                  & ! [L27,M27] :
                                      ( ( leq(n0,L27)
                                        & leq(n0,M27)
                                        & leq(L27,minus(n6,n1))
                                        & leq(M27,n0) )
                                     => a_select3(dv_thruster_filter_init,L27,M27) = init )
                                  & ! [N27,O27] :
                                      ( ( leq(n0,N27)
                                        & leq(n0,O27)
                                        & leq(N27,n5)
                                        & leq(O27,n5) )
                                     => a_select3(q_thruster_filter_init,N27,O27) = init )
                                  & ! [P27,Q27] :
                                      ( ( leq(n0,P27)
                                        & leq(n0,Q27)
                                        & leq(P27,n3)
                                        & leq(Q27,n3) )
                                     => a_select3(r_thruster_filter_init,P27,Q27) = init )
                                  & ! [R27,S27] :
                                      ( ( leq(n0,R27)
                                        & leq(n0,S27)
                                        & leq(R27,n5)
                                        & leq(S27,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R27,S27) = init )
                                  & ! [T27,U27] :
                                      ( ( leq(n0,T27)
                                        & leq(n0,U27)
                                        & leq(T27,n5)
                                        & leq(U27,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T27,U27) = init )
                                  & ! [V27] :
                                      ( ( leq(n0,V27)
                                        & leq(V27,minus(n6,n1)) )
                                     => ! [W27] :
                                          ( ( leq(n0,W27)
                                            & leq(W27,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V27,W27) = init ) )
                                  & ! [X27,Y27] :
                                      ( ( leq(n0,X27)
                                        & leq(n0,Y27)
                                        & leq(X27,minus(n6,n1))
                                        & leq(Y27,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X27,Y27) = init )
                                  & ! [Z27,A28] :
                                      ( ( leq(n0,Z27)
                                        & leq(n0,A28)
                                        & leq(Z27,minus(n6,n1))
                                        & leq(A28,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z27,A28) = init )
                                  & ! [B28,C28] :
                                      ( ( leq(n0,B28)
                                        & leq(n0,C28)
                                        & leq(B28,minus(n6,n1))
                                        & leq(C28,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B28,C28) = init )
                                  & ! [D28,E28] :
                                      ( ( leq(n0,D28)
                                        & leq(n0,E28)
                                        & leq(D28,minus(n6,n1))
                                        & leq(E28,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D28,E28) = init )
                                  & ! [F28,G28] :
                                      ( ( leq(n0,F28)
                                        & leq(n0,G28)
                                        & leq(F28,minus(n6,n1))
                                        & leq(G28,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F28,G28) = init )
                                  & ! [H28,I28] :
                                      ( ( leq(n0,H28)
                                        & leq(n0,I28)
                                        & leq(H28,minus(n6,n1))
                                        & leq(I28,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H28,I28) = init )
                                  & ! [J28,K28] :
                                      ( ( leq(n0,J28)
                                        & leq(n0,K28)
                                        & leq(J28,minus(n4,n1))
                                        & leq(K28,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J28,K28) = init )
                                  & ! [L28,M28] :
                                      ( ( leq(n0,L28)
                                        & leq(n0,M28)
                                        & leq(L28,minus(n6,n1))
                                        & leq(M28,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L28,M28) = init )
                                  & ! [N28,O28] :
                                      ( ( leq(n0,N28)
                                        & leq(n0,O28)
                                        & leq(N28,minus(n6,n1))
                                        & leq(O28,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N28,O28) = init )
                                  & ! [P28,Q28] :
                                      ( ( leq(n0,P28)
                                        & leq(n0,Q28)
                                        & leq(P28,minus(n6,n1))
                                        & leq(Q28,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P28,Q28) = init )
                                  & ! [R28,S28] :
                                      ( ( leq(n0,R28)
                                        & leq(n0,S28)
                                        & leq(R28,minus(n4,n1))
                                        & leq(S28,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R28,S28) = init )
                                  & ! [T28,U28] :
                                      ( ( leq(n0,T28)
                                        & leq(n0,U28)
                                        & leq(T28,minus(n4,n1))
                                        & leq(U28,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T28,U28) = init )
                                  & ! [V28,W28] :
                                      ( ( leq(n0,V28)
                                        & leq(n0,W28)
                                        & leq(V28,minus(n6,n1))
                                        & leq(W28,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V28,W28) = init )
                                  & ! [X28,Y28] :
                                      ( ( leq(n0,X28)
                                        & leq(n0,Y28)
                                        & leq(X28,minus(n4,n1))
                                        & leq(Y28,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X28,Y28) = init )
                                  & ! [Z28,A29] :
                                      ( ( leq(n0,Z28)
                                        & leq(n0,A29)
                                        & leq(Z28,minus(n4,n1))
                                        & leq(A29,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z28,A29) = init )
                                  & ! [B29,C29] :
                                      ( ( leq(n0,B29)
                                        & leq(n0,C29)
                                        & leq(B29,minus(n4,n1))
                                        & leq(C29,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B29,C29) = init )
                                  & ! [D29,E29] :
                                      ( ( leq(n0,D29)
                                        & leq(n0,E29)
                                        & leq(D29,minus(n6,n1))
                                        & leq(E29,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D29,E29) = init )
                                  & ! [F29,G29] :
                                      ( ( leq(n0,F29)
                                        & leq(n0,G29)
                                        & leq(F29,minus(n4,n1))
                                        & leq(G29,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F29,G29) = init ) ) ) ) )
                          & ( gt(pv5,n0)
                           => ( init = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H29,I29] :
                                      ( ( leq(n0,H29)
                                        & leq(n0,I29)
                                        & leq(H29,n3)
                                        & leq(I29,n5) )
                                     => a_select3(h_thruster_filter_init,H29,I29) = init )
                                  & ! [J29,K29] :
                                      ( ( leq(n0,J29)
                                        & leq(n0,K29)
                                        & leq(J29,n5)
                                        & leq(K29,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J29,K29) = init )
                                  & ! [L29,M29] :
                                      ( ( leq(n0,L29)
                                        & leq(n0,M29)
                                        & leq(L29,minus(n6,n1))
                                        & leq(M29,n0) )
                                     => a_select3(dv_thruster_filter_init,L29,M29) = init )
                                  & ! [N29,O29] :
                                      ( ( leq(n0,N29)
                                        & leq(n0,O29)
                                        & leq(N29,n5)
                                        & leq(O29,n5) )
                                     => a_select3(q_thruster_filter_init,N29,O29) = init )
                                  & ! [P29,Q29] :
                                      ( ( leq(n0,P29)
                                        & leq(n0,Q29)
                                        & leq(P29,n3)
                                        & leq(Q29,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P29,Q29) = init )
                                  & ! [R29,S29] :
                                      ( ( leq(n0,R29)
                                        & leq(n0,S29)
                                        & leq(R29,n5)
                                        & leq(S29,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R29,S29) = init )
                                  & ! [T29,U29] :
                                      ( ( leq(n0,T29)
                                        & leq(n0,U29)
                                        & leq(T29,n5)
                                        & leq(U29,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T29,U29) = init )
                                  & ! [V29] :
                                      ( ( leq(n0,V29)
                                        & leq(V29,minus(n6,n1)) )
                                     => ! [W29] :
                                          ( ( leq(n0,W29)
                                            & leq(W29,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V29,W29) = init ) )
                                  & ! [X29,Y29] :
                                      ( ( leq(n0,X29)
                                        & leq(n0,Y29)
                                        & leq(X29,minus(n6,n1))
                                        & leq(Y29,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X29,Y29) = init )
                                  & ! [Z29,A30] :
                                      ( ( leq(n0,Z29)
                                        & leq(n0,A30)
                                        & leq(Z29,minus(n6,n1))
                                        & leq(A30,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z29,A30) = init )
                                  & ! [B30,C30] :
                                      ( ( leq(n0,B30)
                                        & leq(n0,C30)
                                        & leq(B30,minus(n6,n1))
                                        & leq(C30,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B30,C30) = init )
                                  & ! [D30,E30] :
                                      ( ( leq(n0,D30)
                                        & leq(n0,E30)
                                        & leq(D30,minus(n6,n1))
                                        & leq(E30,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D30,E30) = init )
                                  & ! [F30,G30] :
                                      ( ( leq(n0,F30)
                                        & leq(n0,G30)
                                        & leq(F30,minus(n6,n1))
                                        & leq(G30,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F30,G30) = init )
                                  & ! [H30,I30] :
                                      ( ( leq(n0,H30)
                                        & leq(n0,I30)
                                        & leq(H30,minus(n6,n1))
                                        & leq(I30,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H30,I30) = init )
                                  & ! [J30,K30] :
                                      ( ( leq(n0,J30)
                                        & leq(n0,K30)
                                        & leq(J30,minus(n4,n1))
                                        & leq(K30,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J30,K30) = init )
                                  & ! [L30,M30] :
                                      ( ( leq(n0,L30)
                                        & leq(n0,M30)
                                        & leq(L30,minus(n6,n1))
                                        & leq(M30,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L30,M30) = init )
                                  & ! [N30,O30] :
                                      ( ( leq(n0,N30)
                                        & leq(n0,O30)
                                        & leq(N30,minus(n6,n1))
                                        & leq(O30,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N30,O30) = init )
                                  & ! [P30,Q30] :
                                      ( ( leq(n0,P30)
                                        & leq(n0,Q30)
                                        & leq(P30,minus(n6,n1))
                                        & leq(Q30,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P30,Q30) = init )
                                  & ! [R30,S30] :
                                      ( ( leq(n0,R30)
                                        & leq(n0,S30)
                                        & leq(R30,minus(n4,n1))
                                        & leq(S30,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R30,S30) = init )
                                  & ! [T30,U30] :
                                      ( ( leq(n0,T30)
                                        & leq(n0,U30)
                                        & leq(T30,minus(n4,n1))
                                        & leq(U30,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T30,U30) = init )
                                  & ! [V30,W30] :
                                      ( ( leq(n0,V30)
                                        & leq(n0,W30)
                                        & leq(V30,minus(n6,n1))
                                        & leq(W30,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V30,W30) = init )
                                  & ! [X30,Y30] :
                                      ( ( leq(n0,X30)
                                        & leq(n0,Y30)
                                        & leq(X30,minus(n4,n1))
                                        & leq(Y30,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X30,Y30) = init )
                                  & ! [Z30,A31] :
                                      ( ( leq(n0,Z30)
                                        & leq(n0,A31)
                                        & leq(Z30,minus(n4,n1))
                                        & leq(A31,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z30,A31) = init )
                                  & ! [B31,C31] :
                                      ( ( leq(n0,B31)
                                        & leq(n0,C31)
                                        & leq(B31,minus(n4,n1))
                                        & leq(C31,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B31,C31) = init )
                                  & ! [D31,E31] :
                                      ( ( leq(n0,D31)
                                        & leq(n0,E31)
                                        & leq(D31,minus(n6,n1))
                                        & leq(E31,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D31,E31) = init )
                                  & ! [F31,G31] :
                                      ( ( leq(n0,F31)
                                        & leq(n0,G31)
                                        & leq(F31,minus(n4,n1))
                                        & leq(G31,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F31,G31) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H31,I31] :
                                      ( ( leq(n0,H31)
                                        & leq(n0,I31)
                                        & leq(H31,n3)
                                        & leq(I31,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H31,I31) = init )
                                  & ! [J31,K31] :
                                      ( ( leq(n0,J31)
                                        & leq(n0,K31)
                                        & leq(J31,n5)
                                        & leq(K31,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J31,K31) = init )
                                  & ! [L31,M31] :
                                      ( ( leq(n0,L31)
                                        & leq(n0,M31)
                                        & leq(L31,minus(n6,n1))
                                        & leq(M31,n0) )
                                     => a_select3(dv_thruster_filter_init,L31,M31) = init )
                                  & ! [N31,O31] :
                                      ( ( leq(n0,N31)
                                        & leq(n0,O31)
                                        & leq(N31,n5)
                                        & leq(O31,n5) )
                                     => a_select3(q_thruster_filter_init,N31,O31) = init )
                                  & ! [P31,Q31] :
                                      ( ( leq(n0,P31)
                                        & leq(n0,Q31)
                                        & leq(P31,n3)
                                        & leq(Q31,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P31,Q31) = init )
                                  & ! [R31,S31] :
                                      ( ( leq(n0,R31)
                                        & leq(n0,S31)
                                        & leq(R31,n5)
                                        & leq(S31,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R31,S31) = init )
                                  & ! [T31,U31] :
                                      ( ( leq(n0,T31)
                                        & leq(n0,U31)
                                        & leq(T31,n5)
                                        & leq(U31,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T31,U31) = init )
                                  & ! [V31] :
                                      ( ( leq(n0,V31)
                                        & leq(V31,minus(n6,n1)) )
                                     => ! [W31] :
                                          ( ( leq(n0,W31)
                                            & leq(W31,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V31,W31) = init ) )
                                  & ! [X31,Y31] :
                                      ( ( leq(n0,X31)
                                        & leq(n0,Y31)
                                        & leq(X31,minus(n6,n1))
                                        & leq(Y31,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X31,Y31) = init )
                                  & ! [Z31,A32] :
                                      ( ( leq(n0,Z31)
                                        & leq(n0,A32)
                                        & leq(Z31,minus(n6,n1))
                                        & leq(A32,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z31,A32) = init )
                                  & ! [B32,C32] :
                                      ( ( leq(n0,B32)
                                        & leq(n0,C32)
                                        & leq(B32,minus(n6,n1))
                                        & leq(C32,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B32,C32) = init )
                                  & ! [D32,E32] :
                                      ( ( leq(n0,D32)
                                        & leq(n0,E32)
                                        & leq(D32,minus(n6,n1))
                                        & leq(E32,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D32,E32) = init )
                                  & ! [F32,G32] :
                                      ( ( leq(n0,F32)
                                        & leq(n0,G32)
                                        & leq(F32,minus(n6,n1))
                                        & leq(G32,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F32,G32) = init )
                                  & ! [H32,I32] :
                                      ( ( leq(n0,H32)
                                        & leq(n0,I32)
                                        & leq(H32,minus(n6,n1))
                                        & leq(I32,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H32,I32) = init )
                                  & ! [J32,K32] :
                                      ( ( leq(n0,J32)
                                        & leq(n0,K32)
                                        & leq(J32,minus(n4,n1))
                                        & leq(K32,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J32,K32) = init )
                                  & ! [L32,M32] :
                                      ( ( leq(n0,L32)
                                        & leq(n0,M32)
                                        & leq(L32,minus(n6,n1))
                                        & leq(M32,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L32,M32) = init )
                                  & ! [N32,O32] :
                                      ( ( leq(n0,N32)
                                        & leq(n0,O32)
                                        & leq(N32,minus(n6,n1))
                                        & leq(O32,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N32,O32) = init )
                                  & ! [P32,Q32] :
                                      ( ( leq(n0,P32)
                                        & leq(n0,Q32)
                                        & leq(P32,minus(n6,n1))
                                        & leq(Q32,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P32,Q32) = init )
                                  & ! [R32,S32] :
                                      ( ( leq(n0,R32)
                                        & leq(n0,S32)
                                        & leq(R32,minus(n4,n1))
                                        & leq(S32,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R32,S32) = init )
                                  & ! [T32,U32] :
                                      ( ( leq(n0,T32)
                                        & leq(n0,U32)
                                        & leq(T32,minus(n4,n1))
                                        & leq(U32,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T32,U32) = init )
                                  & ! [V32,W32] :
                                      ( ( leq(n0,V32)
                                        & leq(n0,W32)
                                        & leq(V32,minus(n6,n1))
                                        & leq(W32,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V32,W32) = init )
                                  & ! [X32,Y32] :
                                      ( ( leq(n0,X32)
                                        & leq(n0,Y32)
                                        & leq(X32,minus(n4,n1))
                                        & leq(Y32,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X32,Y32) = init )
                                  & ! [Z32,A33] :
                                      ( ( leq(n0,Z32)
                                        & leq(n0,A33)
                                        & leq(Z32,minus(n4,n1))
                                        & leq(A33,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z32,A33) = init )
                                  & ! [B33,C33] :
                                      ( ( leq(n0,B33)
                                        & leq(n0,C33)
                                        & leq(B33,minus(n4,n1))
                                        & leq(C33,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B33,C33) = init )
                                  & ! [D33,E33] :
                                      ( ( leq(n0,D33)
                                        & leq(n0,E33)
                                        & leq(D33,minus(n6,n1))
                                        & leq(E33,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D33,E33) = init )
                                  & ! [F33,G33] :
                                      ( ( leq(n0,F33)
                                        & leq(n0,G33)
                                        & leq(F33,minus(n4,n1))
                                        & leq(G33,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F33,G33) = init ) ) ) ) ) ) )
                      & ( gt(pv5,n0)
                       => ( init = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                          & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                          & ( ~ gt(pv5,n0)
                           => ( init = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H33,I33] :
                                      ( ( leq(n0,H33)
                                        & leq(n0,I33)
                                        & leq(H33,n3)
                                        & leq(I33,n5) )
                                     => a_select3(h_thruster_filter_init,H33,I33) = init )
                                  & ! [J33,K33] :
                                      ( ( leq(n0,J33)
                                        & leq(n0,K33)
                                        & leq(J33,n5)
                                        & leq(K33,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J33,K33) = init )
                                  & ! [L33,M33] :
                                      ( ( leq(n0,L33)
                                        & leq(n0,M33)
                                        & leq(L33,minus(n6,n1))
                                        & leq(M33,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L33,M33) = init )
                                  & ! [N33,O33] :
                                      ( ( leq(n0,N33)
                                        & leq(n0,O33)
                                        & leq(N33,n5)
                                        & leq(O33,n5) )
                                     => a_select3(q_thruster_filter_init,N33,O33) = init )
                                  & ! [P33,Q33] :
                                      ( ( leq(n0,P33)
                                        & leq(n0,Q33)
                                        & leq(P33,n3)
                                        & leq(Q33,n3) )
                                     => a_select3(r_thruster_filter_init,P33,Q33) = init )
                                  & ! [R33,S33] :
                                      ( ( leq(n0,R33)
                                        & leq(n0,S33)
                                        & leq(R33,n5)
                                        & leq(S33,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R33,S33) = init )
                                  & ! [T33,U33] :
                                      ( ( leq(n0,T33)
                                        & leq(n0,U33)
                                        & leq(T33,n5)
                                        & leq(U33,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T33,U33) = init )
                                  & ! [V33] :
                                      ( ( leq(n0,V33)
                                        & leq(V33,minus(n6,n1)) )
                                     => ! [W33] :
                                          ( ( leq(n0,W33)
                                            & leq(W33,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V33,W33) = init ) )
                                  & ! [X33,Y33] :
                                      ( ( leq(n0,X33)
                                        & leq(n0,Y33)
                                        & leq(X33,minus(n6,n1))
                                        & leq(Y33,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X33,Y33) = init )
                                  & ! [Z33,A34] :
                                      ( ( leq(n0,Z33)
                                        & leq(n0,A34)
                                        & leq(Z33,minus(n6,n1))
                                        & leq(A34,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z33,A34) = init )
                                  & ! [B34,C34] :
                                      ( ( leq(n0,B34)
                                        & leq(n0,C34)
                                        & leq(B34,minus(n6,n1))
                                        & leq(C34,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B34,C34) = init )
                                  & ! [D34,E34] :
                                      ( ( leq(n0,D34)
                                        & leq(n0,E34)
                                        & leq(D34,minus(n6,n1))
                                        & leq(E34,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D34,E34) = init )
                                  & ! [F34,G34] :
                                      ( ( leq(n0,F34)
                                        & leq(n0,G34)
                                        & leq(F34,minus(n6,n1))
                                        & leq(G34,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F34,G34) = init )
                                  & ! [H34,I34] :
                                      ( ( leq(n0,H34)
                                        & leq(n0,I34)
                                        & leq(H34,minus(n6,n1))
                                        & leq(I34,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H34,I34) = init )
                                  & ! [J34,K34] :
                                      ( ( leq(n0,J34)
                                        & leq(n0,K34)
                                        & leq(J34,minus(n4,n1))
                                        & leq(K34,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J34,K34) = init )
                                  & ! [L34,M34] :
                                      ( ( leq(n0,L34)
                                        & leq(n0,M34)
                                        & leq(L34,minus(n6,n1))
                                        & leq(M34,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L34,M34) = init )
                                  & ! [N34,O34] :
                                      ( ( leq(n0,N34)
                                        & leq(n0,O34)
                                        & leq(N34,minus(n6,n1))
                                        & leq(O34,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N34,O34) = init )
                                  & ! [P34,Q34] :
                                      ( ( leq(n0,P34)
                                        & leq(n0,Q34)
                                        & leq(P34,minus(n6,n1))
                                        & leq(Q34,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P34,Q34) = init )
                                  & ! [R34,S34] :
                                      ( ( leq(n0,R34)
                                        & leq(n0,S34)
                                        & leq(R34,minus(n4,n1))
                                        & leq(S34,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R34,S34) = init )
                                  & ! [T34,U34] :
                                      ( ( leq(n0,T34)
                                        & leq(n0,U34)
                                        & leq(T34,minus(n4,n1))
                                        & leq(U34,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T34,U34) = init )
                                  & ! [V34,W34] :
                                      ( ( leq(n0,V34)
                                        & leq(n0,W34)
                                        & leq(V34,minus(n6,n1))
                                        & leq(W34,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V34,W34) = init )
                                  & ! [X34,Y34] :
                                      ( ( leq(n0,X34)
                                        & leq(n0,Y34)
                                        & leq(X34,minus(n4,n1))
                                        & leq(Y34,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X34,Y34) = init )
                                  & ! [Z34,A35] :
                                      ( ( leq(n0,Z34)
                                        & leq(n0,A35)
                                        & leq(Z34,minus(n4,n1))
                                        & leq(A35,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z34,A35) = init )
                                  & ! [B35,C35] :
                                      ( ( leq(n0,B35)
                                        & leq(n0,C35)
                                        & leq(B35,minus(n4,n1))
                                        & leq(C35,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B35,C35) = init )
                                  & ! [D35,E35] :
                                      ( ( leq(n0,D35)
                                        & leq(n0,E35)
                                        & leq(D35,minus(n6,n1))
                                        & leq(E35,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D35,E35) = init )
                                  & ! [F35,G35] :
                                      ( ( leq(n0,F35)
                                        & leq(n0,G35)
                                        & leq(F35,minus(n4,n1))
                                        & leq(G35,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F35,G35) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H35,I35] :
                                      ( ( leq(n0,H35)
                                        & leq(n0,I35)
                                        & leq(H35,n3)
                                        & leq(I35,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H35,I35) = init )
                                  & ! [J35,K35] :
                                      ( ( leq(n0,J35)
                                        & leq(n0,K35)
                                        & leq(J35,n5)
                                        & leq(K35,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J35,K35) = init )
                                  & ! [L35,M35] :
                                      ( ( leq(n0,L35)
                                        & leq(n0,M35)
                                        & leq(L35,minus(n6,n1))
                                        & leq(M35,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L35,M35) = init )
                                  & ! [N35,O35] :
                                      ( ( leq(n0,N35)
                                        & leq(n0,O35)
                                        & leq(N35,n5)
                                        & leq(O35,n5) )
                                     => a_select3(q_thruster_filter_init,N35,O35) = init )
                                  & ! [P35,Q35] :
                                      ( ( leq(n0,P35)
                                        & leq(n0,Q35)
                                        & leq(P35,n3)
                                        & leq(Q35,n3) )
                                     => a_select3(r_thruster_filter_init,P35,Q35) = init )
                                  & ! [R35,S35] :
                                      ( ( leq(n0,R35)
                                        & leq(n0,S35)
                                        & leq(R35,n5)
                                        & leq(S35,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R35,S35) = init )
                                  & ! [T35,U35] :
                                      ( ( leq(n0,T35)
                                        & leq(n0,U35)
                                        & leq(T35,n5)
                                        & leq(U35,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T35,U35) = init )
                                  & ! [V35] :
                                      ( ( leq(n0,V35)
                                        & leq(V35,minus(n6,n1)) )
                                     => ! [W35] :
                                          ( ( leq(n0,W35)
                                            & leq(W35,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V35,W35) = init ) )
                                  & ! [X35,Y35] :
                                      ( ( leq(n0,X35)
                                        & leq(n0,Y35)
                                        & leq(X35,minus(n6,n1))
                                        & leq(Y35,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X35,Y35) = init )
                                  & ! [Z35,A36] :
                                      ( ( leq(n0,Z35)
                                        & leq(n0,A36)
                                        & leq(Z35,minus(n6,n1))
                                        & leq(A36,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z35,A36) = init )
                                  & ! [B36,C36] :
                                      ( ( leq(n0,B36)
                                        & leq(n0,C36)
                                        & leq(B36,minus(n6,n1))
                                        & leq(C36,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B36,C36) = init )
                                  & ! [D36,E36] :
                                      ( ( leq(n0,D36)
                                        & leq(n0,E36)
                                        & leq(D36,minus(n6,n1))
                                        & leq(E36,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D36,E36) = init )
                                  & ! [F36,G36] :
                                      ( ( leq(n0,F36)
                                        & leq(n0,G36)
                                        & leq(F36,minus(n6,n1))
                                        & leq(G36,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F36,G36) = init )
                                  & ! [H36,I36] :
                                      ( ( leq(n0,H36)
                                        & leq(n0,I36)
                                        & leq(H36,minus(n6,n1))
                                        & leq(I36,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H36,I36) = init )
                                  & ! [J36,K36] :
                                      ( ( leq(n0,J36)
                                        & leq(n0,K36)
                                        & leq(J36,minus(n4,n1))
                                        & leq(K36,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J36,K36) = init )
                                  & ! [L36,M36] :
                                      ( ( leq(n0,L36)
                                        & leq(n0,M36)
                                        & leq(L36,minus(n6,n1))
                                        & leq(M36,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L36,M36) = init )
                                  & ! [N36,O36] :
                                      ( ( leq(n0,N36)
                                        & leq(n0,O36)
                                        & leq(N36,minus(n6,n1))
                                        & leq(O36,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N36,O36) = init )
                                  & ! [P36,Q36] :
                                      ( ( leq(n0,P36)
                                        & leq(n0,Q36)
                                        & leq(P36,minus(n6,n1))
                                        & leq(Q36,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P36,Q36) = init )
                                  & ! [R36,S36] :
                                      ( ( leq(n0,R36)
                                        & leq(n0,S36)
                                        & leq(R36,minus(n4,n1))
                                        & leq(S36,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R36,S36) = init )
                                  & ! [T36,U36] :
                                      ( ( leq(n0,T36)
                                        & leq(n0,U36)
                                        & leq(T36,minus(n4,n1))
                                        & leq(U36,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T36,U36) = init )
                                  & ! [V36,W36] :
                                      ( ( leq(n0,V36)
                                        & leq(n0,W36)
                                        & leq(V36,minus(n6,n1))
                                        & leq(W36,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V36,W36) = init )
                                  & ! [X36,Y36] :
                                      ( ( leq(n0,X36)
                                        & leq(n0,Y36)
                                        & leq(X36,minus(n4,n1))
                                        & leq(Y36,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X36,Y36) = init )
                                  & ! [Z36,A37] :
                                      ( ( leq(n0,Z36)
                                        & leq(n0,A37)
                                        & leq(Z36,minus(n4,n1))
                                        & leq(A37,minus(n4,n1)) )
                                     => a_select3(r_thruster_filter_init,Z36,A37) = init )
                                  & ! [B37,C37] :
                                      ( ( leq(n0,B37)
                                        & leq(n0,C37)
                                        & leq(B37,minus(n4,n1))
                                        & leq(C37,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B37,C37) = init )
                                  & ! [D37,E37] :
                                      ( ( leq(n0,D37)
                                        & leq(n0,E37)
                                        & leq(D37,minus(n6,n1))
                                        & leq(E37,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D37,E37) = init )
                                  & ! [F37,G37] :
                                      ( ( leq(n0,F37)
                                        & leq(n0,G37)
                                        & leq(F37,minus(n4,n1))
                                        & leq(G37,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F37,G37) = init ) ) ) ) )
                          & ( gt(pv5,n0)
                           => ( init = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                              & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                              & ( ~ gt(pv5,n0)
                               => ( init = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H37,I37] :
                                      ( ( leq(n0,H37)
                                        & leq(n0,I37)
                                        & leq(H37,n3)
                                        & leq(I37,n5) )
                                     => a_select3(h_thruster_filter_init,H37,I37) = init )
                                  & ! [J37,K37] :
                                      ( ( leq(n0,J37)
                                        & leq(n0,K37)
                                        & leq(J37,n5)
                                        & leq(K37,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J37,K37) = init )
                                  & ! [L37,M37] :
                                      ( ( leq(n0,L37)
                                        & leq(n0,M37)
                                        & leq(L37,minus(n6,n1))
                                        & leq(M37,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L37,M37) = init )
                                  & ! [N37,O37] :
                                      ( ( leq(n0,N37)
                                        & leq(n0,O37)
                                        & leq(N37,n5)
                                        & leq(O37,n5) )
                                     => a_select3(q_thruster_filter_init,N37,O37) = init )
                                  & ! [P37,Q37] :
                                      ( ( leq(n0,P37)
                                        & leq(n0,Q37)
                                        & leq(P37,n3)
                                        & leq(Q37,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P37,Q37) = init )
                                  & ! [R37,S37] :
                                      ( ( leq(n0,R37)
                                        & leq(n0,S37)
                                        & leq(R37,n5)
                                        & leq(S37,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R37,S37) = init )
                                  & ! [T37,U37] :
                                      ( ( leq(n0,T37)
                                        & leq(n0,U37)
                                        & leq(T37,n5)
                                        & leq(U37,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T37,U37) = init )
                                  & ! [V37] :
                                      ( ( leq(n0,V37)
                                        & leq(V37,minus(n6,n1)) )
                                     => ! [W37] :
                                          ( ( leq(n0,W37)
                                            & leq(W37,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V37,W37) = init ) )
                                  & ! [X37,Y37] :
                                      ( ( leq(n0,X37)
                                        & leq(n0,Y37)
                                        & leq(X37,minus(n6,n1))
                                        & leq(Y37,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X37,Y37) = init )
                                  & ! [Z37,A38] :
                                      ( ( leq(n0,Z37)
                                        & leq(n0,A38)
                                        & leq(Z37,minus(n6,n1))
                                        & leq(A38,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z37,A38) = init )
                                  & ! [B38,C38] :
                                      ( ( leq(n0,B38)
                                        & leq(n0,C38)
                                        & leq(B38,minus(n6,n1))
                                        & leq(C38,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B38,C38) = init )
                                  & ! [D38,E38] :
                                      ( ( leq(n0,D38)
                                        & leq(n0,E38)
                                        & leq(D38,minus(n6,n1))
                                        & leq(E38,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D38,E38) = init )
                                  & ! [F38,G38] :
                                      ( ( leq(n0,F38)
                                        & leq(n0,G38)
                                        & leq(F38,minus(n6,n1))
                                        & leq(G38,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F38,G38) = init )
                                  & ! [H38,I38] :
                                      ( ( leq(n0,H38)
                                        & leq(n0,I38)
                                        & leq(H38,minus(n6,n1))
                                        & leq(I38,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H38,I38) = init )
                                  & ! [J38,K38] :
                                      ( ( leq(n0,J38)
                                        & leq(n0,K38)
                                        & leq(J38,minus(n4,n1))
                                        & leq(K38,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,J38,K38) = init )
                                  & ! [L38,M38] :
                                      ( ( leq(n0,L38)
                                        & leq(n0,M38)
                                        & leq(L38,minus(n6,n1))
                                        & leq(M38,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L38,M38) = init )
                                  & ! [N38,O38] :
                                      ( ( leq(n0,N38)
                                        & leq(n0,O38)
                                        & leq(N38,minus(n6,n1))
                                        & leq(O38,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N38,O38) = init )
                                  & ! [P38,Q38] :
                                      ( ( leq(n0,P38)
                                        & leq(n0,Q38)
                                        & leq(P38,minus(n6,n1))
                                        & leq(Q38,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P38,Q38) = init )
                                  & ! [R38,S38] :
                                      ( ( leq(n0,R38)
                                        & leq(n0,S38)
                                        & leq(R38,minus(n4,n1))
                                        & leq(S38,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R38,S38) = init )
                                  & ! [T38,U38] :
                                      ( ( leq(n0,T38)
                                        & leq(n0,U38)
                                        & leq(T38,minus(n4,n1))
                                        & leq(U38,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T38,U38) = init )
                                  & ! [V38,W38] :
                                      ( ( leq(n0,V38)
                                        & leq(n0,W38)
                                        & leq(V38,minus(n6,n1))
                                        & leq(W38,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V38,W38) = init )
                                  & ! [X38,Y38] :
                                      ( ( leq(n0,X38)
                                        & leq(n0,Y38)
                                        & leq(X38,minus(n4,n1))
                                        & leq(Y38,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,X38,Y38) = init )
                                  & ! [Z38,A39] :
                                      ( ( leq(n0,Z38)
                                        & leq(n0,A39)
                                        & leq(Z38,minus(n4,n1))
                                        & leq(A39,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z38,A39) = init )
                                  & ! [B39,C39] :
                                      ( ( leq(n0,B39)
                                        & leq(n0,C39)
                                        & leq(B39,minus(n4,n1))
                                        & leq(C39,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,B39,C39) = init )
                                  & ! [D39,E39] :
                                      ( ( leq(n0,D39)
                                        & leq(n0,E39)
                                        & leq(D39,minus(n6,n1))
                                        & leq(E39,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D39,E39) = init )
                                  & ! [F39,G39] :
                                      ( ( leq(n0,F39)
                                        & leq(n0,G39)
                                        & leq(F39,minus(n4,n1))
                                        & leq(G39,minus(n6,n1)) )
                                     => a_select3(h_thruster_filter_init,F39,G39) = init ) ) )
                              & ( gt(pv5,n0)
                               => ( init = init
                                  & a_select3(xhatmin_thruster_filter_init,n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,pv5) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n0,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n1,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n2,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n3,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n4,n0) = init
                                  & a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,n0),init),n5,n0) = init
                                  & leq(n0,pv5)
                                  & leq(pv5,n588)
                                  & ! [H39,I39] :
                                      ( ( leq(n0,H39)
                                        & leq(n0,I39)
                                        & leq(H39,n3)
                                        & leq(I39,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),H39,I39) = init )
                                  & ! [J39,K39] :
                                      ( ( leq(n0,J39)
                                        & leq(n0,K39)
                                        & leq(J39,n5)
                                        & leq(K39,n5) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),J39,K39) = init )
                                  & ! [L39,M39] :
                                      ( ( leq(n0,L39)
                                        & leq(n0,M39)
                                        & leq(L39,minus(n6,n1))
                                        & leq(M39,n0) )
                                     => a_select3(tptp_update3(tptp_update3(dv_thruster_filter_init,n3,n0,init),n0,n0,init),L39,M39) = init )
                                  & ! [N39,O39] :
                                      ( ( leq(n0,N39)
                                        & leq(n0,O39)
                                        & leq(N39,n5)
                                        & leq(O39,n5) )
                                     => a_select3(q_thruster_filter_init,N39,O39) = init )
                                  & ! [P39,Q39] :
                                      ( ( leq(n0,P39)
                                        & leq(n0,Q39)
                                        & leq(P39,n3)
                                        & leq(Q39,n3) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),P39,Q39) = init )
                                  & ! [R39,S39] :
                                      ( ( leq(n0,R39)
                                        & leq(n0,S39)
                                        & leq(R39,n5)
                                        & leq(S39,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),R39,S39) = init )
                                  & ! [T39,U39] :
                                      ( ( leq(n0,T39)
                                        & leq(n0,U39)
                                        & leq(T39,n5)
                                        & leq(U39,n5) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T39,U39) = init )
                                  & ! [V39] :
                                      ( ( leq(n0,V39)
                                        & leq(V39,minus(n6,n1)) )
                                     => ! [W39] :
                                          ( ( leq(n0,W39)
                                            & leq(W39,minus(n6,n1)) )
                                         => a_select3(id_thruster_filter_init,V39,W39) = init ) )
                                  & ! [X39,Y39] :
                                      ( ( leq(n0,X39)
                                        & leq(n0,Y39)
                                        & leq(X39,minus(n6,n1))
                                        & leq(Y39,minus(n6,n1)) )
                                     => a_select3(q_thruster_filter_init,X39,Y39) = init )
                                  & ! [Z39,A40] :
                                      ( ( leq(n0,Z39)
                                        & leq(n0,A40)
                                        & leq(Z39,minus(n6,n1))
                                        & leq(A40,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),Z39,A40) = init )
                                  & ! [B40,C40] :
                                      ( ( leq(n0,B40)
                                        & leq(n0,C40)
                                        & leq(B40,minus(n6,n1))
                                        & leq(C40,minus(n6,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),B40,C40) = init )
                                  & ! [D40,E40] :
                                      ( ( leq(n0,D40)
                                        & leq(n0,E40)
                                        & leq(D40,minus(n6,n1))
                                        & leq(E40,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n5,n0,init),n4,n0,init),n2,n0,init),n1,n0,init),D40,E40) = init )
                                  & ! [F40,G40] :
                                      ( ( leq(n0,F40)
                                        & leq(n0,G40)
                                        & leq(F40,minus(n6,n1))
                                        & leq(G40,minus(n6,n1)) )
                                     => a_select3(id_thruster_filter_init,F40,G40) = init )
                                  & ! [H40,I40] :
                                      ( ( leq(n0,H40)
                                        & leq(n0,I40)
                                        & leq(H40,minus(n6,n1))
                                        & leq(I40,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),H40,I40) = init )
                                  & ! [J40,K40] :
                                      ( ( leq(n0,J40)
                                        & leq(n0,K40)
                                        & leq(J40,minus(n4,n1))
                                        & leq(K40,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),J40,K40) = init )
                                  & ! [L40,M40] :
                                      ( ( leq(n0,L40)
                                        & leq(n0,M40)
                                        & leq(L40,minus(n6,n1))
                                        & leq(M40,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,L40,M40) = init )
                                  & ! [N40,O40] :
                                      ( ( leq(n0,N40)
                                        & leq(n0,O40)
                                        & leq(N40,minus(n6,n1))
                                        & leq(O40,n0) )
                                     => a_select3(xhatmin_thruster_filter_init,N40,O40) = init )
                                  & ! [P40,Q40] :
                                      ( ( leq(n0,P40)
                                        & leq(n0,Q40)
                                        & leq(P40,minus(n6,n1))
                                        & leq(Q40,minus(n4,n1)) )
                                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n4,n1)),init),P40,Q40) = init )
                                  & ! [R40,S40] :
                                      ( ( leq(n0,R40)
                                        & leq(n0,S40)
                                        & leq(R40,minus(n4,n1))
                                        & leq(S40,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zhat_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),R40,S40) = init )
                                  & ! [T40,U40] :
                                      ( ( leq(n0,T40)
                                        & leq(n0,U40)
                                        & leq(T40,minus(n4,n1))
                                        & leq(U40,n0) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(zpred_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),T40,U40) = init )
                                  & ! [V40,W40] :
                                      ( ( leq(n0,V40)
                                        & leq(n0,W40)
                                        & leq(V40,minus(n6,n1))
                                        & leq(W40,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,V40,W40) = init )
                                  & ! [X40,Y40] :
                                      ( ( leq(n0,X40)
                                        & leq(n0,Y40)
                                        & leq(X40,minus(n4,n1))
                                        & leq(Y40,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),X40,Y40) = init )
                                  & ! [Z40,A41] :
                                      ( ( leq(n0,Z40)
                                        & leq(n0,A41)
                                        & leq(Z40,minus(n4,n1))
                                        & leq(A41,minus(n4,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n3,n3,init),n2,n2,init),n1,n1,init),n0,n0,init),Z40,A41) = init )
                                  & ! [B41,C41] :
                                      ( ( leq(n0,B41)
                                        & leq(n0,C41)
                                        & leq(B41,minus(n4,n1))
                                        & leq(C41,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),B41,C41) = init )
                                  & ! [D41,E41] :
                                      ( ( leq(n0,D41)
                                        & leq(n0,E41)
                                        & leq(D41,minus(n6,n1))
                                        & leq(E41,minus(n6,n1)) )
                                     => a_select3(pminus_thruster_filter_init,D41,E41) = init )
                                  & ! [F41,G41] :
                                      ( ( leq(n0,F41)
                                        & leq(n0,G41)
                                        & leq(F41,minus(n4,n1))
                                        & leq(G41,minus(n6,n1)) )
                                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(h_thruster_filter_init,n3,n0,init),n2,n0,init),n1,n0,init),n0,n0,init),F41,G41) = init ) ) ) ) ) ) ) ) ) ) )
              & ( ( init = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [H41,I41] :
                      ( ( leq(n0,H41)
                        & leq(n0,I41)
                        & leq(H41,n3)
                        & leq(I41,n5) )
                     => a_select3(h_thruster_filter_init,H41,I41) = init )
                  & ! [J41,K41] :
                      ( ( leq(n0,J41)
                        & leq(n0,K41)
                        & leq(J41,n5)
                        & leq(K41,n5) )
                     => a_select3(phi_thruster_filter_init,J41,K41) = init )
                  & ! [L41,M41] :
                      ( ( leq(n0,L41)
                        & leq(n0,M41)
                        & leq(L41,minus(n6,n1))
                        & leq(M41,n0) )
                     => a_select3(dv_thruster_filter_init,L41,M41) = init )
                  & ! [N41,O41] :
                      ( ( leq(n0,N41)
                        & leq(n0,O41)
                        & leq(N41,n5)
                        & leq(O41,n5) )
                     => a_select3(q_thruster_filter_init,N41,O41) = init )
                  & ! [P41,Q41] :
                      ( ( leq(n0,P41)
                        & leq(n0,Q41)
                        & leq(P41,n3)
                        & leq(Q41,n3) )
                     => a_select3(r_thruster_filter_init,P41,Q41) = init )
                  & ! [R41,S41] :
                      ( ( leq(n0,R41)
                        & leq(n0,S41)
                        & leq(R41,n5)
                        & leq(S41,n0) )
                     => a_select3(xhatmin_thruster_filter_init,R41,S41) = init )
                  & ! [T41,U41] :
                      ( ( leq(n0,T41)
                        & leq(n0,U41)
                        & leq(T41,n5)
                        & leq(U41,n5) )
                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),T41,U41) = init )
                  & ! [V41] :
                      ( ( leq(n0,V41)
                        & leq(V41,minus(n6,n1)) )
                     => ! [W41] :
                          ( ( leq(n0,W41)
                            & leq(W41,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,V41,W41) = init ) ) )
               => ( ! [X41,Y41] :
                      ( ( leq(n0,X41)
                        & leq(n0,Y41)
                        & leq(X41,n3)
                        & leq(Y41,n5) )
                     => a_select3(h_thruster_filter_init,X41,Y41) = init )
                  & ! [Z41,A42] :
                      ( ( leq(n0,Z41)
                        & leq(n0,A42)
                        & leq(Z41,n5)
                        & leq(A42,n5) )
                     => a_select3(phi_thruster_filter_init,Z41,A42) = init )
                  & ! [B42,C42] :
                      ( ( leq(n0,B42)
                        & leq(n0,C42)
                        & leq(B42,minus(n6,n1))
                        & leq(C42,n0) )
                     => a_select3(dv_thruster_filter_init,B42,C42) = init )
                  & ! [D42,E42] :
                      ( ( leq(n0,D42)
                        & leq(n0,E42)
                        & leq(D42,n5)
                        & leq(E42,n5) )
                     => a_select3(q_thruster_filter_init,D42,E42) = init )
                  & ! [F42,G42] :
                      ( ( leq(n0,F42)
                        & leq(n0,G42)
                        & leq(F42,n3)
                        & leq(G42,n3) )
                     => a_select3(r_thruster_filter_init,F42,G42) = init )
                  & ! [H42,I42] :
                      ( ( leq(n0,H42)
                        & leq(n0,I42)
                        & leq(H42,n5)
                        & leq(I42,n0) )
                     => a_select3(xhatmin_thruster_filter_init,H42,I42) = init )
                  & ! [J42,K42] :
                      ( ( leq(n0,J42)
                        & leq(n0,K42)
                        & leq(J42,n5)
                        & leq(K42,n5) )
                     => a_select3(tptp_const_array2(dim(n0,minus(n6,n1)),dim(n0,minus(n6,n1)),init),J42,K42) = init ) ) )
              & ( ( leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [L42,M42] :
                      ( ( leq(n0,L42)
                        & leq(n0,M42)
                        & leq(L42,n3)
                        & leq(M42,n5) )
                     => a_select3(h_thruster_filter_init,L42,M42) = init )
                  & ! [N42,O42] :
                      ( ( leq(n0,N42)
                        & leq(n0,O42)
                        & leq(N42,n5)
                        & leq(O42,n5) )
                     => a_select3(phi_thruster_filter_init,N42,O42) = init )
                  & ! [P42,Q42] :
                      ( ( leq(n0,P42)
                        & leq(n0,Q42)
                        & leq(P42,minus(n6,n1))
                        & leq(Q42,n0) )
                     => a_select3(dv_thruster_filter_init,P42,Q42) = init )
                  & ! [R42,S42] :
                      ( ( leq(n0,R42)
                        & leq(n0,S42)
                        & leq(R42,n5)
                        & leq(S42,n5) )
                     => a_select3(q_thruster_filter_init,R42,S42) = init )
                  & ! [T42,U42] :
                      ( ( leq(n0,T42)
                        & leq(n0,U42)
                        & leq(T42,n3)
                        & leq(U42,n3) )
                     => a_select3(r_thruster_filter_init,T42,U42) = init )
                  & ! [V42,W42] :
                      ( ( leq(n0,V42)
                        & leq(n0,W42)
                        & leq(V42,n5)
                        & leq(W42,n0) )
                     => a_select3(xhatmin_thruster_filter_init,V42,W42) = init )
                  & ! [X42,Y42] :
                      ( ( leq(n0,X42)
                        & leq(n0,Y42)
                        & leq(X42,n5)
                        & leq(Y42,n5) )
                     => a_select3(pminus_thruster_filter_init,X42,Y42) = init ) )
               => ( init = init
                  & leq(n0,pv5)
                  & leq(pv5,n588)
                  & ! [Z42,A43] :
                      ( ( leq(n0,Z42)
                        & leq(n0,A43)
                        & leq(Z42,n3)
                        & leq(A43,n5) )
                     => a_select3(h_thruster_filter_init,Z42,A43) = init )
                  & ! [B43,C43] :
                      ( ( leq(n0,B43)
                        & leq(n0,C43)
                        & leq(B43,n5)
                        & leq(C43,n5) )
                     => a_select3(phi_thruster_filter_init,B43,C43) = init )
                  & ! [D43,E43] :
                      ( ( leq(n0,D43)
                        & leq(n0,E43)
                        & leq(D43,minus(n6,n1))
                        & leq(E43,n0) )
                     => a_select3(dv_thruster_filter_init,D43,E43) = init )
                  & ! [F43,G43] :
                      ( ( leq(n0,F43)
                        & leq(n0,G43)
                        & leq(F43,n5)
                        & leq(G43,n5) )
                     => a_select3(q_thruster_filter_init,F43,G43) = init )
                  & ! [H43,I43] :
                      ( ( leq(n0,H43)
                        & leq(n0,I43)
                        & leq(H43,n3)
                        & leq(I43,n3) )
                     => a_select3(r_thruster_filter_init,H43,I43) = init )
                  & ! [J43,K43] :
                      ( ( leq(n0,J43)
                        & leq(n0,K43)
                        & leq(J43,n5)
                        & leq(K43,n0) )
                     => a_select3(xhatmin_thruster_filter_init,J43,K43) = init )
                  & ! [L43,M43] :
                      ( ( leq(n0,L43)
                        & leq(n0,M43)
                        & leq(L43,n5)
                        & leq(M43,n5) )
                     => a_select3(pminus_thruster_filter_init,L43,M43) = init )
                  & ! [N43] :
                      ( ( leq(n0,N43)
                        & leq(N43,minus(n0,n1)) )
                     => ! [O43] :
                          ( ( leq(n0,O43)
                            & leq(O43,minus(n6,n1)) )
                         => a_select3(id_thruster_filter_init,N43,O43) = init ) ) ) )
              & ( ( leq(n0,pv23)
                  & leq(pv23,minus(n6,n1)) )
               => ( leq(n0,a_select2(sigma,pv23))
                 => true ) )
              & ( ( ! [P43,Q43] :
                      ( ( leq(n0,P43)
                        & leq(n0,Q43)
                        & leq(P43,n3)
                        & leq(Q43,n5) )
                     => a_select3(h_thruster_filter_init,P43,Q43) = init )
                  & ! [R43,S43] :
                      ( ( leq(n0,R43)
                        & leq(n0,S43)
                        & leq(R43,n5)
                        & leq(S43,n5) )
                     => a_select3(phi_thruster_filter_init,R43,S43) = init ) )
               => ( init = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,n0) = init
                  & ! [T43,U43] :
                      ( ( leq(n0,T43)
                        & leq(n0,U43)
                        & leq(T43,n3)
                        & leq(U43,n5) )
                     => a_select3(h_thruster_filter_init,T43,U43) = init )
                  & ! [V43,W43] :
                      ( ( leq(n0,V43)
                        & leq(n0,W43)
                        & leq(V43,n5)
                        & leq(W43,n5) )
                     => a_select3(phi_thruster_filter_init,V43,W43) = init )
                  & ! [X43,Y43] :
                      ( ( leq(n0,X43)
                        & leq(n0,Y43)
                        & leq(X43,minus(n6,n1))
                        & leq(Y43,n0) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(dv_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),X43,Y43) = init ) ) )
              & ( ( ! [Z43,A44] :
                      ( ( leq(n0,Z43)
                        & leq(n0,A44)
                        & leq(Z43,n3)
                        & leq(A44,n5) )
                     => a_select3(h_thruster_filter_init,Z43,A44) = init )
                  & ! [B44,C44] :
                      ( ( leq(n0,B44)
                        & leq(n0,C44)
                        & leq(B44,n5)
                        & leq(C44,n5) )
                     => a_select3(phi_thruster_filter_init,B44,C44) = init )
                  & ! [D44,E44] :
                      ( ( leq(n0,D44)
                        & leq(n0,E44)
                        & leq(D44,minus(n6,n1))
                        & leq(E44,n0) )
                     => a_select3(dv_thruster_filter_init,D44,E44) = init ) )
               => ( a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n0) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n1) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n2) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n3) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n4) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n5) = init
                  & ! [F44,G44] :
                      ( ( leq(n0,F44)
                        & leq(n0,G44)
                        & leq(F44,n3)
                        & leq(G44,n5) )
                     => a_select3(h_thruster_filter_init,F44,G44) = init )
                  & ! [H44,I44] :
                      ( ( leq(n0,H44)
                        & leq(n0,I44)
                        & leq(H44,n5)
                        & leq(I44,n5) )
                     => a_select3(phi_thruster_filter_init,H44,I44) = init )
                  & ! [J44,K44] :
                      ( ( leq(n0,J44)
                        & leq(n0,K44)
                        & leq(J44,minus(n6,n1))
                        & leq(K44,n0) )
                     => a_select3(dv_thruster_filter_init,J44,K44) = init )
                  & ! [L44,M44] :
                      ( ( leq(n0,L44)
                        & leq(n0,M44)
                        & leq(L44,n5)
                        & leq(M44,n5) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(q_thruster_filter_init,n0,n0,init),n0,n1,init),n0,n2,init),n0,n3,init),n0,n4,init),n0,n5,init),n1,n0,init),n1,n1,init),n1,n2,init),n1,n3,init),n1,n4,init),n1,n5,init),n2,n0,init),n2,n1,init),n2,n2,init),n2,n3,init),n2,n4,init),n2,n5,init),n3,n0,init),n3,n1,init),n3,n2,init),n3,n3,init),n3,n4,init),n3,n5,init),n4,n0,init),n4,n1,init),n4,n2,init),n4,n3,init),n4,n4,init),n4,n5,init),n5,n0,init),n5,n1,init),n5,n2,init),n5,n3,init),n5,n4,init),n5,n5,init),L44,M44) = init ) ) )
              & ( ( ! [N44,O44] :
                      ( ( leq(n0,N44)
                        & leq(n0,O44)
                        & leq(N44,n3)
                        & leq(O44,n5) )
                     => a_select3(h_thruster_filter_init,N44,O44) = init )
                  & ! [P44,Q44] :
                      ( ( leq(n0,P44)
                        & leq(n0,Q44)
                        & leq(P44,n5)
                        & leq(Q44,n5) )
                     => a_select3(phi_thruster_filter_init,P44,Q44) = init )
                  & ! [R44,S44] :
                      ( ( leq(n0,R44)
                        & leq(n0,S44)
                        & leq(R44,minus(n6,n1))
                        & leq(S44,n0) )
                     => a_select3(dv_thruster_filter_init,R44,S44) = init )
                  & ! [T44,U44] :
                      ( ( leq(n0,T44)
                        & leq(n0,U44)
                        & leq(T44,n5)
                        & leq(U44,n5) )
                     => a_select3(q_thruster_filter_init,T44,U44) = init ) )
               => ( a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n0,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n1,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n2,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,minus(n4,n1)),dim(n0,minus(n1000,n1)),init),n3,n0) = init
                  & ! [V44,W44] :
                      ( ( leq(n0,V44)
                        & leq(n0,W44)
                        & leq(V44,n3)
                        & leq(W44,n5) )
                     => a_select3(h_thruster_filter_init,V44,W44) = init )
                  & ! [X44,Y44] :
                      ( ( leq(n0,X44)
                        & leq(n0,Y44)
                        & leq(X44,n5)
                        & leq(Y44,n5) )
                     => a_select3(phi_thruster_filter_init,X44,Y44) = init )
                  & ! [Z44,A45] :
                      ( ( leq(n0,Z44)
                        & leq(n0,A45)
                        & leq(Z44,minus(n6,n1))
                        & leq(A45,n0) )
                     => a_select3(dv_thruster_filter_init,Z44,A45) = init )
                  & ! [B45,C45] :
                      ( ( leq(n0,B45)
                        & leq(n0,C45)
                        & leq(B45,n5)
                        & leq(C45,n5) )
                     => a_select3(q_thruster_filter_init,B45,C45) = init )
                  & ! [D45,E45] :
                      ( ( leq(n0,D45)
                        & leq(n0,E45)
                        & leq(D45,n3)
                        & leq(E45,n3) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_thruster_filter_init,n0,n0,init),n0,n1,init),n0,n2,init),n0,n3,init),n1,n0,init),n1,n1,init),n1,n2,init),n1,n3,init),n2,n0,init),n2,n1,init),n2,n2,init),n2,n3,init),n3,n0,init),n3,n1,init),n3,n2,init),n3,n3,init),D45,E45) = init ) ) )
              & ( ( ! [F45,G45] :
                      ( ( leq(n0,F45)
                        & leq(n0,G45)
                        & leq(F45,n3)
                        & leq(G45,n5) )
                     => a_select3(h_thruster_filter_init,F45,G45) = init )
                  & ! [H45,I45] :
                      ( ( leq(n0,H45)
                        & leq(n0,I45)
                        & leq(H45,n5)
                        & leq(I45,n5) )
                     => a_select3(phi_thruster_filter_init,H45,I45) = init )
                  & ! [J45,K45] :
                      ( ( leq(n0,J45)
                        & leq(n0,K45)
                        & leq(J45,minus(n6,n1))
                        & leq(K45,n0) )
                     => a_select3(dv_thruster_filter_init,J45,K45) = init )
                  & ! [L45,M45] :
                      ( ( leq(n0,L45)
                        & leq(n0,M45)
                        & leq(L45,n5)
                        & leq(M45,n5) )
                     => a_select3(q_thruster_filter_init,L45,M45) = init )
                  & ! [N45,O45] :
                      ( ( leq(n0,N45)
                        & leq(n0,O45)
                        & leq(N45,n3)
                        & leq(O45,n3) )
                     => a_select3(r_thruster_filter_init,N45,O45) = init ) )
               => ( a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n0) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n1) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n2) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n3) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n4) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n5) = init
                  & ! [P45,Q45] :
                      ( ( leq(n0,P45)
                        & leq(n0,Q45)
                        & leq(P45,n3)
                        & leq(Q45,n5) )
                     => a_select3(h_thruster_filter_init,P45,Q45) = init )
                  & ! [R45,S45] :
                      ( ( leq(n0,R45)
                        & leq(n0,S45)
                        & leq(R45,n5)
                        & leq(S45,n5) )
                     => a_select3(phi_thruster_filter_init,R45,S45) = init )
                  & ! [T45,U45] :
                      ( ( leq(n0,T45)
                        & leq(n0,U45)
                        & leq(T45,minus(n6,n1))
                        & leq(U45,n0) )
                     => a_select3(dv_thruster_filter_init,T45,U45) = init )
                  & ! [V45,W45] :
                      ( ( leq(n0,V45)
                        & leq(n0,W45)
                        & leq(V45,n5)
                        & leq(W45,n5) )
                     => a_select3(q_thruster_filter_init,V45,W45) = init )
                  & ! [X45,Y45] :
                      ( ( leq(n0,X45)
                        & leq(n0,Y45)
                        & leq(X45,n3)
                        & leq(Y45,n3) )
                     => a_select3(r_thruster_filter_init,X45,Y45) = init )
                  & ! [Z45,A46] :
                      ( ( leq(n0,Z45)
                        & leq(n0,A46)
                        & leq(Z45,n5)
                        & leq(A46,n0) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(xhatmin_thruster_filter_init,n0,n0,init),n1,n0,init),n2,n0,init),n3,n0,init),n4,n0,init),n5,n0,init),Z45,A46) = init ) ) )
              & ( ( ! [B46,C46] :
                      ( ( leq(n0,B46)
                        & leq(n0,C46)
                        & leq(B46,n3)
                        & leq(C46,n5) )
                     => a_select3(h_thruster_filter_init,B46,C46) = init )
                  & ! [D46,E46] :
                      ( ( leq(n0,D46)
                        & leq(n0,E46)
                        & leq(D46,n5)
                        & leq(E46,n5) )
                     => a_select3(phi_thruster_filter_init,D46,E46) = init )
                  & ! [F46,G46] :
                      ( ( leq(n0,F46)
                        & leq(n0,G46)
                        & leq(F46,minus(n6,n1))
                        & leq(G46,n0) )
                     => a_select3(dv_thruster_filter_init,F46,G46) = init )
                  & ! [H46,I46] :
                      ( ( leq(n0,H46)
                        & leq(n0,I46)
                        & leq(H46,n5)
                        & leq(I46,n5) )
                     => a_select3(q_thruster_filter_init,H46,I46) = init )
                  & ! [J46,K46] :
                      ( ( leq(n0,J46)
                        & leq(n0,K46)
                        & leq(J46,n3)
                        & leq(K46,n3) )
                     => a_select3(r_thruster_filter_init,J46,K46) = init )
                  & ! [L46,M46] :
                      ( ( leq(n0,L46)
                        & leq(n0,M46)
                        & leq(L46,n5)
                        & leq(M46,n0) )
                     => a_select3(xhatmin_thruster_filter_init,L46,M46) = init ) )
               => ( a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n0) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n1) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n2) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n3) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n4) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n5) = init
                  & ! [N46,O46] :
                      ( ( leq(n0,N46)
                        & leq(n0,O46)
                        & leq(N46,n3)
                        & leq(O46,n5) )
                     => a_select3(h_thruster_filter_init,N46,O46) = init )
                  & ! [P46,Q46] :
                      ( ( leq(n0,P46)
                        & leq(n0,Q46)
                        & leq(P46,n5)
                        & leq(Q46,n5) )
                     => a_select3(phi_thruster_filter_init,P46,Q46) = init )
                  & ! [R46,S46] :
                      ( ( leq(n0,R46)
                        & leq(n0,S46)
                        & leq(R46,minus(n6,n1))
                        & leq(S46,n0) )
                     => a_select3(dv_thruster_filter_init,R46,S46) = init )
                  & ! [T46,U46] :
                      ( ( leq(n0,T46)
                        & leq(n0,U46)
                        & leq(T46,n5)
                        & leq(U46,n5) )
                     => a_select3(q_thruster_filter_init,T46,U46) = init )
                  & ! [V46,W46] :
                      ( ( leq(n0,V46)
                        & leq(n0,W46)
                        & leq(V46,n3)
                        & leq(W46,n3) )
                     => a_select3(r_thruster_filter_init,V46,W46) = init )
                  & ! [X46,Y46] :
                      ( ( leq(n0,X46)
                        & leq(n0,Y46)
                        & leq(X46,n5)
                        & leq(Y46,n0) )
                     => a_select3(xhatmin_thruster_filter_init,X46,Y46) = init )
                  & ! [Z46,A47] :
                      ( ( leq(n0,Z46)
                        & leq(n0,A47)
                        & leq(Z46,n5)
                        & leq(A47,n5) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(pminus_thruster_filter_init,n0,n0,init),n0,n1,init),n0,n2,init),n0,n3,init),n0,n4,init),n0,n5,init),n1,n0,init),n1,n1,init),n1,n2,init),n1,n3,init),n1,n4,init),n1,n5,init),n2,n0,init),n2,n1,init),n2,n2,init),n2,n3,init),n2,n4,init),n2,n5,init),n3,n0,init),n3,n1,init),n3,n2,init),n3,n3,init),n3,n4,init),n3,n5,init),n4,n0,init),n4,n1,init),n4,n2,init),n4,n3,init),n4,n4,init),n4,n5,init),n5,n0,init),n5,n1,init),n5,n2,init),n5,n3,init),n5,n4,init),n5,n5,init),Z46,A47) = init ) ) )
              & ( ( ! [B47,C47] :
                      ( ( leq(n0,B47)
                        & leq(n0,C47)
                        & leq(B47,n3)
                        & leq(C47,n5) )
                     => a_select3(h_thruster_filter_init,B47,C47) = init )
                  & ! [D47,E47] :
                      ( ( leq(n0,D47)
                        & leq(n0,E47)
                        & leq(D47,n5)
                        & leq(E47,n5) )
                     => a_select3(phi_thruster_filter_init,D47,E47) = init )
                  & ! [F47,G47] :
                      ( ( leq(n0,F47)
                        & leq(n0,G47)
                        & leq(F47,minus(n6,n1))
                        & leq(G47,n0) )
                     => a_select3(dv_thruster_filter_init,F47,G47) = init )
                  & ! [H47,I47] :
                      ( ( leq(n0,H47)
                        & leq(n0,I47)
                        & leq(H47,n5)
                        & leq(I47,n5) )
                     => a_select3(q_thruster_filter_init,H47,I47) = init )
                  & ! [J47,K47] :
                      ( ( leq(n0,J47)
                        & leq(n0,K47)
                        & leq(J47,n3)
                        & leq(K47,n3) )
                     => a_select3(r_thruster_filter_init,J47,K47) = init )
                  & ! [L47,M47] :
                      ( ( leq(n0,L47)
                        & leq(n0,M47)
                        & leq(L47,n5)
                        & leq(M47,n0) )
                     => a_select3(xhatmin_thruster_filter_init,L47,M47) = init )
                  & ! [N47,O47] :
                      ( ( leq(n0,N47)
                        & leq(n0,O47)
                        & leq(N47,n5)
                        & leq(O47,n5) )
                     => a_select3(pminus_thruster_filter_init,N47,O47) = init ) )
               => true )
              & ( ( ! [P47,Q47] :
                      ( ( leq(n0,P47)
                        & leq(n0,Q47)
                        & leq(P47,n3)
                        & leq(Q47,n5) )
                     => a_select3(h_thruster_filter_init,P47,Q47) = init )
                  & ! [R47,S47] :
                      ( ( leq(n0,R47)
                        & leq(n0,S47)
                        & leq(R47,n5)
                        & leq(S47,n5) )
                     => a_select3(phi_thruster_filter_init,R47,S47) = init )
                  & ! [T47,U47] :
                      ( ( leq(n0,T47)
                        & leq(n0,U47)
                        & leq(T47,minus(n6,n1))
                        & leq(U47,n0) )
                     => a_select3(dv_thruster_filter_init,T47,U47) = init )
                  & ! [V47,W47] :
                      ( ( leq(n0,V47)
                        & leq(n0,W47)
                        & leq(V47,n5)
                        & leq(W47,n5) )
                     => a_select3(q_thruster_filter_init,V47,W47) = init )
                  & ! [X47,Y47] :
                      ( ( leq(n0,X47)
                        & leq(n0,Y47)
                        & leq(X47,n3)
                        & leq(Y47,n3) )
                     => a_select3(r_thruster_filter_init,X47,Y47) = init )
                  & ! [Z47,A48] :
                      ( ( leq(n0,Z47)
                        & leq(n0,A48)
                        & leq(Z47,n5)
                        & leq(A48,n0) )
                     => a_select3(xhatmin_thruster_filter_init,Z47,A48) = init )
                  & ! [B48,C48] :
                      ( ( leq(n0,B48)
                        & leq(n0,C48)
                        & leq(B48,n5)
                        & leq(C48,n5) )
                     => a_select3(pminus_thruster_filter_init,B48,C48) = init ) )
               => ( ! [D48,E48] :
                      ( ( leq(n0,D48)
                        & leq(n0,E48)
                        & leq(D48,n3)
                        & leq(E48,n5) )
                     => a_select3(h_thruster_filter_init,D48,E48) = init )
                  & ! [F48,G48] :
                      ( ( leq(n0,F48)
                        & leq(n0,G48)
                        & leq(F48,n5)
                        & leq(G48,n5) )
                     => a_select3(phi_thruster_filter_init,F48,G48) = init )
                  & ! [H48,I48] :
                      ( ( leq(n0,H48)
                        & leq(n0,I48)
                        & leq(H48,minus(n6,n1))
                        & leq(I48,n0) )
                     => a_select3(dv_thruster_filter_init,H48,I48) = init )
                  & ! [J48,K48] :
                      ( ( leq(n0,J48)
                        & leq(n0,K48)
                        & leq(J48,n5)
                        & leq(K48,n5) )
                     => a_select3(q_thruster_filter_init,J48,K48) = init )
                  & ! [L48,M48] :
                      ( ( leq(n0,L48)
                        & leq(n0,M48)
                        & leq(L48,n3)
                        & leq(M48,n3) )
                     => a_select3(r_thruster_filter_init,L48,M48) = init )
                  & ! [N48,O48] :
                      ( ( leq(n0,N48)
                        & leq(n0,O48)
                        & leq(N48,n5)
                        & leq(O48,n0) )
                     => a_select3(xhatmin_thruster_filter_init,N48,O48) = init )
                  & ! [P48,Q48] :
                      ( ( leq(n0,P48)
                        & leq(n0,Q48)
                        & leq(P48,n5)
                        & leq(Q48,n5) )
                     => a_select3(pminus_thruster_filter_init,P48,Q48) = init ) ) )
              & ( geq(minus(n6,n1),n0)
               => ( init = init
                  & ( geq(minus(n6,n1),n0)
                   => ( init = init
                      & ( ( geq(minus(n4,n1),n0)
                          & geq(minus(n1000,n1),n0) )
                       => init = init ) ) ) ) )
              & ( ! [R48,S48] :
                    ( ( leq(n0,R48)
                      & leq(n0,S48)
                      & leq(R48,n3)
                      & leq(S48,n5) )
                   => a_select3(h_thruster_filter_init,R48,S48) = init )
               => ( init = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n0,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n1,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n2,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n3,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n4,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n5,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n6,n0) = init
                  & a_select3(tptp_const_array2(dim(n0,n7),dim(n0,minus(n1000,n1)),init),n7,n0) = init
                  & a_select2(tptp_const_array1(dim(n0,minus(n6,n1)),init),n0) = init
                  & ! [T48,U48] :
                      ( ( leq(n0,T48)
                        & leq(n0,U48)
                        & leq(T48,n3)
                        & leq(U48,n5) )
                     => a_select3(h_thruster_filter_init,T48,U48) = init )
                  & ! [V48,W48] :
                      ( ( leq(n0,V48)
                        & leq(n0,W48)
                        & leq(V48,n5)
                        & leq(W48,n5) )
                     => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_thruster_filter_init,n0,n0,init),n0,n1,init),n0,n2,init),n0,n3,init),n0,n4,init),n0,n5,init),n1,n0,init),n1,n1,init),n1,n2,init),n1,n3,init),n1,n4,init),n1,n5,init),n2,n0,init),n2,n1,init),n2,n2,init),n2,n3,init),n2,n4,init),n2,n5,init),n3,n0,init),n3,n1,init),n3,n2,init),n3,n3,init),n3,n4,init),n3,n5,init),n4,n0,init),n4,n1,init),n4,n2,init),n4,n3,init),n4,n4,init),n4,n5,init),n5,n0,init),n5,n1,init),n5,n2,init),n5,n3,init),n5,n4,init),n5,n5,init),V48,W48) = init ) ) ) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_1000_588,axiom,
    gt(n1000,n588) ).

fof(gt_588_4,axiom,
    gt(n588,n4) ).

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_7_4,axiom,
    gt(n7,n4) ).

fof(gt_1000_4,axiom,
    gt(n1000,n4) ).

fof(gt_588_5,axiom,
    gt(n588,n5) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_7_5,axiom,
    gt(n7,n5) ).

fof(gt_1000_5,axiom,
    gt(n1000,n5) ).

fof(gt_588_6,axiom,
    gt(n588,n6) ).

fof(gt_7_6,axiom,
    gt(n7,n6) ).

fof(gt_1000_6,axiom,
    gt(n1000,n6) ).

fof(gt_588_7,axiom,
    gt(n588,n7) ).

fof(gt_1000_7,axiom,
    gt(n1000,n7) ).

fof(gt_588_tptp_minus_1,axiom,
    gt(n588,tptp_minus_1) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_7_tptp_minus_1,axiom,
    gt(n7,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_1000_tptp_minus_1,axiom,
    gt(n1000,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_588_0,axiom,
    gt(n588,n0) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_7_0,axiom,
    gt(n7,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_1000_0,axiom,
    gt(n1000,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_588_1,axiom,
    gt(n588,n1) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_7_1,axiom,
    gt(n7,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_1000_1,axiom,
    gt(n1000,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_588_2,axiom,
    gt(n588,n2) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_7_2,axiom,
    gt(n7,n2) ).

fof(gt_1000_2,axiom,
    gt(n1000,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_588_3,axiom,
    gt(n588,n3) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(gt_7_3,axiom,
    gt(n7,n3) ).

fof(gt_1000_3,axiom,
    gt(n1000,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
