%------------------------------------------------------------------------------
% File     : SWV125+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_array_0001
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the array-safety verification for
%            the thruster program. array-safety ensures that each access to
%            an array element is within the specified upper and lower bounds
%            of the array.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_array_0001 [Fis04]

% Status   : Theorem
% Rating   : 0.55 v9.1.0, 0.52 v9.0.0, 0.53 v8.1.0, 0.47 v7.5.0, 0.56 v7.4.0, 0.40 v7.3.0, 0.41 v7.2.0, 0.38 v7.1.0, 0.39 v7.0.0, 0.50 v6.4.0, 0.54 v6.3.0, 0.50 v6.2.0, 0.60 v6.1.0, 0.67 v6.0.0, 0.52 v5.5.0, 0.67 v5.4.0, 0.75 v5.3.0, 0.81 v5.2.0, 0.70 v5.1.0, 0.81 v5.0.0, 0.79 v4.1.0, 0.74 v4.0.1, 0.70 v4.0.0, 0.75 v3.7.0, 0.85 v3.5.0, 0.89 v3.4.0, 1.00 v3.3.0
% Syntax   : Number of formulae    :  121 (  84 unt;   0 def)
%            Number of atoms       :  947 (  90 equ)
%            Maximal formula atoms :  654 (   7 avg)
%            Number of connectives :  847 (  21   ~;  23   |; 698   &)
%                                         (   5 <=>; 100  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  113 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   38 (  38 usr;  20 con; 0-4 aty)
%            Number of variables   :  171 ( 171   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(thruster_array_0001,conjecture,
    ( ( geq(minus(n4,n1),n0)
      & geq(minus(n1000,n1),n0) )
   => ! [A] :
        ( ( geq(n7,n0)
          & geq(minus(n1000,n1),n0) )
       => ! [B] :
            ( ( true
             => true )
            & ( true
             => ( leq(n0,n0)
                & leq(n0,n1)
                & leq(n0,n2)
                & leq(n0,n3)
                & leq(n0,n4)
                & leq(n0,n5)
                & leq(n0,n6)
                & leq(n0,n7)
                & leq(n0,minus(n4,n1))
                & leq(n0,minus(n6,n1))
                & leq(n0,minus(n1000,n1))
                & leq(n1,n7)
                & leq(n1,minus(n4,n1))
                & leq(n1,minus(n6,n1))
                & leq(n2,n7)
                & leq(n2,minus(n4,n1))
                & leq(n2,minus(n6,n1))
                & leq(n3,n7)
                & leq(n3,minus(n4,n1))
                & leq(n3,minus(n6,n1))
                & leq(n4,n7)
                & leq(n4,minus(n6,n1))
                & leq(n5,n7)
                & leq(n5,minus(n6,n1))
                & leq(n6,n7)
                & leq(n7,n7) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv21)
                & leq(pv5,n588)
                & leq(pv21,minus(n6,n1)) )
             => ( leq(n0,n0)
                & leq(n0,pv5)
                & leq(n0,pv21)
                & leq(pv5,n588)
                & leq(pv21,n5)
                & leq(pv21,minus(n6,n1)) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv31)
                & leq(n0,pv32)
                & leq(pv5,n588)
                & leq(pv31,minus(n6,n1))
                & leq(pv32,minus(n6,n1)) )
             => ( ( pv31 != pv32
                 => ( leq(n0,pv5)
                    & leq(n0,pv31)
                    & leq(n0,pv32)
                    & leq(pv5,n588)
                    & leq(pv31,minus(n6,n1))
                    & leq(pv32,minus(n6,n1)) ) )
                & ( pv31 = pv32
                 => ( leq(n0,pv5)
                    & leq(n0,pv31)
                    & leq(n0,pv32)
                    & leq(pv5,n588)
                    & leq(pv31,minus(n6,n1))
                    & leq(pv32,minus(n6,n1)) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv31)
                & leq(pv5,n588)
                & leq(pv31,minus(n6,n1)) )
             => ( leq(n0,pv5)
                & leq(n0,pv31)
                & leq(pv5,n588)
                & leq(pv31,minus(n6,n1)) ) )
            & ( ( leq(n0,pv5)
                & leq(n0,pv31)
                & leq(pv5,n588)
                & leq(pv31,minus(n6,n1)) )
             => ( leq(n0,pv5)
                & leq(pv5,n588) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588) )
             => true )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588) )
             => ( leq(n0,n0)
                & leq(n0,n1)
                & leq(n0,n2)
                & leq(n0,n3)
                & leq(n0,pv5)
                & leq(n0,minus(n4,n1))
                & leq(n0,minus(n6,n1))
                & leq(n1,minus(n4,n1))
                & leq(n1,minus(n6,n1))
                & leq(n2,minus(n4,n1))
                & leq(n2,minus(n6,n1))
                & leq(n3,minus(n4,n1))
                & leq(pv5,minus(n1000,n1))
                & ( ~ gt(pv5,n0)
                 => ( ( ~ gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( leq(n0,n0)
                            & leq(n0,n1)
                            & leq(n0,n2)
                            & leq(n0,n3)
                            & leq(n0,pv5)
                            & leq(n0,minus(n4,n1))
                            & leq(n1,minus(n4,n1))
                            & leq(n2,minus(n4,n1))
                            & leq(n3,minus(n4,n1))
                            & leq(pv5,minus(n1000,n1))
                            & ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) ) ) )
                    & ( gt(pv5,n0)
                     => ( leq(n0,n0)
                        & leq(n0,n1)
                        & leq(n0,n2)
                        & leq(n0,n3)
                        & leq(n0,n4)
                        & leq(n0,n5)
                        & leq(n0,n6)
                        & leq(n0,n7)
                        & leq(n0,pv5)
                        & leq(n0,minus(n6,n1))
                        & leq(n1,n7)
                        & leq(n2,n7)
                        & leq(n3,n7)
                        & leq(n3,minus(n6,n1))
                        & leq(n4,n7)
                        & leq(n5,n7)
                        & leq(n6,n7)
                        & leq(n7,n7)
                        & leq(pv5,minus(n1000,n1))
                        & ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( leq(n0,n0)
                            & leq(n0,n1)
                            & leq(n0,n2)
                            & leq(n0,n3)
                            & leq(n0,pv5)
                            & leq(n0,minus(n4,n1))
                            & leq(n1,minus(n4,n1))
                            & leq(n2,minus(n4,n1))
                            & leq(n3,minus(n4,n1))
                            & leq(pv5,minus(n1000,n1))
                            & ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) ) ) ) ) )
                & ( gt(pv5,n0)
                 => ( leq(n0,n0)
                    & leq(n0,n1)
                    & leq(n0,n2)
                    & leq(n0,n3)
                    & leq(n0,n4)
                    & leq(n0,n5)
                    & leq(n0,n6)
                    & leq(n0,n7)
                    & leq(n0,pv5)
                    & leq(n0,minus(n6,n1))
                    & leq(n1,n7)
                    & leq(n1,minus(n6,n1))
                    & leq(n2,n7)
                    & leq(n2,minus(n6,n1))
                    & leq(n3,n7)
                    & leq(n4,n7)
                    & leq(n4,minus(n6,n1))
                    & leq(n5,n7)
                    & leq(n5,minus(n6,n1))
                    & leq(n6,n7)
                    & leq(n7,n7)
                    & leq(pv5,minus(n1000,n1))
                    & ( ~ gt(pv5,n0)
                     => ( ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( leq(n0,n0)
                            & leq(n0,n1)
                            & leq(n0,n2)
                            & leq(n0,n3)
                            & leq(n0,pv5)
                            & leq(n0,minus(n4,n1))
                            & leq(n1,minus(n4,n1))
                            & leq(n2,minus(n4,n1))
                            & leq(n3,minus(n4,n1))
                            & leq(pv5,minus(n1000,n1))
                            & ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) ) ) )
                    & ( gt(pv5,n0)
                     => ( leq(n0,n0)
                        & leq(n0,n1)
                        & leq(n0,n2)
                        & leq(n0,n3)
                        & leq(n0,n4)
                        & leq(n0,n5)
                        & leq(n0,n6)
                        & leq(n0,n7)
                        & leq(n0,pv5)
                        & leq(n0,minus(n6,n1))
                        & leq(n1,n7)
                        & leq(n2,n7)
                        & leq(n3,n7)
                        & leq(n3,minus(n6,n1))
                        & leq(n4,n7)
                        & leq(n5,n7)
                        & leq(n6,n7)
                        & leq(n7,n7)
                        & leq(pv5,minus(n1000,n1))
                        & ( ~ gt(pv5,n0)
                         => ( ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) )
                        & ( gt(pv5,n0)
                         => ( leq(n0,n0)
                            & leq(n0,n1)
                            & leq(n0,n2)
                            & leq(n0,n3)
                            & leq(n0,pv5)
                            & leq(n0,minus(n4,n1))
                            & leq(n1,minus(n4,n1))
                            & leq(n2,minus(n4,n1))
                            & leq(n3,minus(n4,n1))
                            & leq(pv5,minus(n1000,n1))
                            & ( ~ gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) )
                            & ( gt(pv5,n0)
                             => ( leq(n0,n0)
                                & leq(n0,n1)
                                & leq(n0,n2)
                                & leq(n0,n3)
                                & leq(n0,n4)
                                & leq(n0,n5)
                                & leq(n0,n6)
                                & leq(n0,n7)
                                & leq(n0,pv5)
                                & leq(n0,minus(n4,n1))
                                & leq(n0,minus(n6,n1))
                                & leq(n1,n7)
                                & leq(n1,minus(n4,n1))
                                & leq(n1,minus(n6,n1))
                                & leq(n2,n7)
                                & leq(n2,minus(n4,n1))
                                & leq(n2,minus(n6,n1))
                                & leq(n3,n7)
                                & leq(n3,minus(n4,n1))
                                & leq(n3,minus(n6,n1))
                                & leq(n4,n7)
                                & leq(n4,minus(n6,n1))
                                & leq(n5,n7)
                                & leq(n5,minus(n6,n1))
                                & leq(n6,n7)
                                & leq(n7,n7)
                                & leq(pv5,n588)
                                & leq(pv5,minus(n1000,n1)) ) ) ) ) ) ) ) ) ) )
            & ( ( leq(n0,pv5)
                & leq(pv5,n588) )
             => ( leq(n0,pv5)
                & leq(pv5,n588) ) )
            & ( ( leq(n0,pv23)
                & leq(pv23,minus(n6,n1)) )
             => ( leq(n0,a_select2(sigma,pv23))
               => true ) )
            & ( geq(minus(n6,n1),n0)
             => ( geq(minus(n6,n1),n0)
               => ( ( geq(minus(n4,n1),n0)
                    & geq(minus(n1000,n1),n0) )
                 => true ) ) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_1000_588,axiom,
    gt(n1000,n588) ).

fof(gt_588_4,axiom,
    gt(n588,n4) ).

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_7_4,axiom,
    gt(n7,n4) ).

fof(gt_1000_4,axiom,
    gt(n1000,n4) ).

fof(gt_588_5,axiom,
    gt(n588,n5) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_7_5,axiom,
    gt(n7,n5) ).

fof(gt_1000_5,axiom,
    gt(n1000,n5) ).

fof(gt_588_6,axiom,
    gt(n588,n6) ).

fof(gt_7_6,axiom,
    gt(n7,n6) ).

fof(gt_1000_6,axiom,
    gt(n1000,n6) ).

fof(gt_588_7,axiom,
    gt(n588,n7) ).

fof(gt_1000_7,axiom,
    gt(n1000,n7) ).

fof(gt_588_tptp_minus_1,axiom,
    gt(n588,tptp_minus_1) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_7_tptp_minus_1,axiom,
    gt(n7,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_1000_tptp_minus_1,axiom,
    gt(n1000,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_588_0,axiom,
    gt(n588,n0) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_7_0,axiom,
    gt(n7,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_1000_0,axiom,
    gt(n1000,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_588_1,axiom,
    gt(n588,n1) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_7_1,axiom,
    gt(n7,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_1000_1,axiom,
    gt(n1000,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_588_2,axiom,
    gt(n588,n2) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_7_2,axiom,
    gt(n7,n2) ).

fof(gt_1000_2,axiom,
    gt(n1000,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_588_3,axiom,
    gt(n588,n3) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(gt_7_3,axiom,
    gt(n7,n3) ).

fof(gt_1000_3,axiom,
    gt(n1000,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
