%------------------------------------------------------------------------------
% File     : SWV124+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation quaternion_ds1_symm_0017
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the quaternion_ds1 program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_symm_0017 [Fis04]

% Status   : Theorem
% Rating   : 1.00 v3.3.0
% Syntax   : Number of formulae    :   94 (  57 unt;   0 def)
%            Number of atoms       :  281 (  91 equ)
%            Maximal formula atoms :   20 (   2 avg)
%            Number of connectives :  192 (   5   ~;  23   |; 103   &)
%                                         (   5 <=>;  56  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   4 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   32 (  32 usr;  14 con; 0-4 aty)
%            Number of variables   :  175 ( 175   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_symm_0017,conjecture,
    ( ! [A,B] :
        ( ( leq(n0,A)
          & leq(n0,B)
          & leq(A,minus(n6,n1))
          & leq(B,minus(n6,n1)) )
       => a_select3(q_ds1_filter,A,B) = a_select3(q_ds1_filter,B,A) )
   => ( ! [C,D] :
          ( ( leq(n0,C)
            & leq(n0,D)
            & leq(C,minus(n6,n1))
            & leq(D,minus(n6,n1)) )
         => a_select3(q_ds1_filter,C,D) = a_select3(q_ds1_filter,D,C) )
      & ! [E,F] :
          ( ( leq(n0,E)
            & leq(n0,F)
            & leq(E,minus(n3,n1))
            & leq(F,minus(n3,n1)) )
         => a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_ds1_filter,n0,n0,a_select2(rho,n0)),n0,n1,n0),n0,n2,n0),n1,n0,n0),n1,n1,a_select2(rho,n1)),n1,n2,n0),n2,n0,n0),n2,n1,n0),n2,n2,a_select2(rho,n2)),E,F) = a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(r_ds1_filter,n0,n0,a_select2(rho,n0)),n0,n1,n0),n0,n2,n0),n1,n0,n0),n1,n1,a_select2(rho,n1)),n1,n2,n0),n2,n0,n0),n2,n1,n0),n2,n2,a_select2(rho,n2)),F,E) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
