%------------------------------------------------------------------------------
% File     : SWV118+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation quaternion_ds1_symm_0011
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the quaternion_ds1 program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_symm_0011 [Fis04]

% Status   : Theorem
% Rating   : 0.97 v8.1.0, 0.94 v7.5.0, 0.97 v7.1.0, 0.96 v7.0.0, 1.00 v6.2.0, 0.96 v6.1.0, 1.00 v4.1.0, 0.96 v4.0.1, 1.00 v3.3.0
% Syntax   : Number of formulae    :  111 (  74 unt;   0 def)
%            Number of atoms       :  419 ( 112 equ)
%            Maximal formula atoms :  136 (   3 avg)
%            Number of connectives :  316 (   8   ~;  23   |; 192   &)
%                                         (   5 <=>;  88  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   4 avg)
%            Maximal term depth    :   18 (   3 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   42 (  42 usr;  22 con; 0-4 aty)
%            Number of variables   :  217 ( 217   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_symm_0011,conjecture,
    ( ( leq(n0,pv5)
      & leq(pv5,minus(n999,n1))
      & ! [A,B] :
          ( ( leq(n0,A)
            & leq(n0,B)
            & leq(A,minus(n6,n1))
            & leq(B,minus(n6,n1)) )
         => a_select3(q_ds1_filter,A,B) = a_select3(q_ds1_filter,B,A) )
      & ! [C,D] :
          ( ( leq(n0,C)
            & leq(n0,D)
            & leq(C,minus(n3,n1))
            & leq(D,minus(n3,n1)) )
         => a_select3(r_ds1_filter,C,D) = a_select3(r_ds1_filter,D,C) )
      & ! [E,F] :
          ( ( leq(n0,E)
            & leq(n0,F)
            & leq(E,minus(n6,n1))
            & leq(F,minus(n6,n1)) )
         => a_select3(pminus_ds1_filter,E,F) = a_select3(pminus_ds1_filter,F,E) )
      & ! [G] :
          ( ( leq(n0,G)
            & leq(G,minus(n6,n1)) )
         => ! [H] :
              ( ( leq(n0,H)
                & leq(H,minus(n6,n1)) )
             => a_select3(id_ds1_filter,G,H) = a_select3(id_ds1_filter,H,G) ) ) )
   => ( ( ~ gt(pv5,n0)
       => ( ( ~ gt(pv5,n0)
           => ( leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [I,J] :
                  ( ( leq(n0,I)
                    & leq(n0,J)
                    & leq(I,minus(n6,n1))
                    & leq(J,minus(n6,n1)) )
                 => a_select3(q_ds1_filter,I,J) = a_select3(q_ds1_filter,J,I) )
              & ! [K,L] :
                  ( ( leq(n0,K)
                    & leq(n0,L)
                    & leq(K,minus(n3,n1))
                    & leq(L,minus(n3,n1)) )
                 => a_select3(r_ds1_filter,K,L) = a_select3(r_ds1_filter,L,K) )
              & ! [M,N] :
                  ( ( leq(n0,M)
                    & leq(n0,N)
                    & leq(M,minus(n6,n1))
                    & leq(N,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),M,N) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),N,M) )
              & ! [O,P] :
                  ( ( leq(n0,O)
                    & leq(n0,P)
                    & leq(O,minus(n6,n1))
                    & leq(P,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),O,P) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),P,O) )
              & ! [Q] :
                  ( ( leq(n0,Q)
                    & leq(Q,minus(n6,n1)) )
                 => ! [R] :
                      ( ( leq(n0,R)
                        & leq(R,minus(n6,n1)) )
                     => a_select3(id_ds1_filter,Q,R) = a_select3(id_ds1_filter,R,Q) ) ) ) )
          & ( gt(pv5,n0)
           => ( leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [S,T] :
                  ( ( leq(n0,S)
                    & leq(n0,T)
                    & leq(S,minus(n6,n1))
                    & leq(T,minus(n6,n1)) )
                 => a_select3(q_ds1_filter,S,T) = a_select3(q_ds1_filter,T,S) )
              & ! [U,V] :
                  ( ( leq(n0,U)
                    & leq(n0,V)
                    & leq(U,minus(n3,n1))
                    & leq(V,minus(n3,n1)) )
                 => a_select3(r_ds1_filter,U,V) = a_select3(r_ds1_filter,V,U) )
              & ! [W,X] :
                  ( ( leq(n0,W)
                    & leq(n0,X)
                    & leq(W,minus(n6,n1))
                    & leq(X,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),W,X) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),X,W) )
              & ! [Y,Z] :
                  ( ( leq(n0,Y)
                    & leq(n0,Z)
                    & leq(Y,minus(n6,n1))
                    & leq(Z,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),Y,Z) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(phi_ds1_filter,tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(phi_ds1_filter)))),Z,Y) )
              & ! [A1] :
                  ( ( leq(n0,A1)
                    & leq(A1,minus(n6,n1)) )
                 => ! [B1] :
                      ( ( leq(n0,B1)
                        & leq(B1,minus(n6,n1)) )
                     => a_select3(id_ds1_filter,A1,B1) = a_select3(id_ds1_filter,B1,A1) ) ) ) ) ) )
      & ( gt(pv5,n0)
       => ( ( ~ gt(pv5,n0)
           => ( leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [C1,D1] :
                  ( ( leq(n0,C1)
                    & leq(n0,D1)
                    & leq(C1,minus(n6,n1))
                    & leq(D1,minus(n6,n1)) )
                 => a_select3(q_ds1_filter,C1,D1) = a_select3(q_ds1_filter,D1,C1) )
              & ! [E1,F1] :
                  ( ( leq(n0,E1)
                    & leq(n0,F1)
                    & leq(E1,minus(n3,n1))
                    & leq(F1,minus(n3,n1)) )
                 => a_select3(r_ds1_filter,E1,F1) = a_select3(r_ds1_filter,F1,E1) )
              & ! [G1,H1] :
                  ( ( leq(n0,G1)
                    & leq(n0,H1)
                    & leq(G1,minus(n6,n1))
                    & leq(H1,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),G1,H1) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),H1,G1) )
              & ! [I1,J1] :
                  ( ( leq(n0,I1)
                    & leq(n0,J1)
                    & leq(I1,minus(n6,n1))
                    & leq(J1,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),I1,J1) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),J1,I1) )
              & ! [K1] :
                  ( ( leq(n0,K1)
                    & leq(K1,minus(n6,n1)) )
                 => ! [L1] :
                      ( ( leq(n0,L1)
                        & leq(L1,minus(n6,n1)) )
                     => a_select3(id_ds1_filter,K1,L1) = a_select3(id_ds1_filter,L1,K1) ) ) ) )
          & ( gt(pv5,n0)
           => ( leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [M1,N1] :
                  ( ( leq(n0,M1)
                    & leq(n0,N1)
                    & leq(M1,minus(n6,n1))
                    & leq(N1,minus(n6,n1)) )
                 => a_select3(q_ds1_filter,M1,N1) = a_select3(q_ds1_filter,N1,M1) )
              & ! [O1,P1] :
                  ( ( leq(n0,O1)
                    & leq(n0,P1)
                    & leq(O1,minus(n3,n1))
                    & leq(P1,minus(n3,n1)) )
                 => a_select3(r_ds1_filter,O1,P1) = a_select3(r_ds1_filter,P1,O1) )
              & ! [Q1,R1] :
                  ( ( leq(n0,Q1)
                    & leq(n0,R1)
                    & leq(Q1,minus(n6,n1))
                    & leq(R1,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),Q1,R1) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),R1,Q1) )
              & ! [S1,T1] :
                  ( ( leq(n0,S1)
                    & leq(n0,T1)
                    & leq(S1,minus(n6,n1))
                    & leq(T1,minus(n6,n1)) )
                 => a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),S1,T1) = a_select3(tptp_madd(q_ds1_filter,tptp_mmul(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))),tptp_mmul(tptp_madd(tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),tptp_mmul(r_ds1_filter,trans(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter)))))))))),tptp_mmul(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)),tptp_mmul(pminus_ds1_filter,trans(tptp_msub(id_ds1_filter,tptp_mmul(tptp_mmul(pminus_ds1_filter,tptp_mmul(trans(h_ds1_filter),inv(tptp_madd(r_ds1_filter,tptp_mmul(h_ds1_filter,tptp_mmul(pminus_ds1_filter,trans(h_ds1_filter))))))),h_ds1_filter)))))),trans(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(phi_ds1_filter,n2,n1,times(minus(a_select3(xhatmin_ds1_filter,n3,n0),a_select3(u,n0,pv5)),divide(n1,n400))),n2,n0,times(minus(a_select3(u,n1,pv5),a_select3(xhatmin_ds1_filter,n4,n0)),divide(n1,n400))),n1,n2,times(minus(a_select3(u,n0,pv5),a_select3(xhatmin_ds1_filter,n3,n0)),divide(n1,n400))),n1,n0,times(minus(a_select3(xhatmin_ds1_filter,n5,n0),a_select3(u,n2,pv5)),divide(n1,n400))),n0,n2,times(minus(a_select3(xhatmin_ds1_filter,n4,n0),a_select3(u,n1,pv5)),divide(n1,n400))),n0,n1,times(minus(a_select3(u,n2,pv5),a_select3(xhatmin_ds1_filter,n5,n0)),divide(n1,n400))))))),T1,S1) )
              & ! [U1] :
                  ( ( leq(n0,U1)
                    & leq(U1,minus(n6,n1)) )
                 => ! [V1] :
                      ( ( leq(n0,V1)
                        & leq(V1,minus(n6,n1)) )
                     => a_select3(id_ds1_filter,U1,V1) = a_select3(id_ds1_filter,V1,U1) ) ) ) ) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_400_4,axiom,
    gt(n400,n4) ).

fof(gt_999_4,axiom,
    gt(n999,n4) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_400_5,axiom,
    gt(n400,n5) ).

fof(gt_999_5,axiom,
    gt(n999,n5) ).

fof(gt_400_6,axiom,
    gt(n400,n6) ).

fof(gt_999_6,axiom,
    gt(n999,n6) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_400_tptp_minus_1,axiom,
    gt(n400,tptp_minus_1) ).

fof(gt_999_tptp_minus_1,axiom,
    gt(n999,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_999_400,axiom,
    gt(n999,n400) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_400_0,axiom,
    gt(n400,n0) ).

fof(gt_999_0,axiom,
    gt(n999,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_400_1,axiom,
    gt(n400,n1) ).

fof(gt_999_1,axiom,
    gt(n999,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_400_2,axiom,
    gt(n400,n2) ).

fof(gt_999_2,axiom,
    gt(n999,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(gt_400_3,axiom,
    gt(n400,n3) ).

fof(gt_999_3,axiom,
    gt(n999,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
