%------------------------------------------------------------------------------
% File     : SWV111+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation quaternion_ds1_symm_0004
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the quaternion_ds1 program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_symm_0004 [Fis04]

% Status   : Theorem
% Rating   : 0.70 v9.1.0, 0.61 v9.0.0, 0.64 v8.2.0, 0.61 v8.1.0, 0.56 v7.5.0, 0.66 v7.4.0, 0.57 v7.3.0, 0.59 v7.1.0, 0.57 v7.0.0, 0.63 v6.4.0, 0.69 v6.3.0, 0.67 v6.2.0, 0.72 v6.1.0, 0.80 v6.0.0, 0.78 v5.5.0, 0.85 v5.4.0, 0.86 v5.3.0, 0.93 v5.2.0, 0.90 v5.0.0, 0.92 v4.1.0, 0.96 v3.7.0, 0.95 v3.4.0, 1.00 v3.3.0
% Syntax   : Number of formulae    :  102 (  65 unt;   0 def)
%            Number of atoms       :  336 ( 100 equ)
%            Maximal formula atoms :   62 (   3 avg)
%            Number of connectives :  239 (   5   ~;  23   |; 139   &)
%                                         (   5 <=>;  67  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   36 (  36 usr;  18 con; 0-4 aty)
%            Number of variables   :  189 ( 189   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_symm_0004,conjecture,
    ( ( leq(n0,pv5)
      & leq(n0,pv57)
      & leq(pv5,minus(n999,n1))
      & leq(pv57,minus(n6,n1))
      & ! [A,B] :
          ( ( leq(n0,A)
            & leq(n0,B)
            & leq(A,minus(n6,n1))
            & leq(B,minus(n6,n1)) )
         => a_select3(q_ds1_filter,A,B) = a_select3(q_ds1_filter,B,A) )
      & ! [C,D] :
          ( ( leq(n0,C)
            & leq(n0,D)
            & leq(C,minus(n3,n1))
            & leq(D,minus(n3,n1)) )
         => a_select3(r_ds1_filter,C,D) = a_select3(r_ds1_filter,D,C) )
      & ! [E,F] :
          ( ( leq(n0,E)
            & leq(n0,F)
            & leq(E,minus(n6,n1))
            & leq(F,minus(n6,n1)) )
         => a_select3(pminus_ds1_filter,E,F) = a_select3(pminus_ds1_filter,F,E) )
      & ! [G,H] :
          ( ( leq(n0,G)
            & leq(n0,H)
            & leq(G,minus(n6,n1))
            & leq(H,minus(n6,n1)) )
         => ( ( ( lt(H,plus(n1,minus(n6,n1)))
                & G = pv57 )
             => a_select3(id_ds1_filter,G,H) = a_select3(id_ds1_filter,H,G) )
            & ( lt(G,pv57)
             => a_select3(id_ds1_filter,G,H) = a_select3(id_ds1_filter,H,G) ) ) )
      & ! [I] :
          ( ( leq(n0,I)
            & leq(I,minus(pv57,n1)) )
         => ! [J] :
              ( ( leq(n0,J)
                & leq(J,minus(n6,n1)) )
             => a_select3(id_ds1_filter,I,J) = a_select3(id_ds1_filter,J,I) ) ) )
   => ( leq(n0,pv5)
      & leq(n0,pv57)
      & leq(pv5,minus(n999,n1))
      & leq(pv57,minus(n6,n1))
      & ! [K,L] :
          ( ( leq(n0,K)
            & leq(n0,L)
            & leq(K,minus(n6,n1))
            & leq(L,minus(n6,n1)) )
         => a_select3(q_ds1_filter,K,L) = a_select3(q_ds1_filter,L,K) )
      & ! [M,N] :
          ( ( leq(n0,M)
            & leq(n0,N)
            & leq(M,minus(n3,n1))
            & leq(N,minus(n3,n1)) )
         => a_select3(r_ds1_filter,M,N) = a_select3(r_ds1_filter,N,M) )
      & ! [O,P] :
          ( ( leq(n0,O)
            & leq(n0,P)
            & leq(O,minus(n6,n1))
            & leq(P,minus(n6,n1)) )
         => a_select3(pminus_ds1_filter,O,P) = a_select3(pminus_ds1_filter,P,O) )
      & ! [Q,R] :
          ( ( leq(n0,Q)
            & leq(n0,R)
            & leq(Q,pv57)
            & leq(R,minus(n6,n1)) )
         => a_select3(id_ds1_filter,Q,R) = a_select3(id_ds1_filter,R,Q) )
      & ! [S] :
          ( ( leq(n0,S)
            & leq(S,minus(pv57,n1)) )
         => ! [T] :
              ( ( leq(n0,T)
                & leq(T,minus(n6,n1)) )
             => a_select3(id_ds1_filter,S,T) = a_select3(id_ds1_filter,T,S) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_6_4,axiom,
    gt(n6,n4) ).

fof(gt_999_4,axiom,
    gt(n999,n4) ).

fof(gt_6_5,axiom,
    gt(n6,n5) ).

fof(gt_999_5,axiom,
    gt(n999,n5) ).

fof(gt_999_6,axiom,
    gt(n999,n6) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_6_tptp_minus_1,axiom,
    gt(n6,tptp_minus_1) ).

fof(gt_999_tptp_minus_1,axiom,
    gt(n999,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_6_0,axiom,
    gt(n6,n0) ).

fof(gt_999_0,axiom,
    gt(n999,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_6_1,axiom,
    gt(n6,n1) ).

fof(gt_999_1,axiom,
    gt(n999,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_6_2,axiom,
    gt(n6,n2) ).

fof(gt_999_2,axiom,
    gt(n999,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_6_3,axiom,
    gt(n6,n3) ).

fof(gt_999_3,axiom,
    gt(n999,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_6,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n6) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5
        | X = n6 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_6,axiom,
    succ(succ(succ(succ(succ(succ(n0)))))) = n6 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
