%------------------------------------------------------------------------------
% File     : SWV100+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation quaternion_ds1_inuse_0012
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the inuse-safety verification for
%            the quaternion_ds1 program. inuse-safety ensures that each sensor
%            reading passed as an input to the Kalman filter algorithm is
%            actually used during the computation of the output estimate.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_inuse_0012 [Fis04]

% Status   : Theorem
% Rating   : 1.00 v3.3.0
% Syntax   : Number of formulae    :   92 (  56 unt;   0 def)
%            Number of atoms       :  461 ( 233 equ)
%            Maximal formula atoms :  205 (   5 avg)
%            Number of connectives :  377 (   8   ~;  17   |; 280   &)
%                                         (   5 <=>;  67  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   42 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   37 (  37 usr;  19 con; 0-4 aty)
%            Number of variables   :  186 ( 186   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_inuse_0012,conjecture,
    ( ( a_select2(rho_defuse,n0) = use
      & a_select2(rho_defuse,n1) = use
      & a_select2(rho_defuse,n2) = use
      & a_select2(sigma_defuse,n0) = use
      & a_select2(sigma_defuse,n1) = use
      & a_select2(sigma_defuse,n2) = use
      & a_select2(sigma_defuse,n3) = use
      & a_select2(sigma_defuse,n4) = use
      & a_select2(sigma_defuse,n5) = use
      & a_select3(u_defuse,n0,n0) = use
      & a_select3(u_defuse,n1,n0) = use
      & a_select3(u_defuse,n2,n0) = use
      & a_select2(xinit_defuse,n3) = use
      & a_select2(xinit_defuse,n4) = use
      & a_select2(xinit_defuse,n5) = use
      & a_select2(xinit_mean_defuse,n0) = use
      & a_select2(xinit_mean_defuse,n1) = use
      & a_select2(xinit_mean_defuse,n2) = use
      & a_select2(xinit_mean_defuse,n3) = use
      & a_select2(xinit_mean_defuse,n4) = use
      & a_select2(xinit_mean_defuse,n5) = use
      & a_select2(xinit_noise_defuse,n0) = use
      & a_select2(xinit_noise_defuse,n1) = use
      & a_select2(xinit_noise_defuse,n2) = use
      & a_select2(xinit_noise_defuse,n3) = use
      & a_select2(xinit_noise_defuse,n4) = use
      & a_select2(xinit_noise_defuse,n5) = use
      & leq(n0,pv5)
      & leq(pv5,minus(n999,n1))
      & ! [A,B] :
          ( ( leq(n0,A)
            & leq(n0,B)
            & leq(A,n2)
            & leq(B,minus(pv5,n1)) )
         => ( a_select3(u_defuse,A,B) = use
            & a_select3(z_defuse,A,B) = use ) ) )
   => ( ( ~ gt(pv5,n0)
       => ( ( ~ gt(pv5,n0)
           => ( a_select2(rho_defuse,n0) = use
              & a_select2(rho_defuse,n1) = use
              & a_select2(rho_defuse,n2) = use
              & a_select2(sigma_defuse,n0) = use
              & a_select2(sigma_defuse,n1) = use
              & a_select2(sigma_defuse,n2) = use
              & a_select2(sigma_defuse,n3) = use
              & a_select2(sigma_defuse,n4) = use
              & a_select2(sigma_defuse,n5) = use
              & a_select3(u_defuse,n0,n0) = use
              & a_select3(u_defuse,n1,n0) = use
              & a_select3(u_defuse,n2,n0) = use
              & a_select2(xinit_defuse,n3) = use
              & a_select2(xinit_defuse,n4) = use
              & a_select2(xinit_defuse,n5) = use
              & a_select2(xinit_mean_defuse,n0) = use
              & a_select2(xinit_mean_defuse,n1) = use
              & a_select2(xinit_mean_defuse,n2) = use
              & a_select2(xinit_mean_defuse,n3) = use
              & a_select2(xinit_mean_defuse,n4) = use
              & a_select2(xinit_mean_defuse,n5) = use
              & a_select2(xinit_noise_defuse,n0) = use
              & a_select2(xinit_noise_defuse,n1) = use
              & a_select2(xinit_noise_defuse,n2) = use
              & a_select2(xinit_noise_defuse,n3) = use
              & a_select2(xinit_noise_defuse,n4) = use
              & a_select2(xinit_noise_defuse,n5) = use
              & leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [C,D] :
                  ( ( leq(n0,C)
                    & leq(n0,D)
                    & leq(C,n2)
                    & leq(D,pv5) )
                 => ( a_select3(u_defuse,C,D) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),C,D) = use ) )
              & ! [E,F] :
                  ( ( leq(n0,E)
                    & leq(n0,F)
                    & leq(E,n2)
                    & leq(F,minus(pv5,n1)) )
                 => ( a_select3(u_defuse,E,F) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),E,F) = use ) ) ) )
          & ( gt(pv5,n0)
           => ( a_select2(rho_defuse,n0) = use
              & a_select2(rho_defuse,n1) = use
              & a_select2(rho_defuse,n2) = use
              & a_select2(sigma_defuse,n0) = use
              & a_select2(sigma_defuse,n1) = use
              & a_select2(sigma_defuse,n2) = use
              & a_select2(sigma_defuse,n3) = use
              & a_select2(sigma_defuse,n4) = use
              & a_select2(sigma_defuse,n5) = use
              & a_select3(u_defuse,n0,n0) = use
              & a_select3(u_defuse,n1,n0) = use
              & a_select3(u_defuse,n2,n0) = use
              & a_select2(xinit_defuse,n3) = use
              & a_select2(xinit_defuse,n4) = use
              & a_select2(xinit_defuse,n5) = use
              & a_select2(xinit_mean_defuse,n0) = use
              & a_select2(xinit_mean_defuse,n1) = use
              & a_select2(xinit_mean_defuse,n2) = use
              & a_select2(xinit_mean_defuse,n3) = use
              & a_select2(xinit_mean_defuse,n4) = use
              & a_select2(xinit_mean_defuse,n5) = use
              & a_select2(xinit_noise_defuse,n0) = use
              & a_select2(xinit_noise_defuse,n1) = use
              & a_select2(xinit_noise_defuse,n2) = use
              & a_select2(xinit_noise_defuse,n3) = use
              & a_select2(xinit_noise_defuse,n4) = use
              & a_select2(xinit_noise_defuse,n5) = use
              & leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [G,H] :
                  ( ( leq(n0,G)
                    & leq(n0,H)
                    & leq(G,n2)
                    & leq(H,pv5) )
                 => ( a_select3(u_defuse,G,H) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),G,H) = use ) )
              & ! [I,J] :
                  ( ( leq(n0,I)
                    & leq(n0,J)
                    & leq(I,n2)
                    & leq(J,minus(pv5,n1)) )
                 => ( a_select3(u_defuse,I,J) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),I,J) = use ) ) ) ) ) )
      & ( gt(pv5,n0)
       => ( ( ~ gt(pv5,n0)
           => ( a_select2(rho_defuse,n0) = use
              & a_select2(rho_defuse,n1) = use
              & a_select2(rho_defuse,n2) = use
              & a_select2(sigma_defuse,n0) = use
              & a_select2(sigma_defuse,n1) = use
              & a_select2(sigma_defuse,n2) = use
              & a_select2(sigma_defuse,n3) = use
              & a_select2(sigma_defuse,n4) = use
              & a_select2(sigma_defuse,n5) = use
              & a_select2(xinit_defuse,n3) = use
              & a_select2(xinit_defuse,n4) = use
              & a_select2(xinit_defuse,n5) = use
              & a_select2(xinit_mean_defuse,n0) = use
              & a_select2(xinit_mean_defuse,n1) = use
              & a_select2(xinit_mean_defuse,n2) = use
              & a_select2(xinit_mean_defuse,n3) = use
              & a_select2(xinit_mean_defuse,n4) = use
              & a_select2(xinit_mean_defuse,n5) = use
              & a_select2(xinit_noise_defuse,n0) = use
              & a_select2(xinit_noise_defuse,n1) = use
              & a_select2(xinit_noise_defuse,n2) = use
              & a_select2(xinit_noise_defuse,n3) = use
              & a_select2(xinit_noise_defuse,n4) = use
              & a_select2(xinit_noise_defuse,n5) = use
              & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),n0,n0) = use
              & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),n1,n0) = use
              & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),n2,n0) = use
              & leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [K,L] :
                  ( ( leq(n0,K)
                    & leq(n0,L)
                    & leq(K,n2)
                    & leq(L,pv5) )
                 => ( a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),K,L) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),K,L) = use ) )
              & ! [M,N] :
                  ( ( leq(n0,M)
                    & leq(n0,N)
                    & leq(M,n2)
                    & leq(N,minus(pv5,n1)) )
                 => ( a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),M,N) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),M,N) = use ) ) ) )
          & ( gt(pv5,n0)
           => ( a_select2(rho_defuse,n0) = use
              & a_select2(rho_defuse,n1) = use
              & a_select2(rho_defuse,n2) = use
              & a_select2(sigma_defuse,n0) = use
              & a_select2(sigma_defuse,n1) = use
              & a_select2(sigma_defuse,n2) = use
              & a_select2(sigma_defuse,n3) = use
              & a_select2(sigma_defuse,n4) = use
              & a_select2(sigma_defuse,n5) = use
              & a_select2(xinit_defuse,n3) = use
              & a_select2(xinit_defuse,n4) = use
              & a_select2(xinit_defuse,n5) = use
              & a_select2(xinit_mean_defuse,n0) = use
              & a_select2(xinit_mean_defuse,n1) = use
              & a_select2(xinit_mean_defuse,n2) = use
              & a_select2(xinit_mean_defuse,n3) = use
              & a_select2(xinit_mean_defuse,n4) = use
              & a_select2(xinit_mean_defuse,n5) = use
              & a_select2(xinit_noise_defuse,n0) = use
              & a_select2(xinit_noise_defuse,n1) = use
              & a_select2(xinit_noise_defuse,n2) = use
              & a_select2(xinit_noise_defuse,n3) = use
              & a_select2(xinit_noise_defuse,n4) = use
              & a_select2(xinit_noise_defuse,n5) = use
              & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),n0,n0) = use
              & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),n1,n0) = use
              & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),n2,n0) = use
              & leq(n0,pv5)
              & leq(pv5,minus(n999,n1))
              & ! [O,P] :
                  ( ( leq(n0,O)
                    & leq(n0,P)
                    & leq(O,n2)
                    & leq(P,pv5) )
                 => ( a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),O,P) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),O,P) = use ) )
              & ! [Q,R] :
                  ( ( leq(n0,Q)
                    & leq(n0,R)
                    & leq(Q,n2)
                    & leq(R,minus(pv5,n1)) )
                 => ( a_select3(tptp_update3(tptp_update3(tptp_update3(z_defuse,n0,pv5,use),n1,pv5,use),n2,pv5,use),Q,R) = use
                    & a_select3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(tptp_update3(u_defuse,n0,pv5,use),n1,pv5,use),n0,pv5,use),n2,pv5,use),n1,pv5,use),n2,pv5,use),Q,R) = use ) ) ) ) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_999_4,axiom,
    gt(n999,n4) ).

fof(gt_999_5,axiom,
    gt(n999,n5) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_999_tptp_minus_1,axiom,
    gt(n999,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_999_0,axiom,
    gt(n999,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_999_1,axiom,
    gt(n999,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_999_2,axiom,
    gt(n999,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_999_3,axiom,
    gt(n999,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
