%------------------------------------------------------------------------------
% File     : SWV091+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation quaternion_ds1_inuse_0003
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the inuse-safety verification for
%            the quaternion_ds1 program. inuse-safety ensures that each sensor
%            reading passed as an input to the Kalman filter algorithm is
%            actually used during the computation of the output estimate.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_inuse_0003 [Fis04]

% Status   : Theorem
% Rating   : 0.58 v8.1.0, 0.56 v7.5.0, 0.59 v7.4.0, 0.53 v7.3.0, 0.62 v7.1.0, 0.65 v7.0.0, 0.60 v6.4.0, 0.65 v6.3.0, 0.67 v6.2.0, 0.76 v6.1.0, 0.80 v6.0.0, 0.83 v5.5.0, 0.89 v5.2.0, 0.85 v5.1.0, 0.86 v5.0.0, 0.83 v4.0.1, 0.87 v4.0.0, 0.92 v3.7.0, 0.85 v3.5.0, 0.84 v3.3.0
% Syntax   : Number of formulae    :   85 (  49 unt;   0 def)
%            Number of atoms       :  297 ( 128 equ)
%            Maximal formula atoms :   48 (   3 avg)
%            Number of connectives :  217 (   5   ~;  17   |; 138   &)
%                                         (   5 <=>;  52  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   34 (  34 usr;  16 con; 0-4 aty)
%            Number of variables   :  168 ( 168   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(quaternion_ds1_inuse_0003,conjecture,
    ( ( a_select2(rho_defuse,n0) = use
      & a_select2(rho_defuse,n1) = use
      & a_select2(rho_defuse,n2) = use
      & a_select2(sigma_defuse,n0) = use
      & a_select2(sigma_defuse,n1) = use
      & a_select2(sigma_defuse,n2) = use
      & a_select2(sigma_defuse,n3) = use
      & a_select2(sigma_defuse,n4) = use
      & a_select2(sigma_defuse,n5) = use
      & a_select3(u_defuse,n0,n0) = use
      & a_select3(u_defuse,n1,n0) = use
      & a_select3(u_defuse,n2,n0) = use
      & a_select2(xinit_defuse,n3) = use
      & a_select2(xinit_defuse,n4) = use
      & a_select2(xinit_defuse,n5) = use
      & a_select2(xinit_mean_defuse,n0) = use
      & a_select2(xinit_mean_defuse,n1) = use
      & a_select2(xinit_mean_defuse,n2) = use
      & a_select2(xinit_mean_defuse,n3) = use
      & a_select2(xinit_mean_defuse,n4) = use
      & a_select2(xinit_mean_defuse,n5) = use )
   => ( a_select2(rho_defuse,n0) = use
      & a_select2(rho_defuse,n1) = use
      & a_select2(rho_defuse,n2) = use
      & a_select2(sigma_defuse,n0) = use
      & a_select2(sigma_defuse,n1) = use
      & a_select2(sigma_defuse,n2) = use
      & a_select2(sigma_defuse,n3) = use
      & a_select2(sigma_defuse,n4) = use
      & a_select2(sigma_defuse,n5) = use
      & a_select3(u_defuse,n0,n0) = use
      & a_select3(u_defuse,n1,n0) = use
      & a_select3(u_defuse,n2,n0) = use
      & a_select2(xinit_defuse,n3) = use
      & a_select2(xinit_defuse,n4) = use
      & a_select2(xinit_defuse,n5) = use
      & a_select2(xinit_mean_defuse,n0) = use
      & a_select2(xinit_mean_defuse,n1) = use
      & a_select2(xinit_mean_defuse,n2) = use
      & a_select2(xinit_mean_defuse,n3) = use
      & a_select2(xinit_mean_defuse,n4) = use
      & a_select2(xinit_mean_defuse,n5) = use
      & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_noise_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n0) = use
      & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_noise_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n1) = use
      & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_noise_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n2) = use
      & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_noise_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n3) = use
      & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_noise_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n4) = use
      & a_select2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(tptp_update2(xinit_noise_defuse,n0,use),n1,use),n2,use),n3,use),n4,use),n5,use),n5) = use ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
