%------------------------------------------------------------------------------
% File     : SWV049+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation cl5_nebula_norm_0019
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the norm-safety verification for
%            the cl5_nebula program. norm-safety ensures that the contents of
%            certain one-dimensional arrays add up to one.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : cl5_nebula_norm_0019 [Fis04]

% Status   : Theorem
% Rating   : 1.00 v3.3.0
% Syntax   : Number of formulae    :  100 (  64 unt;   0 def)
%            Number of atoms       :  283 (  85 equ)
%            Maximal formula atoms :   20 (   2 avg)
%            Number of connectives :  188 (   5   ~;  17   |; 105   &)
%                                         (   5 <=>;  56  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   4 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   44 (  44 usr;  22 con; 0-4 aty)
%            Number of variables   :  176 ( 176   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(cl5_nebula_norm_0019,conjecture,
    ( ( pv84 = sum(n0,minus(n5,n1),divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,pv85)),minus(a_select2(x,pv10),a_select2(mu,pv85))),tptp_minus_2),times(a_select2(sigma,pv85),a_select2(sigma,pv85)))),a_select2(rho,pv85)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,pv85))))
      & leq(n0,pv10)
      & leq(n0,pv47)
      & leq(pv10,minus(n135300,n1))
      & leq(pv47,minus(n5,n1))
      & ! [A,B] :
          ( ( leq(n0,A)
            & leq(A,minus(pv47,n1)) )
         => a_select3(q,pv10,A) = divide(divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,A)),minus(a_select2(x,pv10),a_select2(mu,A))),tptp_minus_2),times(a_select2(sigma,A),a_select2(sigma,A)))),a_select2(rho,A)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,A))),sum(n0,minus(n5,n1),divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,B)),minus(a_select2(x,pv10),a_select2(mu,B))),tptp_minus_2),times(a_select2(sigma,B),a_select2(sigma,B)))),a_select2(rho,B)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,B))))) )
      & ! [C,D] :
          ( ( leq(n0,C)
            & leq(C,minus(pv10,n1)) )
         => sum(n0,minus(n5,n1),a_select3(q,C,D)) = n1 ) )
   => ( leq(n0,pv10)
      & leq(pv10,minus(n135300,n1))
      & ! [E,F] :
          ( ( leq(n0,E)
            & leq(E,minus(plus(n1,pv47),n1)) )
         => a_select3(tptp_update3(q,pv10,pv47,divide(divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,pv47)),minus(a_select2(x,pv10),a_select2(mu,pv47))),tptp_minus_2),times(a_select2(sigma,pv47),a_select2(sigma,pv47)))),a_select2(rho,pv47)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,pv47))),pv84)),pv10,E) = divide(divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,E)),minus(a_select2(x,pv10),a_select2(mu,E))),tptp_minus_2),times(a_select2(sigma,E),a_select2(sigma,E)))),a_select2(rho,E)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,E))),sum(n0,minus(n5,n1),divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,F)),minus(a_select2(x,pv10),a_select2(mu,F))),tptp_minus_2),times(a_select2(sigma,F),a_select2(sigma,F)))),a_select2(rho,F)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,F))))) )
      & ! [G,H] :
          ( ( leq(n0,G)
            & leq(G,minus(pv10,n1)) )
         => sum(n0,minus(n5,n1),a_select3(tptp_update3(q,pv10,pv47,divide(divide(times(exp(divide(divide(times(minus(a_select2(x,pv10),a_select2(mu,pv47)),minus(a_select2(x,pv10),a_select2(mu,pv47))),tptp_minus_2),times(a_select2(sigma,pv47),a_select2(sigma,pv47)))),a_select2(rho,pv47)),times(sqrt(times(tptp_pi,n2)),a_select2(sigma,pv47))),pv84)),G,H)) = n1 ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_135300_4,axiom,
    gt(n135300,n4) ).

fof(gt_135300_5,axiom,
    gt(n135300,n5) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_135300_tptp_minus_1,axiom,
    gt(n135300,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_tptp_minus_2,axiom,
    gt(n4,tptp_minus_2) ).

fof(gt_5_tptp_minus_2,axiom,
    gt(n5,tptp_minus_2) ).

fof(gt_tptp_minus_1_tptp_minus_2,axiom,
    gt(tptp_minus_1,tptp_minus_2) ).

fof(gt_135300_tptp_minus_2,axiom,
    gt(n135300,tptp_minus_2) ).

fof(gt_0_tptp_minus_2,axiom,
    gt(n0,tptp_minus_2) ).

fof(gt_1_tptp_minus_2,axiom,
    gt(n1,tptp_minus_2) ).

fof(gt_2_tptp_minus_2,axiom,
    gt(n2,tptp_minus_2) ).

fof(gt_3_tptp_minus_2,axiom,
    gt(n3,tptp_minus_2) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_135300_0,axiom,
    gt(n135300,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_135300_1,axiom,
    gt(n135300,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_135300_2,axiom,
    gt(n135300,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_135300_3,axiom,
    gt(n135300,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
