%------------------------------------------------------------------------------
% File     : SWV042+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation gauss_init_0081
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the init-safety verification for
%            the gauss program. init-safety ensures that each variable or
%            individual array element has been assigned a defined value before
%            it is used.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : gauss_init_0081 [Fis04]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.39 v9.0.0, 0.47 v8.2.0, 0.42 v7.5.0, 0.50 v7.4.0, 0.33 v7.3.0, 0.48 v7.2.0, 0.45 v7.1.0, 0.43 v7.0.0, 0.40 v6.4.0, 0.42 v6.3.0, 0.50 v6.2.0, 0.60 v6.1.0, 0.63 v6.0.0, 0.61 v5.5.0, 0.67 v5.4.0, 0.71 v5.3.0, 0.74 v5.2.0, 0.65 v5.1.0, 0.71 v5.0.0, 0.83 v4.0.0, 0.79 v3.7.0, 0.85 v3.5.0, 0.89 v3.4.0, 1.00 v3.3.0
% Syntax   : Number of formulae    :   85 (  49 unt;   0 def)
%            Number of atoms       :  279 (  92 equ)
%            Maximal formula atoms :   30 (   3 avg)
%            Number of connectives :  199 (   5   ~;  17   |; 110   &)
%                                         (   5 <=>;  62  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   36 (  36 usr;  18 con; 0-4 aty)
%            Number of variables   :  176 ( 176   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(gauss_init_0081,conjecture,
    ( ( ! [A] :
          ( ( leq(n0,A)
            & leq(A,n2) )
         => ! [B] :
              ( ( leq(n0,B)
                & leq(B,n3) )
             => a_select3(simplex7_init,B,A) = init ) )
      & ! [C] :
          ( ( leq(n0,C)
            & leq(C,n3) )
         => a_select2(s_values7_init,C) = init )
      & ! [D] :
          ( ( leq(n0,D)
            & leq(D,minus(plus(n1,n2),n1)) )
         => a_select2(s_center7_init,D) = init )
      & ( gt(loopcounter,n1)
       => ( pvar1400_init = init
          & pvar1401_init = init
          & pvar1402_init = init ) ) )
   => ( ! [E] :
          ( ( leq(n0,E)
            & leq(E,n2) )
         => ! [F] :
              ( ( leq(n0,F)
                & leq(F,n3) )
             => a_select3(simplex7_init,F,E) = init ) )
      & ! [G] :
          ( ( leq(n0,G)
            & leq(G,n3) )
         => a_select2(s_values7_init,G) = init )
      & ! [H] :
          ( ( leq(n0,H)
            & leq(H,n2) )
         => a_select2(s_center7_init,H) = init )
      & ( gt(loopcounter,n1)
       => ( pvar1400_init = init
          & pvar1401_init = init
          & pvar1402_init = init ) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
