%------------------------------------------------------------------------------
% File     : SWV037+1 : TPTP v9.2.0. Bugfixed v3.3.0.
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation gauss_init_0061
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the init-safety verification for
%            the gauss program. init-safety ensures that each variable or
%            individual array element has been assigned a defined value before
%            it is used.

% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : gauss_init_0061 [Fis04]

% Status   : Theorem
% Rating   : 0.82 v9.1.0, 0.73 v9.0.0, 0.78 v8.1.0, 0.75 v7.5.0, 0.81 v7.4.0, 0.70 v7.3.0, 0.69 v7.2.0, 0.66 v7.1.0, 0.74 v7.0.0, 0.73 v6.3.0, 0.79 v6.2.0, 0.88 v6.1.0, 0.93 v6.0.0, 0.91 v5.5.0, 0.93 v5.3.0, 0.96 v5.2.0, 0.90 v5.0.0, 0.88 v4.1.0, 0.83 v4.0.1, 0.91 v4.0.0, 0.92 v3.7.0, 0.85 v3.5.0, 0.84 v3.3.0
% Syntax   : Number of formulae    :  100 (  64 unt;   0 def)
%            Number of atoms       :  465 ( 163 equ)
%            Maximal formula atoms :  201 (   4 avg)
%            Number of connectives :  376 (  11   ~;  17   |; 247   &)
%                                         (   5 <=>;  96  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   42 (   4 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-2 aty)
%            Number of functors    :   55 (  55 usr;  34 con; 0-4 aty)
%            Number of variables   :  194 ( 194   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v3.3.0 - Bugfix in SWV003+0
%------------------------------------------------------------------------------
%----Include NASA software certification axioms
include('Axioms/SWV003+0.ax').
%------------------------------------------------------------------------------
%----Proof obligation generated by the AutoBayes/AutoFilter system
fof(gauss_init_0061,conjecture,
    ( ( s_best7_init = init
      & s_sworst7_init = init
      & s_worst7_init = init
      & leq(n0,s_best7)
      & leq(n0,s_sworst7)
      & leq(n0,s_worst7)
      & leq(s_best7,n3)
      & leq(s_sworst7,n3)
      & leq(s_worst7,n3)
      & ! [A] :
          ( ( leq(n0,A)
            & leq(A,n2) )
         => ! [B] :
              ( ( leq(n0,B)
                & leq(B,n3) )
             => a_select3(simplex7_init,B,A) = init ) )
      & ! [C] :
          ( ( leq(n0,C)
            & leq(C,n3) )
         => a_select2(s_values7_init,C) = init )
      & ! [D] :
          ( ( leq(n0,D)
            & leq(D,n2) )
         => a_select2(s_center7_init,D) = init )
      & ! [E] :
          ( ( leq(n0,E)
            & leq(E,minus(n3,n1)) )
         => a_select2(s_try7_init,E) = init )
      & ( gt(loopcounter,n1)
       => ( pvar1400_init = init
          & pvar1401_init = init
          & pvar1402_init = init ) ) )
   => ( init = init
      & s_worst7_init = init
      & a_select2(s_values7_init,s_worst7) = init
      & ( ~ gt(plus(log(n2),divide(minus(minus(minus(plus(log(n330),log(n410)),log(pv1410)),n1),log(n4)),n2)),a_select2(s_values7,s_worst7))
       => ( init = init
          & s_best7_init = init
          & a_select2(s_values7_init,s_best7) = init
          & ( ~ geq(plus(log(n2),divide(minus(minus(minus(plus(log(n330),log(n410)),log(pv1410)),n1),log(n4)),n2)),a_select2(s_values7,s_best7))
           => ( init = init
              & s_sworst7_init = init
              & a_select2(s_values7_init,s_sworst7) = init
              & ( ~ leq(plus(log(n2),divide(minus(minus(minus(plus(log(n330),log(n410)),log(pv1410)),n1),log(n4)),n2)),a_select2(s_values7,s_sworst7))
               => ( init = init
                  & ( ~ gt(loopcounter,n1)
                   => ( ! [F] :
                          ( ( leq(n0,F)
                            & leq(F,n2) )
                         => ! [G] :
                              ( ( leq(n0,G)
                                & leq(G,n3) )
                             => a_select3(simplex7_init,G,F) = init ) )
                      & ! [H] :
                          ( ( leq(n0,H)
                            & leq(H,n3) )
                         => a_select2(s_values7_init,H) = init )
                      & ( ~ geq(pv1403,tptp_float_0_001)
                       => ( s_best7_init = init
                          & s_sworst7_init = init
                          & s_worst7_init = init
                          & leq(n0,s_best7)
                          & leq(n0,s_sworst7)
                          & leq(n0,s_worst7)
                          & leq(s_best7,n3)
                          & leq(s_sworst7,n3)
                          & leq(s_worst7,n3) ) )
                      & ( gt(loopcounter,n0)
                       => ( s_best7_init = init
                          & s_sworst7_init = init
                          & s_worst7_init = init
                          & leq(n0,s_best7)
                          & leq(n0,s_sworst7)
                          & leq(n0,s_worst7)
                          & leq(s_best7,n3)
                          & leq(s_sworst7,n3)
                          & leq(s_worst7,n3) ) )
                      & ( gt(loopcounter,n0)
                       => ( a_select2(s_values7_init,s_best7) = init
                          & a_select2(s_values7_init,s_sworst7) = init
                          & a_select2(s_values7_init,s_worst7) = init ) ) ) )
                  & ( gt(loopcounter,n1)
                   => ( pvar1400_init = init
                      & pvar1401_init = init
                      & pvar1402_init = init
                      & s_best7_init = init
                      & s_sworst7_init = init
                      & s_worst7_init = init
                      & a_select2(s_values7_init,s_best7) = init
                      & a_select2(s_values7_init,s_sworst7) = init
                      & a_select2(s_values7_init,s_worst7) = init
                      & ! [I] :
                          ( ( leq(n0,I)
                            & leq(I,n2) )
                         => ! [J] :
                              ( ( leq(n0,J)
                                & leq(J,n3) )
                             => a_select3(simplex7_init,J,I) = init ) )
                      & ! [K] :
                          ( ( leq(n0,K)
                            & leq(K,n3) )
                         => a_select2(s_values7_init,K) = init )
                      & ( ~ geq(plus(abs(minus(a_select2(s_values7,s_best7),pv1400)),plus(abs(minus(a_select2(s_values7,s_sworst7),pv1401)),abs(minus(a_select2(s_values7,s_worst7),pv1402)))),tptp_float_0_001)
                       => ( s_best7_init = init
                          & s_sworst7_init = init
                          & s_worst7_init = init
                          & leq(n0,s_best7)
                          & leq(n0,s_sworst7)
                          & leq(n0,s_worst7)
                          & leq(s_best7,n3)
                          & leq(s_sworst7,n3)
                          & leq(s_worst7,n3) ) )
                      & ( gt(loopcounter,n0)
                       => ( s_best7_init = init
                          & s_sworst7_init = init
                          & s_worst7_init = init
                          & leq(n0,s_best7)
                          & leq(n0,s_sworst7)
                          & leq(n0,s_worst7)
                          & leq(s_best7,n3)
                          & leq(s_sworst7,n3)
                          & leq(s_worst7,n3) ) )
                      & ( gt(loopcounter,n0)
                       => ( a_select2(s_values7_init,s_best7) = init
                          & a_select2(s_values7_init,s_sworst7) = init
                          & a_select2(s_values7_init,s_worst7) = init ) ) ) ) ) )
              & ( leq(plus(log(n2),divide(minus(minus(minus(plus(log(n330),log(n410)),log(pv1410)),n1),log(n4)),n2)),a_select2(s_values7,s_sworst7))
               => ( s_best7_init = init
                  & s_sworst7_init = init
                  & s_worst7_init = init
                  & a_select2(s_values7_init,s_worst7) = init
                  & leq(n0,s_best7)
                  & leq(n0,s_sworst7)
                  & leq(n0,s_worst7)
                  & leq(s_best7,n3)
                  & leq(s_sworst7,n3)
                  & leq(s_worst7,n3)
                  & ! [L] :
                      ( ( leq(n0,L)
                        & leq(L,n2) )
                     => ! [M] :
                          ( ( leq(n0,M)
                            & leq(M,n3) )
                         => a_select3(simplex7_init,M,L) = init ) )
                  & ! [N] :
                      ( ( leq(n0,N)
                        & leq(N,n3) )
                     => a_select2(s_values7_init,N) = init )
                  & ! [O] :
                      ( ( leq(n0,O)
                        & leq(O,n2) )
                     => a_select2(s_center7_init,O) = init )
                  & ! [P] :
                      ( ( leq(n0,P)
                        & leq(P,minus(n3,n1)) )
                     => a_select2(s_try7_init,P) = init )
                  & ( gt(loopcounter,n1)
                   => ( pvar1400_init = init
                      & pvar1401_init = init
                      & pvar1402_init = init ) ) ) ) ) )
          & ( geq(plus(log(n2),divide(minus(minus(minus(plus(log(n330),log(n410)),log(pv1410)),n1),log(n4)),n2)),a_select2(s_values7,s_best7))
           => ( s_best7_init = init
              & s_sworst7_init = init
              & s_worst7_init = init
              & leq(n0,s_best7)
              & leq(n0,s_sworst7)
              & leq(n0,s_worst7)
              & leq(s_best7,n3)
              & leq(s_sworst7,n3)
              & leq(s_worst7,n3)
              & ! [Q] :
                  ( ( leq(n0,Q)
                    & leq(Q,n2) )
                 => ! [R] :
                      ( ( leq(n0,R)
                        & leq(R,n3) )
                     => a_select3(simplex7_init,R,Q) = init ) )
              & ! [S] :
                  ( ( leq(n0,S)
                    & leq(S,n3) )
                 => a_select2(s_values7_init,S) = init )
              & ! [T] :
                  ( ( leq(n0,T)
                    & leq(T,n2) )
                 => a_select2(s_center7_init,T) = init )
              & ! [U] :
                  ( ( leq(n0,U)
                    & leq(U,minus(n3,n1)) )
                 => a_select2(s_try7_init,U) = init )
              & ( gt(loopcounter,n1)
               => ( pvar1400_init = init
                  & pvar1401_init = init
                  & pvar1402_init = init ) ) ) ) ) )
      & ( gt(plus(log(n2),divide(minus(minus(minus(plus(log(n330),log(n410)),log(pv1410)),n1),log(n4)),n2)),a_select2(s_values7,s_worst7))
       => ( init = init
          & s_best7_init = init
          & s_sworst7_init = init
          & s_worst7_init = init
          & leq(n0,s_best7)
          & leq(n0,s_sworst7)
          & leq(n0,s_worst7)
          & leq(s_best7,n3)
          & leq(s_sworst7,n3)
          & leq(s_worst7,n3)
          & ! [V] :
              ( ( leq(n0,V)
                & leq(V,n2) )
             => ! [W] :
                  ( ( leq(n0,W)
                    & leq(W,n3) )
                 => a_select3(simplex7_init,W,V) = init ) )
          & ! [X] :
              ( ( leq(n0,X)
                & leq(X,n3) )
             => a_select2(tptp_update2(s_values7_init,s_worst7,init),X) = init )
          & ! [Y] :
              ( ( leq(n0,Y)
                & leq(Y,n2) )
             => a_select2(s_center7_init,Y) = init )
          & ! [Z] :
              ( ( leq(n0,Z)
                & leq(Z,minus(n3,n1)) )
             => a_select2(s_try7_init,Z) = init )
          & ( gt(loopcounter,n1)
           => ( pvar1400_init = init
              & pvar1401_init = init
              & pvar1402_init = init ) ) ) ) ) ) ).

%----Automatically generated axioms

fof(gt_5_4,axiom,
    gt(n5,n4) ).

fof(gt_330_4,axiom,
    gt(n330,n4) ).

fof(gt_410_4,axiom,
    gt(n410,n4) ).

fof(gt_330_5,axiom,
    gt(n330,n5) ).

fof(gt_410_5,axiom,
    gt(n410,n5) ).

fof(gt_410_330,axiom,
    gt(n410,n330) ).

fof(gt_4_tptp_minus_1,axiom,
    gt(n4,tptp_minus_1) ).

fof(gt_5_tptp_minus_1,axiom,
    gt(n5,tptp_minus_1) ).

fof(gt_330_tptp_minus_1,axiom,
    gt(n330,tptp_minus_1) ).

fof(gt_410_tptp_minus_1,axiom,
    gt(n410,tptp_minus_1) ).

fof(gt_0_tptp_minus_1,axiom,
    gt(n0,tptp_minus_1) ).

fof(gt_1_tptp_minus_1,axiom,
    gt(n1,tptp_minus_1) ).

fof(gt_2_tptp_minus_1,axiom,
    gt(n2,tptp_minus_1) ).

fof(gt_3_tptp_minus_1,axiom,
    gt(n3,tptp_minus_1) ).

fof(gt_4_0,axiom,
    gt(n4,n0) ).

fof(gt_5_0,axiom,
    gt(n5,n0) ).

fof(gt_330_0,axiom,
    gt(n330,n0) ).

fof(gt_410_0,axiom,
    gt(n410,n0) ).

fof(gt_1_0,axiom,
    gt(n1,n0) ).

fof(gt_2_0,axiom,
    gt(n2,n0) ).

fof(gt_3_0,axiom,
    gt(n3,n0) ).

fof(gt_4_1,axiom,
    gt(n4,n1) ).

fof(gt_5_1,axiom,
    gt(n5,n1) ).

fof(gt_330_1,axiom,
    gt(n330,n1) ).

fof(gt_410_1,axiom,
    gt(n410,n1) ).

fof(gt_2_1,axiom,
    gt(n2,n1) ).

fof(gt_3_1,axiom,
    gt(n3,n1) ).

fof(gt_4_2,axiom,
    gt(n4,n2) ).

fof(gt_5_2,axiom,
    gt(n5,n2) ).

fof(gt_330_2,axiom,
    gt(n330,n2) ).

fof(gt_410_2,axiom,
    gt(n410,n2) ).

fof(gt_3_2,axiom,
    gt(n3,n2) ).

fof(gt_4_3,axiom,
    gt(n4,n3) ).

fof(gt_5_3,axiom,
    gt(n5,n3) ).

fof(gt_330_3,axiom,
    gt(n330,n3) ).

fof(gt_410_3,axiom,
    gt(n410,n3) ).

fof(finite_domain_4,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n4) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4 ) ) ).

fof(finite_domain_5,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n5) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3
        | X = n4
        | X = n5 ) ) ).

fof(finite_domain_0,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n0) )
     => X = n0 ) ).

fof(finite_domain_1,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n1) )
     => ( X = n0
        | X = n1 ) ) ).

fof(finite_domain_2,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n2) )
     => ( X = n0
        | X = n1
        | X = n2 ) ) ).

fof(finite_domain_3,axiom,
    ! [X] :
      ( ( leq(n0,X)
        & leq(X,n3) )
     => ( X = n0
        | X = n1
        | X = n2
        | X = n3 ) ) ).

fof(successor_4,axiom,
    succ(succ(succ(succ(n0)))) = n4 ).

fof(successor_5,axiom,
    succ(succ(succ(succ(succ(n0))))) = n5 ).

fof(successor_1,axiom,
    succ(n0) = n1 ).

fof(successor_2,axiom,
    succ(succ(n0)) = n2 ).

fof(successor_3,axiom,
    succ(succ(succ(n0))) = n3 ).

%------------------------------------------------------------------------------
