%--------------------------------------------------------------------------
% File     : SWC418+1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_turn_x_rot_l_total1
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [Wei00]
% Names    : cond_turn_x_rot_l_total1 [Wei00]

% Status   : Theorem
% Rating   : 0.73 v9.0.0, 0.75 v8.1.0, 0.67 v7.5.0, 0.75 v7.4.0, 0.70 v7.3.0, 0.76 v7.1.0, 0.70 v7.0.0, 0.67 v6.4.0, 0.73 v6.3.0, 0.75 v6.2.0, 0.92 v6.1.0, 0.93 v6.0.0, 0.96 v5.3.0, 1.00 v5.2.0, 0.95 v5.0.0, 0.96 v4.1.0, 1.00 v2.7.0, 0.83 v2.6.0, 1.00 v2.4.0
% Syntax   : Number of formulae    :   96 (   9 unt;   0 def)
%            Number of atoms       :  420 (  82 equ)
%            Maximal formula atoms :   26 (   4 avg)
%            Number of connectives :  353 (  29   ~;  13   |;  54   &)
%                                         (  26 <=>; 231  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   29 (   7 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :    5 (   5 usr;   1 con; 0-2 aty)
%            Number of variables   :  214 ( 194   !;  20   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001+0.ax').
%--------------------------------------------------------------------------
fof(co1,conjecture,
    ! [U] :
      ( ssList(U)
     => ! [V] :
          ( ssList(V)
         => ! [W] :
              ( ssList(W)
             => ! [X] :
                  ( ssList(X)
                 => ( V != X
                    | U != W
                    | ~ neq(V,nil)
                    | ? [Y] :
                        ( ssItem(Y)
                        & ? [Z] :
                            ( ssList(Z)
                            & ? [X1] :
                                ( ssList(X1)
                                & app(app(Z,cons(Y,nil)),X1) = V
                                & app(app(X1,cons(Y,nil)),Z) = U ) ) )
                    | ( nil != W
                      & nil = X )
                    | ( ? [X2] :
                          ( ssList(X2)
                          & W != X2
                          & ? [X3] :
                              ( ssList(X3)
                              & ? [X4] :
                                  ( ssList(X4)
                                  & tl(X) = X3
                                  & app(X3,X4) = X2
                                  & ? [X5] :
                                      ( ssItem(X5)
                                      & cons(X5,nil) = X4
                                      & hd(X) = X5
                                      & neq(nil,X) )
                                  & neq(nil,X) ) ) )
                      & neq(X,nil) ) ) ) ) ) ) ).

%--------------------------------------------------------------------------
