%--------------------------------------------------------------------------
% File     : SWC396+1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_subst_x_rot_r_total1
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [Wei00]
% Names    : cond_subst_x_rot_r_total1 [Wei00]

% Status   : Theorem
% Rating   : 0.70 v9.1.0, 0.73 v9.0.0, 0.75 v8.2.0, 0.72 v8.1.0, 0.69 v7.5.0, 0.78 v7.4.0, 0.63 v7.3.0, 0.72 v7.1.0, 0.70 v6.4.0, 0.69 v6.3.0, 0.75 v6.2.0, 0.92 v6.1.0, 0.93 v6.0.0, 0.96 v5.2.0, 0.95 v5.0.0, 0.96 v4.1.0, 1.00 v3.3.0, 0.93 v3.2.0, 1.00 v2.4.0
% Syntax   : Number of formulae    :   96 (   9 unt;   0 def)
%            Number of atoms       :  418 (  80 equ)
%            Maximal formula atoms :   24 (   4 avg)
%            Number of connectives :  352 (  30   ~;  14   |;  50   &)
%                                         (  26 <=>; 232  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   29 (   7 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :    5 (   5 usr;   1 con; 0-2 aty)
%            Number of variables   :  212 ( 195   !;  17   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001+0.ax').
%--------------------------------------------------------------------------
fof(co1,conjecture,
    ! [U] :
      ( ssList(U)
     => ! [V] :
          ( ssList(V)
         => ! [W] :
              ( ssList(W)
             => ! [X] :
                  ( ssList(X)
                 => ( V != X
                    | U != W
                    | ! [Y] :
                        ( ssItem(Y)
                       => ( ~ memberP(U,Y)
                          | memberP(V,Y) ) )
                    | ( nil != W
                      & nil = X )
                    | ( neq(X,nil)
                      & ( ~ neq(W,nil)
                        | ? [Z] :
                            ( ssList(Z)
                            & X != Z
                            & ? [X1] :
                                ( ssList(X1)
                                & ? [X2] :
                                    ( ssList(X2)
                                    & tl(W) = X1
                                    & app(X1,X2) = Z
                                    & ? [X3] :
                                        ( ssItem(X3)
                                        & cons(X3,nil) = X2
                                        & hd(W) = X3
                                        & neq(nil,W) )
                                    & neq(nil,W) ) ) ) ) ) ) ) ) ) ) ).

%--------------------------------------------------------------------------
