%--------------------------------------------------------------------------
% File     : SWC319-1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_rot_r_total1_x_rot_r_total3
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [TPTP]
% Names    :

% Status   : Satisfiable
% Rating   : 1.00 v6.3.0, 0.88 v6.2.0, 0.90 v6.1.0, 1.00 v2.4.0
% Syntax   : Number of clauses     :  197 (  60 unt;  34 nHn; 154 RR)
%            Number of literals    :  646 ( 118 equ; 428 neg)
%            Maximal clause size   :   13 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :   53 (  53 usr;   7 con; 0-2 aty)
%            Number of variables   :  336 (  49 sgn)
% SPC      : CNF_SAT_RFO_EQU_NUE

% Comments : Created by CNF conversion from SWC319+1
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001-0.ax').
%--------------------------------------------------------------------------
cnf(co1_1,negated_conjecture,
    ssList(sk1) ).

cnf(co1_2,negated_conjecture,
    ssList(sk2) ).

cnf(co1_3,negated_conjecture,
    ssList(sk3) ).

cnf(co1_4,negated_conjecture,
    ssList(sk4) ).

cnf(co1_5,negated_conjecture,
    sk2 = sk4 ).

cnf(co1_6,negated_conjecture,
    sk1 = sk3 ).

cnf(co1_7,negated_conjecture,
    ( ~ ssItem(A)
    | ~ ssList(B)
    | app(cons(A,nil),B) = sk3
    | app(B,cons(A,nil)) != sk4 ) ).

cnf(co1_8,negated_conjecture,
    ( nil = sk3
    | nil != sk4 ) ).

cnf(co1_9,negated_conjecture,
    ( nil = sk2
    | neq(sk2,nil) ) ).

cnf(co1_10,negated_conjecture,
    ( nil = sk2
    | ~ ssList(A)
    | sk2 != A
    | ~ ssList(B)
    | ~ ssList(C)
    | tl(sk1) != B
    | app(B,C) != A
    | ~ ssItem(D)
    | cons(D,nil) != C
    | hd(sk1) != D
    | ~ neq(nil,sk1)
    | ~ neq(nil,sk1)
    | ~ neq(sk1,nil) ) ).

cnf(co1_11,negated_conjecture,
    ( nil != sk1
    | neq(sk2,nil) ) ).

cnf(co1_12,negated_conjecture,
    ( nil != sk1
    | ~ ssList(A)
    | sk2 != A
    | ~ ssList(B)
    | ~ ssList(C)
    | tl(sk1) != B
    | app(B,C) != A
    | ~ ssItem(D)
    | cons(D,nil) != C
    | hd(sk1) != D
    | ~ neq(nil,sk1)
    | ~ neq(nil,sk1)
    | ~ neq(sk1,nil) ) ).

%--------------------------------------------------------------------------
