%--------------------------------------------------------------------------
% File     : SWC308+1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_rot_l1_x_rot_l_total3
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [Wei00]
% Names    : cond_rot_l1_x_rot_l_total3 [Wei00]

% Status   : Theorem
% Rating   : 0.55 v9.1.0, 0.58 v8.2.0, 0.61 v8.1.0, 0.56 v7.5.0, 0.66 v7.4.0, 0.60 v7.3.0, 0.66 v7.1.0, 0.70 v7.0.0, 0.63 v6.4.0, 0.69 v6.3.0, 0.75 v6.2.0, 0.84 v6.1.0, 0.90 v6.0.0, 0.91 v5.5.0, 0.96 v5.3.0, 1.00 v5.2.0, 0.95 v5.1.0, 0.90 v5.0.0, 0.92 v4.1.0, 0.96 v3.7.0, 0.95 v3.3.0, 1.00 v2.4.0
% Syntax   : Number of formulae    :   96 (   9 unt;   0 def)
%            Number of atoms       :  418 (  82 equ)
%            Maximal formula atoms :   24 (   4 avg)
%            Number of connectives :  351 (  29   ~;  13   |;  52   &)
%                                         (  26 <=>; 231  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   27 (   7 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :    5 (   5 usr;   1 con; 0-2 aty)
%            Number of variables   :  213 ( 194   !;  19   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001+0.ax').
%--------------------------------------------------------------------------
fof(co1,conjecture,
    ! [U] :
      ( ssList(U)
     => ! [V] :
          ( ssList(V)
         => ! [W] :
              ( ssList(W)
             => ! [X] :
                  ( ssList(X)
                 => ( V != X
                    | U != W
                    | ~ neq(V,nil)
                    | ? [Y] :
                        ( ssList(Y)
                        & U = Y
                        & ? [Z] :
                            ( ssList(Z)
                            & ? [X1] :
                                ( ssList(X1)
                                & tl(V) = Z
                                & app(Z,X1) = Y
                                & ? [X2] :
                                    ( ssItem(X2)
                                    & cons(X2,nil) = X1
                                    & hd(V) = X2
                                    & neq(nil,V) )
                                & neq(nil,V) ) ) )
                    | ? [X3] :
                        ( ssItem(X3)
                        & ? [X4] :
                            ( ssList(X4)
                            & app(X4,cons(X3,nil)) != W
                            & app(cons(X3,nil),X4) = X ) )
                    | ( nil != W
                      & nil = X ) ) ) ) ) ) ).

%--------------------------------------------------------------------------
