%--------------------------------------------------------------------------
% File     : SWC307+1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_pst_top_sorted_x_some_total3
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [Wei00]
% Names    : cond_pst_top_sorted_x_some_total3 [Wei00]

% Status   : Theorem
% Rating   : 0.70 v9.1.0, 0.73 v9.0.0, 0.75 v8.1.0, 0.78 v7.5.0, 0.81 v7.4.0, 0.70 v7.3.0, 0.72 v7.1.0, 0.65 v7.0.0, 0.77 v6.3.0, 0.67 v6.2.0, 0.80 v6.1.0, 0.87 v6.0.0, 0.78 v5.5.0, 0.85 v5.4.0, 0.89 v5.2.0, 0.80 v5.1.0, 0.86 v5.0.0, 0.88 v4.1.0, 0.91 v4.0.0, 0.92 v3.7.0, 0.90 v3.5.0, 0.89 v3.3.0, 0.86 v3.2.0, 0.91 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 1.00 v2.4.0
% Syntax   : Number of formulae    :   96 (   9 unt;   0 def)
%            Number of atoms       :  410 (  74 equ)
%            Maximal formula atoms :   16 (   4 avg)
%            Number of connectives :  344 (  30   ~;  13   |;  39   &)
%                                         (  26 <=>; 236  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   25 (   7 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :    5 (   5 usr;   1 con; 0-2 aty)
%            Number of variables   :  212 ( 199   !;  13   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001+0.ax').
%--------------------------------------------------------------------------
fof(co1,conjecture,
    ! [U] :
      ( ssList(U)
     => ! [V] :
          ( ssList(V)
         => ! [W] :
              ( ssList(W)
             => ! [X] :
                  ( ssList(X)
                 => ( V != X
                    | U != W
                    | ~ segmentP(X,W)
                    | ! [Y] :
                        ( ssItem(Y)
                       => ! [Z] :
                            ( ssItem(Z)
                           => ! [X1] :
                                ( ssList(X1)
                               => ! [X2] :
                                    ( ssList(X2)
                                   => ! [X3] :
                                        ( ssList(X3)
                                       => ( app(app(app(app(X1,cons(Y,nil)),X2),cons(Z,nil)),X3) != U
                                          | ~ lt(Z,Y) ) ) ) ) ) )
                    | ( ~ singletonP(W)
                      & neq(X,nil) ) ) ) ) ) ) ).

%--------------------------------------------------------------------------
