%--------------------------------------------------------------------------
% File     : SWC186-1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_pst_different3_x_run_strict_ord_front1
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [TPTP]
% Names    :

% Status   : Unsatisfiable
% Rating   : 1.00 v8.2.0, 0.95 v8.1.0, 0.84 v7.5.0, 1.00 v2.4.0
% Syntax   : Number of clauses     :  199 (  66 unt;  34 nHn; 156 RR)
%            Number of literals    :  623 ( 101 equ; 403 neg)
%            Maximal clause size   :   10 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :   56 (  56 usr;  10 con; 0-2 aty)
%            Number of variables   :  327 (  49 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : Created by CNF conversion from SWC186+1
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001-0.ax').
%--------------------------------------------------------------------------
cnf(co1_1,negated_conjecture,
    ssList(sk1) ).

cnf(co1_2,negated_conjecture,
    ssList(sk2) ).

cnf(co1_3,negated_conjecture,
    ssList(sk3) ).

cnf(co1_4,negated_conjecture,
    ssList(sk4) ).

cnf(co1_5,negated_conjecture,
    sk2 = sk4 ).

cnf(co1_6,negated_conjecture,
    sk1 = sk3 ).

cnf(co1_7,negated_conjecture,
    frontsegP(sk4,sk3) ).

cnf(co1_8,negated_conjecture,
    strictorderedP(sk3) ).

cnf(co1_9,negated_conjecture,
    ( ~ ssList(A)
    | ~ neq(sk3,A)
    | ~ frontsegP(sk4,A)
    | ~ segmentP(A,sk3)
    | ~ strictorderedP(A) ) ).

cnf(co1_10,negated_conjecture,
    ssItem(sk5) ).

cnf(co1_11,negated_conjecture,
    ssList(sk6) ).

cnf(co1_12,negated_conjecture,
    ssList(sk7) ).

cnf(co1_13,negated_conjecture,
    app(app(sk6,cons(sk5,nil)),sk7) = sk1 ).

cnf(co1_14,negated_conjecture,
    ( memberP(sk6,sk5)
    | memberP(sk7,sk5) ) ).

%--------------------------------------------------------------------------
