%--------------------------------------------------------------------------
% File     : SWC066-1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Software Creation
% Problem  : cond_id_segment_total1_x_run_ord_max1
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.

% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [TPTP]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.59 v9.1.0, 0.65 v8.2.0, 0.67 v8.1.0, 0.68 v7.5.0, 0.63 v7.4.0, 0.65 v7.3.0, 0.67 v7.1.0, 0.58 v7.0.0, 0.67 v6.4.0, 0.73 v6.2.0, 0.80 v6.1.0, 0.93 v6.0.0, 0.80 v5.5.0, 1.00 v5.2.0, 0.94 v5.0.0, 0.86 v4.1.0, 0.92 v4.0.1, 0.91 v3.7.0, 0.90 v3.5.0, 0.91 v3.4.0, 0.92 v3.3.0, 0.86 v3.2.0, 0.92 v3.1.0, 0.91 v2.7.0, 1.00 v2.4.0
% Syntax   : Number of clauses     :  198 (  62 unt;  34 nHn; 155 RR)
%            Number of literals    :  631 ( 104 equ; 413 neg)
%            Maximal clause size   :   10 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :   53 (  53 usr;   7 con; 0-2 aty)
%            Number of variables   :  329 (  49 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : Created by CNF conversion from SWC066+1
%--------------------------------------------------------------------------
%----Include list specification axioms
include('Axioms/SWC001-0.ax').
%--------------------------------------------------------------------------
cnf(co1_1,negated_conjecture,
    ssList(sk1) ).

cnf(co1_2,negated_conjecture,
    ssList(sk2) ).

cnf(co1_3,negated_conjecture,
    ssList(sk3) ).

cnf(co1_4,negated_conjecture,
    ssList(sk4) ).

cnf(co1_5,negated_conjecture,
    sk2 = sk4 ).

cnf(co1_6,negated_conjecture,
    sk1 = sk3 ).

cnf(co1_7,negated_conjecture,
    segmentP(sk4,sk3) ).

cnf(co1_8,negated_conjecture,
    totalorderedP(sk3) ).

cnf(co1_9,negated_conjecture,
    ( ~ ssList(A)
    | ~ neq(sk3,A)
    | ~ segmentP(sk4,A)
    | ~ segmentP(A,sk3)
    | ~ totalorderedP(A) ) ).

cnf(co1_10,negated_conjecture,
    ( nil = sk2
    | neq(sk2,nil) ) ).

cnf(co1_11,negated_conjecture,
    ( nil = sk2
    | ~ ssList(A)
    | ~ neq(A,nil)
    | ~ segmentP(sk2,A)
    | ~ segmentP(sk1,A) ) ).

cnf(co1_12,negated_conjecture,
    ( nil != sk1
    | neq(sk2,nil) ) ).

cnf(co1_13,negated_conjecture,
    ( nil != sk1
    | ~ ssList(A)
    | ~ neq(A,nil)
    | ~ segmentP(sk2,A)
    | ~ segmentP(sk1,A) ) ).

%--------------------------------------------------------------------------
