%------------------------------------------------------------------------------
% File     : SWB109_15 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Semantic Web
% Problem  : Querying description logic knowledge bases
% Version  : [QMLTP] axioms.
% English  :

% Refs     : [CD+07] Calvanese et al. (2007), EQL-Lite: Effective First-Ord
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : APM006+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   21 (   2 unt;  14 typ;   0 def)
%            Number of atoms       :   31 (   0 equ)
%            Maximal formula atoms :   11 (   4 avg)
%            Number of connectives :   26 (   2   ~;   0   |;  14   &)
%                                         (   1 <=>;   9  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   13 (   6   >;   7   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   6 usr;   0 prp; 2-3 aty)
%            Number of functors    :    7 (   7 usr;   7 con; 0-0 aty)
%            Number of variables   :   15 (;  12   !;   3   ?;  15   :)
% SPC      : TF0_CSA_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_D, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_serial,axiom,
    ! [W: '$ki_world'] :
    ? [V: '$ki_world'] : '$ki_accessible'(W,V) ).

tff(ann_decl,type,
    ann: $i ).

tff(mary_decl,type,
    mary: $i ).

tff(bob_decl,type,
    bob: $i ).

tff(john_decl,type,
    john: $i ).

tff(paul_decl,type,
    paul: $i ).

tff(jane_decl,type,
    jane: $i ).

tff(parent_decl,type,
    parent: ( '$ki_world' * $i * $i ) > $o ).

tff(q2_decl,type,
    q2: ( '$ki_world' * $i ) > $o ).

tff(female_decl,type,
    female: ( '$ki_world' * $i ) > $o ).

tff(male_decl,type,
    male: ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_cumul',axiom,
    ! [W: '$ki_world',V: '$ki_world',X: $i] :
      ( ( '$ki_exists_in_world_$i'(W,X)
        & '$ki_accessible'(W,V) )
     => '$ki_exists_in_world_$i'(V,X) ) ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(abox,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( female(W,mary)
        & female(W,ann)
        & female(W,jane)
        & male(W,bob)
        & male(W,john)
        & male(W,paul)
        & parent(W,bob,mary)
        & parent(W,bob,ann)
        & parent(W,john,paul)
        & parent(W,mary,jane) ) ) ).

tff(tbox,axiom,
    ! [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
     => ( ! [W: '$ki_world'] :
            ( '$ki_accessible'('$ki_local_world',W)
           => male(W,X) )
       => ! [W: '$ki_world'] :
            ( '$ki_accessible'('$ki_local_world',W)
           => ~ female(W,X) ) ) ) ).

tff(query,axiom,
    ! [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
     => ( q2('$ki_local_world',X)
      <=> ( ! [W: '$ki_world'] :
              ( '$ki_accessible'('$ki_local_world',W)
             => male(W,X) )
          & ~ ! [W: '$ki_world'] :
                ( '$ki_accessible'('$ki_local_world',W)
               => ? [Y: $i] :
                    ( '$ki_exists_in_world_$i'(W,Y)
                    & parent(W,X,Y)
                    & female(W,Y) ) ) ) ) ) ).

tff(verify,conjecture,
    ( q2('$ki_local_world',john)
    & q2('$ki_local_world',paul) ) ).

%------------------------------------------------------------------------------
