%------------------------------------------------------------------------------
% File     : SWB040+1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Semantic Web
% Problem  : Class Modus Tollens
% Version  : [Sch11] axioms.
% English  : If a class is subsumed by another class, then the complement of 
%            the latter class is subsumed by the complement of the former 
%            class.

% Refs     : [Sch11] Schneider, M. (2011), Email to G. Sutcliffe
% Source   : [Sch11]
% Names    : rdfbased-sem-bool-tollens [Sch11]

% Status   : Theorem
% Rating   : 0.61 v9.1.0, 0.52 v9.0.0, 0.58 v8.1.0, 0.56 v7.4.0, 0.53 v7.3.0, 0.55 v7.2.0, 0.52 v7.1.0, 0.43 v7.0.0, 0.47 v6.4.0, 0.50 v6.2.0, 0.64 v6.1.0, 0.80 v6.0.0, 0.87 v5.5.0, 0.89 v5.3.0, 0.93 v5.2.0
% Syntax   : Number of formulae    :  560 ( 197 unt;   0 def)
%            Number of atoms       : 1776 (  90 equ)
%            Maximal formula atoms :   32 (   3 avg)
%            Number of connectives : 1352 ( 136   ~;  35   |; 760   &)
%                                         ( 126 <=>; 295  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   27 (   5 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :   13 (  12 usr;   1 prp; 0-3 aty)
%            Number of functors    :  161 ( 161 usr; 160 con; 0-2 aty)
%            Number of variables   :  973 ( 911   !;  62   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%------------------------------------------------------------------------------
%----Include OWL 2 Full axioms
include('Axioms/SWB001+0.ax').
%------------------------------------------------------------------------------
fof(conclusion_rdfbased_sem_bool_tollens,conjecture,
    iext(uri_rdfs_subClassOf,uri_ex_n2,uri_ex_n1) ).

fof(premise_rdfbased_sem_bool_tollens,axiom,
    ( iext(uri_owl_complementOf,uri_ex_n2,uri_ex_c2)
    & iext(uri_owl_complementOf,uri_ex_n1,uri_ex_c1)
    & iext(uri_rdfs_subClassOf,uri_ex_c1,uri_ex_c2) ) ).

%------------------------------------------------------------------------------
