%------------------------------------------------------------------------------
% File     : SEV519+1 : TPTP v9.2.0. Released v7.3.0.
% Domain   : Set Theory
% Problem  : The empty set is not element of a non-overlapping family
% Version  : [Pas99] axioms
% English  : Every element of the difference of a set A and another set B
%            ends up in an element of a partition of A, but not in an element
%            of the partition of B.

% Refs     : [Cam15] Caminati (2015), Email to G. Sutcliffe
%          : [CK+15] Caminati et al. (2015), Sound Auction Specification an
% Source   : [Cam15]
% Names    : no_empty_in_non_overlapping [Cam15]

% Status   : Theorem
% Rating   : 1.00 v7.3.0
% Syntax   : Number of formulae    :   20 (   2 unt;   0 def)
%            Number of atoms       :   77 (   6 equ)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives :   61 (   4   ~;   2   |;  22   &)
%                                         (  18 <=>;  15  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-3 aty)
%            Number of functors    :   12 (  12 usr;   1 con; 0-3 aty)
%            Number of variables   :   67 (  61   !;   6   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Problem extracted from the Auction Theory Toolbox.
%------------------------------------------------------------------------------
%----Include set theory definitions
include('Axioms/SET006+0.ax').
%----Include partition axioms
include('Axioms/SET006+2.ax').
%------------------------------------------------------------------------------
fof(non_overlapping,axiom,
    ! [X] :
      ( non_overlapping(X)
    <=> ? [U] : partition(X,U) ) ).

fof(insertIntoMember,axiom,
    ! [A,B,C] : insertIntoMember(A,B,C) = union(union(B,singleton(A)),difference(C,singleton(B))) ).

fof(d4_tarski,axiom,
    ! [A,B] :
      ( B = unaryUnion(A)
    <=> ! [C] :
          ( member(C,B)
        <=> ? [D] :
              ( member(C,D)
              & member(D,A) ) ) ) ).

fof(no_empty_in_non_overlapping,conjecture,
    ! [P] :
      ( non_overlapping(P)
     => ~ member(empty_set,P) ) ).

%------------------------------------------------------------------------------
