%------------------------------------------------------------------------------
% File     : SET888+1 : TPTP v9.2.0. Released v3.2.0.
% Domain   : Set theory
% Problem  : Basic properties of sets, theorem 29
% Version  : [Urb06] axioms : Especial.
% English  :

% Refs     : [Byl90] Bylinski (1990), Some Basic Properties of Sets
%          : [Urb06] Urban (2006), Email to G. Sutcliffe
% Source   : [Urb06]
% Names    : zfmisc_1__t29_zfmisc_1 [Urb06]

% Status   : Theorem
% Rating   : 0.73 v9.1.0, 0.70 v9.0.0, 0.72 v8.1.0, 0.69 v7.4.0, 0.63 v7.3.0, 0.59 v7.1.0, 0.65 v7.0.0, 0.73 v6.3.0, 0.75 v6.2.0, 0.92 v6.1.0, 0.93 v6.0.0, 0.91 v5.5.0, 0.89 v5.3.0, 0.93 v5.2.0, 0.95 v5.0.0, 0.96 v4.1.0, 0.91 v4.0.0, 0.88 v3.7.0, 0.90 v3.5.0, 0.89 v3.4.0, 0.95 v3.3.0, 0.86 v3.2.0
% Syntax   : Number of formulae    :   14 (   7 unt;   0 def)
%            Number of atoms       :   25 (  12 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   19 (   8   ~;   1   |;   0   &)
%                                         (   6 <=>;   4  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   4 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    3 (   2 usr;   0 prp; 1-2 aty)
%            Number of functors    :    5 (   5 usr;   0 con; 1-2 aty)
%            Number of variables   :   30 (  28   !;   2   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Translated by MPTP 0.2 from the original problem in the Mizar
%            library, www.mizar.org
%------------------------------------------------------------------------------
fof(antisymmetry_r2_hidden,axiom,
    ! [A,B] :
      ( in(A,B)
     => ~ in(B,A) ) ).

fof(commutativity_k2_tarski,axiom,
    ! [A,B] : unordered_pair(A,B) = unordered_pair(B,A) ).

fof(commutativity_k2_xboole_0,axiom,
    ! [A,B] : set_union2(A,B) = set_union2(B,A) ).

fof(commutativity_k5_xboole_0,axiom,
    ! [A,B] : symmetric_difference(A,B) = symmetric_difference(B,A) ).

fof(d1_tarski,axiom,
    ! [A,B] :
      ( B = singleton(A)
    <=> ! [C] :
          ( in(C,B)
        <=> C = A ) ) ).

fof(d2_tarski,axiom,
    ! [A,B,C] :
      ( C = unordered_pair(A,B)
    <=> ! [D] :
          ( in(D,C)
        <=> ( D = A
            | D = B ) ) ) ).

fof(d6_xboole_0,axiom,
    ! [A,B] : symmetric_difference(A,B) = set_union2(set_difference(A,B),set_difference(B,A)) ).

fof(fc2_xboole_0,axiom,
    ! [A,B] :
      ( ~ empty(A)
     => ~ empty(set_union2(A,B)) ) ).

fof(fc3_xboole_0,axiom,
    ! [A,B] :
      ( ~ empty(A)
     => ~ empty(set_union2(B,A)) ) ).

fof(idempotence_k2_xboole_0,axiom,
    ! [A,B] : set_union2(A,A) = A ).

fof(rc1_xboole_0,axiom,
    ? [A] : empty(A) ).

fof(rc2_xboole_0,axiom,
    ? [A] : ~ empty(A) ).

fof(t1_xboole_0,axiom,
    ! [A,B,C] :
      ( in(A,symmetric_difference(B,C))
    <=> ~ ( in(A,B)
        <=> in(A,C) ) ) ).

fof(t29_zfmisc_1,conjecture,
    ! [A,B] :
      ( A != B
     => symmetric_difference(singleton(A),singleton(B)) = unordered_pair(A,B) ) ).

%------------------------------------------------------------------------------
