%------------------------------------------------------------------------------
% File     : SET830-1 : TPTP v9.2.0. Released v3.2.0.
% Domain   : Set Theory
% Problem  : Problem about set theory
% Version  : [Pau06] axioms : Especial.
% English  :

% Refs     : [Pau06] Paulson (2006), Email to G. Sutcliffe
% Source   : [Pau06]
% Names    : set__equal_inter_5 [Pau06]

% Status   : Unsatisfiable
% Rating   : 0.50 v9.0.0, 0.55 v8.2.0, 0.57 v8.1.0, 0.58 v7.4.0, 0.59 v7.3.0, 0.67 v7.1.0, 0.58 v7.0.0, 0.60 v6.4.0, 0.73 v6.3.0, 0.64 v6.2.0, 0.60 v6.1.0, 0.71 v6.0.0, 0.80 v5.5.0, 0.90 v5.4.0, 0.85 v5.3.0, 0.89 v5.2.0, 0.88 v5.0.0, 0.86 v4.1.0, 0.92 v4.0.1, 0.82 v3.7.0, 0.80 v3.5.0, 0.82 v3.4.0, 0.83 v3.3.0, 0.86 v3.2.0
% Syntax   : Number of clauses     : 1363 ( 221 unt;  28 nHn;1277 RR)
%            Number of literals    : 2568 ( 193 equ;1218 neg)
%            Maximal clause size   :    4 (   1 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :   82 (  81 usr;   0 prp; 1-3 aty)
%            Number of functors    :  125 ( 125 usr;  22 con; 0-6 aty)
%            Number of variables   : 1909 ( 210 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : The problems in the [Pau06] collection each have very many axioms,
%            of which only a small selection are required for the refutation.
%            The mission is to find those few axioms, after which a refutation
%            can be quite easily found.
%------------------------------------------------------------------------------
include('Axioms/MSC001-2.ax').
include('Axioms/MSC001-0.ax').
%------------------------------------------------------------------------------
cnf(cls_conjecture_0,negated_conjecture,
    c_lessequals(v_X,v_Y,tc_set(t_a)) ).

cnf(cls_conjecture_1,negated_conjecture,
    c_lessequals(v_X,v_Z,tc_set(t_a)) ).

cnf(cls_conjecture_2,negated_conjecture,
    c_in(v_x,v_Y,t_a) ).

cnf(cls_conjecture_3,negated_conjecture,
    c_in(v_x,v_Z,t_a) ).

cnf(cls_conjecture_4,negated_conjecture,
    ~ c_in(v_x,v_X,t_a) ).

cnf(cls_conjecture_5,negated_conjecture,
    ( c_lessequals(V_U,v_X,tc_set(t_a))
    | ~ c_lessequals(V_U,v_Z,tc_set(t_a))
    | ~ c_lessequals(V_U,v_Y,tc_set(t_a)) ) ).

%------------------------------------------------------------------------------
