%--------------------------------------------------------------------------
% File     : SET685+3 : TPTP v9.2.0. Released v2.2.0.
% Domain   : Set Theory (Relations)
% Problem  : y in R (X to Y) o D1 iff ?x in D : <x,y> in R & x in D1
% Version  : [Wor90] axioms : Reduced > Incomplete.
% English  : y is in a relation R from X to Y composed with D1 iff there
%            exists an element x in D such that <x,y> is in R and x is in D1.

% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor90] Woronowicz (1990), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (52) [Wor90]

% Status   : Theorem
% Rating   : 0.55 v9.0.0, 0.56 v8.2.0, 0.58 v8.1.0, 0.56 v7.5.0, 0.53 v7.4.0, 0.50 v7.3.0, 0.55 v7.2.0, 0.52 v7.1.0, 0.43 v7.0.0, 0.40 v6.4.0, 0.46 v6.3.0, 0.50 v6.2.0, 0.60 v6.0.0, 0.57 v5.5.0, 0.67 v5.4.0, 0.68 v5.3.0, 0.70 v5.2.0, 0.55 v5.1.0, 0.57 v5.0.0, 0.62 v4.1.0, 0.61 v4.0.1, 0.57 v4.0.0, 0.58 v3.7.0, 0.55 v3.5.0, 0.53 v3.4.0, 0.58 v3.3.0, 0.50 v3.2.0, 0.45 v3.1.0, 0.56 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.50 v2.3.0, 0.33 v2.2.1
% Syntax   : Number of formulae    :   28 (   2 unt;   0 def)
%            Number of atoms       :  123 (   6 equ)
%            Maximal formula atoms :   12 (   4 avg)
%            Number of connectives :  102 (   7   ~;   0   |;  16   &)
%                                         (  11 <=>;  68  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   15 (   7 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-2 aty)
%            Number of functors    :   12 (  12 usr;   2 con; 0-4 aty)
%            Number of variables   :   74 (  66   !;   8   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%---- line(relat_1 - th(142),1919963)
fof(p1,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,binary_relation_type)
             => ( member(C,image(D,B))
              <=> ? [E] :
                    ( ilf_type(E,set_type)
                    & member(ordered_pair(E,C),D)
                    & member(E,B) ) ) ) ) ) ).

%---- line(relset_1 - th(7),1916125)
fof(p2,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,set_type)
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => ! [F] :
                      ( ilf_type(F,relation_type(B,C))
                     => ( member(ordered_pair(D,E),F)
                       => ( member(D,B)
                          & member(E,C) ) ) ) ) ) ) ) ).

%---- line(tarski - df(5),1832760)
fof(p3,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,set_type)
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => ! [F] :
                      ( ilf_type(F,set_type)
                     => ( F = ordered_pair(D,E)
                      <=> F = unordered_pair(unordered_pair(D,E),singleton(D)) ) ) ) ) ) ) ).

%---- declaration(line(tarski - df(5),1832760))
fof(p4,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(ordered_pair(B,C),set_type) ) ) ).

%---- line(relset_1 - df(1),1916080)
fof(p5,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,subset_type(cross_product(B,C)))
               => ilf_type(D,relation_type(B,C)) )
            & ! [E] :
                ( ilf_type(E,relation_type(B,C))
               => ilf_type(E,subset_type(cross_product(B,C))) ) ) ) ) ).

%---- type_nonempty(line(relset_1 - df(1),1916080))
fof(p6,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ? [D] : ilf_type(D,relation_type(C,B)) ) ) ).

%---- line(hidden - axiom693,1832640)
fof(p7,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ( ~ empty(C)
            & ilf_type(C,set_type) )
         => ( ilf_type(B,member_type(C))
          <=> member(B,C) ) ) ) ).

%---- type_nonempty(line(hidden - axiom693,1832640))
fof(p8,axiom,
    ! [B] :
      ( ( ~ empty(B)
        & ilf_type(B,set_type) )
     => ? [C] : ilf_type(C,member_type(B)) ) ).

%---- line(hidden - axiom695,1832628)
fof(p9,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( empty(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ~ member(C,B) ) ) ) ).

%---- declaration(op(singleton,1,function))
fof(p10,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ilf_type(singleton(B),set_type) ) ).

%---- declaration(op(cross_product,2,function))
fof(p11,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(cross_product(B,C),set_type) ) ) ).

%---- declaration(op(unordered_pair,2,function))
fof(p12,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(unordered_pair(B,C),set_type) ) ) ).

%---- property(commutativity,op(unordered_pair,2,function))
fof(p13,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => unordered_pair(B,C) = unordered_pair(C,B) ) ) ).

%---- declaration(op(image,2,function))
fof(p14,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(image(B,C),set_type) ) ) ).

%---- line(relat_1 - axiom696,1917641)
fof(p15,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ilf_type(B,binary_relation_type)
      <=> ( relation_like(B)
          & ilf_type(B,set_type) ) ) ) ).

%---- type_nonempty(line(relat_1 - axiom696,1917641))
fof(p16,axiom,
    ? [B] : ilf_type(B,binary_relation_type) ).

%---- line(hidden - axiom697,1832648)
fof(p17,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ilf_type(C,subset_type(B))
          <=> ilf_type(C,member_type(power_set(B))) ) ) ) ).

%---- type_nonempty(line(hidden - axiom697,1832648))
fof(p18,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ? [C] : ilf_type(C,subset_type(B)) ) ).

%---- line(hidden - axiom698,1832615)
fof(p19,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( B = C
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                <=> member(D,C) ) ) ) ) ) ).

%---- line(hidden - axiom700,1832644)
fof(p20,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( member(B,power_set(C))
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- declaration(line(hidden - axiom700,1832644))
fof(p21,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ~ empty(power_set(B))
        & ilf_type(power_set(B),set_type) ) ) ).

%---- line(relat_1 - df(1),1917627)
fof(p22,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( relation_like(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ( member(C,B)
             => ? [D] :
                  ( ilf_type(D,set_type)
                  & ? [E] :
                      ( ilf_type(E,set_type)
                      & C = ordered_pair(D,E) ) ) ) ) ) ) ).

%---- conditional_cluster(axiom701,relation_like)
fof(p23,axiom,
    ! [B] :
      ( ( empty(B)
        & ilf_type(B,set_type) )
     => relation_like(B) ) ).

%---- conditional_cluster(axiom702,relation_like)
fof(p24,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,subset_type(cross_product(B,C)))
             => relation_like(D) ) ) ) ).

%---- line(relset_1 - axiom712,1916764)
fof(p25,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => image4(B,C,D,E) = image(D,E) ) ) ) ) ).

%---- declaration(line(relset_1 - axiom712,1916764))
fof(p26,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => ilf_type(image4(B,C,D,E),subset_type(C)) ) ) ) ) ).

%---- declaration(set)
fof(p27,axiom,
    ! [B] : ilf_type(B,set_type) ).

%---- line(relset_1 - th(52),1916993)
fof(prove_relset_1_52,conjecture,
    ! [B] :
      ( ( ~ empty(B)
        & ilf_type(B,set_type) )
     => ! [C] :
          ( ( ~ empty(C)
            & ilf_type(C,set_type) )
         => ! [D] :
              ( ( ~ empty(D)
                & ilf_type(D,set_type) )
             => ! [E] :
                  ( ilf_type(E,relation_type(D,B))
                 => ! [F] :
                      ( ilf_type(F,member_type(B))
                     => ( member(F,image4(D,B,E,C))
                      <=> ? [G] :
                            ( ilf_type(G,member_type(D))
                            & member(ordered_pair(G,F),E)
                            & member(G,C) ) ) ) ) ) ) ) ).

%--------------------------------------------------------------------------
