%--------------------------------------------------------------------------
% File     : SET674+3 : TPTP v9.2.0. Released v2.2.0.
% Domain   : Set Theory (Relations)
% Problem  : R (X to Y) o X is the range R & R^-1(Y) is the domain of R
% Version  : [Wor90] axioms : Reduced > Incomplete.
% English  : A relation R from X to Y composed with X is the range of R; and
%            the inverse of R applied to Y is the domain of R.

% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor90] Woronowicz (1990), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (38) [Wor90]

% Status   : Theorem
% Rating   : 0.76 v9.0.0, 0.75 v8.1.0, 0.72 v7.5.0, 0.78 v7.4.0, 0.70 v7.3.0, 0.72 v7.1.0, 0.65 v7.0.0, 0.80 v6.4.0, 0.77 v6.3.0, 0.75 v6.2.0, 0.84 v6.1.0, 0.90 v6.0.0, 0.83 v5.5.0, 0.89 v5.4.0, 0.86 v5.3.0, 0.89 v5.2.0, 0.85 v5.1.0, 0.86 v5.0.0, 0.88 v4.1.0, 0.83 v4.0.1, 0.91 v4.0.0, 0.83 v3.7.0, 0.85 v3.5.0, 0.89 v3.3.0, 0.93 v3.2.0, 1.00 v3.1.0, 0.89 v2.7.0, 1.00 v2.2.1
% Syntax   : Number of formulae    :   41 (   2 unt;   0 def)
%            Number of atoms       :  176 (  10 equ)
%            Maximal formula atoms :    8 (   4 avg)
%            Number of connectives :  139 (   4   ~;   0   |;  18   &)
%                                         (  15 <=>; 102  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   7 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-2 aty)
%            Number of functors    :   16 (  16 usr;   2 con; 0-4 aty)
%            Number of variables   :  107 (  97   !;  10   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%---- line(relat_1 - th(12),1917875)
fof(p1,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( member(B,domain_of(C))
          <=> ? [D] :
                ( ilf_type(D,set_type)
                & member(ordered_pair(B,D),C) ) ) ) ) ).

%---- line(relat_1 - th(17),1917961)
fof(p2,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( member(B,range_of(C))
          <=> ? [D] :
                ( ilf_type(D,set_type)
                & member(ordered_pair(D,B),C) ) ) ) ) ).

%---- line(relat_1 - th(20),1917986)
fof(p3,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,binary_relation_type)
             => ( member(ordered_pair(B,C),D)
               => ( member(B,domain_of(D))
                  & member(C,range_of(D)) ) ) ) ) ) ).

%---- line(relat_1 - th(142),1919963)
fof(p4,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,binary_relation_type)
             => ( member(C,image(D,B))
              <=> ? [E] :
                    ( ilf_type(E,set_type)
                    & member(ordered_pair(E,C),D)
                    & member(E,B) ) ) ) ) ) ).

%---- line(relat_1 - th(165),1920359)
fof(p5,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,binary_relation_type)
             => ( member(C,inverse2(D,B))
              <=> ? [E] :
                    ( ilf_type(E,set_type)
                    & member(ordered_pair(C,E),D)
                    & member(E,B) ) ) ) ) ) ).

%---- line(tarski - th(2),1832736)
fof(p6,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                <=> member(D,C) ) )
           => B = C ) ) ) ).

%---- line(relset_1 - th(7),1916125)
fof(p7,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,set_type)
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => ! [F] :
                      ( ilf_type(F,relation_type(B,C))
                     => ( member(ordered_pair(D,E),F)
                       => ( member(D,B)
                          & member(E,C) ) ) ) ) ) ) ) ).

%---- line(relset_1 - df(1),1916080)
fof(p8,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,subset_type(cross_product(B,C)))
               => ilf_type(D,relation_type(B,C)) )
            & ! [E] :
                ( ilf_type(E,relation_type(B,C))
               => ilf_type(E,subset_type(cross_product(B,C))) ) ) ) ) ).

%---- type_nonempty(line(relset_1 - df(1),1916080))
fof(p9,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ? [D] : ilf_type(D,relation_type(C,B)) ) ) ).

%---- line(boole - df(8),1909359)
fof(p10,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( B = C
          <=> ( subset(B,C)
              & subset(C,B) ) ) ) ) ).

%---- declaration(op(inverse2,2,function))
fof(p11,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(inverse2(B,C),set_type) ) ) ).

%---- declaration(op(domain_of,1,function))
fof(p12,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(domain_of(B),set_type) ) ).

%---- declaration(op(cross_product,2,function))
fof(p13,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(cross_product(B,C),set_type) ) ) ).

%---- declaration(op(range_of,1,function))
fof(p14,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(range_of(B),set_type) ) ).

%---- declaration(op(ordered_pair,2,function))
fof(p15,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(ordered_pair(B,C),set_type) ) ) ).

%---- declaration(op(image,2,function))
fof(p16,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(image(B,C),set_type) ) ) ).

%---- line(relat_1 - axiom450,1917641)
fof(p17,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ilf_type(B,binary_relation_type)
      <=> ( relation_like(B)
          & ilf_type(B,set_type) ) ) ) ).

%---- type_nonempty(line(relat_1 - axiom450,1917641))
fof(p18,axiom,
    ? [B] : ilf_type(B,binary_relation_type) ).

%---- line(hidden - axiom451,1832648)
fof(p19,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ilf_type(C,subset_type(B))
          <=> ilf_type(C,member_type(power_set(B))) ) ) ) ).

%---- type_nonempty(line(hidden - axiom451,1832648))
fof(p20,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ? [C] : ilf_type(C,subset_type(B)) ) ).

%---- line(hidden - axiom452,1832615)
fof(p21,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( B = C
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                <=> member(D,C) ) ) ) ) ) ).

%---- line(tarski - df(3),1832749)
fof(p22,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( subset(B,C)
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- property(reflexivity,op(subset,2,predicate))
fof(p23,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => subset(B,B) ) ).

%---- line(hidden - axiom454,1832644)
fof(p24,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( member(B,power_set(C))
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- declaration(line(hidden - axiom454,1832644))
fof(p25,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ~ empty(power_set(B))
        & ilf_type(power_set(B),set_type) ) ) ).

%---- line(hidden - axiom455,1832640)
fof(p26,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ( ~ empty(C)
            & ilf_type(C,set_type) )
         => ( ilf_type(B,member_type(C))
          <=> member(B,C) ) ) ) ).

%---- type_nonempty(line(hidden - axiom455,1832640))
fof(p27,axiom,
    ! [B] :
      ( ( ~ empty(B)
        & ilf_type(B,set_type) )
     => ? [C] : ilf_type(C,member_type(B)) ) ).

%---- line(relat_1 - df(1),1917627)
fof(p28,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( relation_like(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ( member(C,B)
             => ? [D] :
                  ( ilf_type(D,set_type)
                  & ? [E] :
                      ( ilf_type(E,set_type)
                      & C = ordered_pair(D,E) ) ) ) ) ) ) ).

%---- conditional_cluster(axiom457,relation_like)
fof(p29,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,subset_type(cross_product(B,C)))
             => relation_like(D) ) ) ) ).

%---- line(hidden - axiom458,1832628)
fof(p30,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( empty(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ~ member(C,B) ) ) ) ).

%---- conditional_cluster(axiom459,empty)
fof(p31,axiom,
    ! [B] :
      ( ( empty(B)
        & ilf_type(B,set_type) )
     => relation_like(B) ) ).

%---- line(relset_1 - axiom463,1916330)
fof(p32,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => domain(B,C,D) = domain_of(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom463,1916330))
fof(p33,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(domain(B,C,D),subset_type(B)) ) ) ) ).

%---- line(relset_1 - axiom464,1916334)
fof(p34,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => range(B,C,D) = range_of(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom464,1916334))
fof(p35,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(range(B,C,D),subset_type(C)) ) ) ) ).

%---- line(relset_1 - axiom469,1916764)
fof(p36,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => image4(B,C,D,E) = image(D,E) ) ) ) ) ).

%---- declaration(line(relset_1 - axiom469,1916764))
fof(p37,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => ilf_type(image4(B,C,D,E),subset_type(C)) ) ) ) ) ).

%---- line(relset_1 - axiom470,1916768)
fof(p38,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => inverse4(B,C,D,E) = inverse2(D,E) ) ) ) ) ).

%---- declaration(line(relset_1 - axiom470,1916768))
fof(p39,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,set_type)
                 => ilf_type(inverse4(B,C,D,E),subset_type(B)) ) ) ) ) ).

%---- declaration(set)
fof(p40,axiom,
    ! [B] : ilf_type(B,set_type) ).

%---- line(relset_1 - th(38),1916809)
fof(prove_relset_1_38,conjecture,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ( image4(B,C,D,B) = range(B,C,D)
                & inverse4(B,C,D,C) = domain(B,C,D) ) ) ) ) ).

%--------------------------------------------------------------------------
