%--------------------------------------------------------------------------
% File     : SET663+3 : TPTP v9.2.0. Released v2.2.0.
% Domain   : Set Theory (Relations)
% Problem  : R (X to Y) is (empty set to Y) => R is empty set
% Version  : [Wor90] axioms : Reduced > Incomplete.
% English  : If a relation R from X to Y is a relation from empty set to Y
%            then R is the empty set.

% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor90] Woronowicz (1990), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (26) [Wor90]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.27 v9.0.0, 0.33 v8.2.0, 0.31 v7.5.0, 0.34 v7.4.0, 0.20 v7.3.0, 0.28 v7.1.0, 0.30 v7.0.0, 0.20 v6.4.0, 0.23 v6.3.0, 0.33 v6.2.0, 0.28 v6.1.0, 0.30 v5.5.0, 0.33 v5.4.0, 0.32 v5.3.0, 0.37 v5.2.0, 0.15 v5.1.0, 0.14 v5.0.0, 0.25 v4.1.0, 0.30 v4.0.1, 0.39 v4.0.0, 0.38 v3.7.0, 0.35 v3.5.0, 0.37 v3.4.0, 0.26 v3.3.0, 0.29 v3.2.0, 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Syntax   : Number of formulae    :   35 (   4 unt;   0 def)
%            Number of atoms       :  124 (  12 equ)
%            Maximal formula atoms :    7 (   3 avg)
%            Number of connectives :   94 (   5   ~;   1   |;   9   &)
%                                         (   9 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-2 aty)
%            Number of functors    :   13 (  13 usr;   3 con; 0-3 aty)
%            Number of variables   :   70 (  64   !;   6   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%---- line(boole - th(30),1909435)
fof(p1,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( subset(B,empty_set)
       => B = empty_set ) ) ).

%---- line(relat_1 - th(64),1918818)
fof(p2,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ( ( domain_of(B) = empty_set
          | range_of(B) = empty_set )
       => B = empty_set ) ) ).

%---- line(relset_1 - th(12),1916203)
fof(p3,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ( subset(domain_of(D),B)
                & subset(range_of(D),C) ) ) ) ) ).

%---- line(hidden - axiom249,1832636)
fof(p4,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ~ member(B,empty_set) ) ).

%---- declaration(line(hidden - axiom249,1832636)) Part 1
fof(p5a,axiom,
    empty(empty_set) ).

%---- declaration(line(hidden - axiom249,1832636)) Part 2
fof(p5b,axiom,
    type(empty_set,set_type) ).

%---- line(relset_1 - df(1),1916080)
fof(p6,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,subset_type(cross_product(B,C)))
               => ilf_type(D,relation_type(B,C)) )
            & ! [E] :
                ( ilf_type(E,relation_type(B,C))
               => ilf_type(E,subset_type(cross_product(B,C))) ) ) ) ) ).

%---- type_nonempty(line(relset_1 - df(1),1916080))
fof(p7,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ? [D] : ilf_type(D,relation_type(C,B)) ) ) ).

%---- line(relat_1 - df(2),1917780)
fof(p8,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( B = C
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ! [E] :
                    ( ilf_type(E,set_type)
                   => ( member(ordered_pair(D,E),B)
                    <=> member(ordered_pair(D,E),C) ) ) ) ) ) ) ).

%---- declaration(op(domain_of,1,function))
fof(p9,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(domain_of(B),set_type) ) ).

%---- declaration(op(cross_product,2,function))
fof(p10,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(cross_product(B,C),set_type) ) ) ).

%---- declaration(op(range_of,1,function))
fof(p11,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(range_of(B),set_type) ) ).

%---- declaration(op(ordered_pair,2,function))
fof(p12,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(ordered_pair(B,C),set_type) ) ) ).

%---- line(relat_1 - axiom250,1917641)
fof(p13,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ilf_type(B,binary_relation_type)
      <=> ( relation_like(B)
          & ilf_type(B,set_type) ) ) ) ).

%---- type_nonempty(line(relat_1 - axiom250,1917641))
fof(p14,axiom,
    ? [B] : ilf_type(B,binary_relation_type) ).

%---- line(hidden - axiom251,1832648)
fof(p15,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ilf_type(C,subset_type(B))
          <=> ilf_type(C,member_type(power_set(B))) ) ) ) ).

%---- type_nonempty(line(hidden - axiom251,1832648))
fof(p16,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ? [C] : ilf_type(C,subset_type(B)) ) ).

%---- property(symmetry,op(=,2,predicate))
fof(p17,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( B = C
           => C = B ) ) ) ).

%---- property(reflexivity,op(=,2,predicate))
fof(p18,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => B = B ) ).

%---- line(tarski - df(3),1832749)
fof(p19,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( subset(B,C)
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- property(reflexivity,op(subset,2,predicate))
fof(p20,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => subset(B,B) ) ).

%---- line(hidden - axiom253,1832628)
fof(p21,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( empty(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ~ member(C,B) ) ) ) ).

%---- line(hidden - axiom255,1832644)
fof(p22,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( member(B,power_set(C))
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- declaration(line(hidden - axiom255,1832644))
fof(p23,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ~ empty(power_set(B))
        & ilf_type(power_set(B),set_type) ) ) ).

%---- line(hidden - axiom256,1832640)
fof(p24,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ( ~ empty(C)
            & ilf_type(C,set_type) )
         => ( ilf_type(B,member_type(C))
          <=> member(B,C) ) ) ) ).

%---- type_nonempty(line(hidden - axiom256,1832640))
fof(p25,axiom,
    ! [B] :
      ( ( ~ empty(B)
        & ilf_type(B,set_type) )
     => ? [C] : ilf_type(C,member_type(B)) ) ).

%---- line(relat_1 - df(1),1917627)
fof(p26,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( relation_like(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ( member(C,B)
             => ? [D] :
                  ( ilf_type(D,set_type)
                  & ? [E] :
                      ( ilf_type(E,set_type)
                      & C = ordered_pair(D,E) ) ) ) ) ) ) ).

%---- conditional_cluster(axiom257,relation_like)
fof(p27,axiom,
    ! [B] :
      ( ( empty(B)
        & ilf_type(B,set_type) )
     => relation_like(B) ) ).

%---- conditional_cluster(axiom258,relation_like)
fof(p28,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,subset_type(cross_product(B,C)))
             => relation_like(D) ) ) ) ).

%---- line(relset_1 - axiom262,1916330)
fof(p29,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => domain(B,C,D) = domain_of(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom262,1916330))
fof(p30,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(domain(B,C,D),subset_type(B)) ) ) ) ).

%---- line(relset_1 - axiom263,1916334)
fof(p31,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => range(B,C,D) = range_of(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom263,1916334))
fof(p32,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(range(B,C,D),subset_type(C)) ) ) ) ).

%---- declaration(set)
fof(p33,axiom,
    ! [B] : ilf_type(B,set_type) ).

%---- line(relset_1 - th(26),1916508)
fof(prove_relset_1_26,conjecture,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ( ilf_type(D,relation_type(empty_set,C))
               => D = empty_set ) ) ) ) ).

%--------------------------------------------------------------------------
