%--------------------------------------------------------------------------
% File     : SET661+3 : TPTP v9.2.0. Released v2.2.0.
% Domain   : Set Theory (Relations)
% Problem  : Domain of R^-1 is range of R, & range of R^-1 is domain of R
% Version  : [Wor90] axioms : Reduced > Incomplete.
% English  : The domain of the inverse of a relation R from X to Y is the
%            range of R, and the range of the inverse of R is the domain of R.

% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor90] Woronowicz (1990), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (24) [Wor90]

% Status   : Theorem
% Rating   : 0.79 v9.1.0, 0.82 v9.0.0, 0.81 v8.2.0, 0.83 v8.1.0, 0.81 v7.5.0, 0.91 v7.4.0, 0.80 v7.3.0, 0.86 v7.1.0, 0.83 v7.0.0, 0.90 v6.4.0, 0.88 v6.3.0, 0.92 v6.1.0, 0.93 v6.0.0, 0.91 v5.5.0, 0.93 v5.4.0, 0.96 v5.3.0, 1.00 v5.2.0, 0.95 v5.0.0, 1.00 v4.1.0, 0.96 v3.7.0, 0.95 v3.3.0, 0.93 v3.2.0, 1.00 v3.1.0, 0.78 v2.7.0, 1.00 v2.5.0, 0.88 v2.4.0, 1.00 v2.2.1
% Syntax   : Number of formulae    :   38 (   2 unt;   0 def)
%            Number of atoms       :  149 (  12 equ)
%            Maximal formula atoms :    7 (   3 avg)
%            Number of connectives :  115 (   4   ~;   0   |;  13   &)
%                                         (  14 <=>;  84  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-2 aty)
%            Number of functors    :   14 (  14 usr;   2 con; 0-3 aty)
%            Number of variables   :   87 (  79   !;   8   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%---- line(relat_1 - th(12),1917875)
fof(p1,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( member(B,domain_of(C))
          <=> ? [D] :
                ( ilf_type(D,set_type)
                & member(ordered_pair(B,D),C) ) ) ) ) ).

%---- line(relat_1 - th(17),1917961)
fof(p2,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( member(B,range_of(C))
          <=> ? [D] :
                ( ilf_type(D,set_type)
                & member(ordered_pair(D,B),C) ) ) ) ) ).

%---- line(relat_1 - th(20),1917986)
fof(p3,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,binary_relation_type)
             => ( member(ordered_pair(B,C),D)
               => ( member(B,domain_of(D))
                  & member(C,range_of(D)) ) ) ) ) ) ).

%---- line(relat_1 - th(36),1918323)
fof(p4,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,binary_relation_type)
             => ( member(ordered_pair(B,C),inverse(D))
              <=> member(ordered_pair(C,B),D) ) ) ) ) ).

%---- line(tarski - th(2),1832736)
fof(p5,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                <=> member(D,C) ) )
           => B = C ) ) ) ).

%---- line(relset_1 - df(1),1916080)
fof(p6,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,subset_type(cross_product(B,C)))
               => ilf_type(D,relation_type(B,C)) )
            & ! [E] :
                ( ilf_type(E,relation_type(B,C))
               => ilf_type(E,subset_type(cross_product(B,C))) ) ) ) ) ).

%---- type_nonempty(line(relset_1 - df(1),1916080))
fof(p7,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ? [D] : ilf_type(D,relation_type(C,B)) ) ) ).

%---- line(boole - df(8),1909359)
fof(p8,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( B = C
          <=> ( subset(B,C)
              & subset(C,B) ) ) ) ) ).

%---- declaration(op(domain_of,1,function))
fof(p9,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(domain_of(B),set_type) ) ).

%---- declaration(op(cross_product,2,function))
fof(p10,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(cross_product(B,C),set_type) ) ) ).

%---- declaration(op(range_of,1,function))
fof(p11,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(range_of(B),set_type) ) ).

%---- declaration(op(inverse,1,function))
fof(p12,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ilf_type(inverse(B),binary_relation_type) ) ).

%---- declaration(op(ordered_pair,2,function))
fof(p13,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(ordered_pair(B,C),set_type) ) ) ).

%---- line(relat_1 - axiom216,1917641)
fof(p14,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ilf_type(B,binary_relation_type)
      <=> ( relation_like(B)
          & ilf_type(B,set_type) ) ) ) ).

%---- type_nonempty(line(relat_1 - axiom216,1917641))
fof(p15,axiom,
    ? [B] : ilf_type(B,binary_relation_type) ).

%---- line(hidden - axiom217,1832648)
fof(p16,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ilf_type(C,subset_type(B))
          <=> ilf_type(C,member_type(power_set(B))) ) ) ) ).

%---- type_nonempty(line(hidden - axiom217,1832648))
fof(p17,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ? [C] : ilf_type(C,subset_type(B)) ) ).

%---- line(hidden - axiom218,1832615)
fof(p18,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( B = C
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                <=> member(D,C) ) ) ) ) ) ).

%---- property(symmetry,op(=,2,predicate))
fof(p19,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( B = C
           => C = B ) ) ) ).

%---- property(reflexivity,op(=,2,predicate))
fof(p20,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => B = B ) ).

%---- line(tarski - df(3),1832749)
fof(p21,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( subset(B,C)
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- property(reflexivity,op(subset,2,predicate))
fof(p22,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => subset(B,B) ) ).

%---- line(hidden - axiom220,1832644)
fof(p23,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( member(B,power_set(C))
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- declaration(line(hidden - axiom220,1832644))
fof(p24,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ~ empty(power_set(B))
        & ilf_type(power_set(B),set_type) ) ) ).

%---- line(hidden - axiom221,1832640)
fof(p25,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ( ~ empty(C)
            & ilf_type(C,set_type) )
         => ( ilf_type(B,member_type(C))
          <=> member(B,C) ) ) ) ).

%---- type_nonempty(line(hidden - axiom221,1832640))
fof(p26,axiom,
    ! [B] :
      ( ( ~ empty(B)
        & ilf_type(B,set_type) )
     => ? [C] : ilf_type(C,member_type(B)) ) ).

%---- line(relat_1 - df(1),1917627)
fof(p27,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( relation_like(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ( member(C,B)
             => ? [D] :
                  ( ilf_type(D,set_type)
                  & ? [E] :
                      ( ilf_type(E,set_type)
                      & C = ordered_pair(D,E) ) ) ) ) ) ) ).

%---- conditional_cluster(axiom223,relation_like)
fof(p28,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,subset_type(cross_product(B,C)))
             => relation_like(D) ) ) ) ).

%---- line(hidden - axiom224,1832628)
fof(p29,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( empty(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ~ member(C,B) ) ) ) ).

%---- conditional_cluster(axiom225,empty)
fof(p30,axiom,
    ! [B] :
      ( ( empty(B)
        & ilf_type(B,set_type) )
     => relation_like(B) ) ).

%---- line(relset_1 - axiom229,1916330)
fof(p31,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => domain(B,C,D) = domain_of(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom229,1916330))
fof(p32,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(domain(B,C,D),subset_type(B)) ) ) ) ).

%---- line(relset_1 - axiom230,1916334)
fof(p33,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => range(B,C,D) = range_of(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom230,1916334))
fof(p34,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(range(B,C,D),subset_type(C)) ) ) ) ).

%---- line(relset_1 - axiom231,1916416)
fof(p35,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => inverse3(B,C,D) = inverse(D) ) ) ) ).

%---- declaration(line(relset_1 - axiom231,1916416))
fof(p36,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ilf_type(inverse3(B,C,D),relation_type(C,B)) ) ) ) ).

%---- declaration(set)
fof(p37,axiom,
    ! [B] : ilf_type(B,set_type) ).

%---- line(relset_1 - th(24),1916487)
fof(prove_relset_1_24,conjecture,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ( domain(C,B,inverse3(B,C,D)) = range(B,C,D)
                & range(C,B,inverse3(B,C,D)) = domain(B,C,D) ) ) ) ) ).

%--------------------------------------------------------------------------
