%--------------------------------------------------------------------------
% File     : SET656+3 : TPTP v9.2.0. Released v2.2.0.
% Domain   : Set Theory (Relations)
% Problem  : The intersection of a relation R from X to Y and X x Y is R
% Version  : [Wor90] axioms : Reduced > Incomplete.
% English  :

% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor90] Woronowicz (1990), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (18) [Wor90]

% Status   : Theorem
% Rating   : 0.52 v9.1.0, 0.48 v9.0.0, 0.58 v8.2.0, 0.56 v8.1.0, 0.50 v7.4.0, 0.43 v7.3.0, 0.48 v7.2.0, 0.45 v7.1.0, 0.43 v7.0.0, 0.40 v6.4.0, 0.46 v6.3.0, 0.50 v6.2.0, 0.60 v6.1.0, 0.63 v6.0.0, 0.57 v5.5.0, 0.67 v5.4.0, 0.64 v5.3.0, 0.70 v5.2.0, 0.50 v5.1.0, 0.48 v5.0.0, 0.54 v4.1.0, 0.52 v4.0.1, 0.57 v4.0.0, 0.50 v3.7.0, 0.45 v3.5.0, 0.42 v3.4.0, 0.37 v3.3.0, 0.36 v3.2.0, 0.45 v3.1.0, 0.33 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.67 v2.2.1
% Syntax   : Number of formulae    :   31 (   2 unt;   0 def)
%            Number of atoms       :  128 (  11 equ)
%            Maximal formula atoms :    9 (   4 avg)
%            Number of connectives :  101 (   4   ~;   0   |;  13   &)
%                                         (  13 <=>;  71  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   7 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-2 aty)
%            Number of functors    :   10 (  10 usr;   2 con; 0-4 aty)
%            Number of variables   :   75 (  67   !;   8   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%---- line(boole - th(42),1909607)
fof(p1,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( subset(B,C)
           => intersection(B,C) = B ) ) ) ).

%---- line(zfmisc_1 - df(1),1903822)
fof(p2,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,set_type)
             => ( member(D,cross_product(B,C))
              <=> ? [E] :
                    ( ilf_type(E,set_type)
                    & ? [F] :
                        ( ilf_type(F,set_type)
                        & member(E,B)
                        & member(F,C)
                        & D = ordered_pair(E,F) ) ) ) ) ) ) ).

%---- declaration(line(zfmisc_1 - df(1),1903822))
fof(p3,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(cross_product(B,C),set_type) ) ) ).

%---- line(boole - df(3),1909316)
fof(p4,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,set_type)
             => ( member(D,intersection(B,C))
              <=> ( member(D,B)
                  & member(D,C) ) ) ) ) ) ).

%---- declaration(line(boole - df(3),1909316))
fof(p5,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(intersection(B,C),set_type) ) ) ).

%---- line(relset_1 - df(1),1916080)
fof(p6,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ! [D] :
                ( ilf_type(D,subset_type(cross_product(B,C)))
               => ilf_type(D,relation_type(B,C)) )
            & ! [E] :
                ( ilf_type(E,relation_type(B,C))
               => ilf_type(E,subset_type(cross_product(B,C))) ) ) ) ) ).

%---- type_nonempty(line(relset_1 - df(1),1916080))
fof(p7,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ? [D] : ilf_type(D,relation_type(C,B)) ) ) ).

%---- line(relat_1 - df(2),1917780)
fof(p8,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( B = C
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ! [E] :
                    ( ilf_type(E,set_type)
                   => ( member(ordered_pair(D,E),B)
                    <=> member(ordered_pair(D,E),C) ) ) ) ) ) ) ).

%---- property(commutativity,op(intersection,2,function))
fof(p9,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => intersection(B,C) = intersection(C,B) ) ) ).

%---- declaration(op(ordered_pair,2,function))
fof(p10,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ilf_type(ordered_pair(B,C),set_type) ) ) ).

%---- line(relat_1 - axiom139,1917641)
fof(p11,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ilf_type(B,binary_relation_type)
      <=> ( relation_like(B)
          & ilf_type(B,set_type) ) ) ) ).

%---- type_nonempty(line(relat_1 - axiom139,1917641))
fof(p12,axiom,
    ? [B] : ilf_type(B,binary_relation_type) ).

%---- line(hidden - axiom140,1832648)
fof(p13,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( ilf_type(C,subset_type(B))
          <=> ilf_type(C,member_type(power_set(B))) ) ) ) ).

%---- type_nonempty(line(hidden - axiom140,1832648))
fof(p14,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ? [C] : ilf_type(C,subset_type(B)) ) ).

%---- property(symmetry,op(=,2,predicate))
fof(p15,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => ! [C] :
          ( ilf_type(C,binary_relation_type)
         => ( B = C
           => C = B ) ) ) ).

%---- property(reflexivity,op(=,2,predicate))
fof(p16,axiom,
    ! [B] :
      ( ilf_type(B,binary_relation_type)
     => B = B ) ).

%---- line(tarski - df(3),1832749)
fof(p17,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( subset(B,C)
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- property(reflexivity,op(subset,2,predicate))
fof(p18,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => subset(B,B) ) ).

%---- line(hidden - axiom142,1832644)
fof(p19,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( member(B,power_set(C))
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                 => member(D,C) ) ) ) ) ) ).

%---- declaration(line(hidden - axiom142,1832644))
fof(p20,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( ~ empty(power_set(B))
        & ilf_type(power_set(B),set_type) ) ) ).

%---- line(hidden - axiom143,1832640)
fof(p21,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ( ~ empty(C)
            & ilf_type(C,set_type) )
         => ( ilf_type(B,member_type(C))
          <=> member(B,C) ) ) ) ).

%---- type_nonempty(line(hidden - axiom143,1832640))
fof(p22,axiom,
    ! [B] :
      ( ( ~ empty(B)
        & ilf_type(B,set_type) )
     => ? [C] : ilf_type(C,member_type(B)) ) ).

%---- line(hidden - axiom144,1832615)
fof(p23,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ( B = C
          <=> ! [D] :
                ( ilf_type(D,set_type)
               => ( member(D,B)
                <=> member(D,C) ) ) ) ) ) ).

%---- line(relat_1 - df(1),1917627)
fof(p24,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( relation_like(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ( member(C,B)
             => ? [D] :
                  ( ilf_type(D,set_type)
                  & ? [E] :
                      ( ilf_type(E,set_type)
                      & C = ordered_pair(D,E) ) ) ) ) ) ) ).

%---- conditional_cluster(axiom146,relation_like)
fof(p25,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,subset_type(cross_product(B,C)))
             => relation_like(D) ) ) ) ).

%---- line(hidden - axiom147,1832628)
fof(p26,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ( empty(B)
      <=> ! [C] :
            ( ilf_type(C,set_type)
           => ~ member(C,B) ) ) ) ).

%---- conditional_cluster(axiom148,empty)
fof(p27,axiom,
    ! [B] :
      ( ( empty(B)
        & ilf_type(B,set_type) )
     => relation_like(B) ) ).

%---- line(relset_1 - axiom150,1916318)
fof(p28,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,relation_type(B,C))
                 => intersection4(B,C,D,E) = intersection(D,E) ) ) ) ) ).

%---- declaration(line(relset_1 - axiom150,1916318))
fof(p29,axiom,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => ! [E] :
                  ( ilf_type(E,relation_type(B,C))
                 => ilf_type(intersection4(B,C,D,E),relation_type(B,C)) ) ) ) ) ).

%---- declaration(set)
fof(p30,axiom,
    ! [B] : ilf_type(B,set_type) ).

%---- line(relset_1 - th(18),1916325)
fof(prove_relset_1_18,conjecture,
    ! [B] :
      ( ilf_type(B,set_type)
     => ! [C] :
          ( ilf_type(C,set_type)
         => ! [D] :
              ( ilf_type(D,relation_type(B,C))
             => intersection(D,cross_product(B,C)) = D ) ) ) ).

%--------------------------------------------------------------------------
