%--------------------------------------------------------------------------
% File     : SET619+3 : TPTP v9.2.0. Released v2.2.0.
% Domain   : Set Theory
% Problem  : X U Y = (X sym\ Y) U X ^ Y
% Version  : [Try90] axioms : Reduced > Incomplete.
% English  : The union of X and Y is the union of (the symmetric difference
%            of X and Y) and the intersection of X and Y.

% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try90] Trybulec (1990), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (95) [TS89]

% Status   : Theorem
% Rating   : 0.27 v9.1.0, 0.21 v9.0.0, 0.31 v8.2.0, 0.28 v8.1.0, 0.22 v7.5.0, 0.34 v7.4.0, 0.13 v7.3.0, 0.24 v7.2.0, 0.28 v7.1.0, 0.17 v7.0.0, 0.20 v6.4.0, 0.27 v6.3.0, 0.21 v6.2.0, 0.24 v6.1.0, 0.30 v5.5.0, 0.37 v5.4.0, 0.43 v5.3.0, 0.52 v5.2.0, 0.40 v5.1.0, 0.38 v5.0.0, 0.46 v4.1.0, 0.43 v4.0.0, 0.46 v3.7.0, 0.40 v3.5.0, 0.37 v3.4.0, 0.32 v3.3.0, 0.29 v3.2.0, 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Syntax   : Number of formulae    :   14 (   9 unt;   0 def)
%            Number of atoms       :   24 (  10 equ)
%            Maximal formula atoms :    3 (   1 avg)
%            Number of connectives :   10 (   0   ~;   1   |;   2   &)
%                                         (   6 <=>;   1  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    6 (   4 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    3 (   2 usr;   0 prp; 2-2 aty)
%            Number of functors    :    4 (   4 usr;   0 con; 2-2 aty)
%            Number of variables   :   32 (  32   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%---- line(boole - df(7),1833089)
fof(symmetric_difference_defn,axiom,
    ! [B,C] : symmetric_difference(B,C) = union(difference(B,C),difference(C,B)) ).

%---- line(boole - th(64),1833712)
fof(associativity_of_union,axiom,
    ! [B,C,D] : union(union(B,C),D) = union(B,union(C,D)) ).

%---- line(boole - th(69),1833784)
fof(union_intersection,axiom,
    ! [B,C] : union(B,intersection(B,C)) = B ).

%---- line(boole - th(80),1833943)
fof(union_intersection_difference,axiom,
    ! [B,C] : union(intersection(B,C),difference(B,C)) = B ).

%---- line(boole - df(2),1833042)
fof(union_defn,axiom,
    ! [B,C,D] :
      ( member(D,union(B,C))
    <=> ( member(D,B)
        | member(D,C) ) ) ).

%---- line(boole - df(3),1833060)
fof(intersection_defn,axiom,
    ! [B,C,D] :
      ( member(D,intersection(B,C))
    <=> ( member(D,B)
        & member(D,C) ) ) ).

%---- line(boole - df(8),1833103)
fof(equal_defn,axiom,
    ! [B,C] :
      ( B = C
    <=> ( subset(B,C)
        & subset(C,B) ) ) ).

%---- property(commutativity,op(union,2,function))
fof(commutativity_of_union,axiom,
    ! [B,C] : union(B,C) = union(C,B) ).

%---- property(commutativity,op(intersection,2,function))
fof(commutativity_of_intersection,axiom,
    ! [B,C] : intersection(B,C) = intersection(C,B) ).

%---- property(commutativity,op(symmetric_difference,2,function))
fof(commutativity_of_symmetric_difference,axiom,
    ! [B,C] : symmetric_difference(B,C) = symmetric_difference(C,B) ).

%---- line(hidden - axiom175,1832615)
fof(equal_member_defn,axiom,
    ! [B,C] :
      ( B = C
    <=> ! [D] :
          ( member(D,B)
        <=> member(D,C) ) ) ).

%---- line(tarski - df(3),1832749)
fof(subset_defn,axiom,
    ! [B,C] :
      ( subset(B,C)
    <=> ! [D] :
          ( member(D,B)
         => member(D,C) ) ) ).

%---- property(reflexivity,op(subset,2,predicate))
fof(reflexivity_of_subset,axiom,
    ! [B] : subset(B,B) ).

%---- line(boole - th(95),1834220)
fof(prove_th95,conjecture,
    ! [B,C] : union(B,C) = union(symmetric_difference(B,C),intersection(B,C)) ).

%--------------------------------------------------------------------------
