%--------------------------------------------------------------------------
% File     : SET449-6 : TPTP v9.2.0. Bugfixed v2.1.0.
% Domain   : Set Theory
% Problem  : Condition 1 for one function to be a subset of another
% Version  : [Qua92] axioms.
% English  :

% Refs     : [BL+86] Boyer et al. (1986), Set Theory in First-Order Logic:
%          : [Qua92] Quaife (1992), Automated Deduction in von Neumann-Bern
% Source   : [Quaife]
% Names    : FU16.1 [Quaife]

% Status   : Unknown
% Rating   : 1.00 v2.1.0
% Syntax   : Number of clauses     :  116 (  41 unt;   8 nHn;  83 RR)
%            Number of literals    :  222 (  49 equ; 102 neg)
%            Maximal clause size   :    5 (   1 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   49 (  49 usr;  14 con; 0-3 aty)
%            Number of variables   :  214 (  32 sgn)
% SPC      : CNF_UNK_RFO_SEQ_NHN

% Comments : Not in [Qua92].
%          : Quaife proves all these problems by augmenting the axioms with
%            all previously proved theorems. With a few exceptions (the
%            problems that correspond to [BL+86] problems), the TPTP has
%            retained the order in which Quaife presents the problems. The
%            user may create an augmented version of this problem by adding
%            all previously proved theorems (the ones that correspond to
%            [BL+86] are easily identified and positioned using Quaife's
%            naming scheme).
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%          : v2.1.0 - Bugfix in SET004-0.ax.
%--------------------------------------------------------------------------
%----Include von Neuman-Bernays-Godel set theory axioms
include('Axioms/SET004-0.ax').
%----Include von Neuman-Bernays-Godel Boolean Algebra definitions
include('Axioms/SET004-1.ax').
%--------------------------------------------------------------------------
cnf(prove_function_subset_function1_1,negated_conjecture,
    function(x) ).

cnf(prove_function_subset_function1_2,negated_conjecture,
    subclass(domain_of(x),domain_of(y)) ).

cnf(prove_function_subset_function1_3,negated_conjecture,
    ~ subclass(x,y) ).

cnf(prove_function_subset_function1_4,negated_conjecture,
    ~ member(not_subfunction(x,y),domain_of(x)) ).

%--------------------------------------------------------------------------
