%------------------------------------------------------------------------------
% File     : SCT263_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 304
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_304 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  162 (  43 unt;  50 typ;   0 def)
%            Number of atoms       :  301 (  89 equ)
%            Maximal formula atoms :   17 (   1 avg)
%            Number of connectives :  267 (  78   ~;   8   |;  23   &)
%                                         (  35 <=>; 123  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   37 (  22   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-4 aty)
%            Number of functors    :   39 (  39 usr;  18 con; 0-5 aty)
%            Number of variables   :  299 ( 263   !;   2   ?; 299   :)
%                                         (  34  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:27:24
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Hilbert__Choice_Oinv__into,type,
    hilbert_inv_into: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,B) * B ) > A ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Wellfounded_Omeasure,type,
    measure: 
      !>[A: $tType] : ( fun(A,nat) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_Lba____,type,
    lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_P____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_c____,type,
    c: arrow_411405190le_alt ).

tff(sy_v_d____,type,
    d: arrow_411405190le_alt ).

tff(sy_v_e____,type,
    e: arrow_411405190le_alt ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

tff(sy_v_n____,type,
    n: nat ).

%----Relevant facts (100)
tff(fact_0__096P_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p,arrow_610318064e_Prof) ).

tff(fact_1_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_2_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_3__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_4__096c_A_126_061_Ad_096,axiom,
    c != d ).

tff(fact_5_PiProf,axiom,
    ! [Na: nat] : member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),Na)),lab),lba),arrow_610318064e_Prof) ).

tff(fact_6__096Lab_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lab,arrow_1985332922le_Lin) ).

tff(fact_7__096Lba_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lba,arrow_1985332922le_Lin) ).

tff(fact_8__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lab) ).

tff(fact_9__096b_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lba) ).

tff(fact_10_dist,axiom,
    distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,c,cons(arrow_411405190le_alt,d,cons(arrow_411405190le_alt,e,nil(arrow_411405190le_alt))))) ).

tff(fact_11__096_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e))),arrow_610318064e_Prof) ).

tff(fact_12__096_Ia_M_Ab_J_A_126_058_ALba_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lba) ).

tff(fact_13__096_Ib_M_Aa_J_A_126_058_ALab_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lab) ).

tff(fact_14__096ALL_Ai_O_A_Ie_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ad_J_A_061_A_Ib_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Aa_J_096,axiom,
    ! [I1: arrow_159774573e_indi] :
      ( ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),e)) )
        & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => ( ( ( aa(arrow_159774573e_indi,nat,h,I1) = n )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),c),e)) )
            & ( ( aa(arrow_159774573e_indi,nat,h,I1) != n )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),e)) ) ) ) )
    <=> ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lab) )
        & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lba) ) ) ) ).

tff(fact_15__096_091_124_Ae_A_126_061_Ad_059_Ab_A_126_061_Aa_059_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_A_058_AProf_059_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_ALab_Aelse_ALba_J_A_058_AProf_059_AALL_Ai_O_A_Ie_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ad_J_A_061_A_Ib_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Aa_J_A_124_093_061_061_062_A_Ie_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ad_J_A_061_A_Ib_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Aa_J_096,axiom,
    ( ( e != d )
   => ( ( b != a )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e))),arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),lab),lba),arrow_610318064e_Prof)
         => ( ! [I2: arrow_159774573e_indi] :
                ( ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I2)),n))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I2)),e)) )
                  & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I2)),n))
                   => ( ( ( aa(arrow_159774573e_indi,nat,h,I2) = n )
                       => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I2)),c),e)) )
                      & ( ( aa(arrow_159774573e_indi,nat,h,I2) != n )
                       => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I2)),e)) ) ) ) )
              <=> ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I2)),n))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lab) )
                  & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I2)),n))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lba) ) ) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e)))))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),lab),lba))) ) ) ) ) ) ) ).

tff(fact_16__C2_C,axiom,
    ! [P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B3 )
       => ( ( Aa != B3 )
         => ( ( Ba != A3 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1)) ) ) ) ) ) ) ) ) ).

tff(fact_17__C1_C,axiom,
    ! [P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B3 )
       => ( ( Aa != B3 )
         => ( ( Ba != A3 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1)) ) ) ) ) ) ) ) ) ).

tff(fact_18__C4_C,axiom,
    ! [P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ca: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != Ca )
       => ( ( Aa != Ca )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( ! [I2: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Ca),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Ca),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1)) ) ) ) ) ) ) ) ).

tff(fact_19_pairwise__neutrality,axiom,
    ! [P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B3 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
           => ( ! [I2: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1)) ) ) ) ) ) ) ).

tff(fact_20__C3_C,axiom,
    ! [P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
         => ( ! [I2: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1)) ) ) ) ) ) ).

tff(fact_21__096ALL_Ai_O_A_Ic_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ad_J_A_061_A_Ic_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ad_J_096,axiom,
    ! [I1: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1))
    <=> ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),e)) )
        & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => ( ( ( aa(arrow_159774573e_indi,nat,h,I1) = n )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),c),e)) )
            & ( ( aa(arrow_159774573e_indi,nat,h,I1) != n )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),e)) ) ) ) ) ) ).

tff(fact_22__096c_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ae_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,e),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e))))) ).

tff(fact_23_PW,axiom,
    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,p))
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e))))) ) ).

tff(fact_24_n_I2_J,axiom,
    ! [M2: nat] :
      ( ord_less_eq(nat,M2,n)
     => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),M2)),lab),lba))) ) ).

tff(fact_25_in__mkbot,axiom,
    ! [Z1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,L1),Z1))
    <=> ( ( Y1 != Z1 )
        & ( ( X1 = Z1 )
         => ( X1 != Y1 ) )
        & ( ( X1 != Z1 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ).

tff(fact_26_in__mktop,axiom,
    ! [Z1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,L1),Z1))
    <=> ( ( X1 != Z1 )
        & ( ( Y1 = Z1 )
         => ( X1 != Y1 ) )
        & ( ( Y1 != Z1 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ).

tff(fact_27_n_I3_J,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),plus_plus(nat,n,one_one(nat)))),lab),lba))) ).

tff(fact_28__096_Ic_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ae_J_A_061_Ia_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_A_L_A1_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Ab_J_096,axiom,
    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,e),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e)))))
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),plus_plus(nat,n,one_one(nat)))),lab),lba))) ) ).

tff(fact_29__096ALL_Ai_O_A_Ic_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_Athen_Amktop_A_IP_Ai_J_Ae_Aelse_Aif_Ah_Ai_A_061_An_Athen_Aabove_A_IP_Ai_J_Ac_Ae_Aelse_Amkbot_A_IP_Ai_J_Ae_J_092_060_094esub_062_Ae_J_A_061_A_Ia_A_060_092_060_094bsub_062_Iif_Ah_Ai_A_060_An_A_L_A1_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Ab_J_096,axiom,
    ! [I1: arrow_159774573e_indi] :
      ( ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,e),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),e)) )
        & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),n))
         => ( ( ( aa(arrow_159774573e_indi,nat,h,I1) = n )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,e),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),c),e)) )
            & ( ( aa(arrow_159774573e_indi,nat,h,I1) != n )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,e),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I1)),e)) ) ) ) )
    <=> ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),plus_plus(nat,n,one_one(nat))))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lab) )
        & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,I1)),plus_plus(nat,n,one_one(nat))))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lba) ) ) ) ).

tff(fact_30__096c_A_060_092_060_094bsub_062P_A_Iinv_Ah_An_J_092_060_094esub_062_Ad_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,hilbert_inv_into(arrow_159774573e_indi,nat,top_top(fun(arrow_159774573e_indi,bool)),h,n))) ).

tff(fact_31__096_B_Bthesis_O_A_I_B_BLab_O_A_091_124_Aa_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_059_ALab_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),Lab)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lab,arrow_1985332922le_Lin) ) ).

tff(fact_32__096_B_Bthesis_O_A_I_B_BLba_O_A_091_124_Ab_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_059_ALba_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),Lba)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lba,arrow_1985332922le_Lin) ) ).

tff(fact_33__096_B_Bthesis_O_A_I_B_Be_O_Adistinct_A_091c_M_Ad_M_Ae_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [E: arrow_411405190le_alt] : ~ distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,c,cons(arrow_411405190le_alt,d,cons(arrow_411405190le_alt,E,nil(arrow_411405190le_alt))))) ).

tff(fact_34_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B4))) ) ).

tff(fact_35_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B3: B,A3: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A3,B3) )
    <=> ( ( Aa = A3 )
        & ( Ba = B3 ) ) ) ).

tff(fact_36_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S1: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X3,Xa),R1)
        <=> member(product_prod(A,B),product_Pair(A,B,X3,Xa),S1) )
    <=> ( R1 = S1 ) ) ).

tff(fact_37_in__measure,axiom,
    ! [A: $tType,F: fun(A,nat),Y1: A,X1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X1,Y1),measure(A,F))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(A,nat,F,X1)),aa(A,nat,F,Y1))) ) ).

tff(fact_38_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,L1),Aa),Ba))
        <=> ( ( X1 != Y1 )
            & ( ( X1 = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y1),L1) )
            & ( ( X1 != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X1 = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Aa),L1) ) )
                & ( ( Y1 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_39_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_40_assms_I1_J,axiom,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(fact_41_n_I1_J,axiom,
    pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),n),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool))))) ).

tff(fact_42_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_43_const__Lin__Prof,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L1),arrow_610318064e_Prof) ) ).

tff(fact_44_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),L1)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),L1) ) ) ).

tff(fact_45_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( ( X1 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y1,X1),L1) ) ) ) ).

tff(fact_46_mktop__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,L1),X1),arrow_1985332922le_Lin) ) ).

tff(fact_47_mkbot__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,L1),X1),arrow_1985332922le_Lin) ) ).

tff(fact_48_above__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,L1),X1),Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_49_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B2: B,A1: A,B1: B,A4: A] :
      ( ( product_Pair(A,B,A4,B1) = product_Pair(A,B,A1,B2) )
     => ~ ( ( A4 = A1 )
         => ( B1 != B2 ) ) ) ).

tff(fact_50__096EX_An_060N_O_A_IALL_Am_060_061n_O_Ab_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_Am_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Aa_J_A_G_Aa_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_A_L_A1_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Ab_096,axiom,
    ? [N1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))))
      & ! [M2: nat] :
          ( ord_less_eq(nat,M2,N1)
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),M2)),lab),lba))) )
      & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),plus_plus(nat,N1,one_one(nat)))),lab),lba))) ) ).

tff(fact_51_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_52_third__alt,axiom,
    ! [B1: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B1 )
     => ? [C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A4,cons(arrow_411405190le_alt,B1,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ) ).

tff(fact_53_nat__add__left__cancel__le,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( ord_less_eq(nat,plus_plus(nat,K1,M1),plus_plus(nat,K1,Na))
    <=> ord_less_eq(nat,M1,Na) ) ).

tff(fact_54_nat__add__left__cancel__less,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,K1,M1)),plus_plus(nat,K1,Na)))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na)) ) ).

tff(fact_55_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A3: A,List1: list(A),Aa: A] :
      ( ( cons(A,Aa,List1) = cons(A,A3,List2) )
    <=> ( ( Aa = A3 )
        & ( List1 = List2 ) ) ) ).

tff(fact_56_nat__add__right__cancel,axiom,
    ! [Na: nat,K1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K1) = plus_plus(nat,Na,K1) )
    <=> ( M1 = Na ) ) ).

tff(fact_57_nat__add__left__cancel,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M1) = plus_plus(nat,K1,Na) )
    <=> ( M1 = Na ) ) ).

tff(fact_58__096_B_Bthesis_O_A_I_B_Bn_O_A_091_124_An_A_060_AN_059_AALL_Am_060_061n_O_Ab_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_Am_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Aa_059_Aa_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_A_L_A1_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Ab_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [N1: nat] :
        ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))))
       => ( ! [M2: nat] :
              ( ord_less_eq(nat,M2,N1)
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),M2)),lab),lba))) )
         => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),plus_plus(nat,N1,one_one(nat)))),lab),lba))) ) ) ).

tff(fact_59_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_60_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1)) ) ) ).

tff(fact_61_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_62_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_63_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M))
     => ( M != N ) ) ).

tff(fact_64_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S),T))
     => ( S != T ) ) ).

tff(fact_65_nat__less__cases,axiom,
    ! [Pa: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M1)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M1)) ) ) ) ).

tff(fact_66_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_67_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_68_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_69_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_70_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_71_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_72_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_73_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_74_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X1: A] :
      ( member(A,X1,A2)
    <=> pp(aa(A,bool,A2,X1)) ) ).

tff(fact_77_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_78_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,I,J)),I)) ).

tff(fact_79_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,J,I)),I)) ).

tff(fact_80_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),J))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),plus_plus(nat,J,M))) ) ).

tff(fact_81_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),J))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),plus_plus(nat,M,J))) ) ).

tff(fact_82_add__less__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),J))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,I,K)),plus_plus(nat,J,K))) ) ).

tff(fact_83_add__less__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),J))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),K),L))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,I,K)),plus_plus(nat,J,L))) ) ) ).

tff(fact_84_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),K),L))
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K,N) )
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N)) ) ) ).

tff(fact_85_add__lessD1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,I,J)),K))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),I),K)) ) ).

tff(fact_86_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A1: A] : ( cons(A,A1,List) != nil(A) ) ).

tff(fact_87_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A1: A] : ( nil(A) != cons(A,A1,List) ) ).

tff(fact_88_nat__less__le,axiom,
    ! [Na: nat,M1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
    <=> ( ord_less_eq(nat,M1,Na)
        & ( M1 != Na ) ) ) ).

tff(fact_89_le__eq__less__or__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less_eq(nat,M1,Na)
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
        | ( M1 = Na ) ) ) ).

tff(fact_90_less__imp__le__nat,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ord_less_eq(nat,M,N) ) ).

tff(fact_91_le__neq__implies__less,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ( M != N )
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N)) ) ) ).

tff(fact_92_less__or__eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
        | ( M = N ) )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_93_add__leE,axiom,
    ! [N: nat,K: nat,M: nat] :
      ( ord_less_eq(nat,plus_plus(nat,M,K),N)
     => ~ ( ord_less_eq(nat,M,N)
         => ~ ord_less_eq(nat,K,N) ) ) ).

tff(fact_94_add__leD1,axiom,
    ! [N: nat,K: nat,M: nat] :
      ( ord_less_eq(nat,plus_plus(nat,M,K),N)
     => ord_less_eq(nat,M,N) ) ).

tff(fact_95_add__leD2,axiom,
    ! [N: nat,K: nat,M: nat] :
      ( ord_less_eq(nat,plus_plus(nat,M,K),N)
     => ord_less_eq(nat,K,N) ) ).

tff(fact_96_add__le__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,K,L)
       => ord_less_eq(nat,plus_plus(nat,I,K),plus_plus(nat,J,L)) ) ) ).

tff(fact_97_add__le__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ord_less_eq(nat,plus_plus(nat,I,K),plus_plus(nat,J,K)) ) ).

tff(fact_98_trans__le__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ord_less_eq(nat,I,plus_plus(nat,M,J)) ) ).

tff(fact_99_trans__le__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ord_less_eq(nat,I,plus_plus(nat,J,M)) ) ).

%----Helper facts (11)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X),Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,e,d),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e)))))
    <=> ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),lab),lba))) ) ).

%------------------------------------------------------------------------------
