%------------------------------------------------------------------------------
% File     : SCT256_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 286
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_286 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  182 (  53 unt;  54 typ;   0 def)
%            Number of atoms       :  301 ( 109 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  241 (  68   ~;  12   |;  16   &)
%                                         (  24 <=>; 121  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   15 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   37 (  21   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-4 aty)
%            Number of functors    :   40 (  40 usr;  17 con; 0-5 aty)
%            Number of variables   :  386 ( 335   !;  11   ?; 386   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_Hilbert__Choice_Oinv__into,type,
    hilbert_inv_into: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,B) ) > fun(B,A) ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Omeasures,type,
    measures: 
      !>[A: $tType] : ( list(fun(A,nat)) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T1: $tType] : ( ( fun(A,fun(B,T1)) * product_prod(A,B) ) > T1 ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_Lba____,type,
    lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_P____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_c____,type,
    c: arrow_411405190le_alt ).

tff(sy_v_d____,type,
    d: arrow_411405190le_alt ).

tff(sy_v_e____,type,
    e: arrow_411405190le_alt ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

tff(sy_v_n____,type,
    n: nat ).

%----Relevant facts (100)
tff(fact_0__096c_A_126_061_Ad_096,axiom,
    c != d ).

tff(fact_1__096P_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p,arrow_610318064e_Prof) ).

tff(fact_2_dist,axiom,
    distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,c,cons(arrow_411405190le_alt,d,cons(arrow_411405190le_alt,e,nil(arrow_411405190le_alt))))) ).

tff(fact_3_dictator__def,axiom,
    ! [I: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I) ) ) ) ).

tff(fact_4__096c_A_060_092_060_094bsub_062P_A_Iinv_Ah_An_J_092_060_094esub_062_Ad_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,aa(nat,arrow_159774573e_indi,hilbert_inv_into(arrow_159774573e_indi,nat,top_top(fun(arrow_159774573e_indi,bool)),h),n))) ).

tff(fact_5__096_B_Bthesis_O_A_I_B_Be_O_Adistinct_A_091c_M_Ad_M_Ae_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [E: arrow_411405190le_alt] : ~ distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,c,cons(arrow_411405190le_alt,d,cons(arrow_411405190le_alt,E,nil(arrow_411405190le_alt))))) ).

tff(fact_6_PiProf,axiom,
    ! [Na: nat] : member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),Na)),lab),lba),arrow_610318064e_Prof) ).

tff(fact_7_n_I1_J,axiom,
    pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),n),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool))))) ).

tff(fact_8_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_9_nat__neq__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( M != Na )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),Na))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M)) ) ) ).

tff(fact_10_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_11_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_12_less__not__refl2,axiom,
    ! [M1: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M1))
     => ( M1 != N ) ) ).

tff(fact_13_less__not__refl3,axiom,
    ! [T: nat,S1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S1),T))
     => ( S1 != T ) ) ).

tff(fact_14_nat__less__cases,axiom,
    ! [Pa: fun(nat,fun(nat,bool)),Na: nat,M: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M)) )
     => ( ( ( M = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,Na),M)) ) ) ) ).

tff(fact_15__096Lba_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lba,arrow_1985332922le_Lin) ).

tff(fact_16__096Lab_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lab,arrow_1985332922le_Lin) ).

tff(fact_17_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_18_in__mktop,axiom,
    ! [Z1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,L1),Z1))
    <=> ( ( X1 != Z1 )
        & ( ( Y1 = Z1 )
         => ( X1 != Y1 ) )
        & ( ( Y1 != Z1 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ).

tff(fact_19_in__mkbot,axiom,
    ! [Z1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,L1),Z1))
    <=> ( ( Y1 != Z1 )
        & ( ( X1 = Z1 )
         => ( X1 != Y1 ) )
        & ( ( X1 != Z1 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ).

tff(fact_20_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_21_third__alt,axiom,
    ! [B2: arrow_411405190le_alt,A3: arrow_411405190le_alt] :
      ( ( A3 != B2 )
     => ? [C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A3,cons(arrow_411405190le_alt,B2,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ) ).

tff(fact_22_distinct__singleton,axiom,
    ! [A: $tType,X: A] : distinct(A,cons(A,X,nil(A))) ).

tff(fact_23_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_24_UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_25_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_26_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A6,List3) )
    <=> ( ( Aa = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_27_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B3))) ) ).

tff(fact_28_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A6,B5) )
    <=> ( ( Aa = A6 )
        & ( Ba = B5 ) ) ) ).

tff(fact_29_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),L1)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),L1) ) ) ).

tff(fact_30_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( ( X1 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y1,X1),L1) ) ) ) ).

tff(fact_31_const__Lin__Prof,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi),L1),arrow_610318064e_Prof) ) ).

tff(fact_32_above__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,L1),X1),Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_33_mkbot__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot,L1),X1),arrow_1985332922le_Lin) ) ).

tff(fact_34_mktop__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop,L1),X1),arrow_1985332922le_Lin) ) ).

tff(fact_35_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A5: A,B2: B,A3: A] :
      ( ( product_Pair(A,B,A3,B2) = product_Pair(A,B,A5,B4) )
     => ~ ( ( A3 = A5 )
         => ( B2 != B4 ) ) ) ).

tff(fact_36_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_37_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_38_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fTrue)) ) ).

tff(fact_39_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_1158827142_above,L1),Aa),Ba))
        <=> ( ( X1 != Y1 )
            & ( ( X1 = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y1),L1) )
            & ( ( X1 != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X1 = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Aa),L1) ) )
                & ( ( Y1 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_40_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X3,Xa),R1)
        <=> member(product_prod(A,B),product_Pair(A,B,X3,Xa),S) )
    <=> ( R1 = S ) ) ).

tff(fact_41_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_42_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_43_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xs1: list(A),Ba: A,Aa: A] :
      ( distinct(A,cons(A,Aa,cons(A,Ba,Xs1)))
    <=> ( ( Aa != Ba )
        & distinct(A,cons(A,Aa,Xs1))
        & distinct(A,cons(A,Ba,Xs1)) ) ) ).

tff(fact_44_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B3))) ) ).

tff(fact_45_inv__f__eq,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = Y1 )
       => ( aa(B,A,hilbert_inv_into(A,B,top_top(fun(A,bool)),F),Y1) = X1 ) ) ) ).

tff(fact_46_inv__f__f,axiom,
    ! [B: $tType,A: $tType,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( aa(B,A,hilbert_inv_into(A,B,top_top(fun(A,bool)),F),aa(A,B,F,X1)) = X1 ) ) ).

tff(fact_47_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X2: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),X2) ) ) ).

tff(fact_48_inj__fun,axiom,
    ! [B: $tType,C: $tType,A: $tType,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => inj_on(A,fun(C,B),combb(B,fun(C,B),A,combk(B,C),F),top_top(fun(A,bool))) ) ).

tff(fact_49_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A1: A,List: list(A)] : ( Y != cons(A,A1,List) ) ) ).

tff(fact_50_inj__on__def,axiom,
    ! [B: $tType,A: $tType,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
    <=> ! [X3: A] :
          ( member(A,X3,A2)
         => ! [Xa: A] :
              ( member(A,Xa,A2)
             => ( ( aa(A,B,F,X3) = aa(A,B,F,Xa) )
               => ( X3 = Xa ) ) ) ) ) ).

tff(fact_51_inj__on__contraD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( ( X1 != Y1 )
       => ( member(A,X1,A2)
         => ( member(A,Y1,A2)
           => ( aa(A,B,F,X1) != aa(A,B,F,Y1) ) ) ) ) ) ).

tff(fact_52_inj__on__iff,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( member(A,X1,A2)
       => ( member(A,Y1,A2)
         => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
          <=> ( X1 = Y1 ) ) ) ) ) ).

tff(fact_53_inj__onD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
       => ( member(A,X1,A2)
         => ( member(A,Y1,A2)
           => ( X1 = Y1 ) ) ) ) ) ).

tff(fact_54_inj__on__id2,axiom,
    ! [A: $tType,A2: fun(A,bool)] : inj_on(A,A,combi(A),A2) ).

tff(fact_55_injD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
       => ( X1 = Y1 ) ) ) ).

tff(fact_56_inj__eq,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
      <=> ( X1 = Y1 ) ) ) ).

tff(fact_57_inv__into__f__eq,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( member(A,X1,A2)
       => ( ( aa(A,B,F,X1) = Y1 )
         => ( aa(B,A,hilbert_inv_into(A,B,A2,F),Y1) = X1 ) ) ) ) ).

tff(fact_58_inv__into__f__f,axiom,
    ! [B: $tType,A: $tType,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( member(A,X1,A2)
       => ( aa(B,A,hilbert_inv_into(A,B,A2,F),aa(A,B,F,X1)) = X1 ) ) ) ).

tff(fact_59_inj__imp__inv__eq,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ! [X2: B] : ( aa(A,B,F,aa(B,A,G,X2)) = X2 )
       => ( hilbert_inv_into(A,B,top_top(fun(A,bool)),F) = G ) ) ) ).

tff(fact_60_injI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B)] :
      ( ! [X2: A,Y3: A] :
          ( ( aa(A,B,F,X2) = aa(A,B,F,Y3) )
         => ( X2 = Y3 ) )
     => inj_on(A,B,F,top_top(fun(A,bool))) ) ).

tff(fact_61_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y2: A,Ys: list(A)] : ( Xs1 = cons(A,Y2,Ys) ) ) ).

tff(fact_62_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),arrow_319942042_below(L1,Aa,Ba))
        <=> ( ( X1 != Y1 )
            & ( ( Y1 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Ba),L1) )
            & ( ( Y1 != Aa )
             => ( ( ( X1 = Aa )
                 => ( ( Y1 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Y1),L1) ) )
                & ( ( X1 != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_63_below__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L1,X1,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_64_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F1,Aa),Ba) ) ).

tff(fact_65_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X1: B] : ( aa(B,A,top_top(fun(B,A)),X1) = top_top(A) ) ) ).

tff(fact_66_not__top__less,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A3: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),top_top(A)),A3)) ) ).

tff(fact_67_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( ( X != Y )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_68_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_69_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z)) ) ) ) ).

tff(fact_70_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
         => ( ( B2 = C2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C2)) ) ) ) ).

tff(fact_71_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),C2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C2)) ) ) ) ).

tff(fact_72_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),A3)) ) ) ).

tff(fact_73_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Pa: bool,Y1: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X1))
           => pp(Pa) ) ) ) ).

tff(fact_74_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( Y != X ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X1: A] :
      ( member(A,X1,A2)
    <=> pp(aa(A,bool,A2,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( collect(A,Pa) = Pa ) ).

tff(fact_78_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_79_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_80_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_81_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_82_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_83_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X1))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_84_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
          | ( X = Y )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_85_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X1))
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_86_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X1)) ) ) ) ).

tff(fact_87_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),X)) ) ).

tff(fact_88_less__top,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [Aa: A] :
          ( ( Aa != top_top(A) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),top_top(A))) ) ) ).

tff(fact_89_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_90_alt3,axiom,
    ? [A1: arrow_411405190le_alt,B1: arrow_411405190le_alt,C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A1,cons(arrow_411405190le_alt,B1,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ).

tff(fact_91_in__measures_I2_J,axiom,
    ! [A: $tType,Fs: list(fun(A,nat)),F: fun(A,nat),Y1: A,X1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X1,Y1),measures(A,cons(fun(A,nat),F,Fs)))
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(A,nat,F,X1)),aa(A,nat,F,Y1)))
        | ( ( aa(A,nat,F,X1) = aa(A,nat,F,Y1) )
          & member(product_prod(A,A),product_Pair(A,A,X1,Y1),measures(A,Fs)) ) ) ) ).

tff(fact_92_in__measures_I1_J,axiom,
    ! [A: $tType,Y1: A,X1: A] : ~ member(product_prod(A,A),product_Pair(A,A,X1,Y1),measures(A,nil(fun(A,nat)))) ).

tff(fact_93_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( distinct(A,Xs)
     => distinct(A,insert(A,X,Xs)) ) ).

tff(fact_94_measures__less,axiom,
    ! [A: $tType,Fs: list(fun(A,nat)),Y1: A,X1: A,F: fun(A,nat)] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(A,nat,F,X1)),aa(A,nat,F,Y1)))
     => member(product_prod(A,A),product_Pair(A,A,X1,Y1),measures(A,cons(fun(A,nat),F,Fs))) ) ).

tff(fact_95_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_96__096b_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lba) ).

tff(fact_97__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_98__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lab) ).

tff(fact_99__096_Ib_M_Aa_J_A_126_058_ALab_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lab) ).

%----Arities (13)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (14)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X),Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_424895264_mktop,p),e)),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combs(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,fequal(nat),h),n)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_1158827142_above,p),c),e)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_159774573e_indi,arrow_276188178_mkbot,p),e))),arrow_610318064e_Prof) ).

%------------------------------------------------------------------------------
