%------------------------------------------------------------------------------
% File     : SCT255_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 282
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_282 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  166 (  51 unt;  46 typ;   0 def)
%            Number of atoms       :  288 (  97 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  227 (  59   ~;   5   |;   4   &)
%                                         (  29 <=>; 130  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   44 (  25   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   1 prp; 0-4 aty)
%            Number of functors    :   27 (  27 usr;   9 con; 0-6 aty)
%            Number of variables   :  480 ( 433   !;  10   ?; 480   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:29
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (39)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_Hilbert__Choice_Oinv__into,type,
    hilbert_inv_into: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,B) ) > fun(B,A) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C1: $tType] : ( ( fun(product_prod(A,B),C1) * A * B ) > C1 ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C1: $tType] : ( ( fun(A,fun(B,C1)) * product_prod(A,B) ) > C1 ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_c____,type,
    c: arrow_411405190le_alt ).

tff(sy_v_d____,type,
    d: arrow_411405190le_alt ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (100)
tff(fact_0__096c_A_126_061_Ad_096,axiom,
    c != d ).

tff(fact_1_third__alt,axiom,
    ! [B1: arrow_411405190le_alt,A1: arrow_411405190le_alt] :
      ( ( A1 != B1 )
     => ? [C2: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A1,cons(arrow_411405190le_alt,B1,cons(arrow_411405190le_alt,C2,nil(arrow_411405190le_alt))))) ) ).

tff(fact_2__096c_A_060_092_060_094bsub_062P_A_Iinv_Ah_An_J_092_060_094esub_062_Ad_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,c,d),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,aa(nat,arrow_159774573e_indi,hilbert_inv_into(arrow_159774573e_indi,nat,top_top(fun(arrow_159774573e_indi,bool)),h),n))) ).

tff(fact_3_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_4_distinct__singleton,axiom,
    ! [A: $tType,X: A] : distinct(A,cons(A,X,nil(A))) ).

tff(fact_5_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A4: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A4,List3) )
    <=> ( ( Aa = A4 )
        & ( List = List3 ) ) ) ).

tff(fact_6_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xs1: list(A),Ba: A,Aa: A] :
      ( distinct(A,cons(A,Aa,cons(A,Ba,Xs1)))
    <=> ( ( Aa != Ba )
        & distinct(A,cons(A,Aa,Xs1))
        & distinct(A,cons(A,Ba,Xs1)) ) ) ).

tff(fact_7_alt3,axiom,
    ? [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt,C2: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A3,cons(arrow_411405190le_alt,B2,cons(arrow_411405190le_alt,C2,nil(arrow_411405190le_alt))))) ).

tff(fact_8_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A6: A] : ( nil(A) != cons(A,A6,List2) ) ).

tff(fact_9_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A6: A] : ( cons(A,A6,List2) != nil(A) ) ).

tff(fact_10_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y3: A,Ys1: list(A)] : ( Xs1 = cons(A,Y3,Ys1) ) ) ).

tff(fact_11_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List1: list(A)] : ( Y != cons(A,A3,List1) ) ) ).

tff(fact_12_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_13_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_14_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_15__096P_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p,arrow_610318064e_Prof) ).

tff(fact_16_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_17_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( distinct(A,Xs)
     => distinct(A,insert(A,X,Xs)) ) ).

tff(fact_18_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_19_UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_20_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_21_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B4))) ) ).

tff(fact_22_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B3: B,A4: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A4,B3) )
    <=> ( ( Aa = A4 )
        & ( Ba = B3 ) ) ) ).

tff(fact_23_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X1: B] : ( aa(B,A,top_top(fun(B,A)),X1) = top_top(A) ) ) ).

tff(fact_24_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_25_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,nil(B)) = F11 ) ).

tff(fact_26_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_27_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_28_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_29_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,B1: B,A1: A] :
      ( ( product_Pair(A,B,A1,B1) = product_Pair(A,B,A6,B5) )
     => ~ ( ( A1 = A6 )
         => ( B1 != B5 ) ) ) ).

tff(fact_30_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_31_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F21,Aa),List) ) ).

tff(fact_32_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B4))) ) ).

tff(fact_33_inv__f__eq,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = Y1 )
       => ( aa(B,A,hilbert_inv_into(A,B,top_top(fun(A,bool)),F),Y1) = X1 ) ) ) ).

tff(fact_34_inv__f__f,axiom,
    ! [B: $tType,A: $tType,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( aa(B,A,hilbert_inv_into(A,B,top_top(fun(A,bool)),F),aa(A,B,F,X1)) = X1 ) ) ).

tff(fact_35_inv__into__f__f,axiom,
    ! [B: $tType,A: $tType,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( member(A,X1,A2)
       => ( aa(B,A,hilbert_inv_into(A,B,A2,F),aa(A,B,F,X1)) = X1 ) ) ) ).

tff(fact_36_inv__into__f__eq,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( member(A,X1,A2)
       => ( ( aa(A,B,F,X1) = Y1 )
         => ( aa(B,A,hilbert_inv_into(A,B,A2,F),Y1) = X1 ) ) ) ) ).

tff(fact_37_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,F11: fun(B,fun(C1,A))] : ( product_prod_rec(B,C1,A,F11,product_Pair(B,C1,Aa,Ba)) = aa(C1,A,aa(B,fun(C1,A),F11,Aa),Ba) ) ).

tff(fact_38_inj__eq,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
      <=> ( X1 = Y1 ) ) ) ).

tff(fact_39_inj__on__def,axiom,
    ! [B: $tType,A: $tType,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
    <=> ! [X3: A] :
          ( member(A,X3,A2)
         => ! [Xa: A] :
              ( member(A,Xa,A2)
             => ( ( aa(A,B,F,X3) = aa(A,B,F,Xa) )
               => ( X3 = Xa ) ) ) ) ) ).

tff(fact_40_inj__on__contraD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( ( X1 != Y1 )
       => ( member(A,X1,A2)
         => ( member(A,Y1,A2)
           => ( aa(A,B,F,X1) != aa(A,B,F,Y1) ) ) ) ) ) ).

tff(fact_41_inj__on__iff,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( member(A,X1,A2)
       => ( member(A,Y1,A2)
         => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
          <=> ( X1 = Y1 ) ) ) ) ) ).

tff(fact_42_inj__onD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A2: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A2)
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
       => ( member(A,X1,A2)
         => ( member(A,Y1,A2)
           => ( X1 = Y1 ) ) ) ) ) ).

tff(fact_43_injD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
       => ( X1 = Y1 ) ) ) ).

tff(fact_44_inj__imp__inv__eq,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ! [X2: B] : ( aa(A,B,F,aa(B,A,G,X2)) = X2 )
       => ( hilbert_inv_into(A,B,top_top(fun(A,bool)),F) = G ) ) ) ).

tff(fact_45_injI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B)] :
      ( ! [X2: A,Y2: A] :
          ( ( aa(A,B,F,X2) = aa(A,B,F,Y2) )
         => ( X2 = Y2 ) )
     => inj_on(A,B,F,top_top(fun(A,bool))) ) ).

tff(fact_46_dictator__def,axiom,
    ! [I2: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I2)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I2) ) ) ) ).

tff(fact_47_inj__onI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A2: fun(A,bool)] :
      ( ! [X2: A,Y2: A] :
          ( member(A,X2,A2)
         => ( member(A,Y2,A2)
           => ( ( aa(A,B,F,X2) = aa(A,B,F,Y2) )
             => ( X2 = Y2 ) ) ) )
     => inj_on(A,B,F,A2) ) ).

tff(fact_48_inj__on__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),A2: fun(A,bool)] :
      ( ! [A3: A] :
          ( member(A,A3,A2)
         => ( aa(A,B,F,A3) = aa(A,B,G,A3) ) )
     => ( inj_on(A,B,F,A2)
      <=> inj_on(A,B,G,A2) ) ) ).

tff(fact_49_inj__on__inverseI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),G: fun(B,A),A2: fun(A,bool)] :
      ( ! [X2: A] :
          ( member(A,X2,A2)
         => ( aa(B,A,G,aa(A,B,F,X2)) = X2 ) )
     => inj_on(A,B,F,A2) ) ).

tff(fact_50_UNIV__eq__I,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [X2: A] : member(A,X2,A2)
     => ( top_top(fun(A,bool)) = A2 ) ) ).

tff(fact_51_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_52_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [Xa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa,arrow_610318064e_Prof)
             => ! [A5: arrow_411405190le_alt,B4: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa)) ) ) ) ) ) ).

tff(fact_53_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_54_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [A5: arrow_411405190le_alt,B4: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3)) ) ) ) ).

tff(fact_55_prod__induct6,axiom,
    ! [F1: $tType,E1: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1))))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D1: D,E2: E1,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1)))),A3,product_Pair(B,product_prod(C1,product_prod(D,product_prod(E1,F1))),B2,product_Pair(C1,product_prod(D,product_prod(E1,F1)),C2,product_Pair(D,product_prod(E1,F1),D1,product_Pair(E1,F1,E2,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1))))),bool,Pa,X1)) ) ).

tff(fact_56_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E1: $tType,F1: $tType,Y: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1)))))] :
      ~ ! [A3: A,B2: B,C2: C1,D1: D,E2: E1,F2: F1] : ( Y != product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E1,F1)))),A3,product_Pair(B,product_prod(C1,product_prod(D,product_prod(E1,F1))),B2,product_Pair(C1,product_prod(D,product_prod(E1,F1)),C2,product_Pair(D,product_prod(E1,F1),D1,product_Pair(E1,F1,E2,F2))))) ) ).

tff(fact_57_prod__induct5,axiom,
    ! [E1: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E1)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E1)))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D1: D,E2: E1] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E1)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E1))),A3,product_Pair(B,product_prod(C1,product_prod(D,E1)),B2,product_Pair(C1,product_prod(D,E1),C2,product_Pair(D,E1,D1,E2))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E1)))),bool,Pa,X1)) ) ).

tff(fact_58_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_59__C3_C,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
         => ( ! [I: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ).

tff(fact_60_pairwise__neutrality,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B3 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
           => ( ! [I: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ).

tff(fact_61__C4_C,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ca: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != Ca )
       => ( ( Aa != Ca )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
             => ( ! [I: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Ca),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Ca),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ) ).

tff(fact_62__C1_C,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B3 )
       => ( ( Aa != B3 )
         => ( ( Ba != A4 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
               => ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ) ) ).

tff(fact_63__C2_C,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B3 )
       => ( ( Aa != B3 )
         => ( ( Ba != A4 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
               => ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ) ) ).

tff(fact_64_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E1: $tType,Y: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E1))))] :
      ~ ! [A3: A,B2: B,C2: C1,D1: D,E2: E1] : ( Y != product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E1))),A3,product_Pair(B,product_prod(C1,product_prod(D,E1)),B2,product_Pair(C1,product_prod(D,E1),C2,product_Pair(D,E1,D1,E2)))) ) ).

tff(fact_65_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C1,D)))] :
      ~ ! [A3: A,B2: B,C2: C1,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C1,D)),A3,product_Pair(B,product_prod(C1,D),B2,product_Pair(C1,D,C2,D1))) ) ).

tff(fact_66_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C1,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C1,D))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C1,D)),A3,product_Pair(B,product_prod(C1,D),B2,product_Pair(C1,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,Pa,X1)) ) ).

tff(fact_67_prod__induct3,axiom,
    ! [C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C1)),Pa: fun(product_prod(A,product_prod(B,C1)),bool)] :
      ( ! [A3: A,B2: B,C2: C1] : pp(aa(product_prod(A,product_prod(B,C1)),bool,Pa,product_Pair(A,product_prod(B,C1),A3,product_Pair(B,C1,B2,C2))))
     => pp(aa(product_prod(A,product_prod(B,C1)),bool,Pa,X1)) ) ).

tff(fact_68_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Y: product_prod(A,product_prod(B,C1))] :
      ~ ! [A3: A,B2: B,C2: C1] : ( Y != product_Pair(A,product_prod(B,C1),A3,product_Pair(B,C1,B2,C2)) ) ).

tff(fact_69_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X2: A,Y2: B] : ( P1 != product_Pair(A,B,X2,Y2) ) ).

tff(fact_70_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A3: A,B2: B] : ( Y != product_Pair(A,B,A3,B2) ) ).

tff(fact_71_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,Ca: fun(B,fun(C1,A))] : ( produc1605651328_split(B,C1,A,Ca,product_Pair(B,C1,Aa,Ba)) = aa(C1,A,aa(B,fun(C1,A),Ca,Aa),Ba) ) ).

tff(fact_72_curry__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Ba: C1,Aa: B,F: fun(product_prod(B,C1),A)] : ( product_curry(B,C1,A,F,Aa,Ba) = aa(product_prod(B,C1),A,F,product_Pair(B,C1,Aa,Ba)) ) ).

tff(fact_73_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_74_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X1: A] :
      ( member(A,X1,A2)
    <=> pp(aa(A,bool,A2,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( collect(A,Pa) = Pa ) ).

tff(fact_78_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_79_n_I1_J,axiom,
    ord_less(nat,n,finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))) ).

tff(fact_80_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ~ list_ex1(A,Pa,nil(A)) ).

tff(fact_81_less__top,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [Aa: A] :
          ( ( Aa != top_top(A) )
        <=> ord_less(A,Aa,top_top(A)) ) ) ).

tff(fact_82_not__top__less,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A1: A] : ~ ord_less(A,top_top(A),A1) ) ).

tff(fact_83_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_84_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
        <=> ( ord_less(A,X1,Y1)
            | ord_less(A,Y1,X1) ) ) ) ).

tff(fact_85_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
        <=> ( ord_less(A,Y1,X1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_86_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_87_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ~ ord_less(A,Y1,X1)
         => ( ~ ord_less(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_88_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_89_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_90_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_91_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_92_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_93_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( Y != X ) ) ) ).

tff(fact_94_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Pa: bool,Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( ord_less(A,Y1,X1)
           => pp(Pa) ) ) ) ).

tff(fact_95_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ~ ord_less(A,B1,A1) ) ) ).

tff(fact_96_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less(A,B1,C)
           => ord_less(A,A1,C) ) ) ) ).

tff(fact_97_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ( B1 = C )
           => ord_less(A,A1,C) ) ) ) ).

tff(fact_98_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_99_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

%----Arities (13)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [E: arrow_411405190le_alt] :
      ( distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,c,cons(arrow_411405190le_alt,d,cons(arrow_411405190le_alt,E,nil(arrow_411405190le_alt)))))
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
