%------------------------------------------------------------------------------
% File     : SCT254_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 280
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_280 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  163 (  42 unt;  42 typ;   0 def)
%            Number of atoms       :  336 (  98 equ)
%            Maximal formula atoms :   10 (   2 avg)
%            Number of connectives :  272 (  57   ~;   5   |;  12   &)
%                                         (  30 <=>; 168  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   37 (  22   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-4 aty)
%            Number of functors    :   23 (  23 usr;   6 con; 0-6 aty)
%            Number of variables   :  501 ( 457   !;   9   ?; 501   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:27
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Complete__Lattices_Ocomplete__lattice,type,
    comple187826305attice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Complete__Lattices_Ocomplete__linorder,type,
    comple1035589618norder: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Complete__Lattices_OSup__class_OSup,type,
    complete_Sup_Sup: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Fun_Oid,type,
    id: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_Hilbert__Choice_Oinv__into,type,
    hilbert_inv_into: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,B) ) > fun(B,A) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_OPow,type,
    pow: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(A,bool),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

tff(sy_v_n____,type,
    n: nat ).

%----Relevant facts (100)
tff(fact_0_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_1_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_2_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_3_top1I,axiom,
    ! [A: $tType,X: A] : pp(aa(A,bool,top_top(fun(A,bool)),X)) ).

tff(fact_4_UNIV__I,axiom,
    ! [A: $tType,X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_5_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_6_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X: B] : ( aa(B,A,top_top(fun(B,A)),X) = top_top(A) ) ) ).

tff(fact_7_n_I1_J,axiom,
    ord_less(nat,n,finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))) ).

tff(fact_8_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_9_dictator__def,axiom,
    ! [I2: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I2)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I2) ) ) ) ).

tff(fact_10_inv__equality,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),G: fun(B,A)] :
      ( ! [X1: A] : ( aa(B,A,G,aa(A,B,F,X1)) = X1 )
     => ( ! [Y1: B] : ( aa(A,B,F,aa(B,A,G,Y1)) = Y1 )
       => ( hilbert_inv_into(A,B,top_top(fun(A,bool)),F) = G ) ) ) ).

tff(fact_11_Sup__UNIV,axiom,
    ! [A: $tType] :
      ( comple187826305attice(A)
     => ( complete_Sup_Sup(A,top_top(fun(A,bool))) = top_top(A) ) ) ).

tff(fact_12_inv__id,axiom,
    ! [A: $tType] : ( hilbert_inv_into(A,A,top_top(fun(A,bool)),id(A)) = id(A) ) ).

tff(fact_13_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_14_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X1: A] : member(A,X1,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_15_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ~ ord_less(A,X2,X2) ) ).

tff(fact_16_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
        <=> ( ord_less(A,X,Y)
            | ord_less(A,Y,X) ) ) ) ).

tff(fact_17_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
        <=> ( ord_less(A,Y,X)
            | ( X = Y ) ) ) ) ).

tff(fact_18_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
          | ( X2 = Y2 )
          | ord_less(A,Y2,X2) ) ) ).

tff(fact_19_less__Sup__iff,axiom,
    ! [A: $tType] :
      ( comple1035589618norder(A)
     => ! [S: fun(A,bool),Aa: A] :
          ( ord_less(A,Aa,complete_Sup_Sup(A,S))
        <=> ? [X4: A] :
              ( member(A,X4,S)
              & ord_less(A,Aa,X4) ) ) ) ).

tff(fact_20_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ~ ord_less(A,Y,X)
         => ( ~ ord_less(A,X,Y)
          <=> ( X = Y ) ) ) ) ).

tff(fact_21_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
         => ( ~ ord_less(A,X2,Y2)
           => ord_less(A,Y2,X2) ) ) ) ).

tff(fact_22_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( X2 != Y2 ) ) ) ).

tff(fact_23_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ~ ord_less(A,Y2,X2) ) ) ).

tff(fact_24_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ~ ord_less(A,Y2,X2) ) ) ).

tff(fact_25_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( X2 != Y2 ) ) ) ).

tff(fact_26_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( Y2 != X2 ) ) ) ).

tff(fact_27_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,X)
           => pp(P1) ) ) ) ).

tff(fact_28_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B3: A,A4: A] :
          ( ord_less(A,A4,B3)
         => ~ ord_less(A,B3,A4) ) ) ).

tff(fact_29_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C4: A,B3: A,A4: A] :
          ( ( A4 = B3 )
         => ( ord_less(A,B3,C4)
           => ord_less(A,A4,C4) ) ) ) ).

tff(fact_30_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C4: A,B3: A,A4: A] :
          ( ord_less(A,A4,B3)
         => ( ( B3 = C4 )
           => ord_less(A,A4,C4) ) ) ) ).

tff(fact_31_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( ord_less(A,Y2,Z2)
           => ord_less(A,X2,Z2) ) ) ) ).

tff(fact_32_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ~ ord_less(A,Y2,X2) ) ) ).

tff(fact_33_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less(A,X2,Y2)
         => ( ( X2 != Y2 )
           => ord_less(A,Y2,X2) ) ) ) ).

tff(fact_34_Union__UNIV,axiom,
    ! [A: $tType] : ( complete_Sup_Sup(fun(A,bool),top_top(fun(fun(A,bool),bool))) = top_top(fun(A,bool)) ) ).

tff(fact_35_less__top,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [Aa: A] :
          ( ( Aa != top_top(A) )
        <=> ord_less(A,Aa,top_top(A)) ) ) ).

tff(fact_36_not__top__less,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A4: A] : ~ ord_less(A,top_top(A),A4) ) ).

tff(fact_37_inv__into__f__eq,axiom,
    ! [B: $tType,A: $tType,Y: B,X: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(A,X,A1)
       => ( ( aa(A,B,F,X) = Y )
         => ( aa(B,A,hilbert_inv_into(A,B,A1,F),Y) = X ) ) ) ) ).

tff(fact_38_inv__into__f__f,axiom,
    ! [B: $tType,A: $tType,X: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(A,X,A1)
       => ( aa(B,A,hilbert_inv_into(A,B,A1,F),aa(A,B,F,X)) = X ) ) ) ).

tff(fact_39_inv__f__eq,axiom,
    ! [B: $tType,A: $tType,Y: B,X: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X) = Y )
       => ( aa(B,A,hilbert_inv_into(A,B,top_top(fun(A,bool)),F),Y) = X ) ) ) ).

tff(fact_40_inv__f__f,axiom,
    ! [B: $tType,A: $tType,X: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( aa(B,A,hilbert_inv_into(A,B,top_top(fun(A,bool)),F),aa(A,B,F,X)) = X ) ) ).

tff(fact_41_Sup__eq__top__iff,axiom,
    ! [A: $tType] :
      ( comple1035589618norder(A)
     => ! [A1: fun(A,bool)] :
          ( ( complete_Sup_Sup(A,A1) = top_top(A) )
        <=> ! [X4: A] :
              ( ord_less(A,X4,top_top(A))
             => ? [Xa: A] :
                  ( member(A,Xa,A1)
                  & ord_less(A,X4,Xa) ) ) ) ) ).

tff(fact_42_inj__imp__inv__eq,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ! [X1: B] : ( aa(A,B,F,aa(B,A,G,X1)) = X1 )
       => ( hilbert_inv_into(A,B,top_top(fun(A,bool)),F) = G ) ) ) ).

tff(fact_43_inj__on__id,axiom,
    ! [A: $tType,A1: fun(A,bool)] : inj_on(A,A,id(A),A1) ).

tff(fact_44_injD,axiom,
    ! [B: $tType,A: $tType,Y: A,X: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X) = aa(A,B,F,Y) )
       => ( X = Y ) ) ) ).

tff(fact_45_inj__eq,axiom,
    ! [B: $tType,A: $tType,Y: A,X: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X) = aa(A,B,F,Y) )
      <=> ( X = Y ) ) ) ).

tff(fact_46__C3_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
         => ( ! [I1: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I1)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ).

tff(fact_47_pairwise__neutrality,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A6: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A6 != B5 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
           => ( ! [I1: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I1)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ).

tff(fact_48__C4_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),C1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != C1 )
       => ( ( Aa != C1 )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
             => ( ! [I1: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,C1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I1)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,C1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ).

tff(fact_49_UnionI,axiom,
    ! [A: $tType,A1: A,C3: fun(fun(A,bool),bool),X6: fun(A,bool)] :
      ( member(fun(A,bool),X6,C3)
     => ( member(A,A1,X6)
       => member(A,A1,complete_Sup_Sup(fun(A,bool),C3)) ) ) ).

tff(fact_50__C2_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A6: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A6 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A6 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_51__C1_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A6: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A6 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A6 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_52_inj__onD,axiom,
    ! [B: $tType,A: $tType,Y: A,X: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( ( aa(A,B,F,X) = aa(A,B,F,Y) )
       => ( member(A,X,A1)
         => ( member(A,Y,A1)
           => ( X = Y ) ) ) ) ) ).

tff(fact_53_inj__on__iff,axiom,
    ! [B: $tType,A: $tType,Y: A,X: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(A,X,A1)
       => ( member(A,Y,A1)
         => ( ( aa(A,B,F,X) = aa(A,B,F,Y) )
          <=> ( X = Y ) ) ) ) ) ).

tff(fact_54_inj__on__contraD,axiom,
    ! [B: $tType,A: $tType,Y: A,X: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( ( X != Y )
       => ( member(A,X,A1)
         => ( member(A,Y,A1)
           => ( aa(A,B,F,X) != aa(A,B,F,Y) ) ) ) ) ) ).

tff(fact_55_inj__on__def,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
    <=> ! [X4: A] :
          ( member(A,X4,A1)
         => ! [Xa: A] :
              ( member(A,Xa,A1)
             => ( ( aa(A,B,F,X4) = aa(A,B,F,Xa) )
               => ( X4 = Xa ) ) ) ) ) ).

tff(fact_56_id__apply,axiom,
    ! [A: $tType,X2: A] : ( aa(A,A,id(A),X2) = X2 ) ).

tff(fact_57_id__def,axiom,
    ! [A: $tType,X5: A] : ( aa(A,A,id(A),X5) = X5 ) ).

tff(fact_58_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ! [Xa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa,arrow_610318064e_Prof)
             => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
                  ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa)) ) ) ) ) ) ).

tff(fact_59_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
              ( ! [I: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4)) ) ) ) ).

tff(fact_60_UnionE,axiom,
    ! [A: $tType,C3: fun(fun(A,bool),bool),A1: A] :
      ( member(A,A1,complete_Sup_Sup(fun(A,bool),C3))
     => ~ ! [X3: fun(A,bool)] :
            ( member(A,A1,X3)
           => ~ member(fun(A,bool),X3,C3) ) ) ).

tff(fact_61_injI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B)] :
      ( ! [X1: A,Y1: A] :
          ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
         => ( X1 = Y1 ) )
     => inj_on(A,B,F,top_top(fun(A,bool))) ) ).

tff(fact_62_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X12))
    <=> ! [A3: A,B2: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A3,B2))) ) ).

tff(fact_63_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A6,B5) )
    <=> ( ( Aa = A6 )
        & ( Ba = B5 ) ) ) ).

tff(fact_64_inj__onI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X1: A,Y1: A] :
          ( member(A,X1,A1)
         => ( member(A,Y1,A1)
           => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
             => ( X1 = Y1 ) ) ) )
     => inj_on(A,B,F,A1) ) ).

tff(fact_65_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A5: A,B3: B,A4: A] :
      ( ( product_Pair(A,B,A4,B3) = product_Pair(A,B,A5,B4) )
     => ~ ( ( A4 = A5 )
         => ( B3 != B4 ) ) ) ).

tff(fact_66_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X12))
    <=> ? [A3: A,B2: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A3,B2))) ) ).

tff(fact_67_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F11,Aa),Ba) ) ).

tff(fact_68_inj__on__inverseI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),G: fun(B,A),A1: fun(A,bool)] :
      ( ! [X1: A] :
          ( member(A,X1,A1)
         => ( aa(B,A,G,aa(A,B,F,X1)) = X1 ) )
     => inj_on(A,B,F,A1) ) ).

tff(fact_69_inj__on__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [A2: A] :
          ( member(A,A2,A1)
         => ( aa(A,B,F,A2) = aa(A,B,G,A2) ) )
     => ( inj_on(A,B,F,A1)
      <=> inj_on(A,B,G,A1) ) ) ).

tff(fact_70_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y2: product_prod(A,B)] :
      ~ ! [A2: A,B1: B] : ( Y2 != product_Pair(A,B,A2,B1) ) ).

tff(fact_71_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X1: A,Y1: B] : ( P2 != product_Pair(A,B,X1,Y1) ) ).

tff(fact_72_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B1,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,X)) ) ).

tff(fact_73_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A2: A,B1: B,C2: C,D1: D,E1: E,F2: F1] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B1,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_74_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B1: B,C2: C,D1: D,E1: E] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,X)) ) ).

tff(fact_79_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,X)) ) ).

tff(fact_80_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A,B1: B,C2: C,D1: D] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C2,D1))) ) ).

tff(fact_81_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y2: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B1: B,C2: C] : ( Y2 != product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B1,C2)) ) ).

tff(fact_82_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B1: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B1,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,X)) ) ).

tff(fact_83_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),C1,Aa),Ba) ) ).

tff(fact_84_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,Ba: B,F: fun(B,A),Aa: A] :
          ( ord_less(A,Aa,aa(B,A,F,Ba))
         => ( ord_less(B,Ba,C1)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less(B,X1,Y1)
                 => ord_less(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,Aa,aa(B,A,F,C1)) ) ) ) ) ).

tff(fact_85_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [X11: A] : ord_less(A,X,X11) ) ).

tff(fact_86_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X2: A] :
        ? [Y1: A] : ord_less(A,Y1,X2) ) ).

tff(fact_87_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,Ba: B,F: fun(B,A),Aa: A] :
          ( ( Aa = aa(B,A,F,Ba) )
         => ( ord_less(B,Ba,C1)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less(B,X1,Y1)
                 => ord_less(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,Aa,aa(B,A,F,C1)) ) ) ) ) ).

tff(fact_88_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),Ba: A,Aa: A] :
          ( ord_less(A,Aa,Ba)
         => ( ord_less(B,aa(A,B,F,Ba),C1)
           => ( ! [X1: A,Y1: A] :
                  ( ord_less(A,X1,Y1)
                 => ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1)) )
             => ord_less(B,aa(A,B,F,Aa),C1) ) ) ) ) ).

tff(fact_89_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ? [Z1: A] :
              ( ord_less(A,X2,Z1)
              & ord_less(A,Z1,Y2) ) ) ) ).

tff(fact_90_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F: fun(A,B),Ba: A,Aa: A] :
          ( ord_less(A,Aa,Ba)
         => ( ( aa(A,B,F,Ba) = C1 )
           => ( ! [X1: A,Y1: A] :
                  ( ord_less(A,X1,Y1)
                 => ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1)) )
             => ord_less(B,aa(A,B,F,Aa),C1) ) ) ) ) ).

tff(fact_91_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,Ba) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,Ba)) ) ).

tff(fact_92_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),arrow_424895264_mktop(L,Z))
    <=> ( ( X != Z )
        & ( ( Y = Z )
         => ( X != Y ) )
        & ( ( Y != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),L) ) ) ) ).

tff(fact_93_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_94_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_95_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_96_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y != Z )
        & ( ( X = Z )
         => ( X != Y ) )
        & ( ( X != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),L) ) ) ) ).

tff(fact_97_Pow__UNIV,axiom,
    ! [A: $tType] : ( pow(A,top_top(fun(A,bool))) = top_top(fun(fun(A,bool),bool)) ) ).

tff(fact_98_Union__Pow__eq,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( complete_Sup_Sup(fun(A,bool),pow(A,A1)) = A1 ) ).

tff(fact_99_Pow__top,axiom,
    ! [A: $tType,A1: fun(A,bool)] : member(fun(A,bool),A1,pow(A,A1)) ).

%----Arities (15)
tff(arity_fun___Complete__Lattices_Ocomplete__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( comple187826305attice(T_2)
     => comple187826305attice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Complete__Lattices_Ocomplete__lattice,axiom,
    comple187826305attice(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    arrow_987702531ctator(f,aa(nat,arrow_159774573e_indi,hilbert_inv_into(arrow_159774573e_indi,nat,top_top(fun(arrow_159774573e_indi,bool)),h),n)) ).

%------------------------------------------------------------------------------
