%------------------------------------------------------------------------------
% File     : SCT252_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 275
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_275 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.50 v7.1.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  161 (  46 unt;  45 typ;   0 def)
%            Number of atoms       :  282 (  73 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  209 (  43   ~;   5   |;   6   &)
%                                         (  35 <=>; 120  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   27 (  16   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :   17 (  16 usr;   0 prp; 1-4 aty)
%            Number of functors    :   25 (  25 usr;  10 con; 0-5 aty)
%            Number of variables   :  276 ( 238   !;   3   ?; 276   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:23
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (39)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_Lba____,type,
    lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

%----Relevant facts (98)
tff(fact_0_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_1_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_2__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_3__096Lab_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lab,arrow_1985332922le_Lin) ).

tff(fact_4__096Lba_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lba,arrow_1985332922le_Lin) ).

tff(fact_5__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lab) ).

tff(fact_6__096b_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lba) ).

tff(fact_7__096_B_Bn_O_A_I_Ia_M_Ab_J_A_126_058_AF_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_ALab_Aelse_ALba_J_J_A_061_A_Ib_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_An_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Aa_J_096,axiom,
    ! [N2: nat] :
      ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N2)),lab),lba)))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N2)),lab),lba))) ) ).

tff(fact_8__C2_C,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool))))),lab),lba))) ).

tff(fact_9__096_Ib_M_Aa_J_A_126_058_ALab_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lab) ).

tff(fact_10__096_Ia_M_Ab_J_A_126_058_ALba_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lba) ).

tff(fact_11__096EX_Ak_060N_O_A_IALL_Ai_060_061k_O_A_Ia_M_Ab_J_A_126_058_AF_A_I_Fia_O_Aif_Ah_Aia_A_060_Ai_Athen_ALab_Aelse_ALba_J_J_A_G_Aa_A_060_092_060_094bsub_062F_A_I_Fi_O_Aif_Ah_Ai_A_060_Ak_A_L_A1_Athen_ALab_Aelse_ALba_J_092_060_094esub_062_Ab_096,axiom,
    ? [K2: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),K2),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))))
      & ! [I2: nat] :
          ( ord_less_eq(nat,I2,K2)
         => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),I2)),lab),lba))) )
      & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),plus_plus(nat,K2,one_one(nat)))),lab),lba))) ) ).

tff(fact_12__096_I_Fi_O_Aif_Ah_Ai_A_060_AN_Athen_ALab_Aelse_ALba_J_A_061_A_I_Fp_O_ALab_J_096,axiom,
    ( ? [X2: arrow_159774573e_indi] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,X2)),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))))
   => ( lba = lab ) ) ).

tff(fact_13_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_14_PiProf,axiom,
    ! [N2: nat] : member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N2)),lab),lba),arrow_610318064e_Prof) ).

tff(fact_15__C0_C,axiom,
    ! [N2: nat] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N2)),lab),lba)),arrow_1985332922le_Lin) ).

tff(fact_16__C1_C,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),zero_zero(nat))),lab),lba))) ).

tff(fact_17__096F_A_I_Fi_O_ALba_J_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,lba)),arrow_1985332922le_Lin) ).

tff(fact_18__096F_A_I_Fi_O_ALab_J_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,lab)),arrow_1985332922le_Lin) ).

tff(fact_19_nat__add__left__cancel__le,axiom,
    ! [N2: nat,M2: nat,K1: nat] :
      ( ord_less_eq(nat,plus_plus(nat,K1,M2),plus_plus(nat,K1,N2))
    <=> ord_less_eq(nat,M2,N2) ) ).

tff(fact_20_nat__add__left__cancel__less,axiom,
    ! [N2: nat,M2: nat,K1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),plus_plus(nat,K1,M2)),plus_plus(nat,K1,N2)))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M2),N2)) ) ).

tff(fact_21_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,C2: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,Aa,C2)),plus_plus(A,Ba,C2)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),Ba)) ) ) ).

tff(fact_22_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,Aa: A,C2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C2,Aa)),plus_plus(A,C2,Ba)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),Ba)) ) ) ).

tff(fact_23_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,C2: A,Aa: A] :
          ( ord_less_eq(A,plus_plus(A,Aa,C2),plus_plus(A,Ba,C2))
        <=> ord_less_eq(A,Aa,Ba) ) ) ).

tff(fact_24_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,Aa: A,C2: A] :
          ( ord_less_eq(A,plus_plus(A,C2,Aa),plus_plus(A,C2,Ba))
        <=> ord_less_eq(A,Aa,Ba) ) ) ).

tff(fact_25__096_B_Bthesis_O_A_I_B_BLab_O_A_091_124_Aa_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_059_ALab_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),Lab)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lab,arrow_1985332922le_Lin) ) ).

tff(fact_26_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,Aa: A,Ba: A] :
          ( ( plus_plus(A,Ba,Aa) = plus_plus(A,C2,Aa) )
        <=> ( Ba = C2 ) ) ) ).

tff(fact_27_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,Ba: A,Aa: A] :
          ( ( plus_plus(A,Aa,Ba) = plus_plus(A,Aa,C2) )
        <=> ( Ba = C2 ) ) ) ).

tff(fact_28_nat__add__right__cancel,axiom,
    ! [N2: nat,K1: nat,M2: nat] :
      ( ( plus_plus(nat,M2,K1) = plus_plus(nat,N2,K1) )
    <=> ( M2 = N2 ) ) ).

tff(fact_29_nat__add__left__cancel,axiom,
    ! [N2: nat,M2: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M2) = plus_plus(nat,K1,N2) )
    <=> ( M2 = N2 ) ) ).

tff(fact_30__C3_C,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
         => ( ! [I1: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I1)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ).

tff(fact_31_pairwise__neutrality,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B2: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B2 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
           => ( ! [I1: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I1)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ).

tff(fact_32__C4_C,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),C2: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != C2 )
       => ( ( Aa != C2 )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
             => ( ! [I1: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,C2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I1)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,C2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ) ).

tff(fact_33__096_B_Bb_H_Ab_Aa_H_Aa_AP_H_AP_O_A_091_124_Aa_A_126_061_Ab_059_Aa_H_A_126_061_Ab_H_059_Aa_A_126_061_Ab_H_059_Ab_A_126_061_Aa_H_059_AP_A_058_AProf_059_AP_H_A_058_AProf_059_AALL_Ai_O_A_Ia_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ab_J_A_061_A_Ia_H_A_060_092_060_094bsub_062P_H_Ai_092_060_094esub_062_Ab_H_J_059_Aa_A_060_092_060_094bsub_062F_AP_092_060_094esub_062_Ab_A_124_093_A_061_061_062_Aa_H_A_060_092_060_094bsub_062F_AP_H_092_060_094esub_062_Ab_H_096,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B2: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B2 )
       => ( ( Aa != B2 )
         => ( ( Ba != A3 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
               => ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ) ) ).

tff(fact_34__096_B_Bb_H_Ab_Aa_H_Aa_AP_H_AP_O_A_091_124_Aa_A_126_061_Ab_059_Aa_H_A_126_061_Ab_H_059_Aa_A_126_061_Ab_H_059_Ab_A_126_061_Aa_H_059_AP_A_058_AProf_059_AP_H_A_058_AProf_059_AALL_Ai_O_A_Ia_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ab_J_A_061_A_Ia_H_A_060_092_060_094bsub_062P_H_Ai_092_060_094esub_062_Ab_H_J_A_124_093_A_061_061_062_A_Ia_A_060_092_060_094bsub_062F_AP_092_060_094esub_062_Ab_J_A_061_A_Ia_H_A_060_092_060_094bsub_062F_AP_H_092_060_094esub_062_Ab_H_J_096,axiom,
    ! [P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B2: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B2 )
       => ( ( Aa != B2 )
         => ( ( Ba != A3 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
               => ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2)) ) ) ) ) ) ) ) ) ).

tff(fact_35_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_36_less__zeroE,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),zero_zero(nat))) ).

tff(fact_37_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),zero_zero(nat))) ).

tff(fact_38_neq0__conv,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N2)) ) ).

tff(fact_39_add__is__0,axiom,
    ! [N2: nat,M2: nat] :
      ( ( plus_plus(nat,M2,N2) = zero_zero(nat) )
    <=> ( ( M2 = zero_zero(nat) )
        & ( N2 = zero_zero(nat) ) ) ) ).

tff(fact_40_le__0__eq,axiom,
    ! [N2: nat] :
      ( ord_less_eq(nat,N2,zero_zero(nat))
    <=> ( N2 = zero_zero(nat) ) ) ).

tff(fact_41_less__eq__nat_Osimps_I1_J,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_42_le0,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_43_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ord_less_eq(A,plus_plus(A,Aa,Aa),zero_zero(A))
        <=> ord_less_eq(A,Aa,zero_zero(A)) ) ) ).

tff(fact_44_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ord_less_eq(A,zero_zero(A),plus_plus(A,Aa,Aa))
        <=> ord_less_eq(A,zero_zero(A),Aa) ) ) ).

tff(fact_45_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,Aa,Aa)),zero_zero(A)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),zero_zero(A))) ) ) ).

tff(fact_46_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,Aa,Aa)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),Aa)) ) ) ).

tff(fact_47__096_B_Bthesis_O_A_I_B_BLba_O_A_091_124_Ab_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_059_ALba_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),Lba)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lba,arrow_1985332922le_Lin) ) ).

tff(fact_48_add__gr__0,axiom,
    ! [N2: nat,M2: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),plus_plus(nat,M2,N2)))
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),M2))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N2)) ) ) ).

tff(fact_49_assms_I1_J,axiom,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(fact_50_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_51_const__Lin__Prof,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L),arrow_610318064e_Prof) ) ).

tff(fact_52_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_53_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_54_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_55_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_56_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N1)) ) ).

tff(fact_57_gr__implies__not0,axiom,
    ! [N1: nat,M1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),N1))
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_58_not__less0,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),zero_zero(nat))) ).

tff(fact_59_add__eq__self__zero,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = M1 )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_60_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( plus_plus(nat,M1,zero_zero(nat)) = M1 ) ).

tff(fact_61_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( plus_plus(nat,zero_zero(nat),N1) = N1 ) ).

tff(fact_62_add__nonpos__nonpos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,A1,zero_zero(A))
         => ( ord_less_eq(A,B1,zero_zero(A))
           => ord_less_eq(A,plus_plus(A,A1,B1),zero_zero(A)) ) ) ) ).

tff(fact_63_add__increasing2,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [A1: A,B1: A,C1: A] :
          ( ord_less_eq(A,zero_zero(A),C1)
         => ( ord_less_eq(A,B1,A1)
           => ord_less_eq(A,B1,plus_plus(A,A1,C1)) ) ) ) ).

tff(fact_64_add__increasing,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ( ord_less_eq(A,B1,C1)
           => ord_less_eq(A,B1,plus_plus(A,A1,C1)) ) ) ) ).

tff(fact_65_add__nonneg__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,zero_zero(A),X1)
         => ( ord_less_eq(A,zero_zero(A),Y1)
           => ( ( plus_plus(A,X1,Y1) = zero_zero(A) )
            <=> ( ( X1 = zero_zero(A) )
                & ( Y1 = zero_zero(A) ) ) ) ) ) ) ).

tff(fact_66_add__nonneg__nonneg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ( ord_less_eq(A,zero_zero(A),B1)
           => ord_less_eq(A,zero_zero(A),plus_plus(A,A1,B1)) ) ) ) ).

tff(fact_67_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),zero_zero(A)))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B1),zero_zero(A)))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,B1)),zero_zero(A))) ) ) ) ).

tff(fact_68_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),B1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,A1,B1))) ) ) ) ).

tff(fact_69_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),L) ) ) ).

tff(fact_70_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X1 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y1,X1),L) ) ) ) ).

tff(fact_71_add__nonpos__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,A1,zero_zero(A))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B1),zero_zero(A)))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,B1)),zero_zero(A))) ) ) ) ).

tff(fact_72_add__neg__nonpos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),zero_zero(A)))
         => ( ord_less_eq(A,B1,zero_zero(A))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,B1)),zero_zero(A))) ) ) ) ).

tff(fact_73_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X1: A] :
      ( member(A,X1,A2)
    <=> pp(aa(A,bool,A2,X1)) ) ).

tff(fact_74_add__strict__increasing2,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B1),C1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B1),plus_plus(A,A1,C1))) ) ) ) ).

tff(fact_75_add__strict__increasing,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1))
         => ( ord_less_eq(A,B1,C1)
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B1),plus_plus(A,A1,C1))) ) ) ) ).

tff(fact_76_add__nonneg__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),B1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,A1,B1))) ) ) ) ).

tff(fact_77_add__pos__nonneg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1))
         => ( ord_less_eq(A,zero_zero(A),B1)
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,A1,B1))) ) ) ) ).

tff(fact_78_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C1,A1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_79_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_80_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_81_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C1) = plus_plus(A,A1,plus_plus(A,B1,C1)) ) ) ).

tff(fact_82_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_83_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N2: nat,M2: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M2),N2))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M2)) )
     => ( ( ( M2 = N2 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M2)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),M2))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M2)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M2)) ) ) ) ).

tff(fact_84_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S),T))
     => ( S != T ) ) ).

tff(fact_85_less__not__refl2,axiom,
    ! [M1: nat,N1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),M1))
     => ( M1 != N1 ) ) ).

tff(fact_86_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),N1)) ).

tff(fact_87_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_88_nat__neq__iff,axiom,
    ! [N2: nat,M2: nat] :
      ( ( M2 != N2 )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M2),N2))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),M2)) ) ) ).

tff(fact_89_less__not__refl,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),N1)) ).

tff(fact_90_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( plus_plus(nat,plus_plus(nat,M1,N1),K) = plus_plus(nat,M1,plus_plus(nat,N1,K)) ) ).

tff(fact_91_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_92_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,N1) = plus_plus(nat,N1,M1) ) ).

tff(fact_93_le__antisym,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ord_less_eq(nat,N1,M1)
       => ( M1 = N1 ) ) ) ).

tff(fact_94_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_95_eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 = N1 )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_96_nat__le__linear,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
      | ord_less_eq(nat,N1,M1) ) ).

tff(fact_97_le__refl,axiom,
    ! [N1: nat] : ord_less_eq(nat,N1,N1) ).

%----Arities (9)
tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (8)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X),Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))))
      & ! [M: nat] :
          ( ~ ord_less_eq(nat,M,N)
          | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),M)),lab),lba))) )
      & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),plus_plus(nat,N,one_one(nat)))),lab),lba))) ) ).

%------------------------------------------------------------------------------
