%------------------------------------------------------------------------------
% File     : SCT249_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 268
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_268 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  164 (  44 unt;  39 typ;   0 def)
%            Number of atoms       :  281 (  55 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  191 (  35   ~;   8   |;   8   &)
%                                         (  22 <=>; 118  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   26 (  16   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-4 aty)
%            Number of functors    :   25 (  25 usr;   8 con; 0-5 aty)
%            Number of variables   :  349 ( 315   !;   3   ?; 349   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:05
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_Lba____,type,
    lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

%----Relevant facts (100)
tff(fact_0__096Lba_A_058_ALin_096,axiom,
    pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),lba),arrow_1985332922le_Lin)) ).

tff(fact_1__096Lab_A_058_ALin_096,axiom,
    pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),lab),arrow_1985332922le_Lin)) ).

tff(fact_2__096range_Ah_A_060_061_A_1230_O_O_060N_125_096,axiom,
    ord_less_eq(fun(nat,bool),image(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))),ord_atLeastLessThan(nat,zero_zero(nat),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool))))) ).

tff(fact_3_surjh,axiom,
    image(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) = ord_atLeastLessThan(nat,zero_zero(nat),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))) ).

tff(fact_4_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_5_PiProf,axiom,
    ! [N1: nat] : pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N1)),lab),lba)),arrow_610318064e_Prof)) ).

tff(fact_6_top1I,axiom,
    ! [A: $tType,X2: A] : pp(aa(A,bool,top_top(fun(A,bool)),X2)) ).

tff(fact_7_UNIV__I,axiom,
    ! [A: $tType,X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),top_top(fun(A,bool)))) ).

tff(fact_8_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),top_top(fun(A,bool)))) ).

tff(fact_9_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X2: B] : ( aa(B,A,top_top(fun(B,A)),X2) = top_top(A) ) ) ).

tff(fact_10_not__top__less,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),top_top(A)),A2)) ) ).

tff(fact_11_less__top,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [Aa: A] :
          ( ( Aa != top_top(A) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),top_top(A))) ) ) ).

tff(fact_12__C0_C,axiom,
    ! [N1: nat] : pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N1)),lab),lba))),arrow_1985332922le_Lin)) ).

tff(fact_13_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_14_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_15_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),N1))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),M1)) ) ) ).

tff(fact_16_linorder__neqE__nat,axiom,
    ! [Y: nat,X1: nat] :
      ( ( X1 != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X1),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X1)) ) ) ).

tff(fact_17_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_18_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_19_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ord_less_eq(A,X1,X1) ) ).

tff(fact_20_subsetD,axiom,
    ! [A: $tType,C3: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),B2)) ) ) ).

tff(fact_21_equalityI,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( ord_less_eq(fun(A,bool),B2,A1)
       => ( A1 = B2 ) ) ) ).

tff(fact_22_image__eqI,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),X2: B,F: fun(B,A),Ba: A] :
      ( ( Ba = aa(B,A,F,X2) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Ba),image(B,A,F,A1))) ) ) ).

tff(fact_23__096F_A_I_Fi_O_ALba_J_A_058_ALin_096,axiom,
    pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,lba))),arrow_1985332922le_Lin)) ).

tff(fact_24_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_25_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_26_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N1)) ) ).

tff(fact_27_assms_I1_J,axiom,
    pp(aa(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),f),pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin)))) ).

tff(fact_28__096_B_Bthesis_O_A_I_B_Bh_O_A_091_124_Ainj_Ah_059_Arange_Ah_A_061_A_1230_O_O_060N_125_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [H: fun(arrow_159774573e_indi,nat)] :
        ( inj_on(arrow_159774573e_indi,nat,H,top_top(fun(arrow_159774573e_indi,bool)))
       => ( image(arrow_159774573e_indi,nat,H,top_top(fun(arrow_159774573e_indi,bool))) != ord_atLeastLessThan(nat,zero_zero(nat),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))) ) ) ).

tff(fact_29_subset__refl,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,A1) ).

tff(fact_30_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X3: A] : ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_31_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ord_less_eq(A,X1,Y)
          | ord_less_eq(A,Y,X1) ) ) ).

tff(fact_32_psubset__eq,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B2))
    <=> ( ord_less_eq(fun(A,bool),A1,B2)
        & ( A1 != B2 ) ) ) ).

tff(fact_33_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( pp(aa(fun(A,B),bool,aa(fun(A,B),fun(fun(A,B),bool),ord_less(fun(A,B)),F),G))
        <=> ( ord_less_eq(fun(A,B),F,G)
            & ~ ord_less_eq(fun(A,B),G,F) ) ) ) ).

tff(fact_34_set__eq__subset,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
    <=> ( ord_less_eq(fun(A,bool),A1,B2)
        & ord_less_eq(fun(A,bool),B2,A1) ) ) ).

tff(fact_35_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 = Y1 )
        <=> ( ord_less_eq(A,X2,Y1)
            & ord_less_eq(A,Y1,X2) ) ) ) ).

tff(fact_36_subset__iff__psubset__eq,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
    <=> ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B2))
        | ( A1 = B2 ) ) ) ).

tff(fact_37_subset__image__iff,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A),B2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),B2,image(B,A,F,A1))
    <=> ? [AA: fun(B,bool)] :
          ( ord_less_eq(fun(B,bool),AA,A1)
          & ( B2 = image(B,A,F,AA) ) ) ) ).

tff(fact_38_image__iff,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A),Z1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Z1),image(B,A,F,A1)))
    <=> ? [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1))
          & ( Z1 = aa(B,A,F,X3) ) ) ) ).

tff(fact_39_rev__predicate1D,axiom,
    ! [A: $tType,Q1: fun(A,bool),X2: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,X2))
     => ( ord_less_eq(fun(A,bool),P1,Q1)
       => pp(aa(A,bool,Q1,X2)) ) ) ).

tff(fact_40_const__Lin__Prof,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L)),arrow_610318064e_Prof)) ) ).

tff(fact_41_equalityD1,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
     => ord_less_eq(fun(A,bool),A1,B2) ) ).

tff(fact_42_equalityD2,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
     => ord_less_eq(fun(A,bool),B2,A1) ) ).

tff(fact_43_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X1: A] :
          ( ( X1 = Y )
         => ord_less_eq(A,X1,Y) ) ) ).

tff(fact_44_psubset__imp__subset,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B2))
     => ord_less_eq(fun(A,bool),A1,B2) ) ).

tff(fact_45_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_46_imageI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X2)),image(A,B,F,A1))) ) ).

tff(fact_47_in__mono,axiom,
    ! [A: $tType,X2: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_48_image__mono,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ord_less_eq(fun(B,bool),image(A,B,F,A1),image(A,B,F,B2)) ) ).

tff(fact_49_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X2: A,Y1: A] :
          ( ord_less_eq(A,Y1,X2)
         => ( ord_less_eq(A,X2,Y1)
          <=> ( X2 = Y1 ) ) ) ) ).

tff(fact_50_predicate1D,axiom,
    ! [A: $tType,X2: A,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),P1,Q1)
     => ( pp(aa(A,bool,P1,X2))
       => pp(aa(A,bool,Q1,X2)) ) ) ).

tff(fact_51_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( A2 = B1 )
         => ( ord_less_eq(A,B1,C1)
           => ord_less_eq(A,A2,C1) ) ) ) ).

tff(fact_52_set__rev__mp,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ord_less_eq(fun(A,bool),A1,B2)
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_53_psubset__subset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),B2: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B2))
     => ( ord_less_eq(fun(A,bool),B2,C2)
       => pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),C2)) ) ) ).

tff(fact_54_set__mp,axiom,
    ! [A: $tType,X2: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_55_subset__psubset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),B2),C2))
       => pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),C2)) ) ) ).

tff(fact_56_subset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( ord_less_eq(fun(A,bool),B2,C2)
       => ord_less_eq(fun(A,bool),A1,C2) ) ) ).

tff(fact_57_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less_eq(A,A2,B1)
         => ( ( B1 = C1 )
           => ord_less_eq(A,A2,C1) ) ) ) ).

tff(fact_58_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X1: A] :
          ( ord_less_eq(A,X1,Y)
         => ( ord_less_eq(A,Y,X1)
           => ( X1 = Y ) ) ) ) ).

tff(fact_59_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X1: A] :
          ( ord_less_eq(A,X1,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X1,Z) ) ) ) ).

tff(fact_60_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ba: B,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ( Ba = aa(A,B,F,X2) )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ba),image(A,B,F,A1))) ) ) ).

tff(fact_61_equalityE,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
     => ~ ( ord_less_eq(fun(A,bool),A1,B2)
         => ~ ord_less_eq(fun(A,bool),B2,A1) ) ) ).

tff(fact_62_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_63_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ~ ord_less_eq(A,X1,Y)
         => ord_less_eq(A,Y,X1) ) ) ).

tff(fact_64_image__ident,axiom,
    ! [A: $tType,Y2: fun(A,bool)] : ( image(A,A,combi(A),Y2) = Y2 ) ).

tff(fact_65_image__image,axiom,
    ! [B: $tType,A: $tType,C: $tType,A1: fun(C,bool),G: fun(C,B),F: fun(B,A)] : ( image(B,A,F,image(C,B,G,A1)) = image(C,A,combb(B,A,C,F,G),A1) ) ).

tff(fact_66_pred__subset__eq,axiom,
    ! [A: $tType,S: fun(A,bool),R1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),combc(A,fun(A,bool),bool,member(A),R1),combc(A,fun(A,bool),bool,member(A),S))
    <=> ord_less_eq(fun(A,bool),R1,S) ) ).

tff(fact_67_range__eqI,axiom,
    ! [A: $tType,B: $tType,X2: B,F: fun(B,A),Ba: A] :
      ( ( Ba = aa(B,A,F,X2) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Ba),image(B,A,F,top_top(fun(B,bool))))) ) ).

tff(fact_68_rangeI,axiom,
    ! [A: $tType,B: $tType,X2: B,F: fun(B,A)] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),aa(B,A,F,X2)),image(B,A,F,top_top(fun(B,bool))))) ).

tff(fact_69_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X1: A] :
          ( ord_less_eq(A,X1,Y)
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Z)) ) ) ) ).

tff(fact_70_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( ord_less_eq(A,Y,Z)
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Z)) ) ) ) ).

tff(fact_71_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B1: A,A2: A] :
          ( ord_less_eq(A,A2,B1)
         => ( ( A2 != B1 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B1)) ) ) ) ).

tff(fact_72_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X1: A] :
          ( ord_less_eq(A,X1,Y)
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
            | ( X1 = Y ) ) ) ) ).

tff(fact_73_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y1))
          <=> ( X2 = Y1 ) ) ) ) ).

tff(fact_74_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ord_less_eq(A,X1,Y) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y: A] :
          ( ord_less_eq(A,Y,X1)
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y)) ) ) ).

tff(fact_79_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B1: A,A2: A] :
          ( ( A2 != B1 )
         => ( ord_less_eq(A,A2,B1)
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B1)) ) ) ) ).

tff(fact_80_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y1))
         => ( ord_less_eq(A,X2,Y1)
          <=> ( X2 = Y1 ) ) ) ) ).

tff(fact_81_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y: A] :
          ( ~ ord_less_eq(A,Y,X1)
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y)) ) ) ).

tff(fact_82_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ord_less_eq(A,Y,X1) ) ) ).

tff(fact_83_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y1))
            | ( X2 = Y1 ) ) ) ) ).

tff(fact_84_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y1))
        <=> ( ord_less_eq(A,X2,Y1)
            & ~ ord_less_eq(A,Y1,X2) ) ) ) ).

tff(fact_85_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y1))
        <=> ( ord_less_eq(A,X2,Y1)
            & ( X2 != Y1 ) ) ) ) ).

tff(fact_86_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ord_less_eq(A,X1,Y)
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ).

tff(fact_87_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less_eq(A,X2,Y1)
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X2)) ) ) ).

tff(fact_88_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y1))
        <=> ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_89_top__le,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] :
          ( ord_less_eq(A,top_top(A),A2)
         => ( A2 = top_top(A) ) ) ) ).

tff(fact_90_top__unique,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [Aa: A] :
          ( ord_less_eq(A,top_top(A),Aa)
        <=> ( Aa = top_top(A) ) ) ) ).

tff(fact_91_top__greatest,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] : ord_less_eq(A,A2,top_top(A)) ) ).

tff(fact_92_subset__UNIV,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,top_top(fun(A,bool))) ).

tff(fact_93_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N)) ) ).

tff(fact_94_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( N != zero_zero(nat) ) ) ).

tff(fact_95_not__less0,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_96_range__composition,axiom,
    ! [A: $tType,C: $tType,B: $tType,G: fun(B,C),F: fun(C,A)] : ( image(B,A,combb(C,A,B,F,G),top_top(fun(B,bool))) = image(C,A,F,image(B,C,G,top_top(fun(B,bool)))) ) ).

tff(fact_97_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( ( X1 != Y )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ) ).

tff(fact_98_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ).

tff(fact_99_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Z)) ) ) ) ).

%----Arities (13)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (11)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X1),Y) = X1 ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X1),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( ? [X: arrow_159774573e_indi] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(arrow_159774573e_indi,nat,h,X)),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))))
   => ( lba = lab ) ) ).

%------------------------------------------------------------------------------
