%------------------------------------------------------------------------------
% File     : SCT246_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 263
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_263 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  167 (  42 unt;  46 typ;   0 def)
%            Number of atoms       :  339 (  89 equ)
%            Maximal formula atoms :   12 (   2 avg)
%            Number of connectives :  300 (  82   ~;   9   |;  16   &)
%                                         (  32 <=>; 161  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   44 (  23   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   32 (  32 usr;  11 con; 0-6 aty)
%            Number of variables   :  489 ( 445   !;   8   ?; 489   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:38
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T1: $tType] : ( ( fun(A,fun(B,T1)) * product_prod(A,B) ) > T1 ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A,B),product_prod(A,B)),bool) ) ).

tff(sy_c_Wellfounded_Omeasure,type,
    measure: 
      !>[A: $tType] : ( fun(A,nat) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Wellfounded_Omlex__prod,type,
    mlex_prod: 
      !>[A: $tType] : ( ( fun(A,nat) * fun(product_prod(A,A),bool) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_Lba____,type,
    lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (100)
tff(fact_0_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_1_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_2_assms_I1_J,axiom,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(fact_3__096Lab_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lab,arrow_1985332922le_Lin) ).

tff(fact_4__096Lba_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lba,arrow_1985332922le_Lin) ).

tff(fact_5_PiProf,axiom,
    ! [N: nat] : member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),N)),lab),lba),arrow_610318064e_Prof) ).

tff(fact_6_const__Lin__Prof,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L),arrow_610318064e_Prof) ) ).

tff(fact_7_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_8_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X2,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_9_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X2,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_10_mkbot__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_11_mktop__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_12_less__not__refl,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),N1)) ).

tff(fact_13_nat__neq__iff,axiom,
    ! [N: nat,M: nat] :
      ( ( M != N )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M)) ) ) ).

tff(fact_14_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_15_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),N1)) ).

tff(fact_16_less__not__refl2,axiom,
    ! [M1: nat,N1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),M1))
     => ( M1 != N1 ) ) ).

tff(fact_17_less__not__refl3,axiom,
    ! [T: nat,S2: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S2),T))
     => ( S2 != T ) ) ).

tff(fact_18_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N: nat,M: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
     => ( ( ( M = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) ) ) ) ).

tff(fact_19_PiE,axiom,
    ! [B: $tType,A: $tType,X2: A,B4: fun(A,fun(B,bool)),A3: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A3,B4))
     => ( ~ member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B4,X2))
       => ~ member(A,X2,A3) ) ) ).

tff(fact_20_dictator__def,axiom,
    ! [I1: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I1)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I1) ) ) ) ).

tff(fact_21_funcset__mem,axiom,
    ! [A: $tType,B: $tType,X2: A,B4: fun(B,bool),A3: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A3,combk(fun(B,bool),A,B4)))
     => ( member(A,X2,A3)
       => member(B,aa(A,B,F,X2),B4) ) ) ).

tff(fact_22_funcset__id,axiom,
    ! [A: $tType,A3: fun(A,bool)] : member(fun(A,A),combi(A),pi(A,A,A3,combk(fun(A,bool),A,A3))) ).

tff(fact_23__C3_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
         => ( ! [I2: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ).

tff(fact_24_pairwise__neutrality,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B1: arrow_411405190le_alt,A1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A1 != B1 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
           => ( ! [I2: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ).

tff(fact_25__C4_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),C1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != C1 )
       => ( ( Aa != C1 )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
             => ( ! [I2: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,C1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,C1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ).

tff(fact_26__C1_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B1: arrow_411405190le_alt,A1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A1 != B1 )
       => ( ( Aa != B1 )
         => ( ( Ba != A1 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_27__C2_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B1: arrow_411405190le_alt,A1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A1 != B1 )
       => ( ( Aa != B1 )
         => ( ( Ba != A1 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_28_notin__Lin__iff,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X2 != Y2 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y2,X2),L) ) ) ) ).

tff(fact_29_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),L) ) ) ).

tff(fact_30_in__mktop,axiom,
    ! [Z2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_424895264_mktop(L,Z2))
    <=> ( ( X2 != Z2 )
        & ( ( Y2 = Z2 )
         => ( X2 != Y2 ) )
        & ( ( Y2 != Z2 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ).

tff(fact_31_in__mkbot,axiom,
    ! [Z2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_276188178_mkbot(L,Z2))
    <=> ( ( Y2 != Z2 )
        & ( ( X2 = Z2 )
         => ( X2 != Y2 ) )
        & ( ( X2 != Z2 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ).

tff(fact_32_in__above,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_1158827142_above(L,Aa,Ba))
        <=> ( ( X2 != Y2 )
            & ( ( X2 = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y2),L) )
            & ( ( X2 != Ba )
             => ( ( ( Y2 = Ba )
                 => ( ( X2 = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Aa),L) ) )
                & ( ( Y2 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ) ) ) ) ).

tff(fact_33_in__below,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_319942042_below(L,Aa,Ba))
        <=> ( ( X2 != Y2 )
            & ( ( Y2 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Ba),L) )
            & ( ( Y2 != Aa )
             => ( ( ( X2 = Aa )
                 => ( ( Y2 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Y2),L) ) )
                & ( ( X2 != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ) ) ) ) ).

tff(fact_34_Pi__mem,axiom,
    ! [B: $tType,A: $tType,X2: A,B4: fun(A,fun(B,bool)),A3: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A3,B4))
     => ( member(A,X2,A3)
       => member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B4,X2)) ) ) ).

tff(fact_35_dictatorI,axiom,
    ! [I1: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Fa,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin)))
     => ( ! [X1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
            ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X1,arrow_610318064e_Prof)
           => ! [A4: arrow_411405190le_alt,B3: arrow_411405190le_alt] :
                ( ( A4 != B3 )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,I1))
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X1)) ) ) )
       => arrow_987702531ctator(Fa,I1) ) ) ).

tff(fact_36_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ! [Xa1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa1,arrow_610318064e_Prof)
             => ! [A5: arrow_411405190le_alt,B5: arrow_411405190le_alt] :
                  ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa1,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa1)) ) ) ) ) ) ).

tff(fact_37_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ! [A5: arrow_411405190le_alt,B5: arrow_411405190le_alt] :
              ( ! [I: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4)) ) ) ) ).

tff(fact_38__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lab) ).

tff(fact_39__096b_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lba) ).

tff(fact_40_Pi__I,axiom,
    ! [B: $tType,A: $tType,B4: fun(A,fun(B,bool)),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [X1: A] :
          ( member(A,X1,A3)
         => member(B,aa(A,B,F,X1),aa(A,fun(B,bool),B4,X1)) )
     => member(fun(A,B),F,pi(A,B,A3,B4)) ) ).

tff(fact_41__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_42__096_Ib_M_Aa_J_A_126_058_ALab_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),lab) ).

tff(fact_43__096_Ia_M_Ab_J_A_126_058_ALba_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),lba) ).

tff(fact_44__096_B_Bthesis_O_A_I_B_BLab_O_A_091_124_Aa_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_059_ALab_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),Lab)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lab,arrow_1985332922le_Lin) ) ).

tff(fact_45__096_B_Bthesis_O_A_I_B_BLba_O_A_091_124_Ab_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_059_ALba_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),Lba)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lba,arrow_1985332922le_Lin) ) ).

tff(fact_46_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),X1) ) ) ).

tff(fact_47_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X12))
    <=> ! [A5: A,B5: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A5,B5))) ) ).

tff(fact_48_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A1,B1) )
    <=> ( ( Aa = A1 )
        & ( Ba = B1 ) ) ) ).

tff(fact_49_funcsetI,axiom,
    ! [A: $tType,B: $tType,B4: fun(B,bool),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [X1: A] :
          ( member(A,X1,A3)
         => member(B,aa(A,B,F,X1),B4) )
     => member(fun(A,B),F,pi(A,B,A3,combk(fun(B,bool),A,B4))) ) ).

tff(fact_50_Pi__I_H,axiom,
    ! [B: $tType,A: $tType,B4: fun(A,fun(B,bool)),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [X1: A] :
          ( member(A,X1,A3)
         => member(B,aa(A,B,F,X1),aa(A,fun(B,bool),B4,X1)) )
     => member(fun(A,B),F,pi(A,B,A3,B4)) ) ).

tff(fact_51_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B2: B,A2: A] :
      ( ( product_Pair(A,B,A2,B2) = product_Pair(A,B,A6,B6) )
     => ~ ( ( A2 = A6 )
         => ( B2 != B6 ) ) ) ).

tff(fact_52_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X12))
    <=> ? [A5: A,B5: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A5,B5))) ) ).

tff(fact_53_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F11,Aa),Ba) ) ).

tff(fact_54_Pi__cong,axiom,
    ! [B: $tType,A: $tType,B4: fun(A,fun(B,bool)),G: fun(A,B),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [W: A] :
          ( member(A,W,A3)
         => ( aa(A,B,F,W) = aa(A,B,G,W) ) )
     => ( member(fun(A,B),F,pi(A,B,A3,B4))
      <=> member(fun(A,B),G,pi(A,B,A3,B4)) ) ) ).

tff(fact_55_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A4: A,B3: B] : ( Y != product_Pair(A,B,A4,B3) ) ).

tff(fact_56_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S1: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X4: A,Xa1: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X4,Xa1),R1)
        <=> member(product_prod(A,B),product_Pair(A,B,X4,Xa1),S1) )
    <=> ( R1 = S1 ) ) ).

tff(fact_57_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A4: A,B3: B,C3: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A4,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B3,product_Pair(C,product_prod(D,product_prod(E,F1)),C3,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,X2)) ) ).

tff(fact_58_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A4: A,B3: B,C3: C,D1: D,E1: E,F2: F1] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A4,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B3,product_Pair(C,product_prod(D,product_prod(E,F1)),C3,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_59_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A4: A,B3: B,C3: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A4,product_Pair(B,product_prod(C,product_prod(D,E)),B3,product_Pair(C,product_prod(D,E),C3,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_60_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A4: A,B3: B,C3: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A4,product_Pair(B,product_prod(C,product_prod(D,E)),B3,product_Pair(C,product_prod(D,E),C3,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,X2)) ) ).

tff(fact_61_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A4: A,B3: B,C3: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A4,product_Pair(B,product_prod(C,D),B3,product_Pair(C,D,C3,D1))) ) ).

tff(fact_62_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A4: A,B3: B,C3: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,D)),A4,product_Pair(B,product_prod(C,D),B3,product_Pair(C,D,C3,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,X2)) ) ).

tff(fact_63_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A4: A,B3: B,C3: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,product_Pair(A,product_prod(B,C),A4,product_Pair(B,C,B3,C3))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,X2)) ) ).

tff(fact_64_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A4: A,B3: B,C3: C] : ( Y != product_Pair(A,product_prod(B,C),A4,product_Pair(B,C,B3,C3)) ) ).

tff(fact_65_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X1: A,Y1: B] : ( P2 != product_Pair(A,B,X1,Y1) ) ).

tff(fact_66_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),C1,Aa),Ba) ) ).

tff(fact_67_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,Ba) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,Ba)) ) ).

tff(fact_68_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_69_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_70_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_71_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X3: fun(product_prod(A,B),C),Xa: A,Xb: B] : ( product_curry(A,B,C,X3,Xa,Xb) = aa(product_prod(A,B),C,X3,product_Pair(A,B,Xa,Xb)) ) ).

tff(fact_72_in__measure,axiom,
    ! [A: $tType,F: fun(A,nat),Y2: A,X2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X2,Y2),measure(A,F))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(A,nat,F,X2)),aa(A,nat,F,Y2))) ) ).

tff(fact_73_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( ( X != Y )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_74_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X2: A] :
      ( member(A,X2,A3)
    <=> pp(aa(A,bool,A3,X2)) ) ).

tff(fact_77_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),X)) ) ).

tff(fact_78_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ) ).

tff(fact_79_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_80_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
          | ( X = Y )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_81_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_82_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_83_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_84_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_85_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_86_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_87_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( Y != X ) ) ) ).

tff(fact_88_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
           => pp(P1) ) ) ) ).

tff(fact_89_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),A2)) ) ) ).

tff(fact_90_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),C2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),C2)) ) ) ) ).

tff(fact_91_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ( ( B2 = C2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),C2)) ) ) ) ).

tff(fact_92_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z1)) ) ) ) ).

tff(fact_93_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,S: fun(product_prod(B,B),bool),R2: fun(product_prod(A,A),bool),B1: B,A1: A,Ba: B,Aa: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Aa,Ba),product_Pair(A,B,A1,B1)),lex_prod(A,B,R2,S))
    <=> ( member(product_prod(A,A),product_Pair(A,A,Aa,A1),R2)
        | ( ( Aa = A1 )
          & member(product_prod(B,B),product_Pair(B,B,Ba,B1),S) ) ) ) ).

tff(fact_94_mlex__less,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Y2: A,X2: A,F: fun(A,nat)] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(A,nat,F,X2)),aa(A,nat,F,Y2)))
     => member(product_prod(A,A),product_Pair(A,A,X2,Y2),mlex_prod(A,F,R1)) ) ).

tff(fact_95_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X2: A] :
        ? [X11: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),X11)) ) ).

tff(fact_96_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [Y1: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X)) ) ).

tff(fact_97_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,Ba: B,F: fun(B,A),Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F,Ba)))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),Ba),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X1)),aa(B,A,F,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_98_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,Ba: B,F: fun(B,A),Aa: A] :
          ( ( Aa = aa(B,A,F,Ba) )
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),Ba),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X1)),aa(B,A,F,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_99_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ? [Z: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z))
              & pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Z),Y)) ) ) ) ).

%----Arities (11)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (9)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X),Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,nat,bool,combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat),h),n)),lab),lba)),arrow_1985332922le_Lin) ).

%------------------------------------------------------------------------------
