%------------------------------------------------------------------------------
% File     : SCT244_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 260
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_260 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  176 (  47 unt;  46 typ;   0 def)
%            Number of atoms       :  334 ( 102 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  279 (  75   ~;  14   |;  17   &)
%                                         (  20 <=>; 153  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :   14 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   32 (  17   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-4 aty)
%            Number of functors    :   33 (  33 usr;  10 con; 0-5 aty)
%            Number of variables   :  487 ( 438   !;   9   ?; 487   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:25
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( fun(B,C) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_Fun_Othe__inv__into,type,
    the_inv_into: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,B) * B ) > A ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T1: $tType] : ( ( fun(A,fun(B,T1)) * product_prod(A,B) ) > T1 ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_Lba____,type,
    lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_h____,type,
    h: fun(arrow_159774573e_indi,nat) ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (100)
tff(fact_0__096Lab_A_058_ALin_096,axiom,
    pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),lab),arrow_1985332922le_Lin)) ).

tff(fact_1__096Lba_A_058_ALin_096,axiom,
    pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),lba),arrow_1985332922le_Lin)) ).

tff(fact_2_injh,axiom,
    inj_on(arrow_159774573e_indi,nat,h,top_top(fun(arrow_159774573e_indi,bool))) ).

tff(fact_3_top1I,axiom,
    ! [A: $tType,X2: A] : pp(aa(A,bool,top_top(fun(A,bool)),X2)) ).

tff(fact_4_UNIV__I,axiom,
    ! [A: $tType,X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),top_top(fun(A,bool)))) ).

tff(fact_5_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),top_top(fun(A,bool)))) ).

tff(fact_6_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X2: B] : ( aa(B,A,top_top(fun(B,A)),X2) = top_top(A) ) ) ).

tff(fact_7_not__top__less,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A3: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),top_top(A)),A3)) ) ).

tff(fact_8_less__top,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [Aa: A] :
          ( ( Aa != top_top(A) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),top_top(A))) ) ) ).

tff(fact_9_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin)) ).

tff(fact_10_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y2 )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1158827142_above(L,X2,Y2)),arrow_1985332922le_Lin)) ) ) ).

tff(fact_11_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y2 )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_319942042_below(L,X2,Y2)),arrow_1985332922le_Lin)) ) ) ).

tff(fact_12_mkbot__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot(L,X2)),arrow_1985332922le_Lin)) ) ).

tff(fact_13_mktop__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop(L,X2)),arrow_1985332922le_Lin)) ) ).

tff(fact_14_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fTrue)) ) ).

tff(fact_15_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( ( X != Y )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_16_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_17_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z2)) ) ) ) ).

tff(fact_18_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B3))
         => ( ( B3 = C3 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C3)) ) ) ) ).

tff(fact_19_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ( A3 = B3 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B3),C3))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C3)) ) ) ) ).

tff(fact_20_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B3: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B3))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B3),A3)) ) ) ).

tff(fact_21_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P2: bool,Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
           => pp(P2) ) ) ) ).

tff(fact_22_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( Y != X ) ) ) ).

tff(fact_23_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_24_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_25_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_26_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_27_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_28_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_29_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
          | ( X = Y )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_30_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_31_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ) ).

tff(fact_32_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),X)) ) ).

tff(fact_33_inj__fun,axiom,
    ! [B: $tType,C: $tType,A: $tType,F2: fun(A,B)] :
      ( inj_on(A,B,F2,top_top(fun(A,bool)))
     => inj_on(A,fun(C,B),aa(fun(A,B),fun(A,fun(C,B)),combb(B,fun(C,B),A,combk(B,C)),F2),top_top(fun(A,bool))) ) ).

tff(fact_34_injD,axiom,
    ! [B: $tType,A: $tType,Y2: A,X2: A,F2: fun(A,B)] :
      ( inj_on(A,B,F2,top_top(fun(A,bool)))
     => ( ( aa(A,B,F2,X2) = aa(A,B,F2,Y2) )
       => ( X2 = Y2 ) ) ) ).

tff(fact_35_inj__eq,axiom,
    ! [B: $tType,A: $tType,Y2: A,X2: A,F2: fun(A,B)] :
      ( inj_on(A,B,F2,top_top(fun(A,bool)))
     => ( ( aa(A,B,F2,X2) = aa(A,B,F2,Y2) )
      <=> ( X2 = Y2 ) ) ) ).

tff(fact_36_inj__on__id2,axiom,
    ! [A: $tType,A6: fun(A,bool)] : inj_on(A,A,combi(A),A6) ).

tff(fact_37_UNIV__eq__I,axiom,
    ! [A: $tType,A6: fun(A,bool)] :
      ( ! [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A6))
     => ( top_top(fun(A,bool)) = A6 ) ) ).

tff(fact_38_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),top_top(fun(A,bool)))) ).

tff(fact_39_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,Ba: B,F2: fun(B,A),Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F2,Ba)))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),Ba),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F2,X1)),aa(B,A,F2,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F2,C1))) ) ) ) ) ).

tff(fact_40_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,Ba: B,F2: fun(B,A),Aa: A] :
          ( ( Aa = aa(B,A,F2,Ba) )
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),Ba),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F2,X1)),aa(B,A,F2,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F2,C1))) ) ) ) ) ).

tff(fact_41_inj__onD,axiom,
    ! [B: $tType,A: $tType,Y2: A,X2: A,A6: fun(A,bool),F2: fun(A,B)] :
      ( inj_on(A,B,F2,A6)
     => ( ( aa(A,B,F2,X2) = aa(A,B,F2,Y2) )
       => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A6))
         => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),A6))
           => ( X2 = Y2 ) ) ) ) ) ).

tff(fact_42_inj__on__iff,axiom,
    ! [B: $tType,A: $tType,Y2: A,X2: A,A6: fun(A,bool),F2: fun(A,B)] :
      ( inj_on(A,B,F2,A6)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A6))
       => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),A6))
         => ( ( aa(A,B,F2,X2) = aa(A,B,F2,Y2) )
          <=> ( X2 = Y2 ) ) ) ) ) ).

tff(fact_43_inj__on__contraD,axiom,
    ! [B: $tType,A: $tType,Y2: A,X2: A,A6: fun(A,bool),F2: fun(A,B)] :
      ( inj_on(A,B,F2,A6)
     => ( ( X2 != Y2 )
       => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A6))
         => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),A6))
           => ( aa(A,B,F2,X2) != aa(A,B,F2,Y2) ) ) ) ) ) ).

tff(fact_44_inj__on__def,axiom,
    ! [B: $tType,A: $tType,A6: fun(A,bool),F2: fun(A,B)] :
      ( inj_on(A,B,F2,A6)
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A6))
         => ! [Xa: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A6))
             => ( ( aa(A,B,F2,X3) = aa(A,B,F2,Xa) )
               => ( X3 = Xa ) ) ) ) ) ).

tff(fact_45_injI,axiom,
    ! [B: $tType,A: $tType,F2: fun(A,B)] :
      ( ! [X1: A,Y1: A] :
          ( ( aa(A,B,F2,X1) = aa(A,B,F2,Y1) )
         => ( X1 = Y1 ) )
     => inj_on(A,B,F2,top_top(fun(A,bool))) ) ).

tff(fact_46_inj__on__inverseI,axiom,
    ! [B: $tType,A: $tType,F2: fun(A,B),G: fun(B,A),A6: fun(A,bool)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A6))
         => ( aa(B,A,G,aa(A,B,F2,X1)) = X1 ) )
     => inj_on(A,B,F2,A6) ) ).

tff(fact_47_inj__on__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F2: fun(A,B),A6: fun(A,bool)] :
      ( ! [A1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A6))
         => ( aa(A,B,F2,A1) = aa(A,B,G,A1) ) )
     => ( inj_on(A,B,F2,A6)
      <=> inj_on(A,B,G,A6) ) ) ).

tff(fact_48_inj__onI,axiom,
    ! [B: $tType,A: $tType,F2: fun(A,B),A6: fun(A,bool)] :
      ( ! [X1: A,Y1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A6))
         => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),A6))
           => ( ( aa(A,B,F2,X1) = aa(A,B,F2,Y1) )
             => ( X1 = Y1 ) ) ) )
     => inj_on(A,B,F2,A6) ) ).

tff(fact_49_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X2: A] :
        ? [X12: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),X12)) ) ).

tff(fact_50_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F2: fun(A,B),Ba: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),Ba))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F2,Ba)),C1))
           => ( ! [X1: A,Y1: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F2,X1)),aa(A,B,F2,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F2,Aa)),C1)) ) ) ) ) ).

tff(fact_51_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F2: fun(A,B),Ba: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),Ba))
         => ( ( aa(A,B,F2,Ba) = C1 )
           => ( ! [X1: A,Y1: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F2,X1)),aa(A,B,F2,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F2,Aa)),C1)) ) ) ) ) ).

tff(fact_52_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ? [Z1: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z1))
              & pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Z1),Y)) ) ) ) ).

tff(fact_53_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [Y1: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X)) ) ).

tff(fact_54_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_55_the__inv__f__f,axiom,
    ! [B: $tType,A: $tType,X2: A,F2: fun(A,B)] :
      ( inj_on(A,B,F2,top_top(fun(A,bool)))
     => ( the_inv_into(A,B,top_top(fun(A,bool)),F2,aa(A,B,F2,X2)) = X2 ) ) ).

tff(fact_56_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_57_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),N1))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),M1)) ) ) ).

tff(fact_58_the__inv__into__f__f,axiom,
    ! [B: $tType,A: $tType,X2: A,A6: fun(A,bool),F2: fun(A,B)] :
      ( inj_on(A,B,F2,A6)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A6))
       => ( the_inv_into(A,B,A6,F2,aa(A,B,F2,X2)) = X2 ) ) ) ).

tff(fact_59_the__inv__into__f__eq,axiom,
    ! [B: $tType,A: $tType,Y2: B,X2: A,A6: fun(A,bool),F2: fun(A,B)] :
      ( inj_on(A,B,F2,A6)
     => ( ( aa(A,B,F2,X2) = Y2 )
       => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A6))
         => ( the_inv_into(A,B,A6,F2,Y2) = X2 ) ) ) ) ).

tff(fact_60_nat__less__cases,axiom,
    ! [P2: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),N1))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P2,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P2,N1),M1)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N1),M1))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P2,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P2,N1),M1)) ) ) ) ).

tff(fact_61_less__not__refl3,axiom,
    ! [T: nat,S1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S1),T))
     => ( S1 != T ) ) ).

tff(fact_62_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M))
     => ( M != N ) ) ).

tff(fact_63_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_64_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_65_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_66_in__below,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),arrow_319942042_below(L,Aa,Ba)))
        <=> ( ( X2 != Y2 )
            & ( ( Y2 = Aa )
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Ba)),L)) )
            & ( ( Y2 != Aa )
             => ( ( ( X2 = Aa )
                 => ( ( Y2 = Ba )
                    | pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Y2)),L)) ) )
                & ( ( X2 != Aa )
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),L)) ) ) ) ) ) ) ) ).

tff(fact_67_in__above,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),arrow_1158827142_above(L,Aa,Ba)))
        <=> ( ( X2 != Y2 )
            & ( ( X2 = Ba )
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y2)),L)) )
            & ( ( X2 != Ba )
             => ( ( ( Y2 = Ba )
                 => ( ( X2 = Aa )
                    | pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Aa)),L)) ) )
                & ( ( Y2 != Ba )
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),L)) ) ) ) ) ) ) ) ).

tff(fact_68_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba)),L))
       => ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa)),L)) ) ) ).

tff(fact_69_notin__Lin__iff,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => ( ( X2 != Y2 )
       => ( ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),L))
        <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y2,X2)),L)) ) ) ) ).

tff(fact_70_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa: B] :
          ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),product_Pair(A,B,X3,Xa)),R1))
        <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),product_Pair(A,B,X3,Xa)),S)) )
    <=> ( R1 = S ) ) ).

tff(fact_71_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),arrow_424895264_mktop(L,Z)))
    <=> ( ( X2 != Z )
        & ( ( Y2 = Z )
         => ( X2 != Y2 ) )
        & ( ( Y2 != Z )
         => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),L)) ) ) ) ).

tff(fact_72_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),arrow_276188178_mkbot(L,Z)))
    <=> ( ( Y2 != Z )
        & ( ( X2 = Z )
         => ( X2 != Y2 ) )
        & ( ( X2 != Z )
         => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2)),L)) ) ) ) ).

tff(fact_73__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b)),lab)) ).

tff(fact_74__096b_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_096,axiom,
    pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a)),lba)) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F2: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F2,X1) = aa(A,B,G,X1) )
     => ( F2 = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A6: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A6))
    <=> pp(aa(A,bool,A6,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P2: fun(A,bool)] : ( collect(A,P2) = P2 ) ).

tff(fact_78_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X1),arrow_1985332922le_Lin))
          & pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba)),X1)) ) ) ).

tff(fact_79__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_80__096_Ia_M_Ab_J_A_126_058_ALba_096,axiom,
    ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b)),lba)) ).

tff(fact_81__096_Ib_M_Aa_J_A_126_058_ALab_096,axiom,
    ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a)),lab)) ).

tff(fact_82__096_B_Bthesis_O_A_I_B_BLab_O_A_091_124_Aa_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_059_ALab_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b)),Lab))
       => ~ pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Lab),arrow_1985332922le_Lin)) ) ).

tff(fact_83__096_B_Bthesis_O_A_I_B_BLba_O_A_091_124_Ab_A_060_092_060_094bsub_062Lba_092_060_094esub_062_Aa_059_ALba_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a)),Lba))
       => ~ pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Lba),arrow_1985332922le_Lin)) ) ).

tff(fact_84_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X11))
    <=> ! [A2: A,B2: B] : pp(aa(product_prod(A,B),bool,P2,product_Pair(A,B,A2,B2))) ) ).

tff(fact_85_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A5,B5) )
    <=> ( ( Aa = A5 )
        & ( Ba = B5 ) ) ) ).

tff(fact_86_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A4: A,B3: B,A3: A] :
      ( ( product_Pair(A,B,A3,B3) = product_Pair(A,B,A4,B4) )
     => ~ ( ( A3 = A4 )
         => ( B3 != B4 ) ) ) ).

tff(fact_87_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X11))
    <=> ? [A2: A,B2: B] : pp(aa(product_prod(A,B),bool,P2,product_Pair(A,B,A2,B2))) ) ).

tff(fact_88_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F11,Aa),Ba) ) ).

tff(fact_89_prod__induct6,axiom,
    ! [F: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),bool)] :
      ( ! [A1: A,B1: B,C2: C,D1: D,E1: E,F1: F] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),bool,P2,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F))),B1,product_Pair(C,product_prod(D,product_prod(E,F)),C2,product_Pair(D,product_prod(E,F),D1,product_Pair(E,F,E1,F1)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),bool,P2,X2)) ) ).

tff(fact_90_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F)))))] :
      ~ ! [A1: A,B1: B,C2: C,D1: D,E1: E,F1: F] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F))),B1,product_Pair(C,product_prod(D,product_prod(E,F)),C2,product_Pair(D,product_prod(E,F),D1,product_Pair(E,F,E1,F1))))) ) ).

tff(fact_91_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A1: A,B1: B,C2: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_92_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A1: A,B1: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,X2)) ) ).

tff(fact_93_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,D))),P2: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A1: A,B1: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,X2)) ) ).

tff(fact_94_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A1: A,B1: B,C2: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C2,D1))) ) ).

tff(fact_95_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A1: A,B1: B,C2: C] : ( Y != product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B1,C2)) ) ).

tff(fact_96_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,C)),P2: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A1: A,B1: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P2,product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B1,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P2,X2)) ) ).

tff(fact_97_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X1: A,Y1: B] : ( P1 != product_Pair(A,B,X1,Y1) ) ).

tff(fact_98_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A1: A,B1: B] : ( Y != product_Pair(A,B,A1,B1) ) ).

tff(fact_99_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),C1,Aa),Ba) ) ).

%----Arities (13)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (16)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X),Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),combb(B,C,A,P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),combs(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(arrow_159774573e_indi,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_159774573e_indi,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),aa(fun(arrow_159774573e_indi,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_159774573e_indi,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))),combc(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),aa(fun(arrow_159774573e_indi,bool),fun(arrow_159774573e_indi,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))),combb(bool,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),aa(nat,fun(arrow_159774573e_indi,bool),aa(fun(arrow_159774573e_indi,fun(nat,bool)),fun(nat,fun(arrow_159774573e_indi,bool)),combc(arrow_159774573e_indi,nat,bool),aa(fun(arrow_159774573e_indi,nat),fun(arrow_159774573e_indi,fun(nat,bool)),combb(nat,fun(nat,bool),arrow_159774573e_indi,ord_less(nat)),h)),n))),lab)),lba)),collect(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(arrow_159774573e_indi,bool)),fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),combb(fun(arrow_159774573e_indi,bool),bool,fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fAll(arrow_159774573e_indi)),aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(arrow_159774573e_indi,bool)),fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(arrow_159774573e_indi,bool)),combb(fun(arrow_159774573e_indi,bool),fun(arrow_159774573e_indi,bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combs(arrow_159774573e_indi,bool,bool,aa(fun(arrow_159774573e_indi,bool),fun(arrow_159774573e_indi,fun(bool,bool)),combb(bool,fun(bool,bool),arrow_159774573e_indi,fimplies),aa(fun(arrow_159774573e_indi,bool),fun(arrow_159774573e_indi,bool),aa(fun(arrow_159774573e_indi,fun(fun(arrow_159774573e_indi,bool),bool)),fun(fun(arrow_159774573e_indi,bool),fun(arrow_159774573e_indi,bool)),combc(arrow_159774573e_indi,fun(arrow_159774573e_indi,bool),bool),member(arrow_159774573e_indi)),top_top(fun(arrow_159774573e_indi,bool)))))),aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(arrow_159774573e_indi,bool)),aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,bool))),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(arrow_159774573e_indi,bool))),combc(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,bool)),aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(arrow_159774573e_indi,fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool))),fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,bool))),combb(fun(arrow_159774573e_indi,fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool)),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,bool)),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),arrow_159774573e_indi,member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))))),arrow_1985332922le_Lin)))))) ).

%------------------------------------------------------------------------------
