%------------------------------------------------------------------------------
% File     : SCT242_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 256
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_256 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  115 (  32 unt;  33 typ;   0 def)
%            Number of atoms       :  221 (  88 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  202 (  63   ~;   2   |;  12   &)
%                                         (  24 <=>; 101  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   35 (  18   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   1 prp; 0-5 aty)
%            Number of functors    :   23 (  23 usr;   8 con; 0-6 aty)
%            Number of variables   :  453 ( 417   !;   7   ?; 453   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:16
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (28)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C: $tType,B: $tType] : ( ( fun(A,C) * product_prod(A,B) ) > product_prod(C,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * product_prod(A,B) ) > product_prod(A,C) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(product_prod(A,B),C) > fun(A,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C: $tType,D: $tType] : ( ( fun(A,product_prod(B,C)) * fun(B,fun(C,D)) ) > fun(A,D) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (78)
tff(fact_0__096Lab_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lab,arrow_1985332922le_Lin) ).

tff(fact_1__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_2__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),lab) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_BLab_O_A_091_124_Aa_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_059_ALab_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),Lab)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lab,arrow_1985332922le_Lin) ) ).

tff(fact_4__096_Ib_M_Aa_J_A_126_058_ALab_096,axiom,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),b),a),lab) ).

tff(fact_5_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X),L) ) ) ) ).

tff(fact_6_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),L) ) ) ).

tff(fact_7_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),X1) ) ) ).

tff(fact_8_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X11))
    <=> ! [A2: A,B1: B] : pp(aa(product_prod(A,B),bool,P2,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1))) ) ).

tff(fact_9_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,Ba: B,Aa: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
    <=> ( ( Aa = A3 )
        & ( Ba = B2 ) ) ) ).

tff(fact_10_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_1158827142_above(L,Aa,Ba))
        <=> ( ( X != Y1 )
            & ( ( X = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Y1),L) )
            & ( ( X != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Aa),L) ) )
                & ( ( Y1 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_11_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_319942042_below(L,Aa,Ba))
        <=> ( ( X != Y1 )
            & ( ( Y1 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Ba),L) )
            & ( ( Y1 != Aa )
             => ( ( ( X = Aa )
                 => ( ( Y1 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Y1),L) ) )
                & ( ( X != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_12_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_13_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( ( X != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_14_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( ( X != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_15_mkbot__Lin,axiom,
    ! [X: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X),arrow_1985332922le_Lin) ) ).

tff(fact_16_mktop__Lin,axiom,
    ! [X: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X),arrow_1985332922le_Lin) ) ).

tff(fact_17_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y1 != Z )
        & ( ( X = Z )
         => ( X != Y1 ) )
        & ( ( X != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L) ) ) ) ).

tff(fact_18_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_424895264_mktop(L,Z))
    <=> ( ( X != Z )
        & ( ( Y1 = Z )
         => ( X != Y1 ) )
        & ( ( Y1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L) ) ) ) ).

tff(fact_19_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,B4: B,A5: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_20_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X11))
    <=> ? [A2: A,B1: B] : pp(aa(product_prod(A,B),bool,P2,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1))) ) ).

tff(fact_21_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A,aa(B,fun(C,A),F1,Aa),Ba) ) ).

tff(fact_22_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y2: product_prod(A,B)] :
      ~ ! [A4: A,B3: B] : ( Y2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) ) ).

tff(fact_23_PairE,axiom,
    ! [A: $tType,B: $tType,P: product_prod(A,B)] :
      ~ ! [X1: A,Y: B] : ( P != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y) ) ).

tff(fact_24_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y2: product_prod(A,product_prod(B,C))] :
      ~ ! [A4: A,B3: B,C2: C] : ( Y2 != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A4),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B3),C2)) ) ).

tff(fact_25_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,C)),P2: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A4: A,B3: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P2,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A4),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B3),C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P2,X)) ) ).

tff(fact_26_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A4: A,B3: B,C2: C,D1: D] : ( Y2 != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A4),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_27_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,D))),P2: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A4: A,B3: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A4),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,X)) ) ).

tff(fact_28_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A4: A,B3: B,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,X)) ) ).

tff(fact_29_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A4: A,B3: B,C2: C,D1: D,E1: E,F3: F2] : ( Y2 != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_30_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A4: A,B3: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A4),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,X)) ) ).

tff(fact_31_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A4: A,B3: B,C2: C,D1: D,E1: E] : ( Y2 != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A4),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_32_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),produc1605651328_split(B,C,A),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A,aa(B,fun(C,A),C1,Aa),Ba) ) ).

tff(fact_33_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( aa(C,A,aa(B,fun(C,A),product_curry(B,C,A,F),Aa),Ba) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) ) ).

tff(fact_34_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),Aa),Ba)) ) ).

tff(fact_35_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),Aa),Ba))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_36_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),Aa),Ba))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_37_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_38_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_39_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_40_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y1: B,X: A,R: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R,X,Y1)
    <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y1),R) ) ).

tff(fact_41_apsnd__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y1: C,X: A,F: fun(C,B)] : ( product_apsnd(C,B,A,F,aa(C,product_prod(A,C),aa(A,fun(C,product_prod(A,C)),product_Pair(A,C),X),Y1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),aa(C,B,F,Y1)) ) ).

tff(fact_42_apfst__conv,axiom,
    ! [C: $tType,A: $tType,B: $tType,Y1: B,X: C,F: fun(C,A)] : ( product_apfst(C,A,B,F,aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X),Y1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,X)),Y1) ) ).

tff(fact_43_splitI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,Aa),Ba))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_44_prod__caseI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F1,Aa),Ba))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_45_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,Aa),Ba))
     => member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba))) ) ).

tff(fact_46_split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A,aa(B,fun(C,A),F,Aa),Ba) ) ).

tff(fact_47_splitD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,Aa),Ba)) ) ).

tff(fact_48_apsnd__apfst__commute,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,P1: product_prod(D,C),G: fun(D,A),F: fun(C,B)] : ( product_apsnd(C,B,A,F,product_apfst(D,A,C,G,P1)) = product_apfst(D,A,B,G,product_apsnd(C,B,D,F,P1)) ) ).

tff(fact_49_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q: product_prod(A,B),P1: product_prod(A,B)] :
      ( ( P1 = Q )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P1) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q) ) ) ).

tff(fact_50_splitD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C1: C,Ba: B,Aa: A,R: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),R),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),R,Aa),Ba),C1)) ) ).

tff(fact_51_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A,aa(B,fun(C,A),F1,Aa),Ba) ) ).

tff(fact_52_curry__split,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C))] : ( product_curry(A,B,C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F)) = F ) ).

tff(fact_53_split__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),product_curry(A,B,C,F)) = F ) ).

tff(fact_54_splitE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B),C1: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P1))
     => ~ ! [X1: A,Y: B] :
            ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C1,X1),Y)) ) ) ).

tff(fact_55_splitI2,axiom,
    ! [B: $tType,A: $tType,C1: fun(A,fun(B,bool)),P1: product_prod(A,B)] :
      ( ! [A4: A,B3: B] :
          ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C1,A4),B3)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P1)) ) ).

tff(fact_56_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,fun(C,bool))),Z: C,P1: product_prod(A,B)] :
      ( ! [A4: A,B3: B] :
          ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) )
         => member(C,Z,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A4),B3)) )
     => member(C,Z,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1)) ) ).

tff(fact_57_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,X: C,C1: fun(A,fun(B,fun(C,bool))),P1: product_prod(A,B)] :
      ( ! [A4: A,B3: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) = P1 )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A4),B3),X)) )
     => pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1),X)) ) ).

tff(fact_58_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C: $tType,P1: product_prod(B,C),C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),P1))
     => ~ ! [X1: B,Y: C] :
            ( ( P1 = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X1),Y) )
           => ~ member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,X1),Y)) ) ) ).

tff(fact_59_splitE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: C,P1: product_prod(A,B),C1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1),Z))
     => ~ ! [X1: A,Y: B] :
            ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,X1),Y),Z)) ) ) ).

tff(fact_60__C3_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
         => ( ! [I2: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I2))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ).

tff(fact_61_pairwise__neutrality,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B2: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B2 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
           => ( ! [I2: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I2))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ).

tff(fact_62__C2_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B2: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B2 )
       => ( ( Aa != B2 )
         => ( ( Ba != A3 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_63__C1_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B2: arrow_411405190le_alt,A3: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A3 != B2 )
       => ( ( Aa != B2 )
         => ( ( Ba != A3 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_64__C4_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),C1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != C1 )
       => ( ( Aa != C1 )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P2,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
             => ( ! [I2: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P2,I2))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),C1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P2))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),C1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ).

tff(fact_65_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [Xa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa,arrow_610318064e_Prof)
             => ! [A2: arrow_411405190le_alt,B1: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa)) ) ) ) ) ) ).

tff(fact_66_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [A2: arrow_411405190le_alt,B1: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3)) ) ) ) ).

tff(fact_67_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,P1: product_prod(A,B),G: fun(A,fun(B,C)),F: fun(A,fun(B,C)),Q: product_prod(A,B)] :
      ( ! [X1: A,Y: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y) = Q )
         => ( aa(B,C,aa(A,fun(B,C),F,X1),Y) = aa(B,C,aa(A,fun(B,C),G,X1),Y) ) )
     => ( ( P1 = Q )
       => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F),P1) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),G),Q) ) ) ) ).

tff(fact_68_splitE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: product_prod(B,C),P2: fun(B,fun(C,A)),Q1: fun(A,bool)] :
      ( pp(aa(A,bool,Q1,aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),P2),Z)))
     => ~ ! [X1: B,Y: C] :
            ( ( Z = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X1),Y) )
           => ~ pp(aa(A,bool,Q1,aa(C,A,aa(B,fun(C,A),P2,X1),Y))) ) ) ).

tff(fact_69_dictator__def,axiom,
    ! [I: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I) ) ) ) ).

tff(fact_70_apfst__convE,axiom,
    ! [C: $tType,A: $tType,B: $tType,P1: product_prod(C,B),F: fun(C,A),Q: product_prod(A,B)] :
      ( ( Q = product_apfst(C,A,B,F,P1) )
     => ~ ! [X1: C,Y: B] :
            ( ( P1 = aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X1),Y) )
           => ( Q != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,X1)),Y) ) ) ) ).

tff(fact_71_scomp__apply,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,X: B,G: fun(C,fun(D,A)),F: fun(B,product_prod(C,D))] : ( aa(B,A,product_scomp(B,C,D,A,F,G),X) = aa(product_prod(C,D),A,aa(fun(C,fun(D,A)),fun(product_prod(C,D),A),product_prod_case(C,D,A),G),aa(B,product_prod(C,D),F,X)) ) ).

tff(fact_72_surj__pair,axiom,
    ! [A: $tType,B: $tType,P: product_prod(A,B)] :
    ? [X1: A,Y: B] : ( P = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y) ) ).

tff(fact_73_scomp__Pair,axiom,
    ! [C: $tType,B: $tType,A: $tType,X: fun(A,product_prod(B,C))] : ( product_scomp(A,B,C,product_prod(B,C),X,product_Pair(B,C)) = X ) ).

tff(fact_74_scomp__def,axiom,
    ! [B: $tType,C: $tType,D: $tType,A: $tType,G: fun(C,fun(D,B)),F: fun(A,product_prod(C,D)),X2: A] : ( aa(A,B,product_scomp(A,C,D,B,F,G),X2) = aa(product_prod(C,D),B,aa(fun(C,fun(D,B)),fun(product_prod(C,D),B),product_prod_case(C,D,B),G),aa(A,product_prod(C,D),F,X2)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_77_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: fun(C,fun(A,B)),X: C] : ( product_scomp(A,C,A,B,aa(C,fun(A,product_prod(C,A)),product_Pair(C,A),X),F) = aa(C,fun(A,B),F,X) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [Lba: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),b),a),Lba)
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lba,arrow_1985332922le_Lin)
       => thesis ) ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
