%------------------------------------------------------------------------------
% File     : SCT241_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 255
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_255 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  112 (  31 unt;  32 typ;   0 def)
%            Number of atoms       :  217 (  88 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  200 (  63   ~;   2   |;  12   &)
%                                         (  24 <=>;  99  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   35 (  18   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-5 aty)
%            Number of functors    :   23 (  23 usr;   8 con; 0-6 aty)
%            Number of variables   :  452 ( 416   !;   7   ?; 452   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (27)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A1: $tType,B: $tType] : ( ( fun(product_prod(A1,B),bool) * A1 * B ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B: $tType] : fun(A1,fun(B,product_prod(A1,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A1: $tType,C: $tType,B: $tType] : ( ( fun(A1,C) * product_prod(A1,B) ) > product_prod(C,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C: $tType,A1: $tType] : ( ( fun(B,C) * product_prod(A1,B) ) > product_prod(A1,C) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B: $tType,C: $tType] : ( fun(product_prod(A1,B),C) > fun(A1,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B: $tType,C: $tType] : fun(fun(A1,fun(B,C)),fun(product_prod(A1,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A1: $tType,B: $tType,T: $tType] : fun(fun(A1,fun(B,T)),fun(product_prod(A1,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B: $tType,T: $tType] : ( ( fun(A1,fun(B,T)) * product_prod(A1,B) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A1: $tType,B: $tType,C: $tType,D: $tType] : ( ( fun(A1,product_prod(B,C)) * fun(B,fun(C,D)) ) > fun(A1,D) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * A1 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Lab____,type,
    lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

%----Relevant facts (77)
tff(fact_0__096Lab_A_058_ALin_096,axiom,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),lab,arrow_1985332922le_Lin) ).

tff(fact_1__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_2__096a_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_096,axiom,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),lab) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_BLab_O_A_091_124_Aa_A_060_092_060_094bsub_062Lab_092_060_094esub_062_Ab_059_ALab_A_058_ALin_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Lab: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),Lab)
       => ~ member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Lab,arrow_1985332922le_Lin) ) ).

tff(fact_4_split__paired__All,axiom,
    ! [A1: $tType,B: $tType,P1: fun(product_prod(A1,B),bool)] :
      ( ! [X11: product_prod(A1,B)] : pp(aa(product_prod(A1,B),bool,P1,X11))
    <=> ! [A3: A1,B2: B] : pp(aa(product_prod(A1,B),bool,P1,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A3),B2))) ) ).

tff(fact_5_Pair__eq,axiom,
    ! [A1: $tType,B: $tType,B3: B,A4: A1,Ba: B,Aa: A1] :
      ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A4),B3) )
    <=> ( ( Aa = A4 )
        & ( Ba = B3 ) ) ) ).

tff(fact_6_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( ( X != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L1)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X),L1) ) ) ) ).

tff(fact_7_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),L1)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),L1) ) ) ).

tff(fact_8_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_276188178_mkbot(L1,Z))
    <=> ( ( Y1 != Z )
        & ( ( X = Z )
         => ( X != Y1 ) )
        & ( ( X != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L1) ) ) ) ).

tff(fact_9_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_424895264_mktop(L1,Z))
    <=> ( ( X != Z )
        & ( ( Y1 = Z )
         => ( X != Y1 ) )
        & ( ( Y1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L1) ) ) ) ).

tff(fact_10_Pair__inject,axiom,
    ! [A1: $tType,B: $tType,B5: B,A6: A1,B4: B,A5: A1] :
      ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A5),B4) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A6),B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_11_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_12_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_13_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),X1) ) ) ).

tff(fact_14_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_1158827142_above(L1,Aa,Ba))
        <=> ( ( X != Y1 )
            & ( ( X = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Y1),L1) )
            & ( ( X != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Aa),L1) ) )
                & ( ( Y1 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_15_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),arrow_319942042_below(L1,Aa,Ba))
        <=> ( ( X != Y1 )
            & ( ( Y1 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Ba),L1) )
            & ( ( Y1 != Aa )
             => ( ( ( X = Aa )
                 => ( ( Y1 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Y1),L1) ) )
                & ( ( X != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_16_mktop__Lin,axiom,
    ! [X: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L1,X),arrow_1985332922le_Lin) ) ).

tff(fact_17_mkbot__Lin,axiom,
    ! [X: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L1,X),arrow_1985332922le_Lin) ) ).

tff(fact_18_below__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( ( X != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L1,X,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_19_above__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( ( X != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L1,X,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_20_split__paired__Ex,axiom,
    ! [A1: $tType,B: $tType,P1: fun(product_prod(A1,B),bool)] :
      ( ? [X11: product_prod(A1,B)] : pp(aa(product_prod(A1,B),bool,P1,X11))
    <=> ? [A3: A1,B2: B] : pp(aa(product_prod(A1,B),bool,P1,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A3),B2))) ) ).

tff(fact_21__C3_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
         => ( ! [I2: arrow_159774573e_indi] :
                ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
           => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
            <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ).

tff(fact_22_pairwise__neutrality,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B3 )
       => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
           => ( ! [I2: arrow_159774573e_indi] :
                  ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
             => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
              <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ).

tff(fact_23__C4_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),C1: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( Ba != C1 )
       => ( ( Aa != C1 )
         => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
             => ( ! [I2: arrow_159774573e_indi] :
                    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),C1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),C1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ).

tff(fact_24__C1_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B3 )
       => ( ( Aa != B3 )
         => ( ( Ba != A4 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_25__C2_C,axiom,
    ! [P3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B3 )
       => ( ( Aa != B3 )
         => ( ( Ba != A4 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P1,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P3,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P1,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P3,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P3)) ) ) ) ) ) ) ) ) ).

tff(fact_26_prod_Orecs,axiom,
    ! [B: $tType,A1: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A1))] : ( product_prod_rec(B,C,A1,F1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A1,aa(B,fun(C,A1),F1,Aa),Ba) ) ).

tff(fact_27_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_28_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3)) ) ) ) ).

tff(fact_29_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [Xa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa,arrow_610318064e_Prof)
             => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa)) ) ) ) ) ) ).

tff(fact_30_dictator__def,axiom,
    ! [I: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I) ) ) ) ).

tff(fact_31_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A2: A1,B1: B,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A2),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B1),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,X)) ) ).

tff(fact_32_prod__cases6,axiom,
    ! [A1: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y2: product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A2: A1,B1: B,C2: C,D1: D,E1: E,F3: F2] : ( Y2 != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A2),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B1),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_33_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A1,B1: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A1,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A1,product_prod(B,product_prod(C,product_prod(D,E)))),A2),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B1),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,X)) ) ).

tff(fact_34_prod__cases5,axiom,
    ! [A1: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y2: product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A1,B1: B,C2: C,D1: D,E1: E] : ( Y2 != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A1,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A1,product_prod(B,product_prod(C,product_prod(D,E)))),A2),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B1),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_35_prod__cases4,axiom,
    ! [A1: $tType,B: $tType,C: $tType,D: $tType,Y2: product_prod(A1,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A1,B1: B,C2: C,D1: D] : ( Y2 != aa(product_prod(B,product_prod(C,D)),product_prod(A1,product_prod(B,product_prod(C,D))),aa(A1,fun(product_prod(B,product_prod(C,D)),product_prod(A1,product_prod(B,product_prod(C,D)))),product_Pair(A1,product_prod(B,product_prod(C,D))),A2),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B1),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_36_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A1,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A1,B1: B,C2: C,D1: D] : pp(aa(product_prod(A1,product_prod(B,product_prod(C,D))),bool,P1,aa(product_prod(B,product_prod(C,D)),product_prod(A1,product_prod(B,product_prod(C,D))),aa(A1,fun(product_prod(B,product_prod(C,D)),product_prod(A1,product_prod(B,product_prod(C,D)))),product_Pair(A1,product_prod(B,product_prod(C,D))),A2),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B1),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C,D))),bool,P1,X)) ) ).

tff(fact_37_prod__cases3,axiom,
    ! [A1: $tType,B: $tType,C: $tType,Y2: product_prod(A1,product_prod(B,C))] :
      ~ ! [A2: A1,B1: B,C2: C] : ( Y2 != aa(product_prod(B,C),product_prod(A1,product_prod(B,C)),aa(A1,fun(product_prod(B,C),product_prod(A1,product_prod(B,C))),product_Pair(A1,product_prod(B,C)),A2),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B1),C2)) ) ).

tff(fact_38_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,C)),P1: fun(product_prod(A1,product_prod(B,C)),bool)] :
      ( ! [A2: A1,B1: B,C2: C] : pp(aa(product_prod(A1,product_prod(B,C)),bool,P1,aa(product_prod(B,C),product_prod(A1,product_prod(B,C)),aa(A1,fun(product_prod(B,C),product_prod(A1,product_prod(B,C))),product_Pair(A1,product_prod(B,C)),A2),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B1),C2))))
     => pp(aa(product_prod(A1,product_prod(B,C)),bool,P1,X)) ) ).

tff(fact_39_prod_Oexhaust,axiom,
    ! [A1: $tType,B: $tType,Y2: product_prod(A1,B)] :
      ~ ! [A2: A1,B1: B] : ( Y2 != aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1) ) ).

tff(fact_40_PairE,axiom,
    ! [A1: $tType,B: $tType,P2: product_prod(A1,B)] :
      ~ ! [X1: A1,Y: B] : ( P2 != aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y) ) ).

tff(fact_41_internal__split__conv,axiom,
    ! [B: $tType,A1: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A1))] : ( aa(product_prod(B,C),A1,aa(fun(B,fun(C,A1)),fun(product_prod(B,C),A1),produc1605651328_split(B,C,A1),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A1,aa(B,fun(C,A1),C1,Aa),Ba) ) ).

tff(fact_42_curry__conv,axiom,
    ! [A1: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A1)] : ( aa(C,A1,aa(B,fun(C,A1),product_curry(B,C,A1,F),Aa),Ba) = aa(product_prod(B,C),A1,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) ) ).

tff(fact_43_curryI,axiom,
    ! [A1: $tType,B: $tType,Ba: B,Aa: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(product_prod(A1,B),bool,F,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba)))
     => pp(aa(B,bool,aa(A1,fun(B,bool),product_curry(A1,B,bool,F),Aa),Ba)) ) ).

tff(fact_44_in__rel__def,axiom,
    ! [B: $tType,A1: $tType,Y1: B,X: A1,R: fun(product_prod(A1,B),bool)] :
      ( in_rel(A1,B,R,X,Y1)
    <=> member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X),Y1),R) ) ).

tff(fact_45_curryE,axiom,
    ! [A1: $tType,B: $tType,Ba: B,Aa: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),product_curry(A1,B,bool,F),Aa),Ba))
     => pp(aa(product_prod(A1,B),bool,F,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba))) ) ).

tff(fact_46_curryD,axiom,
    ! [A1: $tType,B: $tType,Ba: B,Aa: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),product_curry(A1,B,bool,F),Aa),Ba))
     => pp(aa(product_prod(A1,B),bool,F,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba))) ) ).

tff(fact_47_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A1: $tType] : ( produc1605651328_split(A1,B,C) = product_prod_case(A1,B,C) ) ).

tff(fact_48_apsnd__conv,axiom,
    ! [A1: $tType,B: $tType,C: $tType,Y1: C,X: A1,F: fun(C,B)] : ( product_apsnd(C,B,A1,F,aa(C,product_prod(A1,C),aa(A1,fun(C,product_prod(A1,C)),product_Pair(A1,C),X),Y1)) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X),aa(C,B,F,Y1)) ) ).

tff(fact_49_apfst__conv,axiom,
    ! [C: $tType,A1: $tType,B: $tType,Y1: B,X: C,F: fun(C,A1)] : ( product_apfst(C,A1,B,F,aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X),Y1)) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),aa(C,A1,F,X)),Y1) ) ).

tff(fact_50_surj__pair,axiom,
    ! [A1: $tType,B: $tType,P2: product_prod(A1,B)] :
    ? [X1: A1,Y: B] : ( P2 = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y) ) ).

tff(fact_51_prod__caseI,axiom,
    ! [A1: $tType,B: $tType,Ba: B,Aa: A1,F1: fun(A1,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),F1,Aa),Ba))
     => pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),F1),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba))) ) ).

tff(fact_52_splitI,axiom,
    ! [A1: $tType,B: $tType,Ba: B,Aa: A1,F: fun(A1,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),F,Aa),Ba))
     => pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),F),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba))) ) ).

tff(fact_53_mem__splitI,axiom,
    ! [A1: $tType,B: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,fun(A1,bool))),Z: A1] :
      ( member(A1,Z,aa(C,fun(A1,bool),aa(B,fun(C,fun(A1,bool)),C1,Aa),Ba))
     => member(A1,Z,aa(product_prod(B,C),fun(A1,bool),aa(fun(B,fun(C,fun(A1,bool))),fun(product_prod(B,C),fun(A1,bool)),product_prod_case(B,C,fun(A1,bool)),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba))) ) ).

tff(fact_54_split__conv,axiom,
    ! [B: $tType,A1: $tType,C: $tType,Ba: C,Aa: B,F: fun(B,fun(C,A1))] : ( aa(product_prod(B,C),A1,aa(fun(B,fun(C,A1)),fun(product_prod(B,C),A1),product_prod_case(B,C,A1),F),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A1,aa(B,fun(C,A1),F,Aa),Ba) ) ).

tff(fact_55_splitD_H,axiom,
    ! [B: $tType,A1: $tType,C: $tType,C1: C,Ba: B,Aa: A1,R: fun(A1,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A1,B),fun(C,bool),aa(fun(A1,fun(B,fun(C,bool))),fun(product_prod(A1,B),fun(C,bool)),product_prod_case(A1,B,fun(C,bool)),R),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A1,fun(B,fun(C,bool)),R,Aa),Ba),C1)) ) ).

tff(fact_56_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A1: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A1))] : ( aa(product_prod(B,C),A1,aa(fun(B,fun(C,A1)),fun(product_prod(B,C),A1),product_prod_case(B,C,A1),F1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A1,aa(B,fun(C,A1),F1,Aa),Ba) ) ).

tff(fact_57_splitD,axiom,
    ! [A1: $tType,B: $tType,Ba: B,Aa: A1,F: fun(A1,fun(B,bool))] :
      ( pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),F),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Aa),Ba)))
     => pp(aa(B,bool,aa(A1,fun(B,bool),F,Aa),Ba)) ) ).

tff(fact_58_apsnd__apfst__commute,axiom,
    ! [A1: $tType,B: $tType,C: $tType,D: $tType,P: product_prod(D,C),G: fun(D,A1),F: fun(C,B)] : ( product_apsnd(C,B,A1,F,product_apfst(D,A1,C,G,P)) = product_apfst(D,A1,B,G,product_apsnd(C,B,D,F,P)) ) ).

tff(fact_59_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A1: $tType,C1: fun(A1,fun(B,C)),Q: product_prod(A1,B),P: product_prod(A1,B)] :
      ( ( P = Q )
     => ( aa(product_prod(A1,B),C,aa(fun(A1,fun(B,C)),fun(product_prod(A1,B),C),product_prod_case(A1,B,C),C1),P) = aa(product_prod(A1,B),C,aa(fun(A1,fun(B,C)),fun(product_prod(A1,B),C),product_prod_case(A1,B,C),C1),Q) ) ) ).

tff(fact_60_curry__split,axiom,
    ! [C: $tType,B: $tType,A1: $tType,F: fun(A1,fun(B,C))] : ( product_curry(A1,B,C,aa(fun(A1,fun(B,C)),fun(product_prod(A1,B),C),product_prod_case(A1,B,C),F)) = F ) ).

tff(fact_61_split__curry,axiom,
    ! [C: $tType,B: $tType,A1: $tType,F: fun(product_prod(A1,B),C)] : ( aa(fun(A1,fun(B,C)),fun(product_prod(A1,B),C),product_prod_case(A1,B,C),product_curry(A1,B,C,F)) = F ) ).

tff(fact_62_splitE,axiom,
    ! [A1: $tType,B: $tType,P: product_prod(A1,B),C1: fun(A1,fun(B,bool))] :
      ( pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),C1),P))
     => ~ ! [X1: A1,Y: B] :
            ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y) )
           => ~ pp(aa(B,bool,aa(A1,fun(B,bool),C1,X1),Y)) ) ) ).

tff(fact_63_splitI2,axiom,
    ! [B: $tType,A1: $tType,C1: fun(A1,fun(B,bool)),P: product_prod(A1,B)] :
      ( ! [A2: A1,B1: B] :
          ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1) )
         => pp(aa(B,bool,aa(A1,fun(B,bool),C1,A2),B1)) )
     => pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),C1),P)) ) ).

tff(fact_64_splitE_H,axiom,
    ! [B: $tType,A1: $tType,C: $tType,Z: C,P: product_prod(A1,B),C1: fun(A1,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A1,B),fun(C,bool),aa(fun(A1,fun(B,fun(C,bool))),fun(product_prod(A1,B),fun(C,bool)),product_prod_case(A1,B,fun(C,bool)),C1),P),Z))
     => ~ ! [X1: A1,Y: B] :
            ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A1,fun(B,fun(C,bool)),C1,X1),Y),Z)) ) ) ).

tff(fact_65_mem__splitE,axiom,
    ! [B: $tType,A1: $tType,C: $tType,P: product_prod(B,C),C1: fun(B,fun(C,fun(A1,bool))),Z: A1] :
      ( member(A1,Z,aa(product_prod(B,C),fun(A1,bool),aa(fun(B,fun(C,fun(A1,bool))),fun(product_prod(B,C),fun(A1,bool)),product_prod_case(B,C,fun(A1,bool)),C1),P))
     => ~ ! [X1: B,Y: C] :
            ( ( P = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X1),Y) )
           => ~ member(A1,Z,aa(C,fun(A1,bool),aa(B,fun(C,fun(A1,bool)),C1,X1),Y)) ) ) ).

tff(fact_66_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A1: $tType,C1: fun(A1,fun(B,fun(C,bool))),Z: C,P: product_prod(A1,B)] :
      ( ! [A2: A1,B1: B] :
          ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1) )
         => member(C,Z,aa(B,fun(C,bool),aa(A1,fun(B,fun(C,bool)),C1,A2),B1)) )
     => member(C,Z,aa(product_prod(A1,B),fun(C,bool),aa(fun(A1,fun(B,fun(C,bool))),fun(product_prod(A1,B),fun(C,bool)),product_prod_case(A1,B,fun(C,bool)),C1),P)) ) ).

tff(fact_67_splitI2_H,axiom,
    ! [A1: $tType,B: $tType,C: $tType,X: C,C1: fun(A1,fun(B,fun(C,bool))),P: product_prod(A1,B)] :
      ( ! [A2: A1,B1: B] :
          ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1) = P )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A1,fun(B,fun(C,bool)),C1,A2),B1),X)) )
     => pp(aa(C,bool,aa(product_prod(A1,B),fun(C,bool),aa(fun(A1,fun(B,fun(C,bool))),fun(product_prod(A1,B),fun(C,bool)),product_prod_case(A1,B,fun(C,bool)),C1),P),X)) ) ).

tff(fact_68_splitE2,axiom,
    ! [B: $tType,A1: $tType,C: $tType,Z: product_prod(B,C),P1: fun(B,fun(C,A1)),Q1: fun(A1,bool)] :
      ( pp(aa(A1,bool,Q1,aa(product_prod(B,C),A1,aa(fun(B,fun(C,A1)),fun(product_prod(B,C),A1),product_prod_case(B,C,A1),P1),Z)))
     => ~ ! [X1: B,Y: C] :
            ( ( Z = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X1),Y) )
           => ~ pp(aa(A1,bool,Q1,aa(C,A1,aa(B,fun(C,A1),P1,X1),Y))) ) ) ).

tff(fact_69_split__cong,axiom,
    ! [C: $tType,B: $tType,A1: $tType,P: product_prod(A1,B),G: fun(A1,fun(B,C)),F: fun(A1,fun(B,C)),Q: product_prod(A1,B)] :
      ( ! [X1: A1,Y: B] :
          ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y) = Q )
         => ( aa(B,C,aa(A1,fun(B,C),F,X1),Y) = aa(B,C,aa(A1,fun(B,C),G,X1),Y) ) )
     => ( ( P = Q )
       => ( aa(product_prod(A1,B),C,aa(fun(A1,fun(B,C)),fun(product_prod(A1,B),C),product_prod_case(A1,B,C),F),P) = aa(product_prod(A1,B),C,aa(fun(A1,fun(B,C)),fun(product_prod(A1,B),C),product_prod_case(A1,B,C),G),Q) ) ) ) ).

tff(fact_70_apfst__convE,axiom,
    ! [C: $tType,A1: $tType,B: $tType,P: product_prod(C,B),F: fun(C,A1),Q: product_prod(A1,B)] :
      ( ( Q = product_apfst(C,A1,B,F,P) )
     => ~ ! [X1: C,Y: B] :
            ( ( P = aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X1),Y) )
           => ( Q != aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),aa(C,A1,F,X1)),Y) ) ) ) ).

tff(fact_71_scomp__apply,axiom,
    ! [A1: $tType,C: $tType,D: $tType,B: $tType,X: B,G: fun(C,fun(D,A1)),F: fun(B,product_prod(C,D))] : ( aa(B,A1,product_scomp(B,C,D,A1,F,G),X) = aa(product_prod(C,D),A1,aa(fun(C,fun(D,A1)),fun(product_prod(C,D),A1),product_prod_case(C,D,A1),G),aa(B,product_prod(C,D),F,X)) ) ).

tff(fact_72_scomp__def,axiom,
    ! [B: $tType,C: $tType,D: $tType,A1: $tType,G: fun(C,fun(D,B)),F: fun(A1,product_prod(C,D)),X2: A1] : ( aa(A1,B,product_scomp(A1,C,D,B,F,G),X2) = aa(product_prod(C,D),B,aa(fun(C,fun(D,B)),fun(product_prod(C,D),B),product_prod_case(C,D,B),G),aa(A1,product_prod(C,D),F,X2)) ) ).

tff(fact_73_Pair__scomp,axiom,
    ! [A1: $tType,B: $tType,C: $tType,F: fun(C,fun(A1,B)),X: C] : ( product_scomp(A1,C,A1,B,aa(C,fun(A1,product_prod(C,A1)),product_Pair(C,A1),X),F) = aa(C,fun(A1,B),F,X) ) ).

tff(fact_74_scomp__Pair,axiom,
    ! [C: $tType,B: $tType,A1: $tType,X: fun(A1,product_prod(B,C))] : ( product_scomp(A1,B,C,product_prod(B,C),X,product_Pair(B,C)) = X ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A1: $tType,G: fun(A1,B),F: fun(A1,B)] :
      ( ! [X1: A1] : ( aa(A1,B,F,X1) = aa(A1,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A1: $tType,A: fun(A1,bool),X: A1] :
      ( member(A1,X,A)
    <=> pp(aa(A1,bool,A,X)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),b),a),lab) ).

%------------------------------------------------------------------------------
