%------------------------------------------------------------------------------
% File     : SCT239_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 253
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_253 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v7.5.0, 0.33 v7.4.0, 0.75 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  141 (  41 unt;  36 typ;   0 def)
%            Number of atoms       :  210 ( 154 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  140 (  35   ~;   3   |;  22   &)
%                                         (  32 <=>;  48  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   46 (  27   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   1 prp; 0-3 aty)
%            Number of functors    :   24 (  24 usr;   3 con; 0-5 aty)
%            Number of variables   :  358 ( 320   !;   9   ?; 358   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:30
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (30)
tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A1: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A1: $tType] : ( ( A1 * A1 ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Obutlast,type,
    butlast: 
      !>[A1: $tType] : ( list(A1) > list(A1) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A1: $tType] : ( list(A1) > $o ) ).

tff(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A1: $tType] : ( ( fun(A1,bool) * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Ohd,type,
    hd: 
      !>[A1: $tType] : ( list(A1) > A1 ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olast,type,
    last: 
      !>[A1: $tType] : ( list(A1) > A1 ) ).

tff(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B1: $tType,A1: $tType] : ( ( fun(B1,A1) * B1 * list(B1) ) > list(B1) ) ).

tff(sy_c_List_Olinorder__class_Osort__key,type,
    linorder_sort_key: 
      !>[B1: $tType,A1: $tType] : ( ( fun(B1,A1) * list(B1) ) > list(B1) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A1: $tType] : list(A1) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,fun(list(A1),T)) * list(A1) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,fun(list(A1),fun(T,T))) * list(A1) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A1: $tType] : ( ( fun(A1,bool) * list(A1) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,list(B1)) * list(A1) ) > list(B1) ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A1: $tType] : ( list(A1) > $o ) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A1: $tType] : ( list(A1) > list(A1) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A1: $tType] : ( list(A1) > list(A1) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A1: $tType] : ( ( fun(A1,bool) * list(A1) ) > list(A1) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (100)
tff(fact_0_alt3,axiom,
    ? [A3: arrow_411405190le_alt,B4: arrow_411405190le_alt,C: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A3,cons(arrow_411405190le_alt,B4,cons(arrow_411405190le_alt,C,nil(arrow_411405190le_alt))))) ).

tff(fact_1_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_2_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_3_third__alt,axiom,
    ! [B3: arrow_411405190le_alt,A6: arrow_411405190le_alt] :
      ( ( A6 != B3 )
     => ? [C: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A6,cons(arrow_411405190le_alt,B3,cons(arrow_411405190le_alt,C,nil(arrow_411405190le_alt))))) ) ).

tff(fact_4_distinct_Osimps_I1_J,axiom,
    ! [A1: $tType] : distinct(A1,nil(A1)) ).

tff(fact_5_distinct__singleton,axiom,
    ! [A1: $tType,X: A1] : distinct(A1,cons(A1,X,nil(A1))) ).

tff(fact_6_list_Oinject,axiom,
    ! [A1: $tType,List3: list(A1),A5: A1,List: list(A1),A2: A1] :
      ( ( cons(A1,A2,List) = cons(A1,A5,List3) )
    <=> ( ( A2 = A5 )
        & ( List = List3 ) ) ) ).

tff(fact_7_distinct__length__2__or__more,axiom,
    ! [A1: $tType,Xs1: list(A1),B2: A1,A2: A1] :
      ( distinct(A1,cons(A1,A2,cons(A1,B2,Xs1)))
    <=> ( ( A2 != B2 )
        & distinct(A1,cons(A1,A2,Xs1))
        & distinct(A1,cons(A1,B2,Xs1)) ) ) ).

tff(fact_8_list_Osimps_I2_J,axiom,
    ! [A1: $tType,List2: list(A1),A4: A1] : ( nil(A1) != cons(A1,A4,List2) ) ).

tff(fact_9_list_Osimps_I3_J,axiom,
    ! [A1: $tType,List2: list(A1),A4: A1] : ( cons(A1,A4,List2) != nil(A1) ) ).

tff(fact_10_neq__Nil__conv,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( Xs1 != nil(A1) )
    <=> ? [Y3: A1,Ys4: list(A1)] : ( Xs1 = cons(A1,Y3,Ys4) ) ) ).

tff(fact_11_list_Oexhaust,axiom,
    ! [A1: $tType,Y2: list(A1)] :
      ( ( Y2 != nil(A1) )
     => ~ ! [A3: A1,List1: list(A1)] : ( Y2 != cons(A1,A3,List1) ) ) ).

tff(fact_12_not__Cons__self,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] : ( Xs != cons(A1,X,Xs) ) ).

tff(fact_13_not__Cons__self2,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1] : ( cons(A1,X,Xs) != Xs ) ).

tff(fact_14_insert__Nil,axiom,
    ! [A1: $tType,X: A1] : ( insert(A1,X,nil(A1)) = cons(A1,X,nil(A1)) ) ).

tff(fact_15_splice_Osimps_I2_J,axiom,
    ! [A1: $tType,Va: list(A1),V: A1] : ( splice(A1,cons(A1,V,Va),nil(A1)) = cons(A1,V,Va) ) ).

tff(fact_16_list_Osimps_I4_J,axiom,
    ! [B1: $tType,A1: $tType,F2: fun(B1,fun(list(B1),A1)),F1: A1] : ( list_case(A1,B1,F1,F2,nil(B1)) = F1 ) ).

tff(fact_17_list_Osimps_I5_J,axiom,
    ! [A1: $tType,B1: $tType,List: list(B1),A2: B1,F2: fun(B1,fun(list(B1),A1)),F1: A1] : ( list_case(A1,B1,F1,F2,cons(B1,A2,List)) = aa(list(B1),A1,aa(B1,fun(list(B1),A1),F2,A2),List) ) ).

tff(fact_18_list__ex1__simps_I1_J,axiom,
    ! [A1: $tType,P: fun(A1,bool)] : ~ list_ex1(A1,P,nil(A1)) ).

tff(fact_19_splice_Osimps_I3_J,axiom,
    ! [A1: $tType,Ys1: list(A1),Y2: A1,Xs: list(A1),X: A1] : ( splice(A1,cons(A1,X,Xs),cons(A1,Y2,Ys1)) = cons(A1,X,cons(A1,Y2,splice(A1,Xs,Ys1))) ) ).

tff(fact_20_list__nonempty__induct,axiom,
    ! [A1: $tType,P: fun(list(A1),bool),Xs1: list(A1)] :
      ( ( Xs1 != nil(A1) )
     => ( ! [X2: A1] : pp(aa(list(A1),bool,P,cons(A1,X2,nil(A1))))
       => ( ! [X2: A1,Xs2: list(A1)] :
              ( ( Xs2 != nil(A1) )
             => ( pp(aa(list(A1),bool,P,Xs2))
               => pp(aa(list(A1),bool,P,cons(A1,X2,Xs2))) ) )
         => pp(aa(list(A1),bool,P,Xs1)) ) ) ) ).

tff(fact_21_list_Orecs_I1_J,axiom,
    ! [B1: $tType,A1: $tType,F2: fun(B1,fun(list(B1),fun(A1,A1))),F1: A1] : ( list_rec(A1,B1,F1,F2,nil(B1)) = F1 ) ).

tff(fact_22_list_Orecs_I2_J,axiom,
    ! [A1: $tType,B1: $tType,List: list(B1),A2: B1,F2: fun(B1,fun(list(B1),fun(A1,A1))),F1: A1] : ( list_rec(A1,B1,F1,F2,cons(B1,A2,List)) = aa(A1,A1,aa(list(B1),fun(A1,A1),aa(B1,fun(list(B1),fun(A1,A1)),F2,A2),List),list_rec(A1,B1,F1,F2,List)) ) ).

tff(fact_23_distinct__insert,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] :
      ( distinct(A1,Xs)
     => distinct(A1,insert(A1,X,Xs)) ) ).

tff(fact_24_splice_Osimps_I1_J,axiom,
    ! [A1: $tType,Ys1: list(A1)] : ( splice(A1,nil(A1),Ys1) = Ys1 ) ).

tff(fact_25_splice__Nil2,axiom,
    ! [A1: $tType,Xs: list(A1)] : ( splice(A1,Xs,nil(A1)) = Xs ) ).

tff(fact_26_last_Osimps,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] :
      ( ( ( Xs = nil(A1) )
       => ( last(A1,cons(A1,X,Xs)) = X ) )
      & ( ( Xs != nil(A1) )
       => ( last(A1,cons(A1,X,Xs)) = last(A1,Xs) ) ) ) ).

tff(fact_27_butlast_Osimps_I2_J,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] :
      ( ( ( Xs = nil(A1) )
       => ( butlast(A1,cons(A1,X,Xs)) = nil(A1) ) )
      & ( ( Xs != nil(A1) )
       => ( butlast(A1,cons(A1,X,Xs)) = cons(A1,X,butlast(A1,Xs)) ) ) ) ).

tff(fact_28_insort__key_Osimps_I1_J,axiom,
    ! [B1: $tType,A1: $tType] :
      ( linorder(B1)
     => ! [X1: A1,F: fun(A1,B1)] : ( linorder_insort_key(A1,B1,F,X1,nil(A1)) = cons(A1,X1,nil(A1)) ) ) ).

tff(fact_29_null__rec_I2_J,axiom,
    ! [B1: $tType] : null(B1,nil(B1)) ).

tff(fact_30_List_Onull__def,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( null(A1,Xs1)
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_31_eq__Nil__null,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( Xs1 = nil(A1) )
    <=> null(A1,Xs1) ) ).

tff(fact_32_takeWhile_Osimps_I2_J,axiom,
    ! [A1: $tType,Xs1: list(A1),X1: A1,P: fun(A1,bool)] :
      ( ( pp(aa(A1,bool,P,X1))
       => ( takeWhile(A1,P,cons(A1,X1,Xs1)) = cons(A1,X1,takeWhile(A1,P,Xs1)) ) )
      & ( ~ pp(aa(A1,bool,P,X1))
       => ( takeWhile(A1,P,cons(A1,X1,Xs1)) = nil(A1) ) ) ) ).

tff(fact_33_takeWhile_Osimps_I1_J,axiom,
    ! [A1: $tType,P: fun(A1,bool)] : ( takeWhile(A1,P,nil(A1)) = nil(A1) ) ).

tff(fact_34_butlast_Osimps_I1_J,axiom,
    ! [A1: $tType] : ( butlast(A1,nil(A1)) = nil(A1) ) ).

tff(fact_35_insort__key__left__comm,axiom,
    ! [A1: $tType,B1: $tType] :
      ( linorder(A1)
     => ! [Xs1: list(B1),Y: B1,X1: B1,F: fun(B1,A1)] :
          ( ( aa(B1,A1,F,X1) != aa(B1,A1,F,Y) )
         => ( linorder_insort_key(B1,A1,F,Y,linorder_insort_key(B1,A1,F,X1,Xs1)) = linorder_insort_key(B1,A1,F,X1,linorder_insort_key(B1,A1,F,Y,Xs1)) ) ) ) ).

tff(fact_36_insort__not__Nil,axiom,
    ! [B1: $tType,A1: $tType] :
      ( linorder(B1)
     => ! [Xs1: list(A1),A2: A1,F: fun(A1,B1)] : ( linorder_insort_key(A1,B1,F,A2,Xs1) != nil(A1) ) ) ).

tff(fact_37_distinct__takeWhile,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( distinct(A1,Xs1)
     => distinct(A1,takeWhile(A1,P,Xs1)) ) ).

tff(fact_38_last__ConsL,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] :
      ( ( Xs = nil(A1) )
     => ( last(A1,cons(A1,X,Xs)) = X ) ) ).

tff(fact_39_last__ConsR,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
     => ( last(A1,cons(A1,X,Xs)) = last(A1,Xs) ) ) ).

tff(fact_40_distinct__butlast,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
     => ( distinct(A1,Xs)
       => distinct(A1,butlast(A1,Xs)) ) ) ).

tff(fact_41_null__rec_I1_J,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1] : ~ null(A1,cons(A1,X,Xs)) ).

tff(fact_42_equal__Nil__null,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( equal_equal(list(A1),Xs1,nil(A1))
    <=> null(A1,Xs1) ) ).

tff(fact_43_sort__key__simps_I2_J,axiom,
    ! [B1: $tType,A1: $tType] :
      ( linorder(B1)
     => ! [Xs1: list(A1),X1: A1,F: fun(A1,B1)] : ( linorder_sort_key(A1,B1,F,cons(A1,X1,Xs1)) = linorder_insort_key(A1,B1,F,X1,linorder_sort_key(A1,B1,F,Xs1)) ) ) ).

tff(fact_44_snoc__eq__iff__butlast,axiom,
    ! [A1: $tType,Ys: list(A1),X1: A1,Xs1: list(A1)] :
      ( ( append(A1,Xs1,cons(A1,X1,nil(A1))) = Ys )
    <=> ( ( Ys != nil(A1) )
        & ( butlast(A1,Ys) = Xs1 )
        & ( last(A1,Ys) = X1 ) ) ) ).

tff(fact_45_append__butlast__last__id,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
     => ( append(A1,butlast(A1,Xs),cons(A1,last(A1,Xs),nil(A1))) = Xs ) ) ).

tff(fact_46_last__snoc,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] : ( last(A1,append(A1,Xs,cons(A1,X,nil(A1)))) = X ) ).

tff(fact_47_butlast__snoc,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1)] : ( butlast(A1,append(A1,Xs,cons(A1,X,nil(A1)))) = Xs ) ).

tff(fact_48_append__same__eq,axiom,
    ! [A1: $tType,Zs: list(A1),Xs1: list(A1),Ys: list(A1)] :
      ( ( append(A1,Ys,Xs1) = append(A1,Zs,Xs1) )
    <=> ( Ys = Zs ) ) ).

tff(fact_49_same__append__eq,axiom,
    ! [A1: $tType,Zs: list(A1),Ys: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys) = append(A1,Xs1,Zs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_50_append__assoc,axiom,
    ! [A1: $tType,Zs1: list(A1),Ys1: list(A1),Xs: list(A1)] : ( append(A1,append(A1,Xs,Ys1),Zs1) = append(A1,Xs,append(A1,Ys1,Zs1)) ) ).

tff(fact_51_append__Cons,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs: list(A1),X: A1] : ( append(A1,cons(A1,X,Xs),Ys1) = cons(A1,X,append(A1,Xs,Ys1)) ) ).

tff(fact_52_Nil__is__append__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( nil(A1) = append(A1,Xs1,Ys) )
    <=> ( ( Xs1 = nil(A1) )
        & ( Ys = nil(A1) ) ) ) ).

tff(fact_53_self__append__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( Xs1 = append(A1,Xs1,Ys) )
    <=> ( Ys = nil(A1) ) ) ).

tff(fact_54_self__append__conv2,axiom,
    ! [A1: $tType,Xs1: list(A1),Ys: list(A1)] :
      ( ( Ys = append(A1,Xs1,Ys) )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_55_append__is__Nil__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys) = nil(A1) )
    <=> ( ( Xs1 = nil(A1) )
        & ( Ys = nil(A1) ) ) ) ).

tff(fact_56_append__self__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys) = Xs1 )
    <=> ( Ys = nil(A1) ) ) ).

tff(fact_57_append__self__conv2,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys) = Ys )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_58_sort__key__simps_I1_J,axiom,
    ! [B1: $tType,A1: $tType] :
      ( linorder(B1)
     => ! [F: fun(A1,B1)] : ( linorder_sort_key(A1,B1,F,nil(A1)) = nil(A1) ) ) ).

tff(fact_59_distinct__sort,axiom,
    ! [B1: $tType,A1: $tType] :
      ( linorder(B1)
     => ! [Xs1: list(A1),F: fun(A1,B1)] :
          ( distinct(A1,linorder_sort_key(A1,B1,F,Xs1))
        <=> distinct(A1,Xs1) ) ) ).

tff(fact_60_append1__eq__conv,axiom,
    ! [A1: $tType,Y: A1,Ys: list(A1),X1: A1,Xs1: list(A1)] :
      ( ( append(A1,Xs1,cons(A1,X1,nil(A1))) = append(A1,Ys,cons(A1,Y,nil(A1))) )
    <=> ( ( Xs1 = Ys )
        & ( X1 = Y ) ) ) ).

tff(fact_61_append__eq__appendI,axiom,
    ! [A1: $tType,Us1: list(A1),Ys1: list(A1),Zs1: list(A1),Xs11: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Xs11) = Zs1 )
     => ( ( Ys1 = append(A1,Xs11,Us1) )
       => ( append(A1,Xs,Ys1) = append(A1,Zs1,Us1) ) ) ) ).

tff(fact_62_append__eq__append__conv2,axiom,
    ! [A1: $tType,Ts: list(A1),Zs: list(A1),Ys: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys) = append(A1,Zs,Ts) )
    <=> ? [Us: list(A1)] :
          ( ( ( Xs1 = append(A1,Zs,Us) )
            & ( append(A1,Us,Ys) = Ts ) )
          | ( ( append(A1,Xs1,Us) = Zs )
            & ( Ys = append(A1,Us,Ts) ) ) ) ) ).

tff(fact_63_equal__list__def,axiom,
    ! [A1: $tType,Y: list(A1),X1: list(A1)] :
      ( equal_equal(list(A1),X1,Y)
    <=> ( X1 = Y ) ) ).

tff(fact_64_Cons__eq__appendI,axiom,
    ! [A1: $tType,Zs1: list(A1),Xs: list(A1),Ys1: list(A1),Xs11: list(A1),X: A1] :
      ( ( cons(A1,X,Xs11) = Ys1 )
     => ( ( Xs = append(A1,Xs11,Zs1) )
       => ( cons(A1,X,Xs) = append(A1,Ys1,Zs1) ) ) ) ).

tff(fact_65_append__Nil,axiom,
    ! [A1: $tType,Ys1: list(A1)] : ( append(A1,nil(A1),Ys1) = Ys1 ) ).

tff(fact_66_append__Nil2,axiom,
    ! [A1: $tType,Xs: list(A1)] : ( append(A1,Xs,nil(A1)) = Xs ) ).

tff(fact_67_eq__Nil__appendI,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs: list(A1)] :
      ( ( Xs = Ys1 )
     => ( Xs = append(A1,nil(A1),Ys1) ) ) ).

tff(fact_68_append__eq__Cons__conv,axiom,
    ! [A1: $tType,Xs1: list(A1),X1: A1,Zs: list(A1),Ys: list(A1)] :
      ( ( append(A1,Ys,Zs) = cons(A1,X1,Xs1) )
    <=> ( ( ( Ys = nil(A1) )
          & ( Zs = cons(A1,X1,Xs1) ) )
        | ? [Ys3: list(A1)] :
            ( ( Ys = cons(A1,X1,Ys3) )
            & ( append(A1,Ys3,Zs) = Xs1 ) ) ) ) ).

tff(fact_69_Cons__eq__append__conv,axiom,
    ! [A1: $tType,Zs: list(A1),Ys: list(A1),Xs1: list(A1),X1: A1] :
      ( ( cons(A1,X1,Xs1) = append(A1,Ys,Zs) )
    <=> ( ( ( Ys = nil(A1) )
          & ( cons(A1,X1,Xs1) = Zs ) )
        | ? [Ys3: list(A1)] :
            ( ( cons(A1,X1,Ys3) = Ys )
            & ( Xs1 = append(A1,Ys3,Zs) ) ) ) ) ).

tff(fact_70_takeWhile__tail,axiom,
    ! [A1: $tType,L: list(A1),Xs1: list(A1),X1: A1,P: fun(A1,bool)] :
      ( ~ pp(aa(A1,bool,P,X1))
     => ( takeWhile(A1,P,append(A1,Xs1,cons(A1,X1,L))) = takeWhile(A1,P,Xs1) ) ) ).

tff(fact_71_butlast__append,axiom,
    ! [A1: $tType,Xs: list(A1),Ys1: list(A1)] :
      ( ( ( Ys1 = nil(A1) )
       => ( butlast(A1,append(A1,Xs,Ys1)) = butlast(A1,Xs) ) )
      & ( ( Ys1 != nil(A1) )
       => ( butlast(A1,append(A1,Xs,Ys1)) = append(A1,Xs,butlast(A1,Ys1)) ) ) ) ).

tff(fact_72_last__append,axiom,
    ! [A1: $tType,Xs: list(A1),Ys1: list(A1)] :
      ( ( ( Ys1 = nil(A1) )
       => ( last(A1,append(A1,Xs,Ys1)) = last(A1,Xs) ) )
      & ( ( Ys1 != nil(A1) )
       => ( last(A1,append(A1,Xs,Ys1)) = last(A1,Ys1) ) ) ) ).

tff(fact_73_last__appendR,axiom,
    ! [A1: $tType,Xs: list(A1),Ys1: list(A1)] :
      ( ( Ys1 != nil(A1) )
     => ( last(A1,append(A1,Xs,Ys1)) = last(A1,Ys1) ) ) ).

tff(fact_74_last__appendL,axiom,
    ! [A1: $tType,Xs: list(A1),Ys1: list(A1)] :
      ( ( Ys1 = nil(A1) )
     => ( last(A1,append(A1,Xs,Ys1)) = last(A1,Xs) ) ) ).

tff(fact_75_rev__induct,axiom,
    ! [A1: $tType,Xs1: list(A1),P: fun(list(A1),bool)] :
      ( pp(aa(list(A1),bool,P,nil(A1)))
     => ( ! [X2: A1,Xs2: list(A1)] :
            ( pp(aa(list(A1),bool,P,Xs2))
           => pp(aa(list(A1),bool,P,append(A1,Xs2,cons(A1,X2,nil(A1))))) )
       => pp(aa(list(A1),bool,P,Xs1)) ) ) ).

tff(fact_76_rev__cases,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
     => ~ ! [Ys2: list(A1),Y1: A1] : ( Xs != append(A1,Ys2,cons(A1,Y1,nil(A1))) ) ) ).

tff(fact_77_rotate__simps,axiom,
    ! [A1: $tType,B1: $tType,Xs: list(B1),X: B1] :
      ( ( rotate1(A1,nil(A1)) = nil(A1) )
      & ( rotate1(B1,cons(B1,X,Xs)) = append(B1,Xs,cons(B1,X,nil(B1))) ) ) ).

tff(fact_78_maps__simps_I1_J,axiom,
    ! [A1: $tType,B1: $tType,Xs1: list(B1),X1: B1,F: fun(B1,list(A1))] : ( maps(B1,A1,F,cons(B1,X1,Xs1)) = append(A1,aa(B1,list(A1),F,X1),maps(B1,A1,F,Xs1)) ) ).

tff(fact_79_rotate1__is__Nil__conv,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( rotate1(A1,Xs1) = nil(A1) )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_80_distinct1__rotate,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( distinct(A1,rotate1(A1,Xs1))
    <=> distinct(A1,Xs1) ) ).

tff(fact_81_maps__simps_I2_J,axiom,
    ! [B1: $tType,A1: $tType,F: fun(B1,list(A1))] : ( maps(B1,A1,F,nil(B1)) = nil(A1) ) ).

tff(fact_82_dropWhile__eq__Cons__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Y: A1,Xs1: list(A1),P: fun(A1,bool)] :
      ( ( dropWhile(A1,P,Xs1) = cons(A1,Y,Ys) )
    <=> ( ( Xs1 = append(A1,takeWhile(A1,P,Xs1),cons(A1,Y,Ys)) )
        & ~ pp(aa(A1,bool,P,Y)) ) ) ).

tff(fact_83_rev__eq__Cons__iff,axiom,
    ! [A1: $tType,Ys: list(A1),Y: A1,Xs1: list(A1)] :
      ( ( rev(A1,Xs1) = cons(A1,Y,Ys) )
    <=> ( Xs1 = append(A1,rev(A1,Ys),cons(A1,Y,nil(A1))) ) ) ).

tff(fact_84_rev__is__rev__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( rev(A1,Xs1) = rev(A1,Ys) )
    <=> ( Xs1 = Ys ) ) ).

tff(fact_85_rev__is__Nil__conv,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( rev(A1,Xs1) = nil(A1) )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_86_Nil__is__rev__conv,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( nil(A1) = rev(A1,Xs1) )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_87_rev_Osimps_I1_J,axiom,
    ! [A1: $tType] : ( rev(A1,nil(A1)) = nil(A1) ) ).

tff(fact_88_rev__append,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs: list(A1)] : ( rev(A1,append(A1,Xs,Ys1)) = append(A1,rev(A1,Ys1),rev(A1,Xs)) ) ).

tff(fact_89_distinct__rev,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( distinct(A1,rev(A1,Xs1))
    <=> distinct(A1,Xs1) ) ).

tff(fact_90_dropWhile_Osimps_I2_J,axiom,
    ! [A1: $tType,Xs1: list(A1),X1: A1,P: fun(A1,bool)] :
      ( ( pp(aa(A1,bool,P,X1))
       => ( dropWhile(A1,P,cons(A1,X1,Xs1)) = dropWhile(A1,P,Xs1) ) )
      & ( ~ pp(aa(A1,bool,P,X1))
       => ( dropWhile(A1,P,cons(A1,X1,Xs1)) = cons(A1,X1,Xs1) ) ) ) ).

tff(fact_91_dropWhile_Osimps_I1_J,axiom,
    ! [A1: $tType,P: fun(A1,bool)] : ( dropWhile(A1,P,nil(A1)) = nil(A1) ) ).

tff(fact_92_rev__singleton__conv,axiom,
    ! [A1: $tType,X1: A1,Xs1: list(A1)] :
      ( ( rev(A1,Xs1) = cons(A1,X1,nil(A1)) )
    <=> ( Xs1 = cons(A1,X1,nil(A1)) ) ) ).

tff(fact_93_singleton__rev__conv,axiom,
    ! [A1: $tType,Xs1: list(A1),X1: A1] :
      ( ( cons(A1,X1,nil(A1)) = rev(A1,Xs1) )
    <=> ( Xs1 = cons(A1,X1,nil(A1)) ) ) ).

tff(fact_94_rev_Osimps_I2_J,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1] : ( rev(A1,cons(A1,X,Xs)) = append(A1,rev(A1,Xs),cons(A1,X,nil(A1))) ) ).

tff(fact_95_distinct__dropWhile,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( distinct(A1,Xs1)
     => distinct(A1,dropWhile(A1,P,Xs1)) ) ).

tff(fact_96_rev__swap,axiom,
    ! [A1: $tType,Ys: list(A1),Xs1: list(A1)] :
      ( ( rev(A1,Xs1) = Ys )
    <=> ( Xs1 = rev(A1,Ys) ) ) ).

tff(fact_97_rev__rev__ident,axiom,
    ! [A1: $tType,Xs: list(A1)] : ( rev(A1,rev(A1,Xs)) = Xs ) ).

tff(fact_98_takeWhile__dropWhile__id,axiom,
    ! [A1: $tType,Xs1: list(A1),P: fun(A1,bool)] : ( append(A1,takeWhile(A1,P,Xs1),dropWhile(A1,P,Xs1)) = Xs1 ) ).

tff(fact_99_last__rev,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
     => ( last(A1,rev(A1,Xs)) = hd(A1,Xs) ) ) ).

%----Arities (1)
tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [A: arrow_411405190le_alt,B: arrow_411405190le_alt] :
      ( ( A != B )
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
