%------------------------------------------------------------------------------
% File     : SCT238_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 252
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_252 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  157 (  28 unt;  32 typ;   0 def)
%            Number of atoms       :  317 (  88 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  202 (  10   ~;   2   |;   8   &)
%                                         (  23 <=>; 159  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   29 (  17   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   1 prp; 0-4 aty)
%            Number of functors    :   16 (  16 usr;   2 con; 0-5 aty)
%            Number of variables   :  444 ( 412   !;   5   ?; 444   :)
%                                         (  27  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:28
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

tff(ty_tc_sum,type,
    sum_sum: ( $tType * $tType ) > $tType ).

%----Explicit typings (25)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Finite__Set_Ocard,type,
    finite_card: 
      !>[A: $tType] : ( fun(A,bool) > nat ) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > $o ) ).

tff(sy_c_Fun_Oswap,type,
    swap: 
      !>[A: $tType,B: $tType] : ( ( A * A * fun(A,B) ) > fun(A,B) ) ).

tff(sy_c_Fun_Othe__inv__into,type,
    the_inv_into: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,B) ) > fun(B,A) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (99)
tff(fact_0_card__image,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( finite_card(B,image(A,B,F,A1)) = finite_card(A,A1) ) ) ).

tff(fact_1_range__ex1__eq,axiom,
    ! [B: $tType,A: $tType,B3: B,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( member(B,B3,image(A,B,F,top_top(fun(A,bool))))
      <=> ? [X2: A] :
            ( ( B3 = aa(A,B,F,X2) )
            & ! [Y3: A] :
                ( ( B3 = aa(A,B,F,Y3) )
               => ( Y3 = X2 ) ) ) ) ) ).

tff(fact_2_inj__image__mem__iff,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),A3: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( member(B,aa(A,B,F,A3),image(A,B,F,A1))
      <=> member(A,A3,A1) ) ) ).

tff(fact_3_inj__image__eq__iff,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,bool),A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( image(A,B,F,A1) = image(A,B,F,B2) )
      <=> ( A1 = B2 ) ) ) ).

tff(fact_4_image__eqI,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),X1: B,F: fun(B,A),B3: A] :
      ( ( B3 = aa(B,A,F,X1) )
     => ( member(B,X1,A1)
       => member(A,B3,image(B,A,F,A1)) ) ) ).

tff(fact_5_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_6_UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_7_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_8_inj__eq,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
      <=> ( X1 = Y1 ) ) ) ).

tff(fact_9_injD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
       => ( X1 = Y1 ) ) ) ).

tff(fact_10_rangeI,axiom,
    ! [A: $tType,B: $tType,X1: B,F: fun(B,A)] : member(A,aa(B,A,F,X1),image(B,A,F,top_top(fun(B,bool)))) ).

tff(fact_11_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_12_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_13_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: B,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
     => ( ( B3 = aa(A,B,F,X1) )
       => member(B,B3,image(A,B,F,A1)) ) ) ).

tff(fact_14_imageI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
     => member(B,aa(A,B,F,X1),image(A,B,F,A1)) ) ).

tff(fact_15_image__iff,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A),Z1: A] :
      ( member(A,Z1,image(B,A,F,A1))
    <=> ? [X2: B] :
          ( member(B,X2,A1)
          & ( Z1 = aa(B,A,F,X2) ) ) ) ).

tff(fact_16_inj__onD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
       => ( member(A,X1,A1)
         => ( member(A,Y1,A1)
           => ( X1 = Y1 ) ) ) ) ) ).

tff(fact_17_inj__on__iff,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(A,X1,A1)
       => ( member(A,Y1,A1)
         => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
          <=> ( X1 = Y1 ) ) ) ) ) ).

tff(fact_18_inj__on__contraD,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( ( X1 != Y1 )
       => ( member(A,X1,A1)
         => ( member(A,Y1,A1)
           => ( aa(A,B,F,X1) != aa(A,B,F,Y1) ) ) ) ) ) ).

tff(fact_19_inj__on__def,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
    <=> ! [X2: A] :
          ( member(A,X2,A1)
         => ! [Xa1: A] :
              ( member(A,Xa1,A1)
             => ( ( aa(A,B,F,X2) = aa(A,B,F,Xa1) )
               => ( X2 = Xa1 ) ) ) ) ) ).

tff(fact_20_range__eqI,axiom,
    ! [A: $tType,B: $tType,X1: B,F: fun(B,A),B3: A] :
      ( ( B3 = aa(B,A,F,X1) )
     => member(A,B3,image(B,A,F,top_top(fun(B,bool)))) ) ).

tff(fact_21_inj__on__image__iff,axiom,
    ! [B: $tType,A: $tType,F: fun(A,A),G: fun(A,B),A1: fun(A,bool)] :
      ( ! [X3: A] :
          ( member(A,X3,A1)
         => ! [Xa: A] :
              ( member(A,Xa,A1)
             => ( ( aa(A,B,G,aa(A,A,F,X3)) = aa(A,B,G,aa(A,A,F,Xa)) )
              <=> ( aa(A,B,G,X3) = aa(A,B,G,Xa) ) ) ) )
     => ( inj_on(A,A,F,A1)
       => ( inj_on(A,B,G,image(A,A,F,A1))
        <=> inj_on(A,B,G,A1) ) ) ) ).

tff(fact_22_injI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B)] :
      ( ! [X3: A,Y2: A] :
          ( ( aa(A,B,F,X3) = aa(A,B,F,Y2) )
         => ( X3 = Y2 ) )
     => inj_on(A,B,F,top_top(fun(A,bool))) ) ).

tff(fact_23_surjE,axiom,
    ! [A: $tType,B: $tType,Y1: A,F: fun(B,A)] :
      ( ( image(B,A,F,top_top(fun(B,bool))) = top_top(fun(A,bool)) )
     => ~ ! [X3: B] : ( Y1 != aa(B,A,F,X3) ) ) ).

tff(fact_24_surjD,axiom,
    ! [A: $tType,B: $tType,Y1: A,F: fun(B,A)] :
      ( ( image(B,A,F,top_top(fun(B,bool))) = top_top(fun(A,bool)) )
     => ? [X3: B] : ( Y1 = aa(B,A,F,X3) ) ) ).

tff(fact_25_surjI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),G: fun(B,A)] :
      ( ! [X3: A] : ( aa(B,A,G,aa(A,B,F,X3)) = X3 )
     => ( image(B,A,G,top_top(fun(B,bool))) = top_top(fun(A,bool)) ) ) ).

tff(fact_26_surj__def,axiom,
    ! [A: $tType,B: $tType,F: fun(B,A)] :
      ( ( image(B,A,F,top_top(fun(B,bool))) = top_top(fun(A,bool)) )
    <=> ! [Y3: A] :
        ? [X2: B] : ( Y3 = aa(B,A,F,X2) ) ) ).

tff(fact_27_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X1: B] : ( aa(B,A,top_top(fun(B,A)),X1) = top_top(A) ) ) ).

tff(fact_28_inj__on__inverseI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),G: fun(B,A),A1: fun(A,bool)] :
      ( ! [X3: A] :
          ( member(A,X3,A1)
         => ( aa(B,A,G,aa(A,B,F,X3)) = X3 ) )
     => inj_on(A,B,F,A1) ) ).

tff(fact_29_inj__on__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [A4: A] :
          ( member(A,A4,A1)
         => ( aa(A,B,F,A4) = aa(A,B,G,A4) ) )
     => ( inj_on(A,B,F,A1)
      <=> inj_on(A,B,G,A1) ) ) ).

tff(fact_30_inj__onI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X3: A,Y2: A] :
          ( member(A,X3,A1)
         => ( member(A,Y2,A1)
           => ( ( aa(A,B,F,X3) = aa(A,B,F,Y2) )
             => ( X3 = Y2 ) ) ) )
     => inj_on(A,B,F,A1) ) ).

tff(fact_31_image__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),N: fun(A,bool),M: fun(A,bool)] :
      ( ( M = N )
     => ( ! [X3: A] :
            ( member(A,X3,N)
           => ( aa(A,B,F,X3) = aa(A,B,G,X3) ) )
       => ( image(A,B,F,M) = image(A,B,G,N) ) ) ) ).

tff(fact_32_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X3: A] : member(A,X3,top_top(fun(A,bool))) ).

tff(fact_33_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X3: A] : member(A,X3,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_34_surj__swap__iff,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A),B3: B,A3: B] :
      ( ( image(B,A,swap(B,A,A3,B3,F),top_top(fun(B,bool))) = top_top(fun(A,bool)) )
    <=> ( image(B,A,F,top_top(fun(B,bool))) = top_top(fun(A,bool)) ) ) ).

tff(fact_35_inj__on__the__inv__into,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => inj_on(B,A,the_inv_into(A,B,A1,F),image(A,B,F,A1)) ) ).

tff(fact_36_swap__triple,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: A,C2: A,A3: A] :
      ( ( A3 != C2 )
     => ( ( B3 != C2 )
       => ( swap(A,B,A3,B3,swap(A,B,B3,C2,swap(A,B,A3,B3,F))) = swap(A,B,A3,C2,F) ) ) ) ).

tff(fact_37_swap__nilpotent,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: A,A3: A] : ( swap(A,B,A3,B3,swap(A,B,A3,B3,F)) = F ) ).

tff(fact_38_swap__commute,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: A,A3: A] : ( swap(A,B,A3,B3,F) = swap(A,B,B3,A3,F) ) ).

tff(fact_39_swap__self,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A3: A] : ( swap(A,B,A3,A3,F) = F ) ).

tff(fact_40_swap__image__eq,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: A,A1: fun(A,bool),A3: A] :
      ( member(A,A3,A1)
     => ( member(A,B3,A1)
       => ( image(A,B,swap(A,B,A3,B3,F),A1) = image(A,B,F,A1) ) ) ) ).

tff(fact_41_inj__on__imp__inj__on__swap,axiom,
    ! [B: $tType,A: $tType,B3: A,A3: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(A,A3,A1)
       => ( member(A,B3,A1)
         => inj_on(A,B,swap(A,B,A3,B3,F),A1) ) ) ) ).

tff(fact_42_inj__on__swap__iff,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: A,A1: fun(A,bool),A3: A] :
      ( member(A,A3,A1)
     => ( member(A,B3,A1)
       => ( inj_on(A,B,swap(A,B,A3,B3,F),A1)
        <=> inj_on(A,B,F,A1) ) ) ) ).

tff(fact_43_the__inv__into__f__eq,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( ( aa(A,B,F,X1) = Y1 )
       => ( member(A,X1,A1)
         => ( aa(B,A,the_inv_into(A,B,A1,F),Y1) = X1 ) ) ) ) ).

tff(fact_44_the__inv__into__f__f,axiom,
    ! [B: $tType,A: $tType,X1: A,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(A,X1,A1)
       => ( aa(B,A,the_inv_into(A,B,A1,F),aa(A,B,F,X1)) = X1 ) ) ) ).

tff(fact_45_surj__imp__surj__swap,axiom,
    ! [B: $tType,A: $tType,B3: B,A3: B,F: fun(B,A)] :
      ( ( image(B,A,F,top_top(fun(B,bool))) = top_top(fun(A,bool)) )
     => ( image(B,A,swap(B,A,A3,B3,F),top_top(fun(B,bool))) = top_top(fun(A,bool)) ) ) ).

tff(fact_46_the__inv__f__f,axiom,
    ! [B: $tType,A: $tType,X1: A,F: fun(A,B)] :
      ( inj_on(A,B,F,top_top(fun(A,bool)))
     => ( aa(B,A,the_inv_into(A,B,top_top(fun(A,bool)),F),aa(A,B,F,X1)) = X1 ) ) ).

tff(fact_47_f__the__inv__into__f,axiom,
    ! [A: $tType,B: $tType,Y1: B,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(B,Y1,image(A,B,F,A1))
       => ( aa(A,B,F,aa(B,A,the_inv_into(A,B,A1,F),Y1)) = Y1 ) ) ) ).

tff(fact_48_the__inv__into__onto,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( image(B,A,the_inv_into(A,B,A1,F),image(A,B,F,A1)) = A1 ) ) ).

tff(fact_49_the__inv__into__into,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,bool),X1: B,A1: fun(A,bool),F: fun(A,B)] :
      ( inj_on(A,B,F,A1)
     => ( member(B,X1,image(A,B,F,A1))
       => ( ord_less_eq(fun(A,bool),A1,B2)
         => member(A,aa(B,A,the_inv_into(A,B,A1,F),X1),B2) ) ) ) ).

tff(fact_50_eq__card__imp__inj__on,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool)] :
      ( finite_finite1(A,A1)
     => ( ( finite_card(B,image(A,B,F,A1)) = finite_card(A,A1) )
       => inj_on(A,B,F,A1) ) ) ).

tff(fact_51_inj__on__iff__eq__card,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool)] :
      ( finite_finite1(A,A1)
     => ( inj_on(A,B,F,A1)
      <=> ( finite_card(B,image(A,B,F,A1)) = finite_card(A,A1) ) ) ) ).

tff(fact_52_finite__UNIV__surj__inj,axiom,
    ! [A: $tType,F: fun(A,A)] :
      ( finite_finite1(A,top_top(fun(A,bool)))
     => ( ( image(A,A,F,top_top(fun(A,bool))) = top_top(fun(A,bool)) )
       => inj_on(A,A,F,top_top(fun(A,bool))) ) ) ).

tff(fact_53_finite__UNIV__inj__surj,axiom,
    ! [A: $tType,F: fun(A,A)] :
      ( finite_finite1(A,top_top(fun(A,bool)))
     => ( inj_on(A,A,F,top_top(fun(A,bool)))
       => ( image(A,A,F,top_top(fun(A,bool))) = top_top(fun(A,bool)) ) ) ) ).

tff(fact_54_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_55_finite__code,axiom,
    ! [A: $tType] :
      ( finite_finite(A)
     => ! [A1: fun(A,bool)] : finite_finite1(A,A1) ) ).

tff(fact_56_subsetD,axiom,
    ! [A: $tType,C2: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( member(A,C2,A1)
       => member(A,C2,B2) ) ) ).

tff(fact_57_equalityI,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( ord_less_eq(fun(A,bool),B2,A1)
       => ( A1 = B2 ) ) ) ).

tff(fact_58_finite__option__UNIV,axiom,
    ! [A: $tType] :
      ( finite_finite1(option(A),top_top(fun(option(A),bool)))
    <=> finite_finite1(A,top_top(fun(A,bool))) ) ).

tff(fact_59_finite__Plus__UNIV__iff,axiom,
    ! [A: $tType,B: $tType] :
      ( finite_finite1(sum_sum(A,B),top_top(fun(sum_sum(A,B),bool)))
    <=> ( finite_finite1(A,top_top(fun(A,bool)))
        & finite_finite1(B,top_top(fun(B,bool))) ) ) ).

tff(fact_60_finite__imageI,axiom,
    ! [B: $tType,A: $tType,H1: fun(A,B),Fa: fun(A,bool)] :
      ( finite_finite1(A,Fa)
     => finite_finite1(B,image(A,B,H1,Fa)) ) ).

tff(fact_61_endo__inj__surj,axiom,
    ! [A: $tType,F: fun(A,A),A1: fun(A,bool)] :
      ( finite_finite1(A,A1)
     => ( ord_less_eq(fun(A,bool),image(A,A,F,A1),A1)
       => ( inj_on(A,A,F,A1)
         => ( image(A,A,F,A1) = A1 ) ) ) ) ).

tff(fact_62_finite__surj__inj,axiom,
    ! [A: $tType,F: fun(A,A),A1: fun(A,bool)] :
      ( finite_finite1(A,A1)
     => ( ord_less_eq(fun(A,bool),A1,image(A,A,F,A1))
       => inj_on(A,A,F,A1) ) ) ).

tff(fact_63_finite,axiom,
    ! [A: $tType] :
      ( finite_finite(A)
     => ! [A1: fun(A,bool)] : finite_finite1(A,A1) ) ).

tff(fact_64_subset__refl,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,A1) ).

tff(fact_65_set__eq__subset,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
    <=> ( ord_less_eq(fun(A,bool),A1,B2)
        & ord_less_eq(fun(A,bool),B2,A1) ) ) ).

tff(fact_66_rev__finite__subset,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: fun(A,bool)] :
      ( finite_finite1(A,B2)
     => ( ord_less_eq(fun(A,bool),A1,B2)
       => finite_finite1(A,A1) ) ) ).

tff(fact_67_finite__surj,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),B2: fun(B,bool),A1: fun(A,bool)] :
      ( finite_finite1(A,A1)
     => ( ord_less_eq(fun(B,bool),B2,image(A,B,F,A1))
       => finite_finite1(B,B2) ) ) ).

tff(fact_68_rev__predicate1D,axiom,
    ! [A: $tType,Q1: fun(A,bool),X1: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,X1))
     => ( ord_less_eq(fun(A,bool),P1,Q1)
       => pp(aa(A,bool,Q1,X1)) ) ) ).

tff(fact_69_equalityD1,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
     => ord_less_eq(fun(A,bool),A1,B2) ) ).

tff(fact_70_equalityD2,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
     => ord_less_eq(fun(A,bool),B2,A1) ) ).

tff(fact_71_in__mono,axiom,
    ! [A: $tType,X1: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( member(A,X1,A1)
       => member(A,X1,B2) ) ) ).

tff(fact_72_finite__subset,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( finite_finite1(A,B2)
       => finite_finite1(A,A1) ) ) ).

tff(fact_73_predicate1D,axiom,
    ! [A: $tType,X1: A,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),P1,Q1)
     => ( pp(aa(A,bool,P1,X1))
       => pp(aa(A,bool,Q1,X1)) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_set__rev__mp,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
     => ( ord_less_eq(fun(A,bool),A1,B2)
       => member(A,X1,B2) ) ) ).

tff(fact_78_set__mp,axiom,
    ! [A: $tType,X1: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( member(A,X1,A1)
       => member(A,X1,B2) ) ) ).

tff(fact_79_subset__trans,axiom,
    ! [A: $tType,C1: fun(A,bool),B2: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B2)
     => ( ord_less_eq(fun(A,bool),B2,C1)
       => ord_less_eq(fun(A,bool),A1,C1) ) ) ).

tff(fact_80_equalityE,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B2 )
     => ~ ( ord_less_eq(fun(A,bool),A1,B2)
         => ~ ord_less_eq(fun(A,bool),B2,A1) ) ) ).

tff(fact_81_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X2: A] : ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_82_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_83_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
        <=> ( ord_less_eq(A,X1,Y1)
            & ord_less_eq(A,Y1,X1) ) ) ) ).

tff(fact_84_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_85_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_86_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X1: A,Y1: A] :
          ( ord_less_eq(A,Y1,X1)
         => ( ord_less_eq(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_87_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A2: A] :
          ( ( A2 = B1 )
         => ( ord_less_eq(A,B1,C)
           => ord_less_eq(A,A2,C) ) ) ) ).

tff(fact_88_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A2: A] :
          ( ord_less_eq(A,A2,B1)
         => ( ( B1 = C )
           => ord_less_eq(A,A2,C) ) ) ) ).

tff(fact_89_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_90_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_91_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_92_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_93_finite__Prod__UNIV,axiom,
    ! [B: $tType,A: $tType] :
      ( finite_finite1(A,top_top(fun(A,bool)))
     => ( finite_finite1(B,top_top(fun(B,bool)))
       => finite_finite1(product_prod(A,B),top_top(fun(product_prod(A,B),bool))) ) ) ).

tff(fact_94_finite__fun__UNIVD2,axiom,
    ! [A: $tType,B: $tType] :
      ( finite_finite1(fun(A,B),top_top(fun(fun(A,B),bool)))
     => finite_finite1(B,top_top(fun(B,bool))) ) ).

tff(fact_95_top__greatest,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] : ord_less_eq(A,A2,top_top(A)) ) ).

tff(fact_96_top__unique,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A3: A] :
          ( ord_less_eq(A,top_top(A),A3)
        <=> ( A3 = top_top(A) ) ) ) ).

tff(fact_97_top__le,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] :
          ( ord_less_eq(A,top_top(A),A2)
         => ( A2 = top_top(A) ) ) ) ).

tff(fact_98_subset__UNIV,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,top_top(fun(A,bool))) ).

%----Arities (19)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_sum___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(sum_sum(T_1,T_2)) ) ).

tff(arity_Option_Ooption___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType] :
      ( finite_finite(T_1)
     => finite_finite(option(T_1)) ) ).

tff(arity_prod___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(product_prod(T_1,T_2)) ) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [H: fun(arrow_159774573e_indi,nat)] :
      ( inj_on(arrow_159774573e_indi,nat,H,top_top(fun(arrow_159774573e_indi,bool)))
     => ( ( image(arrow_159774573e_indi,nat,H,top_top(fun(arrow_159774573e_indi,bool))) = ord_atLeastLessThan(nat,zero_zero(nat),finite_card(arrow_159774573e_indi,top_top(fun(arrow_159774573e_indi,bool)))) )
       => thesis ) ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
