%------------------------------------------------------------------------------
% File     : SCT224_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 218
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_218 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  156 (  51 unt;  45 typ;   0 def)
%            Number of atoms       :  247 (  88 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  195 (  59   ~;   3   |;  15   &)
%                                         (  34 <=>;  84  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :   15 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   52 (  27   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-6 aty)
%            Number of functors    :   34 (  34 usr;  11 con; 0-6 aty)
%            Number of variables   :  442 ( 394   !;  11   ?; 442   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:24
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (39)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P_H____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P____,type,
    p1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_c____,type,
    c: arrow_411405190le_alt ).

%----Relevant facts (100)
tff(fact_0__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_1__096P_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p1,arrow_610318064e_Prof) ).

tff(fact_2__096ALL_Ai_O_A_Ib_A_060_092_060_094bsub_062below_A_Ibelow_A_Ibelow_A_IP_Ai_J_Ac_Ab_J_Ab_Aa_J_Aa_Ac_092_060_094esub_062_Aa_J_A_061_A_Ia_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ab_J_096,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)),c),b)),b),a)),a),c))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)) ) ).

tff(fact_3_iff,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I3)) ) ).

tff(fact_4__096P_H_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p,arrow_610318064e_Prof) ).

tff(fact_5__096ALL_Ai_O_A_Ia_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ab_J_A_061_A_Ia_A_060_092_060_094bsub_062below_A_IP_Ai_J_Ac_Ab_092_060_094esub_062_Ac_J_096,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)),c),b)) ) ).

tff(fact_6__096ALL_Ai_O_A_Ia_A_060_092_060_094bsub_062below_A_IP_Ai_J_Ac_Ab_092_060_094esub_062_Ac_J_A_061_A_Ib_A_060_092_060_094bsub_062below_A_Ibelow_A_IP_Ai_J_Ac_Ab_J_Ab_Aa_092_060_094esub_062_Ac_J_096,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)),c),b))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)),c),b)),b),a)) ) ).

tff(fact_7__096ALL_Ai_O_A_Ib_A_060_092_060_094bsub_062below_A_Ibelow_A_IP_Ai_J_Ac_Ab_J_Ab_Aa_092_060_094esub_062_Ac_J_A_061_A_Ib_A_060_092_060_094bsub_062below_A_Ibelow_A_Ibelow_A_IP_Ai_J_Ac_Ab_J_Ab_Aa_J_Aa_Ac_092_060_094esub_062_Aa_J_096,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)),c),b)),b),a))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)),c),b)),b),a)),a),c)) ) ).

tff(fact_8_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A6: A,B4: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A6,B4))) ) ).

tff(fact_9_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A4: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A4,B5) )
    <=> ( ( Aa = A4 )
        & ( Ba = B5 ) ) ) ).

tff(fact_10_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y2 != Z )
        & ( ( X2 = Z )
         => ( X2 != Y2 ) )
        & ( ( X2 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ).

tff(fact_11_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_424895264_mktop(L,Z))
    <=> ( ( X2 != Z )
        & ( ( Y2 = Z )
         => ( X2 != Y2 ) )
        & ( ( Y2 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ).

tff(fact_12_ab,axiom,
    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,p1))
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b))) ) ).

tff(fact_13_ac,axiom,
    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b)))
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,c),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b)),b),a))) ) ).

tff(fact_14_bc,axiom,
    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,c),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b)),b),a)))
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b)),b),a)),a),c))) ) ).

tff(fact_15__096_I_Fp_O_Abelow_A_Ibelow_A_IP_Ap_J_Ac_Ab_J_Ab_Aa_J_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b)),b),a),arrow_610318064e_Prof) ).

tff(fact_16__096_I_Fp_O_Abelow_A_Ibelow_A_Ibelow_A_IP_Ap_J_Ac_Ab_J_Ab_Aa_J_Aa_Ac_J_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b)),b),a)),a),c),arrow_610318064e_Prof) ).

tff(fact_17_in__below,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,L),Aa),Ba))
        <=> ( ( X2 != Y2 )
            & ( ( Y2 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Ba),L) )
            & ( ( Y2 != Aa )
             => ( ( ( X2 = Aa )
                 => ( ( Y2 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Y2),L) ) )
                & ( ( X2 != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ) ) ) ) ).

tff(fact_18_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A3: A,B2: B,A5: A] :
      ( ( product_Pair(A,B,A5,B2) = product_Pair(A,B,A3,B6) )
     => ~ ( ( A5 = A3 )
         => ( B2 != B6 ) ) ) ).

tff(fact_19_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_20_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_21__096_I_Fp_O_Abelow_A_IP_Ap_J_Ac_Ab_J_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p1),c),b),arrow_610318064e_Prof) ).

tff(fact_22__C1_C,axiom,
    ! [P_a: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A4 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P_a,arrow_610318064e_Prof)
               => ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P_a,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P_a)) ) ) ) ) ) ) ) ) ).

tff(fact_23__C2_C,axiom,
    ! [P_a: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A4: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A4 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A4 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P_a,arrow_610318064e_Prof)
               => ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P_a,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A4,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P_a)) ) ) ) ) ) ) ) ) ).

tff(fact_24_assms_I1_J,axiom,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(fact_25_const__Lin__Prof,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L),arrow_610318064e_Prof) ) ).

tff(fact_26_mkbot__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_27_mktop__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_28_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),L) ) ) ).

tff(fact_29_notin__Lin__iff,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X2 != Y2 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y2,X2),L) ) ) ) ).

tff(fact_30_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,L),X2),Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_31_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ! [Xa1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa1,arrow_610318064e_Prof)
             => ! [A6: arrow_411405190le_alt,B4: arrow_411405190le_alt] :
                  ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa1,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa1)) ) ) ) ) ) ).

tff(fact_32_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A6: A,B4: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A6,B4))) ) ).

tff(fact_33_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),X) ) ) ).

tff(fact_34_in__above,axiom,
    ! [Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),arrow_1158827142_above(L,Aa,Ba))
        <=> ( ( X2 != Y2 )
            & ( ( X2 = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y2),L) )
            & ( ( X2 != Ba )
             => ( ( ( Y2 = Ba )
                 => ( ( X2 = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Aa),L) ) )
                & ( ( Y2 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X2,Y2),L) ) ) ) ) ) ) ) ).

tff(fact_35_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F1,Aa),Ba) ) ).

tff(fact_36_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_37_dictator__def,axiom,
    ! [I1: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I1)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I1) ) ) ) ).

tff(fact_38_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4,arrow_610318064e_Prof)
         => ! [A6: arrow_411405190le_alt,B4: arrow_411405190le_alt] :
              ( ! [I2: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I2))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4)) ) ) ) ).

tff(fact_39_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X2,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_40_dictatorI,axiom,
    ! [I1: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Fa,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin)))
     => ( ! [X: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
            ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X,arrow_610318064e_Prof)
           => ! [A2: arrow_411405190le_alt,B1: arrow_411405190le_alt] :
                ( ( A2 != B1 )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X,I1))
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X)) ) ) )
       => arrow_987702531ctator(Fa,I1) ) ) ).

tff(fact_41_PiE,axiom,
    ! [B: $tType,A: $tType,X2: A,B3: fun(A,fun(B,bool)),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,B3))
     => ( ~ member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B3,X2))
       => ~ member(A,X2,A1) ) ) ).

tff(fact_42_funcset__id,axiom,
    ! [A: $tType,A1: fun(A,bool)] : member(fun(A,A),combi(A),pi(A,A,A1,combk(fun(A,bool),A,A1))) ).

tff(fact_43_funcset__mem,axiom,
    ! [A: $tType,B: $tType,X2: A,B3: fun(B,bool),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,combk(fun(B,bool),A,B3)))
     => ( member(A,X2,A1)
       => member(B,aa(A,B,F,X2),B3) ) ) ).

tff(fact_44_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool)] :
      ( ! [A2: A,B1: B,C1: C,D1: D,E1: E,F4: F3] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B1,product_Pair(C,product_prod(D,product_prod(E,F3)),C1,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,X2)) ) ).

tff(fact_45_Pi__mem,axiom,
    ! [B: $tType,A: $tType,X2: A,B3: fun(A,fun(B,bool)),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,B3))
     => ( member(A,X2,A1)
       => member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B3,X2)) ) ) ).

tff(fact_46_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F3: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))))] :
      ~ ! [A2: A,B1: B,C1: C,D1: D,E1: E,F4: F3] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B1,product_Pair(C,product_prod(D,product_prod(E,F3)),C1,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4))))) ) ).

tff(fact_47_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B1: B,C1: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_48_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B1: B,C1: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,X2)) ) ).

tff(fact_49_Pi__I,axiom,
    ! [B: $tType,A: $tType,B3: fun(A,fun(B,bool)),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X: A] :
          ( member(A,X,A1)
         => member(B,aa(A,B,F,X),aa(A,fun(B,bool),B3,X)) )
     => member(fun(A,B),F,pi(A,B,A1,B3)) ) ).

tff(fact_50_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A,B1: B,C1: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X2)) ) ).

tff(fact_51_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A,B1: B,C1: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1))) ) ).

tff(fact_52_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B1: B,C1: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B1,C1))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X2)) ) ).

tff(fact_53_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B1: B,C1: C] : ( Y != product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B1,C1)) ) ).

tff(fact_54_funcsetI,axiom,
    ! [A: $tType,B: $tType,B3: fun(B,bool),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X: A] :
          ( member(A,X,A1)
         => member(B,aa(A,B,F,X),B3) )
     => member(fun(A,B),F,pi(A,B,A1,combk(fun(B,bool),A,B3))) ) ).

tff(fact_55_Pi__I_H,axiom,
    ! [B: $tType,A: $tType,B3: fun(A,fun(B,bool)),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X: A] :
          ( member(A,X,A1)
         => member(B,aa(A,B,F,X),aa(A,fun(B,bool),B3,X)) )
     => member(fun(A,B),F,pi(A,B,A1,B3)) ) ).

tff(fact_56_Pi__cong,axiom,
    ! [B: $tType,A: $tType,B3: fun(A,fun(B,bool)),G: fun(A,B),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [W: A] :
          ( member(A,W,A1)
         => ( aa(A,B,F,W) = aa(A,B,G,W) ) )
     => ( member(fun(A,B),F,pi(A,B,A1,B3))
      <=> member(fun(A,B),G,pi(A,B,A1,B3)) ) ) ).

tff(fact_57_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R2: fun(product_prod(A,B),bool)] :
      ( ! [X4: A,Xa1: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X4,Xa1),R2)
        <=> member(product_prod(A,B),product_Pair(A,B,X4,Xa1),S) )
    <=> ( R2 = S ) ) ).

tff(fact_58_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X: A,Y3: B] : ( P1 != product_Pair(A,B,X,Y3) ) ).

tff(fact_59_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A2: A,B1: B] : ( Y != product_Pair(A,B,A2,B1) ) ).

tff(fact_60_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,Ca: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,Ca,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),Ca,Aa),Ba) ) ).

tff(fact_61_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,Ba) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,Ba)) ) ).

tff(fact_62_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X3: fun(product_prod(A,B),C),Xa: A,Xb: B] : ( product_curry(A,B,C,X3,Xa,Xb) = aa(product_prod(A,B),C,X3,product_Pair(A,B,Xa,Xb)) ) ).

tff(fact_63_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_64_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_65_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_66_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y2: B,X2: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,X2,Y2)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,X2)),aa(B,A,F,Y2))) ) ).

tff(fact_67_Prof__def,axiom,
    arrow_610318064e_Prof = pi(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),top_top(fun(arrow_159774573e_indi,bool)),combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),arrow_159774573e_indi,arrow_1985332922le_Lin)) ).

tff(fact_68_dist,axiom,
    distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,a,cons(arrow_411405190le_alt,b,cons(arrow_411405190le_alt,c,nil(arrow_411405190le_alt))))) ).

tff(fact_69_top1I,axiom,
    ! [A: $tType,X2: A] : pp(aa(A,bool,top_top(fun(A,bool)),X2)) ).

tff(fact_70_Pi__UNIV,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool)] : ( pi(A,B,A1,combk(fun(B,bool),A,top_top(fun(B,bool)))) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_71__096_B_Bthesis_O_A_I_B_Bc_O_Adistinct_A_091a_M_Ab_M_Ac_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [C1: arrow_411405190le_alt] : ~ distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,a,cons(arrow_411405190le_alt,b,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ).

tff(fact_72_inv__imagep__def,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R1: fun(B,fun(B,bool)),X3: A,Xa: A] :
      ( inv_imagep(B,A,R1,F,X3,Xa)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(A,B,F,X3)),aa(A,B,F,Xa))) ) ).

tff(fact_73_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_74_third__alt,axiom,
    ! [B2: arrow_411405190le_alt,A5: arrow_411405190le_alt] :
      ( ( A5 != B2 )
     => ? [C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A5,cons(arrow_411405190le_alt,B2,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( member(A,X2,A1)
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( collect(A,Pa) = Pa ) ).

tff(fact_78_distinct__singleton,axiom,
    ! [A: $tType,X1: A] : distinct(A,cons(A,X1,nil(A))) ).

tff(fact_79_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A4: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A4,List3) )
    <=> ( ( Aa = A4 )
        & ( List2 = List3 ) ) ) ).

tff(fact_80_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_81_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_82_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( cons(A,A3,List1) != nil(A) ) ).

tff(fact_83_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( nil(A) != cons(A,A3,List1) ) ).

tff(fact_84_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xs1: list(A),Ba: A,Aa: A] :
      ( distinct(A,cons(A,Aa,cons(A,Ba,Xs1)))
    <=> ( ( Aa != Ba )
        & distinct(A,cons(A,Aa,Xs1))
        & distinct(A,cons(A,Ba,Xs1)) ) ) ).

tff(fact_85_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_86_UNIV__I,axiom,
    ! [A: $tType,X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_87_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_88_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y1: A,Ys1: list(A)] : ( Xs1 = cons(A,Y1,Ys1) ) ) ).

tff(fact_89_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != cons(A,A2,List) ) ) ).

tff(fact_90_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X2: B] : ( aa(B,A,top_top(fun(B,A)),X2) = top_top(A) ) ) ).

tff(fact_91_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_92_distinct__insert,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] :
      ( distinct(A,Xs)
     => distinct(A,insert(A,X1,Xs)) ) ).

tff(fact_93_alt3,axiom,
    ? [A2: arrow_411405190le_alt,B1: arrow_411405190le_alt,C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A2,cons(arrow_411405190le_alt,B1,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ).

tff(fact_94_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_95_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X1: A] : ( splice(A,cons(A,X1,Xs),cons(A,Y,Ys)) = cons(A,X1,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_96_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_97_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_98_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_99_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X: A] : member(A,X,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [I: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I)),c),b)),b),a)),a),c))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I)) ) ).

%------------------------------------------------------------------------------
