%------------------------------------------------------------------------------
% File     : SCT219_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 208
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_208 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  167 (  50 unt;  52 typ;   0 def)
%            Number of atoms       :  274 (  95 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  232 (  73   ~;  16   |;  20   &)
%                                         (  33 <=>;  90  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :   14 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   64 (  34   >;  30   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-5 aty)
%            Number of functors    :   40 (  40 usr;  13 con; 0-6 aty)
%            Number of variables   :  505 ( 447   !;  13   ?; 505   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:36
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)))) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olexord,type,
    lexord: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistrel1,type,
    listrel1: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Opartition,type,
    partition: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > product_prod(list(A),list(A)) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P_H____,type,
    p1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_c____,type,
    c: arrow_411405190le_alt ).

%----Relevant facts (100)
tff(fact_0__096P_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p,arrow_610318064e_Prof) ).

tff(fact_1__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_2_dist,axiom,
    distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,a,cons(arrow_411405190le_alt,b,cons(arrow_411405190le_alt,c,nil(arrow_411405190le_alt))))) ).

tff(fact_3_iff,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I3))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3)) ) ).

tff(fact_4__096ALL_Ai_O_A_Ia_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ab_J_A_061_A_Ia_A_060_092_060_094bsub_062below_A_IP_Ai_J_Ac_Ab_092_060_094esub_062_Ac_J_096,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I3))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I3)),c),b)) ) ).

tff(fact_5_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_6_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_7__096_B_Bthesis_O_A_I_B_Bc_O_Adistinct_A_091a_M_Ab_M_Ac_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [C1: arrow_411405190le_alt] : ~ distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,a,cons(arrow_411405190le_alt,b,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ).

tff(fact_8_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A2: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A2,B3))) ) ).

tff(fact_9_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A5,B5) )
    <=> ( ( Aa = A5 )
        & ( Ba = B5 ) ) ) ).

tff(fact_10__096_I_Fp_O_Abelow_A_Ibelow_A_IP_Ap_J_Ac_Ab_J_Ab_Aa_J_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p),c),b)),b),a),arrow_610318064e_Prof) ).

tff(fact_11__096_I_Fp_O_Abelow_A_Ibelow_A_Ibelow_A_IP_Ap_J_Ac_Ab_J_Ab_Aa_J_Aa_Ac_J_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p),c),b)),b),a)),a),c),arrow_610318064e_Prof) ).

tff(fact_12_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),arrow_276188178_mkbot(L1,Z))
    <=> ( ( Y1 != Z )
        & ( ( X1 = Z )
         => ( X1 != Y1 ) )
        & ( ( X1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ).

tff(fact_13_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),arrow_424895264_mktop(L1,Z))
    <=> ( ( X1 != Z )
        & ( ( Y1 = Z )
         => ( X1 != Y1 ) )
        & ( ( Y1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ).

tff(fact_14_ab,axiom,
    ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,p))
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p),c),b))) ) ).

tff(fact_15__096_I_Fp_O_Abelow_A_IP_Ap_J_Ac_Ab_J_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),combc(arrow_159774573e_indi,arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combb(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_159774573e_indi,arrow_319942042_below,p),c),b),arrow_610318064e_Prof) ).

tff(fact_16_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,L1),Aa),Ba))
        <=> ( ( X1 != Y1 )
            & ( ( Y1 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Ba),L1) )
            & ( ( Y1 != Aa )
             => ( ( ( X1 = Aa )
                 => ( ( Y1 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Y1),L1) ) )
                & ( ( X1 != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_17_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A4: A,B4: B,A6: A] :
      ( ( product_Pair(A,B,A6,B4) = product_Pair(A,B,A4,B6) )
     => ~ ( ( A6 = A4 )
         => ( B4 != B6 ) ) ) ).

tff(fact_18_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,R2: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R2,X1,Y1)
    <=> member(product_prod(A,B),product_Pair(A,B,X1,Y1),R2) ) ).

tff(fact_19__096P_H_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p1,arrow_610318064e_Prof) ).

tff(fact_20__C1_C,axiom,
    ! [P_a: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A5: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A5 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A5 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P_a,arrow_610318064e_Prof)
               => ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P_a,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P_a)) ) ) ) ) ) ) ) ) ).

tff(fact_21__C2_C,axiom,
    ! [P_a: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A5: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A5 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A5 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P_a,arrow_610318064e_Prof)
               => ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P_a,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A5,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P_a)) ) ) ) ) ) ) ) ) ).

tff(fact_22_assms_I1_J,axiom,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(fact_23_const__Lin__Prof,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L1),arrow_610318064e_Prof) ) ).

tff(fact_24_mkbot__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L1,X1),arrow_1985332922le_Lin) ) ).

tff(fact_25_mktop__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L1,X1),arrow_1985332922le_Lin) ) ).

tff(fact_26_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),L1)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa),L1) ) ) ).

tff(fact_27_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( ( X1 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y1,X1),L1) ) ) ) ).

tff(fact_28_below__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,L1),X1),Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_29_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_30_third__alt,axiom,
    ! [B4: arrow_411405190le_alt,A6: arrow_411405190le_alt] :
      ( ( A6 != B4 )
     => ? [C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A6,cons(arrow_411405190le_alt,B4,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ) ).

tff(fact_31_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [Xa1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa1,arrow_610318064e_Prof)
             => ! [A2: arrow_411405190le_alt,B3: arrow_411405190le_alt] :
                  ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa1,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa1)) ) ) ) ) ) ).

tff(fact_32_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [A2: arrow_411405190le_alt,B3: arrow_411405190le_alt] :
              ( ! [I2: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B3),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I2))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B3),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3)) ) ) ) ).

tff(fact_33_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A2: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A2,B3))) ) ).

tff(fact_34_distinct__singleton,axiom,
    ! [A: $tType,X: A] : distinct(A,cons(A,X,nil(A))) ).

tff(fact_35_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X2: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),X2) ) ) ).

tff(fact_36_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A5,List3) )
    <=> ( ( Aa = A5 )
        & ( List = List3 ) ) ) ).

tff(fact_37_not__Cons__self2,axiom,
    ! [A: $tType,Xs2: list(A),X: A] : ( cons(A,X,Xs2) != Xs2 ) ).

tff(fact_38_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs2: list(A)] : ( Xs2 != cons(A,X,Xs2) ) ).

tff(fact_39_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( cons(A,A4,List2) != nil(A) ) ).

tff(fact_40_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( nil(A) != cons(A,A4,List2) ) ).

tff(fact_41_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xs: list(A),Ba: A,Aa: A] :
      ( distinct(A,cons(A,Aa,cons(A,Ba,Xs)))
    <=> ( ( Aa != Ba )
        & distinct(A,cons(A,Aa,Xs))
        & distinct(A,cons(A,Ba,Xs)) ) ) ).

tff(fact_42_dictatorI,axiom,
    ! [I1: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Fa,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin)))
     => ( ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
            ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X2,arrow_610318064e_Prof)
           => ! [A1: arrow_411405190le_alt,B1: arrow_411405190le_alt] :
                ( ( A1 != B1 )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,I1))
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A1,B1),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2)) ) ) )
       => arrow_987702531ctator(Fa,I1) ) ) ).

tff(fact_43_PiE,axiom,
    ! [B: $tType,A: $tType,X1: A,B2: fun(A,fun(B,bool)),A3: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A3,B2))
     => ( ~ member(B,aa(A,B,F,X1),aa(A,fun(B,bool),B2,X1))
       => ~ member(A,X1,A3) ) ) ).

tff(fact_44_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A1: A,List1: list(A)] : ( Y != cons(A,A1,List1) ) ) ).

tff(fact_45_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y3: A,Ys2: list(A)] : ( Xs = cons(A,Y3,Ys2) ) ) ).

tff(fact_46_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),arrow_1158827142_above(L1,Aa,Ba))
        <=> ( ( X1 != Y1 )
            & ( ( X1 = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y1),L1) )
            & ( ( X1 != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X1 = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Aa),L1) ) )
                & ( ( Y1 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X1,Y1),L1) ) ) ) ) ) ) ) ).

tff(fact_47_Pi__mem,axiom,
    ! [B: $tType,A: $tType,X1: A,B2: fun(A,fun(B,bool)),A3: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A3,B2))
     => ( member(A,X1,A3)
       => member(B,aa(A,B,F,X1),aa(A,fun(B,bool),B2,X1)) ) ) ).

tff(fact_48_above__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L1,X1,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_49_funcset__mem,axiom,
    ! [A: $tType,B: $tType,X1: A,B2: fun(B,bool),A3: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A3,combk(fun(B,bool),A,B2)))
     => ( member(A,X1,A3)
       => member(B,aa(A,B,F,X1),B2) ) ) ).

tff(fact_50_funcset__id,axiom,
    ! [A: $tType,A3: fun(A,bool)] : member(fun(A,A),combi(A),pi(A,A,A3,combk(fun(A,bool),A,A3))) ).

tff(fact_51_dictator__def,axiom,
    ! [I1: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I1)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1) ) ) ) ).

tff(fact_52_Pi__I,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool)),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [X2: A] :
          ( member(A,X2,A3)
         => member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B2,X2)) )
     => member(fun(A,B),F,pi(A,B,A3,B2)) ) ).

tff(fact_53_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F1,Aa),Ba) ) ).

tff(fact_54_funcsetI,axiom,
    ! [A: $tType,B: $tType,B2: fun(B,bool),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [X2: A] :
          ( member(A,X2,A3)
         => member(B,aa(A,B,F,X2),B2) )
     => member(fun(A,B),F,pi(A,B,A3,combk(fun(B,bool),A,B2))) ) ).

tff(fact_55_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_56_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs2: list(A)] :
      ( distinct(A,Xs2)
     => distinct(A,insert(A,X,Xs2)) ) ).

tff(fact_57_alt3,axiom,
    ? [A1: arrow_411405190le_alt,B1: arrow_411405190le_alt,C1: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A1,cons(arrow_411405190le_alt,B1,cons(arrow_411405190le_alt,C1,nil(arrow_411405190le_alt))))) ).

tff(fact_58_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_59_Pi__cong,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool)),G: fun(A,B),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [W: A] :
          ( member(A,W,A3)
         => ( aa(A,B,F,W) = aa(A,B,G,W) ) )
     => ( member(fun(A,B),F,pi(A,B,A3,B2))
      <=> member(fun(A,B),G,pi(A,B,A3,B2)) ) ) ).

tff(fact_60_Pi__I_H,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool)),F: fun(A,B),A3: fun(A,bool)] :
      ( ! [X2: A] :
          ( member(A,X2,A3)
         => member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B2,X2)) )
     => member(fun(A,B),F,pi(A,B,A3,B2)) ) ).

tff(fact_61_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_62_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_63_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs2: list(A),X: A] : ( splice(A,cons(A,X,Xs2),cons(A,Y,Ys1)) = cons(A,X,cons(A,Y,splice(A,Xs2,Ys1))) ) ).

tff(fact_64_splice__Nil2,axiom,
    ! [A: $tType,Xs2: list(A)] : ( splice(A,Xs2,nil(A)) = Xs2 ) ).

tff(fact_65_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_66_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_67_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D,E1: E,F4: F3] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B1,product_Pair(C,product_prod(D,product_prod(E,F3)),C1,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,X1)) ) ).

tff(fact_68_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F3: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D,E1: E,F4: F3] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B1,product_Pair(C,product_prod(D,product_prod(E,F3)),C1,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4))))) ) ).

tff(fact_69_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,X1)) ) ).

tff(fact_70_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_71_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1))) ) ).

tff(fact_72_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X1)) ) ).

tff(fact_73_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A1: A,B1: B,C1: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B1,C1))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X1)) ) ).

tff(fact_74_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A1: A,B1: B,C1: C] : ( Y != product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B1,C1)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X1: A] :
      ( member(A,X1,A3)
    <=> pp(aa(A,bool,A3,X1)) ) ).

tff(fact_77_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R2: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa1: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X3,Xa1),R2)
        <=> member(product_prod(A,B),product_Pair(A,B,X3,Xa1),S) )
    <=> ( R2 = S ) ) ).

tff(fact_78_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A1: A,B1: B] : ( Y != product_Pair(A,B,A1,B1) ) ).

tff(fact_79_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X2: A,Y2: B] : ( P1 != product_Pair(A,B,X2,Y2) ) ).

tff(fact_80_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,Ca: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,Ca,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),Ca,Aa),Ba) ) ).

tff(fact_81_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,Ba) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,Ba)) ) ).

tff(fact_82_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ~ list_ex1(A,Pa,nil(A)) ).

tff(fact_83_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_84_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_85_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_86_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X4: fun(product_prod(A,B),C),Xa: A,Xb: B] : ( product_curry(A,B,C,X4,Xa,Xb) = aa(product_prod(A,B),C,X4,product_Pair(A,B,Xa,Xb)) ) ).

tff(fact_87_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Pa: fun(A,bool)] :
      ( list_ex1(A,Pa,cons(A,X1,Xs))
    <=> ( ( pp(aa(A,bool,Pa,X1))
         => list_all(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combb(bool,bool,A,fNot,Pa)),fequal(A,X1)),Xs) )
        & ( ~ pp(aa(A,bool,Pa,X1))
         => list_ex1(A,Pa,Xs) ) ) ) ).

tff(fact_88_list__nonempty__induct,axiom,
    ! [A: $tType,Pa: fun(list(A),bool),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,Pa,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs1: list(A)] :
              ( ( Xs1 != nil(A) )
             => ( pp(aa(list(A),bool,Pa,Xs1))
               => pp(aa(list(A),bool,Pa,cons(A,X2,Xs1))) ) )
         => pp(aa(list(A),bool,Pa,Xs)) ) ) ) ).

tff(fact_89_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Pa: fun(A,bool)] :
      ( list_all(A,Pa,cons(A,X1,Xs))
    <=> ( pp(aa(A,bool,Pa,X1))
        & list_all(A,Pa,Xs) ) ) ).

tff(fact_90_list__all__simps_I2_J,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : list_all(A,Pa,nil(A)) ).

tff(fact_91_lexord__cons__cons,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Y1: list(A),Ba: A,X1: list(A),Aa: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,Aa,X1),cons(A,Ba,Y1)),lexord(A,R1))
    <=> ( member(product_prod(A,A),product_Pair(A,A,Aa,Ba),R1)
        | ( ( Aa = Ba )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X1,Y1),lexord(A,R1)) ) ) ) ).

tff(fact_92_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_93_lexord__Nil__right,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),X1: list(A)] : ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X1,nil(A)),lexord(A,R1)) ).

tff(fact_94_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,Aa,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_95_lexord__Nil__left,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Y1: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),nil(A),Y1),lexord(A,R1))
    <=> ? [A2: A,X3: list(A)] : ( Y1 = cons(A,A2,X3) ) ) ).

tff(fact_96_lexord__irreflexive,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(product_prod(A,A),bool)] :
      ( ! [X2: A] : ~ member(product_prod(A,A),product_Pair(A,A,X2,X2),R1)
     => ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Xs),lexord(A,R1)) ) ).

tff(fact_97_lexord__linear,axiom,
    ! [A: $tType,Y1: list(A),X1: list(A),R1: fun(product_prod(A,A),bool)] :
      ( ! [A1: A,B1: A] :
          ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R1)
          | ( A1 = B1 )
          | member(product_prod(A,A),product_Pair(A,A,B1,A1),R1) )
     => ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X1,Y1),lexord(A,R1))
        | ( X1 = Y1 )
        | member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Y1,X1),lexord(A,R1)) ) ) ).

tff(fact_98_partition_Osimps_I1_J,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( partition(A,Pa,nil(A)) = product_Pair(list(A),list(A),nil(A),nil(A)) ) ).

tff(fact_99_Cons__listrel1__Cons,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Ys: list(A),Y1: A,Xs: list(A),X1: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X1,Xs),cons(A,Y1,Ys)),listrel1(A,R1))
    <=> ( ( member(product_prod(A,A),product_Pair(A,A,X1,Y1),R1)
          & ( Xs = Ys ) )
        | ( ( X1 = Y1 )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R1)) ) ) ) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,fequal(A,X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,fequal(A,X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [I: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I)),c),b))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,c),aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(arrow_411405190le_alt,fun(arrow_411405190le_alt,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),arrow_319942042_below,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I)),c),b)),b),a)) ) ).

%------------------------------------------------------------------------------
