%------------------------------------------------------------------------------
% File     : SCT214_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 195
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_195 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  146 (  42 unt;  42 typ;   0 def)
%            Number of atoms       :  253 ( 130 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  207 (  58   ~;  12   |;  28   &)
%                                         (  36 <=>;  73  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   49 (  28   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   1 prp; 0-3 aty)
%            Number of functors    :   30 (  30 usr;   8 con; 0-6 aty)
%            Number of variables   :  494 ( 451   !;  14   ?; 494   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:45
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olex,type,
    lex: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olexn,type,
    lexn: 
      !>[A: $tType] : ( ( fun(product_prod(A,A),bool) * nat ) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olexord,type,
    lexord: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistrel1,type,
    listrel1: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Opartition,type,
    partition: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > product_prod(list(A),list(A)) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C1: $tType] : ( ( fun(product_prod(A,B),C1) * A * B ) > C1 ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C1: $tType] : ( ( fun(A,fun(B,C1)) * product_prod(A,B) ) > C1 ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P_H____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P____,type,
    p1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (100)
tff(fact_0__096a_A_126_061_Ab_096,axiom,
    a != b ).

tff(fact_1__096P_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p1,arrow_610318064e_Prof) ).

tff(fact_2__096P_H_A_058_AProf_096,axiom,
    member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),p,arrow_610318064e_Prof) ).

tff(fact_3_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_4_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_5_third__alt,axiom,
    ! [B3: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B3 )
     => ? [C3: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A4,cons(arrow_411405190le_alt,B3,cons(arrow_411405190le_alt,C3,nil(arrow_411405190le_alt))))) ) ).

tff(fact_6_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_7_distinct__singleton,axiom,
    ! [A: $tType,X1: A] : distinct(A,cons(A,X1,nil(A))) ).

tff(fact_8_iff,axiom,
    ! [I3: arrow_159774573e_indi] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I3))
    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b,a),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I3)) ) ).

tff(fact_9_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A6,List3) )
    <=> ( ( Aa = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_10_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xs: list(A),Ba: A,Aa: A] :
      ( distinct(A,cons(A,Aa,cons(A,Ba,Xs)))
    <=> ( ( Aa != Ba )
        & distinct(A,cons(A,Aa,Xs))
        & distinct(A,cons(A,Ba,Xs)) ) ) ).

tff(fact_11_alt3,axiom,
    ? [A2: arrow_411405190le_alt,B1: arrow_411405190le_alt,C3: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A2,cons(arrow_411405190le_alt,B1,cons(arrow_411405190le_alt,C3,nil(arrow_411405190le_alt))))) ).

tff(fact_12_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != cons(A,A5,List2) ) ).

tff(fact_13_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( cons(A,A5,List2) != nil(A) ) ).

tff(fact_14_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs = cons(A,Y3,Ys4) ) ) ).

tff(fact_15_list_Oexhaust,axiom,
    ! [A: $tType,Y2: list(A)] :
      ( ( Y2 != nil(A) )
     => ~ ! [A2: A,List1: list(A)] : ( Y2 != cons(A,A2,List1) ) ) ).

tff(fact_16_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != cons(A,X1,Xs1) ) ).

tff(fact_17_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( cons(A,X1,Xs1) != Xs1 ) ).

tff(fact_18__C2_C,axiom,
    ! [P_a: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A6: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A6 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A6 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P_a,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P_a,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P_a)) ) ) ) ) ) ) ) ) ).

tff(fact_19__C1_C,axiom,
    ! [P_a: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),B5: arrow_411405190le_alt,A6: arrow_411405190le_alt,Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( ( A6 != B5 )
       => ( ( Aa != B5 )
         => ( ( Ba != A6 )
           => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Pa,arrow_610318064e_Prof)
             => ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),P_a,arrow_610318064e_Prof)
               => ( ! [I2: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Pa,I2))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),P_a,I2)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,Pa))
                   => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A6,B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,P_a)) ) ) ) ) ) ) ) ) ).

tff(fact_20_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3)) ) ) ) ).

tff(fact_21_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ! [Xa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa,arrow_610318064e_Prof)
             => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa)) ) ) ) ) ) ).

tff(fact_22_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A3: A,B2: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A3,B2))) ) ).

tff(fact_23_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A6,B5) )
    <=> ( ( Aa = A6 )
        & ( Ba = B5 ) ) ) ).

tff(fact_24_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_25_dictator__def,axiom,
    ! [I: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I) ) ) ) ).

tff(fact_26_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V1: A] : ( splice(A,cons(A,V1,Va),nil(A)) = cons(A,V1,Va) ) ).

tff(fact_27_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,nil(B)) = F11 ) ).

tff(fact_28_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y2: A,Xs1: list(A),X1: A] : ( splice(A,cons(A,X1,Xs1),cons(A,Y2,Ys1)) = cons(A,X1,cons(A,Y2,splice(A,Xs1,Ys1))) ) ).

tff(fact_29_distinct__insert,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] :
      ( distinct(A,Xs1)
     => distinct(A,insert(A,X1,Xs1)) ) ).

tff(fact_30_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_31_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_32_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A5: A,B3: B,A4: A] :
      ( ( product_Pair(A,B,A4,B3) = product_Pair(A,B,A5,B4) )
     => ~ ( ( A4 = A5 )
         => ( B3 != B4 ) ) ) ).

tff(fact_33_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F21,Aa),List) ) ).

tff(fact_34_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A3: A,B2: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A3,B2))) ) ).

tff(fact_35_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,F11: fun(B,fun(C1,A))] : ( product_prod_rec(B,C1,A,F11,product_Pair(B,C1,Aa,Ba)) = aa(C1,A,aa(B,fun(C1,A),F11,Aa),Ba) ) ).

tff(fact_36_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y2: product_prod(A,B)] :
      ~ ! [A2: A,B1: B] : ( Y2 != product_Pair(A,B,A2,B1) ) ).

tff(fact_37_PairE,axiom,
    ! [A: $tType,B: $tType,P: product_prod(A,B)] :
      ~ ! [X2: A,Y1: B] : ( P != product_Pair(A,B,X2,Y1) ) ).

tff(fact_38_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Y2: product_prod(A,product_prod(B,C1))] :
      ~ ! [A2: A,B1: B,C3: C1] : ( Y2 != product_Pair(A,product_prod(B,C1),A2,product_Pair(B,C1,B1,C3)) ) ).

tff(fact_39_prod__induct3,axiom,
    ! [C1: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,C1)),Pa: fun(product_prod(A,product_prod(B,C1)),bool)] :
      ( ! [A2: A,B1: B,C3: C1] : pp(aa(product_prod(A,product_prod(B,C1)),bool,Pa,product_Pair(A,product_prod(B,C1),A2,product_Pair(B,C1,B1,C3))))
     => pp(aa(product_prod(A,product_prod(B,C1)),bool,Pa,X)) ) ).

tff(fact_40_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A2: A,B1: B,C3: C1,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F1))),B1,product_Pair(C1,product_prod(D,product_prod(E,F1)),C3,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1))))),bool,Pa,X)) ) ).

tff(fact_41_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,F1: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A2: A,B1: B,C3: C1,D1: D,E1: E,F2: F1] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F1))),B1,product_Pair(C1,product_prod(D,product_prod(E,F1)),C3,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_42_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B1: B,C3: C1,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E))),A2,product_Pair(B,product_prod(C1,product_prod(D,E)),B1,product_Pair(C1,product_prod(D,E),C3,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,Pa,X)) ) ).

tff(fact_43_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A2: A,B1: B,C3: C1,D1: D,E1: E] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E))),A2,product_Pair(B,product_prod(C1,product_prod(D,E)),B1,product_Pair(C1,product_prod(D,E),C3,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_44_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C1,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C1,D))),bool)] :
      ( ! [A2: A,B1: B,C3: C1,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C1,D)),A2,product_Pair(B,product_prod(C1,D),B1,product_Pair(C1,D,C3,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,Pa,X)) ) ).

tff(fact_45_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,D)))] :
      ~ ! [A2: A,B1: B,C3: C1,D1: D] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C1,D)),A2,product_Pair(B,product_prod(C1,D),B1,product_Pair(C1,D,C3,D1))) ) ).

tff(fact_46_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,C2: fun(B,fun(C1,A))] : ( produc1605651328_split(B,C1,A,C2,product_Pair(B,C1,Aa,Ba)) = aa(C1,A,aa(B,fun(C1,A),C2,Aa),Ba) ) ).

tff(fact_47_curry__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Ba: C1,Aa: B,F: fun(product_prod(B,C1),A)] : ( product_curry(B,C1,A,F,Aa,Ba) = aa(product_prod(B,C1),A,F,product_Pair(B,C1,Aa,Ba)) ) ).

tff(fact_48_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ~ list_ex1(A,Pa,nil(A)) ).

tff(fact_49_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_50_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_51_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_52_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y != Z )
        & ( ( X = Z )
         => ( X != Y ) )
        & ( ( X != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),L) ) ) ) ).

tff(fact_53_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y: arrow_411405190le_alt,X: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),arrow_424895264_mktop(L,Z))
    <=> ( ( X != Z )
        & ( ( Y = Z )
         => ( X != Y ) )
        & ( ( Y != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y),L) ) ) ) ).

tff(fact_54_list__nonempty__induct,axiom,
    ! [A: $tType,Pa: fun(list(A),bool),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,Pa,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,Pa,Xs2))
               => pp(aa(list(A),bool,Pa,cons(A,X2,Xs2))) ) )
         => pp(aa(list(A),bool,Pa,Xs)) ) ) ) ).

tff(fact_55_lexord__cons__cons,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y: list(A),Ba: A,X: list(A),Aa: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,Aa,X),cons(A,Ba,Y)),lexord(A,R))
    <=> ( member(product_prod(A,A),product_Pair(A,A,Aa,Ba),R)
        | ( ( Aa = Ba )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X,Y),lexord(A,R)) ) ) ) ).

tff(fact_56_lexord__Nil__right,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),X: list(A)] : ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X,nil(A)),lexord(A,R)) ).

tff(fact_57_lexord__Nil__left,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),nil(A),Y),lexord(A,R))
    <=> ? [A3: A,X3: list(A)] : ( Y = cons(A,A3,X3) ) ) ).

tff(fact_58_lexord__irreflexive,axiom,
    ! [A: $tType,Xs: list(A),R: fun(product_prod(A,A),bool)] :
      ( ! [X2: A] : ~ member(product_prod(A,A),product_Pair(A,A,X2,X2),R)
     => ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Xs),lexord(A,R)) ) ).

tff(fact_59_lexord__linear,axiom,
    ! [A: $tType,Y: list(A),X: list(A),R: fun(product_prod(A,A),bool)] :
      ( ! [A2: A,B1: A] :
          ( member(product_prod(A,A),product_Pair(A,A,A2,B1),R)
          | ( A2 = B1 )
          | member(product_prod(A,A),product_Pair(A,A,B1,A2),R) )
     => ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X,Y),lexord(A,R))
        | ( X = Y )
        | member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Y,X),lexord(A,R)) ) ) ).

tff(fact_60_partition_Osimps_I1_J,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( partition(A,Pa,nil(A)) = product_Pair(list(A),list(A),nil(A),nil(A)) ) ).

tff(fact_61_Cons__listrel1__Cons,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Ys: list(A),Y: A,Xs: list(A),X: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X,Xs),cons(A,Y,Ys)),listrel1(A,R))
    <=> ( ( member(product_prod(A,A),product_Pair(A,A,X,Y),R)
          & ( Xs = Ys ) )
        | ( ( X = Y )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R)) ) ) ) ).

tff(fact_62_Nil__notin__lex,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Ys: list(A)] : ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),nil(A),Ys),lex(A,R)) ).

tff(fact_63_listrel1I2,axiom,
    ! [A: $tType,X: A,R: fun(product_prod(A,A),bool),Ys: list(A),Xs: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R))
     => member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X,Xs),cons(A,X,Ys)),listrel1(A,R)) ) ).

tff(fact_64_not__listrel1__Nil,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Xs: list(A)] : ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,nil(A)),listrel1(A,R)) ).

tff(fact_65_not__Nil__listrel1,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Xs: list(A)] : ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),nil(A),Xs),listrel1(A,R)) ).

tff(fact_66_listrel1I1,axiom,
    ! [A: $tType,Xs: list(A),R: fun(product_prod(A,A),bool),Y: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y),R)
     => member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X,Xs),cons(A,Y,Xs)),listrel1(A,R)) ) ).

tff(fact_67_Nil2__notin__lex,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Xs: list(A)] : ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,nil(A)),lex(A,R)) ).

tff(fact_68_Cons__listrel1E1,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Ys: list(A),Xs: list(A),X: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X,Xs),Ys),listrel1(A,R))
     => ( ! [Y1: A] :
            ( ( Ys = cons(A,Y1,Xs) )
           => ~ member(product_prod(A,A),product_Pair(A,A,X,Y1),R) )
       => ~ ! [Zs2: list(A)] :
              ( ( Ys = cons(A,X,Zs2) )
             => ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Zs2),listrel1(A,R)) ) ) ) ).

tff(fact_69_Cons__listrel1E2,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Ys: list(A),Y: A,Xs: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,cons(A,Y,Ys)),listrel1(A,R))
     => ( ! [X2: A] :
            ( ( Xs = cons(A,X2,Ys) )
           => ~ member(product_prod(A,A),product_Pair(A,A,X2,Y),R) )
       => ~ ! [Zs2: list(A)] :
              ( ( Xs = cons(A,Y,Zs2) )
             => ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Zs2,Ys),listrel1(A,R)) ) ) ) ).

tff(fact_70_Cons__in__lex,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Ys: list(A),Y: A,Xs: list(A),X: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X,Xs),cons(A,Y,Ys)),lex(A,R))
    <=> ( ( member(product_prod(A,A),product_Pair(A,A,X,Y),R)
          & ( size_size(list(A),Xs) = size_size(list(A),Ys) ) )
        | ( ( X = Y )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),lex(A,R)) ) ) ) ).

tff(fact_71_neq__if__length__neq,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( size_size(list(A),Xs1) != size_size(list(A),Ys1) )
     => ( Xs1 != Ys1 ) ) ).

tff(fact_72_listrel1__eq__len,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Ys: list(A),Xs: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R))
     => ( size_size(list(A),Xs) = size_size(list(A),Ys) ) ) ).

tff(fact_73_lexord__lex,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y: list(A),X: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X,Y),lex(A,R))
    <=> ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X,Y),lexord(A,R))
        & ( size_size(list(A),X) = size_size(list(A),Y) ) ) ) ).

tff(fact_74_list__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(list(A),fun(list(B),bool)),Ys: list(B),Xs: list(A)] :
      ( ( size_size(list(A),Xs) = size_size(list(B),Ys) )
     => ( pp(aa(list(B),bool,aa(list(A),fun(list(B),bool),Pa,nil(A)),nil(B)))
       => ( ! [X2: A,Xs2: list(A),Y1: B,Ys3: list(B)] :
              ( ( size_size(list(A),Xs2) = size_size(list(B),Ys3) )
             => ( pp(aa(list(B),bool,aa(list(A),fun(list(B),bool),Pa,Xs2),Ys3))
               => pp(aa(list(B),bool,aa(list(A),fun(list(B),bool),Pa,cons(A,X2,Xs2)),cons(B,Y1,Ys3))) ) )
         => pp(aa(list(B),bool,aa(list(A),fun(list(B),bool),Pa,Xs),Ys)) ) ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_76_lexn__length,axiom,
    ! [A: $tType,N: nat,R: fun(product_prod(A,A),bool),Ys: list(A),Xs: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),lexn(A,R,N))
     => ( ( size_size(list(A),Xs) = N )
        & ( size_size(list(A),Ys) = N ) ) ) ).

tff(fact_77_snoc__listrel1__snoc__iff,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y: A,Ys: list(A),X: A,Xs: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),append(A,Xs,cons(A,X,nil(A))),append(A,Ys,cons(A,Y,nil(A)))),listrel1(A,R))
    <=> ( ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R))
          & ( X = Y ) )
        | ( ( Xs = Ys )
          & member(product_prod(A,A),product_Pair(A,A,X,Y),R) ) ) ) ).

tff(fact_78_append__assoc,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A)] : ( append(A,append(A,Xs1,Ys1),Zs) = append(A,Xs1,append(A,Ys1,Zs)) ) ).

tff(fact_79_same__append__eq,axiom,
    ! [A: $tType,Zs1: list(A),Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = append(A,Xs,Zs1) )
    <=> ( Ys = Zs1 ) ) ).

tff(fact_80_append__same__eq,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Xs) = append(A,Zs1,Xs) )
    <=> ( Ys = Zs1 ) ) ).

tff(fact_81_append__Cons,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A),X1: A] : ( append(A,cons(A,X1,Xs1),Ys1) = cons(A,X1,append(A,Xs1,Ys1)) ) ).

tff(fact_82_append__self__conv2,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = Ys )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_83_append__self__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = Xs )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_84_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = nil(A) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_85_self__append__conv2,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( Ys = append(A,Xs,Ys) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_86_self__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = append(A,Xs,Ys) )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_87_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( nil(A) = append(A,Xs,Ys) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_88_append1__eq__conv,axiom,
    ! [A: $tType,Y: A,Ys: list(A),X: A,Xs: list(A)] :
      ( ( append(A,Xs,cons(A,X,nil(A))) = append(A,Ys,cons(A,Y,nil(A))) )
    <=> ( ( Xs = Ys )
        & ( X = Y ) ) ) ).

tff(fact_89_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs1: list(A),Ys: list(A),Xs: list(A),X: A] :
      ( ( cons(A,X,Xs) = append(A,Ys,Zs1) )
    <=> ( ( ( Ys = nil(A) )
          & ( cons(A,X,Xs) = Zs1 ) )
        | ? [Ys2: list(A)] :
            ( ( cons(A,X,Ys2) = Ys )
            & ( Xs = append(A,Ys2,Zs1) ) ) ) ) ).

tff(fact_90_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs: list(A),X: A,Zs1: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Zs1) = cons(A,X,Xs) )
    <=> ( ( ( Ys = nil(A) )
          & ( Zs1 = cons(A,X,Xs) ) )
        | ? [Ys2: list(A)] :
            ( ( Ys = cons(A,X,Ys2) )
            & ( append(A,Ys2,Zs1) = Xs ) ) ) ) ).

tff(fact_91_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs: list(A),Xs1: list(A),Ys1: list(A),Xs11: list(A),X1: A] :
      ( ( cons(A,X1,Xs11) = Ys1 )
     => ( ( Xs1 = append(A,Xs11,Zs) )
       => ( cons(A,X1,Xs1) = append(A,Ys1,Zs) ) ) ) ).

tff(fact_92_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( Xs1 = Ys1 )
     => ( Xs1 = append(A,nil(A),Ys1) ) ) ).

tff(fact_93_append__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( append(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_94_append__Nil,axiom,
    ! [A: $tType,Ys1: list(A)] : ( append(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_95_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs1: list(A),Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = append(A,Zs1,Ts) )
    <=> ? [Us2: list(A)] :
          ( ( ( Xs = append(A,Zs1,Us2) )
            & ( append(A,Us2,Ys) = Ts ) )
          | ( ( append(A,Xs,Us2) = Zs1 )
            & ( Ys = append(A,Us2,Ts) ) ) ) ) ).

tff(fact_96_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys1: list(A),Zs: list(A),Xs11: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Xs11) = Zs )
     => ( ( Ys1 = append(A,Xs11,Us1) )
       => ( append(A,Xs1,Ys1) = append(A,Zs,Us1) ) ) ) ).

tff(fact_97_append__listrel1I,axiom,
    ! [A: $tType,Vs: list(A),Us: list(A),R: fun(product_prod(A,A),bool),Ys: list(A),Xs: list(A)] :
      ( ( ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R))
          & ( Us = Vs ) )
        | ( ( Xs = Ys )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Us,Vs),listrel1(A,R)) ) )
     => member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),append(A,Xs,Us),append(A,Ys,Vs)),listrel1(A,R)) ) ).

tff(fact_98_lexord__append__leftI,axiom,
    ! [A: $tType,X: list(A),R: fun(product_prod(A,A),bool),V: list(A),U: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),U,V),lexord(A,R))
     => member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),append(A,X,U),append(A,X,V)),lexord(A,R)) ) ).

tff(fact_99_listrel1I,axiom,
    ! [A: $tType,Ys: list(A),Vs: list(A),Us: list(A),Xs: list(A),R: fun(product_prod(A,A),bool),Y: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y),R)
     => ( ( Xs = append(A,Us,cons(A,X,Vs)) )
       => ( ( Ys = append(A,Us,cons(A,Y,Vs)) )
         => member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),listrel1(A,R)) ) ) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [C: arrow_411405190le_alt] :
      ( distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,a,cons(arrow_411405190le_alt,b,cons(arrow_411405190le_alt,C,nil(arrow_411405190le_alt)))))
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
